<?php
/*
	file:	/modules/download/edit.php
	modify:	2010/02/10 - 2010/05/31
*/

function Download_edit( &$p )
{
	//1.Check Request
	if ( empty ( $p['id'] )
		|| ! is_numeric( $p['id'] ) ) {
		raysn_clewbox ( translate( 'download id empty' ) );
	}

	require_once './modules/download/download.inc';
	if ( ! $Download= _Get_DownloadData( $p['id']  ) ) {
		raysn_clewbox ( translate( 'download not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		//.Get Column Option
		require_once './libraries/module.inc';
		require_once './modules/role/role.inc';
		require_once './modules/column/column.inc';

		$Download['title'] = htmlspecialchars( $Download['title'] );

		//.Process platform
		if ( empty ( $Download['platform'] ) )
			$Download['platform']= array();
		else
			$Download['platform']= explode( ',', $Download['platform'] );

		//.Process roles
		$Download['DownloadRoles'] = _Get_DownloadRoles( $Download['did'] );
		$Download['text'] = htmlspecialchars( $Download['text'] );
		$Download['keywords'] = htmlspecialchars( $Download['keywords'] );
		$Download['description'] = htmlspecialchars( $Download['description'] );

		$Download['RoleList'] = _Get_RoleList( );
		$Download['PassAllowed']= raysn_check_user_permit( 'download', 'pass' );
		$Download['ColumnAvailable'] = _Get_ColumnAvailable( 'download' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 )
		{
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$Download['ColumnAvailable'] = array_intersect( $UserAllowedCids, $DataArray['ColumnAvailable'] );
		}

		return $Download;
	}
	else
	{
		//1.Check Request
		$SqlArray['pass'] = raysn_check_user_permit( 'download', 'pass' );
		if ( raysn_get_user_id() != $Download['uid'] && ! $SqlArray['pass'] ) {
			raysn_clewbox( translate( 'you can not edit others' ) );
		}
		require_once './modules/column/column.inc';

		//.Check cid
		if ( ! empty ( $p['cid'] )
			&& $p['cid'] != $Download['cid'] )
		{
			$ColumnDatas= _Get_ColumnDatas( );
			if ( ! empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
				&& $ColumnDatas[ $p['cid'] ]['type'] == 'download' ) {
				if ( raysn_check_user_column( $p['cid'] ) ) {
					$SqlArray['cid']= $p['cid'];
				} else
					raysn_clewbox( language( 'no permission for the column' ) );
			} else
				raysn_clewbox( translate( 'can not publish this column' ) );
		}

		require_once './libraries/string.inc';


		//.Check title
		if ( isset ( $p['fileName'] )
			&& $p['fileName'] != $Download['title'] )
		{
			if ( _Check_Strlen( $p['fileName'], 3, 60 ) ) {
				$SqlArray['title']= trim( $p['fileName'] );
			}
			else
				raysn_clewbox( translate( 'title empty', array( '@min'=> 3, '@max'=> 60 ) ) );
		}

		//.Check platform
		if ( ! empty ( $p['platform'] )
			&& is_array( $p['platform'] ) ) {
			$p['platform']= implode( ',', $p['platform'] );
			if ( preg_match( "/^\d(,\d){0,8}$/", $p['platform'] ) )
				$SqlArray['platform']= $p['platform'];
			else
				raysn_clewbox( translate( 'platform error' ) );
		}
		else {
			$SqlArray['platform'] = NULL;
		}

		//.Check FileUrl
		if ( isset ( $p['fileUrl'] )
			&& $p['fileUrl'] != $Download['url']
			&& _Check_Strlen( $p['fileUrl'], 6, 128 ) ) {
			if ( _Check_DownloadUrlExist( $p['fileUrl'] ) ) {
				raysn_clewbox( translate( 'url already exist' ) );
			}
			$SqlArray['url']= trim( $p['fileUrl'] );
			$SqlArray['type']= ExtName( $SqlArray['url'] );
			$SqlArray['code']= md5( raysn_get_pass_encode( $SqlArray['url'] ) );
		}
		
		//.Check FileSize
		if ( isset ( $p['fileSize'] )
			&& preg_match( "/^\d+(\.\d{1,3})?(K|M)$/", $p['fileSize'] ) ) {
			$SqlArray['size']= $p['fileSize'];
		}
		
		//.Check FileType
		if ( isset ( $p['fileType'] )
			&& preg_match( "/^[a-z\d]{2,4}$/", $p['fileType'] ) ) {
			$SqlArray['type']= $p['fileType'];
		}

		//.Check text
		if ( ! empty ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 65535 ) )
			$SqlArray2['text']= trim( $p['text'] );
		else
			$SqlArray2['text']= '';

		//.Check keywords
		if ( isset ( $p['keywords'] ) )
		{
			if ( _Check_Strlen( $p['keywords'], 0, 60 ) )
				$SqlArray['keywords']= trim( $p['keywords'] );
			else
				raysn_clewbox( translate( 'keywords too many', array( '@max'=> 60 ) ) );
		}

		//.Check description
		if ( isset ( $p['description'] ) ) {
			if ( $p['description'] != NULL ) {
				if ( _Check_Strlen( $p['description'], 10, 255 ) )
					$SqlArray['description']= trim( $p['description'] );
				else
					raysn_clewbox( translate( 'description length illegal', array( '@min'=> 10, '@max'=> 255 ) ) );
			}
			elseif ( variable_get( "Download_AutoDescription", "128" ) ) {
				$SqlArray['description']= _Get_PlainText( $SqlArray2['text'], variable_get( "Download_AutoDescription", "128" ) );
			}
		}

		//.Check cost
		if ( isset ( $p['cost'] )
			&& is_numeric( $p['cost'] ) ) {
			$SqlArray['cost']= trim( $p['cost'] );
		}
		
		//.Check comments
		if ( isset ( $p['comments'] )
			&& $p['comments'] != $Download['comments']
			&& in_array( $p['comments'], array( 0, 1, 2 ) ) ) {
			$SqlArray['comments']= $p['comments'];
		}

		//.Check editor
		if ( isset ( $p['editor'] )
			&& $p['editor'] != $Download['editor'] )
		{
			if ( _Check_Strlen( $p['editor'], 2, 16 ) )
				$SqlArray['editor']= trim( $p['editor'] );
			else
				raysn_clewbox( translate( 'editor empty' ) );
		}

		//.Check date
		$SqlArray['modified'] = time( );
		if ( isset ( $p['pubdate'] )
			&& $p['pubdate'] != $Download['pubdate'] )
		{
			if ( $pubdate = _Make_TimeStamp( $p['pubdate'] ) )
				$SqlArray['pubdate'] = $pubdate;
			else
				raysn_clewbox ( translate( 'time format error', array( '@time'=> $p['pubdate'] ) ) );
		}

		//.Check image
		if ( isset ( $p['txtUrl'] )
			&& _Check_Strlen( $p['txtUrl'], 20, 255 ) ) {
			$SqlArray['image'] = $p['txtUrl'];
		}
		else {
			$SqlArray['image'] = _Get_ImageUrl( $p['text'] );
		}

		//2.Update Data
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->update( 'download', $SqlArray, "`did`= '{$p['id']}'");
		$MysqlObject->update( 'download_text', $SqlArray2, "`did`= '{$p['id']}'");

		//.Check and Update Roles
		$MysqlObject->delete( 'download_role', "`did`= '{$p['id']}'" );
		if ( isset ( $p['roles'] ) ) {
			if ( ! is_array( $p['roles'] )
				|| count( $p['roles'] ) > 9 ) {
				raysn_clewbox ( translate( 'roles too many' ) );
			}
			require_once './modules/role/role.inc';
			$Roles= _Get_RoleNames( );
			foreach ( $p['roles'] as $rid ) {
				if ( array_key_exists( $rid, $Roles ) ) {
					$MysqlObject->insert( 'download_role', array( 'did'=> $p['id'], 'rid'=> $rid ) );
				}
			}
		}

		//3.Update Column
		if ( ! empty ( $p['cid'] )
			&& $p['cid']!= $Article['cid'] ) {
			_Count_Documents( $p['cid'] );//Update New Column
			_Count_Documents( $Download['cid'] );//Update Old Column
		}

		//.Update Page
		if ( $SqlArray['pass'] ) {
			if ( isset ( $SqlArray['cid'] )
				|| $SqlArray['pass'] != $Download['pass']
				|| isset ( $SqlArray['title'] )
				|| isset ( $SqlArray['pubdate'] ) ) {
				_Drop_ColumnPages( $Download['cid'] );
			}
			if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && INDEX_PATH != '' ) {
				_Make_DownloadPage( $p['id'] );
			}
			else {
				_Drop_DownloadPage( $p['id'] );
			}
		}

		//.Update Comment
		if ( isset ( $SqlArray['title'] ) ) {
			require_once './libraries/module.inc';
			if ( _Check_ModuleEnabled( 'comment' ) ) {
				require_once './modules/comment/comment.inc';
				_Set_CommentTitle( 'download', $p['id'], $SqlArray['title'] );
			}
		}

		//.Operation Complete
		raysn_clewbox ( translate( 'edit success' ) );
	}
}
