<?php
/*
	file:	/modules/download/make.php
	modify:	2010/02/10 - 2010/05/31
*/

function Download_make( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './libraries/module.inc';
		require_once './modules/role/role.inc';
		require_once './modules/column/column.inc';

		$DataArray['editor'] = raysn_get_user_info( 'name' );
		$DataArray['RoleList'] = _Get_RoleList( );
		$DataArray['ColumnAvailable'] = _Get_ColumnAvailable( 'download' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 )
		{
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$DataArray['ColumnAvailable'] = array_intersect( $UserAllowedCids, $DataArray['ColumnAvailable'] );
		}

		return $DataArray;
	}
	else
	{
		//1.Check Request
		require_once './modules/column/column.inc';
		$ColumnDatas= _Get_ColumnDatas( );

		//.Check cid
		if ( ! empty ( $p['cid'] ) ) {
			if ( ! empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
				&& $ColumnDatas[ $p['cid'] ]['type'] == 'download' ) {
				if ( raysn_check_user_column( $p['cid'] ) ) {
					$SqlArray['cid']= $p['cid'];
				} else
					raysn_clewbox( language( 'no permission for the column' ) );
			} else
				raysn_clewbox( translate( 'can not publish this column' ) );
		} else
			raysn_clewbox( translate( 'cid empty' ) );

		//.Check title
		require_once './libraries/string.inc';
		if ( isset ( $p['fileName'] )
			&& _Check_Strlen( $p['fileName'], 3, 60 ) ) {
			$SqlArray['title']= trim( $p['fileName'] );
		}
		else
			raysn_clewbox( translate( 'title empty', array( '@min'=> 3, '@max'=> 60 ) ) );

		//.Check platform
		if ( ! empty ( $p['platform'] )
			&& is_array( $p['platform'] ) ) {
			$p['platform']= implode( ',', $p['platform'] );
			if ( preg_match( "/^\d(,\d){0,8}$/", $p['platform'] ) )
				$SqlArray['platform']= $p['platform'];
			else
				raysn_clewbox( translate( 'platform error' ) );
		}

		//.Check UrlLink
		if ( isset ( $p['fileUrl'] )
			&& _Check_Strlen( $p['fileUrl'], 6, 128 ) )
		{
			require_once './modules/download/download.inc';
			if ( _Check_DownloadUrlExist( $p['fileUrl'] ) ) {
				raysn_clewbox( translate( 'url already exist' ) );
			}
			$SqlArray['url']= trim( $p['fileUrl'] );
			$SqlArray['type']= ExtName( $SqlArray['url'] );
			$SqlArray['code']= md5( time( ) );
		} else
			raysn_clewbox( translate( 'UrlLink empty', array( '@min'=> 6, '@max'=> 128 ) ) );
		
		//.Check FileSize
		if ( isset ( $p['fileSize'] )
			&& preg_match( "/^\d+(\.\d{1,3})?(K|M)$/", $p['fileSize'] ) ) {
			$SqlArray['size']= $p['fileSize'];
		}
		
		//.Check FileType
		if ( isset ( $p['fileType'] )
			&& preg_match( "/^[a-z\d]{2,4}$/", $p['fileType'] ) ) {
			$SqlArray['type']= $p['fileType'];
		}

		//.Check text
		if ( ! empty ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 65535 ) )
			$SqlArray2['text']= trim( $p['text'] );
		else
			$SqlArray2['text']= '';

		//.Check keywords
		if ( isset ( $p['keywords'] ) )
		{
			if ( _Check_Strlen( $p['keywords'], 0, 60 ) )
				$SqlArray['keywords']= trim( $p['keywords'] );
			else
				raysn_clewbox( translate( 'keywords too many', array( '@max'=> 60 ) ) );
		}

		//.Check description
		if ( ! isset ( $p['description'] )
			|| $p['description'] == NULL ) {
			if ( variable_get( "Download_AutoDescription", "128" ) ) {
				$SqlArray['description']= _Get_PlainText( $SqlArray2['text'], variable_get( "Download_AutoDescription", "128" ) );
			}
		}
		else
		{
			if ( _Check_Strlen( $p['description'], 10, 255 ) )
				$SqlArray['description']= trim( $p['description'] );
			else
				raysn_clewbox( translate( 'description length illegal', array( '@min'=> 10, '@max'=> 255 ) ) );
		}

		//.Check cost
		if ( isset ( $p['cost'] )
			&& is_numeric( $p['cost'] ) ) {
			$SqlArray['cost']= trim( $p['cost'] );
		}
		
		//.Check comments
		if ( isset ( $p['comments'] )
			&& in_array( $p['comments'], array( 0, 1, 2 ) ) ) {
			$SqlArray['comments']= $p['comments'];
		}

		//.Check editor
		if ( ! empty ( $p['editor'] )
			&& _Check_Strlen( $p['editor'], 2, 16 ) )
			$SqlArray['editor']= trim( $p['editor'] );
		else
			raysn_clewbox( translate( 'editor empty' ) );

		//.Check date
		$SqlArray['modified']= time( );
		if ( empty ( $p['pubdate'] ) ) {
			$SqlArray['pubdate'] = $SqlArray['modified'];
		}
		elseif ( ! $SqlArray['pubdate'] = _Make_TimeStamp( $p['pubdate'] ) ) {
			raysn_clewbox ( translate( 'time format error', array( '@time'=> $p['pubdate'] ) ) );
		}

		//.Check image
		if ( isset ( $p['txtUrl'] )
			&& _Check_Strlen( $p['txtUrl'], 20, 255 ) ) {
			$SqlArray['image'] = $p['txtUrl'];
		}
		else {
			$SqlArray['image'] = _Get_ImageUrl( $p['text'] );
		}

		$SqlArray['uid']= raysn_get_user_id( );
		$SqlArray['pass']= raysn_check_user_permit( 'download', 'pass' );

		//2.Insert Data
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->insert( 'download', $SqlArray );

		$SqlArray2['did']= $MysqlObject->_Get_InsertId();
		$MysqlObject->insert( 'download_text', $SqlArray2 );

		//.Check and Update Roles
		if ( ! empty ( $p['roles'] ) ) {
			if ( ! is_array( $p['roles'] )
				|| count( $p['roles'] ) > 9 ) {
				raysn_clewbox ( translate( 'roles too many' ) );
			}

			require_once './modules/role/role.inc';
			$Roles= _Get_RoleNames( );
			foreach ( $p['roles'] as $rid ) {
				if ( array_key_exists( $rid, $Roles ) ) {
					$MysqlObject->insert( 'download_role', array( 'did'=> $SqlArray2['did'], 'rid'=> $rid ) );
				}
			}
		}

		//3.Update Column
		_Count_Documents( $SqlArray['cid'] );

		if ( $SqlArray['pass'] ) {
			if ( $SqlArray['pubdate'] <= $SqlArray['modified'] ) {
				_Drop_ColumnPages( $SqlArray['cid'] );
			}
			if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && INDEX_PATH != '' ) {
				require_once './modules/download/download.inc';
				_Make_DownloadPage( $SqlArray2['did'] );
			}
		}

		//.Operation Complete
		setcookie ( "Download_cid", $p['cid'] );
		raysn_clewbox ( translate( 'add success' ), url( 'download/make' ) );
	}
}
