<?php
/*
	file:	/modules/file/edit.php
	modify:	2009/01/30 - 2010/03/16
*/

function File_edit( &$p )
{
	if ( empty ( $p['path'] )
		|| empty ( $p['file'] ) ) {
		raysn_clewbox ( translate( 'file path empty' ) );
	}

	$FileObject = raysn_object( 'file' )->path( $p['path'] . $p['file'] );

	if ( ! $FileObject->is_file( ) ) {
		raysn_clewbox ( translate( 'file not exist', array( '@file'=> $p['file'] ) ) );
	}

	if ( empty ( $p['confirm'] ) )
	{
		$FileInfo = array(
			'path'=> $p['path'],
			'file'=> $p['file'],
			'size'=> $FileObject->size( ),
			'mtime'=> date( "Y-n-d H:i:s", $FileObject->mtime( ) ),
			'writeable'=> $FileObject->is_writeable( ),
			'dirwriteable'=> $FileObject->is_dirwriteable( )
		);

		if ( $FileObject->is_text( ) ) {
			$FileInfo['text'] = htmlspecialchars( $FileObject->read( ) );
		}
		else {
			$FileInfo['ViewName'] = 'file_browse';
			$FileInfo['Is_ImageType'] = $FileObject->is_image( );
		}

		return $FileInfo;
	}
	else
	{
		require_once './libraries/string.inc';

		//.Check text
		if ( ! isset ( $p['text'] )
			|| ! _Check_Strlen( $p['text'], 0, 65535 ) ) {
			raysn_clewbox( translate( 'text too many', array( '@max'=> 65535 ) ) );
		}

		//Edit file
		if ( ! $FileObject->make( stripslashes( $p['text'] ) ) ) {
			raysn_clewbox( translate( 'edit failed' ) );
		}
		else {
			watchdog( 'modified a file', array( '@file'=> $FileObject->path( ) ) );
			raysn_clewbox( translate( 'edit success' ) );
		}
	}
}
