<?php
/*
	file:	/modules/file/make.php
	modify:	2009/01/30 - 2010/03/16
*/

function File_make( &$p )
{
	if ( empty ( $p['path'] ) ) {
		raysn_clewbox ( translate( 'dir path empty' ) );
	}

	$FileObject = raysn_object( 'file' )->path( $p['path'] );

	if ( ! $FileObject->is_dir( ) ) {
		raysn_clewbox ( translate( 'dir not exist', array( '@dir'=> $p['path'] ) ) );
	}

	if ( ! $FileObject->is_writeable( ) ) {
		message_set( 'dir not writeable' );
	}

	//View Form
	if ( empty( $p['confirm'] ) ) {
		return array( 'path'=> $p['path'] );
	}
	else
	{
		require_once './libraries/string.inc';

		//Check name
		if ( empty ( $p['name'] )
			|| ! preg_match( "/^[^\.]{1}[\w\.\:]{0,30}$/", $p['name'] ) ) {
			raysn_clewbox ( translate( 'name format error', array( '@min'=> 1, '@max'=> 32 ) ) );
		}
		//Check file
		if ( $FileObject->path( $p['path'] . $p['name'] )->file_exists() ) {
			raysn_clewbox ( translate( 'file already exist' ) );
		}

		//Check type
		if ( ! empty ( $p['type'] )
			&& in_array( $p['type'], array( 'file', 'dir' ) ) )
		{
			if ( $p['type'] == 'file' ) {
				//Make file
				if ( $FileObject->make() < 0 ) {
					raysn_clewbox ( translate( 'make file failed' ) );
				}
				else {
					watchdog( 'creating a file', array( '@file'=> $FileObject->path( ) ) );
					raysn_clewbox ( translate( 'make file success', array( '@file'=> $p['name'] ) ), url( 'file/list', array( 'path'=> $p['path'] ) ) );
				}
			}
			else
			{
				//Make dir
				if ( ! $FileObject->mkdir( ) ) {
					raysn_clewbox ( translate( 'make dir failed' ) );
				}
				else {
					watchdog( 'creating a dir', array( '@dir'=> $FileObject->path( ) ) );
					raysn_clewbox ( translate( 'make dir success', array( '@dir'=> $p['name'] ) ), url( 'file/list', array( 'path'=> $p['path'] ) ) );
				}
			}
		}
		else
			raysn_clewbox ( translate( 'type format error' ) );
	}
}
