<?php
/*
	file:	/modules/file/remove.php
	modify:	2009/01/30 - 2010/03/16
*/

function File_remove( &$p )
{
	if ( ! isset ( $p['path'] )
		|| ! isset ( $p['file'] ) ) {
		raysn_clewbox ( translate( 'file path empty' ) );
	}

	if ( ! raysn_object( 'file' )
		->path( $p['path'] . $p['file'] )
		->file_exists( ) ) {
		raysn_clewbox ( translate( 'file not exist', array( '@file'=> $p['file'] ) ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( 'path'=> $p['path'], 'file'=> $p['file'] );
	}
	else
	{
		//Check type
		$FileObject = $GLOBALS['OBJECT']['file'];
		if ( $FileObject->is_dir( ) ) {
			$Filelist = $FileObject->path( $FileObject->path() . '/' )->ls( );

			if ( ! empty ( $Filelist['dir'] )
				|| ! empty ( $Filelist['file'] ) ) {
				raysn_clewbox( translate( 'dir not empty' ) );
			}

			//Remove dir
			if ( ! $FileObject->remove( ) ) {
				raysn_clewbox ( translate( 'remove dir failed' ) );
			}
			else {
				watchdog( 'deleted a dir', array( '@dir'=> $FileObject->path( ) ) );
				raysn_clewbox ( translate( 'remove dir success', array( '@dir'=> $p['file'] ) ), url( 'file/list', array( 'path'=> $p['path'] ) ) );
			}
		}
		else
		{
			//Remove file
			if ( ! $FileObject->remove( ) ) {
				raysn_clewbox ( translate( 'remove file failed' ) );
			}
			else {
				watchdog( 'deleted a file', array( '@file'=> $FileObject->path( ) ) );
				raysn_clewbox ( translate( 'remove file success', array( '@file'=> $p['file'] ) ), url( 'file/list', array( 'path'=> $p['path'] ) ) );
			}
		}
	}
}
