<?php
/*
	file:	/modules/file/rename.php
	modify:	2009/01/30 - 2010/03/13
*/

function File_rename( &$p )
{
	if ( empty ( $p['path'] )
		|| empty ( $p['file'] ) ) {
		raysn_clewbox ( translate( 'file path empty' ) );
	}

	if ( ! raysn_object( 'file' )
		->path( $p['path'] . $p['file'] )
		->file_exists( ) ) {
		raysn_clewbox ( translate( 'file not exist', array( '@file'=> $p['file'] ) ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( 'path'=> $p['path'], 'file'=> $p['file'] );
	}
	else
	{
		//Check newname
		if ( empty ( $p['newname'] )
			|| ! preg_match( "/^[^\.]{1}[\w\.\:]{0,30}$/", $p['newname'] ) ) {
			raysn_clewbox ( translate( 'name format error' ) );
		}
		elseif ( $p['newname'] == $p['file'] ) {
			raysn_clewbox ( translate( 'name no change' ) );
		}
		elseif ( file_exists( $p['path'] . $p['newname'] ) ) {
			raysn_clewbox ( translate( 'name already exist' ) );
		}

		//Modify file name
		if ( ! $GLOBALS['OBJECT']['file']->rename( $p['newname'] ) ) {
			raysn_clewbox ( translate( 'rename failed' ) );
		}
		else {
			watchdog( 'renamed a file', array( '@file'=> $GLOBALS['OBJECT']['file']->path( ), '@newname'=> $p['newname'] ) );
			raysn_clewbox ( translate( 'rename success' ), url( 'file/list', array( 'path'=> $p['path'] ) ) );
		}
	}
}
