<?php
/*
	file:	/modules/file/upload.php
	modify:	2010/01/21 - 2010/03/16
*/

function File_upload( &$p )
{
	//.Check Request
	if ( empty ( $p['path'] ) )
		$p['path']= './';
	else
		$p['path']= './' . preg_replace( "/(\.+\/)+|\/$/", NULL, $p['path'] ) .'/';

	if ( $p['path'] != './styles/images/' ) {
		return message_set( 'can not upload' );
	}
	if ( ! is_writeable( $p['path'] ) ) {
		return message_set( 'dir not writeable' );
	}

	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( );
	}
	else
	{
		//Check upload file
		if ( ! $UploadObject= raysn_object( 'upload' )
			->_Set_Uploadinfo( 'UploadFile' ) ) {
			return message_set( 'file empty' );
		}

		//Check file type
		if ( ! in_array( $UploadObject->UploadfileType, array ( 'jpg','gif','png','bmp','swf' ) ) ) {
			return message_set( 'type disallowed' );
		}

		//.Check file name
		require_once './libraries/string.inc';
		if ( ! _Check_Chrlen( $UploadObject->UploadfileInfo['name'], 5, 36 ) ) {
			return message_set( 'name format error', array( '@min'=> 5, '@max'=> 36 ) );
		}

		//Check file
		$FileUploadPath = $p['path'] . $UploadObject->UploadfileInfo['name'];
		if ( is_file ( $FileUploadPath ) ) {
			return message_set( 'file already exist' );
		}

		//Save Upload attachment
		if ( ! $UploadObject->_Save_Uploadfile( $FileUploadPath ) ) {
			return message_set( 'dir not writeable', array( '@dir'=> $p['path'] ) );
		}

		//Operation Complete
		return message_set( 'upload success' );
	}
}
