<?php
/*
	file:	/modules/helper/answer.php
	modify:	2009/04/20 - 2010/03/29
*/

define( 'ANSWER_INTERVAL_TIME', 300 );

function helper_answer( &$p )
{
	//.Check Request
	require_once './modules/helper/helper.inc';
	if ( ! empty ( $p['id'] )
		&& is_numeric( $p['id'] ) ) {
		$Helper= _Get_HelperData( $p['id'] );
	}

	//view form
	if ( ! isset ( $Helper['hid'] ) || empty ( $p['confirm'] ) )
	{
		$SqlWhere= 'uid= '. raysn_get_user_id( );

		//.Check page
		$GLOBALS['BackupPath']= 'helper/answer/';
		if ( empty ( $p['id'] ) || $p['id'] < 1 ) {
			$NowIndex= 1;
		} else {
			$NowIndex= $p['id'];
		}

		//Page List
		$DataArray['Pagelist']= raysn_object( 'pagelist' )->_Set_PageInfo( array(
				'TotalNumber'=> $GLOBALS['OBJECT']['mysql']->select_count( 'helper_answer', $SqlWhere ),
				'NowIndex'=> $NowIndex
			) )->_Get_Pagelist( );

		if ( $NowIndex > $GLOBALS['OBJECT']['pagelist']->TotalPage ) {
			$NowIndex = 1;
		}

		//.Select Replies Data
		$DataArray['AnswerList'] = $GLOBALS['OBJECT']['mysql']
			->select( 'helper_answer', array(
				'where'=> $SqlWhere,
				'order'=> '`replied`',
				'limit'=> ( ( $NowIndex- 1 ) * PAGE_SIZE ) . ',' . PAGE_SIZE
			) );

		require_once './libraries/string.inc';
		return $DataArray;
	}
	else
	{
		//.Check Request
		if ( raysn_get_user_id( ) == $Helper['uid'] ) {
			raysn_clewbox ( translate( 'can not answer yourself' ) );
		}

		raysn_start_user_session( );
		if ( isset ( $_SESSION['HelperAnswerMark'][ $p['id'] ] )
			&& $_SESSION['HelperAnswerMark'][ $p['id'] ] > time( ) - ANSWER_INTERVAL_TIME ) {
			raysn_clewbox ( translate( 'Too fast', array( '@time'=> ANSWER_INTERVAL_TIME/ 60 ) ) );
		}

		require_once './libraries/string.inc';

		//Check answer
		if ( isset ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 1000 ) )
			$SqlArray['text']= htmlspecialchars( trim( $p['text'] ) );
		else
			raysn_clewbox ( translate( 'answer format error', array( '@min'=> 10, '@max'=> 1000 ) ) );

		$SqlArray['hid']= $Helper['hid'];
		$SqlArray['uid']= raysn_get_user_id( );
		$SqlArray['replied']= time( );
		$SqlArray['pass']= raysn_check_user_permit( 'helper', 'pass' );

		//.Insert Data
		$GLOBALS['OBJECT']['mysql']->insert( 'helper_answer', $SqlArray );

		//.Update Data
		$GLOBALS['OBJECT']['mysql']
			->update( 'helper', array( 'replied' => $SqlArray['replied'] ), "`hid`= '{$Helper['hid']}'" );

		//.Add Point
		raysn_add_user_points( variable_get( 'Helper_AnswerPointAdd', 1 ) );

		$_SESSION['HelperAnswerMark' ][ $p['id'] ]= time( );
		//.Operation Complete
		if ( $SqlArray['pass'] ) {
			variable_set( 'HELPER_UPDATE_TIMESTAMP_'. $Helper['hid'], time( ) );
		}
		raysn_clewbox ( translate( 'answer success' ), url( 'helper/'. $Helper['hid'] ) );
	}
}
