<?php
/*
	file:	/modules/helper/ask.php
	modify:	2009/04/20 - 2010/03/29
*/

define( 'ASK_INTERVAL_TIME', 600 );

function Helper_ask( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) ) {
		require_once './modules/column/column.inc';
		$DataArray['ColumnAvailable'] = _Get_ColumnAvailable( 'helper' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 ) {
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$DataArray['ColumnAvailable'] = array_intersect( $UserAllowedCids, $DataArray['ColumnAvailable'] );
		}
		return $DataArray;
	}
	else
	{
		//1.Check Request
		if ( ! isset ( $_COOKIE['RAYSN_SECCODE'] )
			|| strtolower( $p['code'] ) != $_COOKIE['RAYSN_SECCODE'] ) {
			raysn_clewbox ( language( 'check code error' ) );
		}

		raysn_start_user_session( );
		if ( isset ( $_SESSION['HelperAskMark'] )
			&& $_SESSION['HelperAskMark'] > time( ) - ASK_INTERVAL_TIME ) {
			raysn_clewbox ( translate( 'Too fast', array( '@time'=> ASK_INTERVAL_TIME/ 60 ) ) );
		}

		//.Check Request
		require_once './modules/column/column.inc';
		$ColumnDatas= _Get_ColumnDatas( );

		//.Check cid
		if ( ! empty ( $p['cid'] ) ) {
			if ( ! empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
				&& $ColumnDatas[ $p['cid'] ]['type'] == 'helper' ) {
				if ( raysn_check_user_column( $p['cid'] ) ) {
					$SqlArray['cid']= $p['cid'];
				} else
					raysn_clewbox( language( 'no permission for the column' ) );
			} else
				raysn_clewbox( translate( 'can not publish this column' ) );
		} else
			raysn_clewbox( translate( 'cid empty' ) );

		require_once './libraries/string.inc';

		//Check Text
		if ( isset ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 255 ) )
			$SqlArray['text']= htmlspecialchars( trim( $p['text'] ) );
		else
			raysn_clewbox ( translate( 'text format error' ) );

		$SqlArray['uid']= raysn_get_user_id( );
		$SqlArray['pass']= raysn_check_user_permit( 'helper', 'pass' );
		$SqlArray['created']= time( );

		//.Insert Data
		raysn_object( 'mysql' )->insert( 'helper', $SqlArray );

		//3.Update Column
		_Count_Documents( $SqlArray['cid'] );

		//.Operation Complete
		$_SESSION['HelperAskMark']= time( );
		setcookie ( "Helper_cid", $SqlArray['cid'] );
		if ( $SqlArray['pass'] ) {
			_Drop_ColumnPages( $SqlArray['cid'] );
		}
		raysn_clewbox ( translate( 'ask success' ), url( 'helper/list/question' ) );
	}
}
