<?php
/*
	file:	/modules/helper/edit.php
	modify:	2009/04/20 - 2010/03/27
*/

define( 'PAGE_SIZE', variable_get( 'PageSize', 10 ) );

function helper_edit( &$p )
{
	//.Check Request
	if ( ! empty ( $p['id'] )
		&& is_numeric( $p['id'] ) )
		$hid = $p['id'];
	else
		raysn_clewbox ( translate( 'helper id empty' ) );

	require_once './modules/helper/helper.inc';
	if ( ! $DataArray['Helper']= _Get_HelperData( $hid ) ) {
		raysn_clewbox ( translate( 'helper not exist' ) );
	}

	//view form
	if ( empty ( $p['confirm'] ) )
	{
		if ( empty ( $p['page'] ) || $p['page'] < 1 ) {
			$NowIndex= 1;
		} else {
			$NowIndex= $p['page'];
		}

		//Page List
		$DataArray['Pagelist']= raysn_object( 'pagelist' )->_Set_PageInfo( array(
				'TotalNumber'=> $GLOBALS['OBJECT']['mysql']->select_count( 'helper_answer', "`hid`= '$hid'" ),
				'NowIndex'=> $NowIndex
			) )->_Get_Pagelist( );

		if ( $NowIndex > $GLOBALS['OBJECT']['pagelist']->TotalPage ) {
			$NowIndex = 1;
		}

		//.Select Replies Data
		$DataArray['Answers'] = $GLOBALS['OBJECT']['mysql']
			->select( 'helper_answer', array(
				'where'=> "`hid`= '$hid'",
				'order'=> '`replied`',
				'limit'=> ( ( $NowIndex- 1 ) * PAGE_SIZE ) . ',' . PAGE_SIZE
			) );

		require_once './modules/user/user.inc';
		require_once './modules/column/column.inc';
		$ColumnDatas= _Get_ColumnDatas( );
		$DataArray['Helper']['name'] = _Get_UserName( $DataArray['Helper']['uid'] );
		$DataArray['ColumnAvailable'] = _Get_ColumnAvailable( 'helper' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 )
		{
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$DataArray['ColumnAvailable'] = array_intersect( $UserAllowedCids, $DataArray['ColumnAvailable'] );
		}
		return $DataArray;
	}
	else
	{
		//.Check Request
		$SqlArray['pass']= raysn_check_user_permit( 'helper', 'pass' );
		if ( raysn_get_user_id() != $DataArray['Helper']['uid'] && ! $SqlArray['pass'] ) {
			raysn_clewbox( translate( 'you can not edit others' ) );
		}
		require_once './modules/column/column.inc';

		//.Check cid
		if ( ! empty ( $p['cid'] )
			&& $p['cid'] != $DataArray['Helper']['cid'] )
		{
			$ColumnDatas= _Get_ColumnDatas( );
			if ( ! empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
				&& $ColumnDatas[ $p['cid'] ]['type'] == 'helper' ) {
				if ( raysn_check_user_column( $p['cid'] ) ) {
					$SqlArray['cid']= $p['cid'];
				} else
					raysn_clewbox( language( 'no permission for the column' ) );
			} else
				raysn_clewbox( translate( 'can not publish this column' ) );
		}

		require_once './libraries/string.inc';

		//Check Text
		if ( isset ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 255 ) )
			$SqlArray['text']= trim( $p['text'] );
		else
			raysn_clewbox ( translate( 'text format error' ) );

		$SqlArray['created']= time( );

		//.Insert Data
		raysn_object( 'mysql' )
			->update( 'helper', $SqlArray, "`hid`= '$hid'" );

		//3.Update Column
		if ( ! empty ( $p['cid'] )
			&& $p['cid']!= $Article['cid'] ) {
			_Count_Documents( $p['cid'] );//Update New Column
			_Count_Documents( $Helper['cid'] );//Update Old Column
		}

		//.Operation Complete
		if ( $SqlArray['pass'] ) {
			variable_set( 'HELPER_UPDATE_TIMESTAMP_'. $hid, time( ) );
		}
		if ( isset ( $SqlArray['cid'] )
			|| $SqlArray['pass'] != $Helper['pass']
			|| $SqlArray['title'] != $Helper['title'] ) {
			_Drop_ColumnPages( $Helper['cid'] );
		}
		raysn_clewbox ( translate( 'edit success' ) );
	}
}
