<?php
/*
	file:	/modules/install/index.php
	modify:	2010/01/07 - 2010/05/18
*/

function Install_index( &$p )
{
	//.check cleanURLs
	if ( isset ( $p['CheckCleanURLs'] ) ) {
		return array( 'cleanURL'=> translate( 'support cleanURL' ) );
	}

	//.check installed
	if ( Raysn_Check_Installed( ) ) {
		return array( 'ViewName'=> 'Install_success' );
	}
	if ( filemtime( './includes/profile/settings.php' ) != Raysn_Check_Timestamp( ) ) {
		raysn_clewbox( translate( 'Repair your own profile' ) );
	}

	//.read agreement
	if ( empty ( $_POST['agreement'] )
		|| $_POST['agreement'] != 'agree' ) {
		return array( );
	}
	else
	{
		//.Check Server
		if ( phpversion() < '5.2.0' ) {
			message_set( 'your php version too lower', array( '@version'=> phpversion() ) );
		}
		foreach ( array( 'gd', 'mbstring' ) as $ext ) {
			if ( ! extension_loaded( $ext ) ) {
				message_set( 'your php not load ext', array( '@ext'=> $ext ) );
			}
		}
		if ( ! function_exists( 'mysql_connect' ) ) {
			message_set( 'you are not installed mysql' );
		}

		//.Check dir
		$FileObject = raysn_object( 'file' );
		foreach ( array( './archives/','./includes/backup/','./includes/cache/','./includes/permit/' ) as $filepath ) {
			if ( ! $FileObject->path( $filepath )->is_writeable() ) {
				message_set( 'dir not writeable', array( '@filepath'=> $filepath ) );
			}
		}

		//.check settings file
		if ( ! $FileObject->path( './includes/profile/settings.php' )->is_writeable() ) {
			message_set( 'settings file not writeable', array( '@filepath'=> $FileObject->path() ) );
		}

		if ( message_check( ) ) {
			return array( );
		}
	}

	//.setup
	if ( empty ( $p['confirm'] ) ) {
		return array( 'ViewName'=> 'Install_setup' );
	}
	else
	{
		//.Process Mysql Passport
		if ( empty ( $p['dbhost'] ) ) {
			$p['dbhost'] = 'localhost';
		}

		if ( isset ( $p['dbport'] )
			&& $p['dbport'] != '3306' ) {
			$p['dbhost'] .= ':' . $p['dbport'];
		}

		if ( empty ( $p['dbname'] )
			|| empty ( $p['dbuser'] )
			|| empty ( $p['dbpass'] ) ) {
			raysn_clewbox ( translate( 'input mysql passport' ) );
		}

		//.Check Mysql Passport
		global $CONFIG;
		$CONFIG['DB_URL']= 'mysql://'.$p['dbuser'].':'.$p['dbpass'].'@'.$p['dbhost'].'/'.$p['dbname'];
		if ( raysn_object( 'mysql' )->_Get_Version( ) < '5.0.1' ) {
			raysn_clewbox( translate( 'your mysql version too lower', array( '@version'=> $MysqlVersion ) ) );
		}

		//.Process User Passport
		require_once './libraries/string.inc';
		require_once './modules/user/user.inc';

		//Check User
		if ( ! empty ( $p['user'] )
			&& _Check_Chrlen( $p['user'], 3, 16 ) ) {
			$SqlArray['user']= $p['user'];
		}
		else {
			raysn_clewbox ( translate( 'user format error', array( '@user'=> $p['user'] ) ) );
		}

		//Check Name
		if ( ! empty ( $p['name'] )
			&& _Check_Strlen( $p['name'], 2, 7 ) ) {
			$SqlArray['name']= trim ( $p['name'] );
		}
		else {
			raysn_clewbox ( translate( 'name format error', array( '@name'=> $p['name'] ) ) );
		}

		//Check Pass
		if ( ! empty ( $p['pass1'] )
			&& ! empty ( $p['pass2'] ) )
		{
			if ( ! _Check_PasswordFormat( $p['pass1'], 6, 16 ) )
				raysn_clewbox ( translate( 'password format error' ) );
			elseif ( $p['pass2'] != $p['pass1'] )
				raysn_clewbox ( translate( 'password confirm error' ) );
			else
				$SqlArray['pass']= raysn_get_pass_encode( $p['pass1'] );
		}
		else
			raysn_clewbox ( translate( 'password empty' ) );

		$SqlArray['uid']= $SqlArray['rid']= 1;
		$SqlArray['status']= 1;
		$SqlArray['created']= time( );

		//.Check CleanURLs
		if ( $p['cleanURL'] == 'support' ) {
			$INDEX_PATH = '';
		}
		else {
			$INDEX_PATH = 'index.php/';
		}

		//.Setup Mysql Passport
		$FileObject = raysn_object( 'file' );
		$FileObject->path( './includes/profile/settings.php' )
			->make( "<?php\n"
				. "define( 'ROOT_DIR', '" . preg_replace( '/index\.php(.*)/','',$_SERVER['PHP_SELF'] ) . "' );"
				. "define( 'INDEX_PATH', '$INDEX_PATH' );"

				. "\$SITE['NAME'] = '" . translate( 'my site name', array( '@name'=> $SqlArray['name'] ) ) . "';"
				. "\$SITE['HOST'] = 'http://{$_SERVER['HTTP_HOST']}';"
				. "\$SITE['EMAIL'] = '".$SITE['EMAIL']."';"
				. "\$SITE['BEIAN'] = '".$SITE['BEIAN']."';"
				. "\$SITE['KEYWORDS'] = '".$SITE['KEYWORDS']."';"
				. "\$SITE['DESCRIPTION'] = '".$SITE['DESCRIPTION']."';"

				. "\$CONFIG['DB_URL'] = '".$CONFIG['DB_URL']."';"
				. "\$CONFIG['UNLOCK'] = '".$SqlArray['pass']."';"
				. "\$CONFIG['SITE_ACCESS'] = 'opened';"
				. "\$CONFIG['CACHE_PAGE'] = 'opened';"
				. "\$CONFIG['STATIC_LINK'] = 'closed';"
				. "\$CONFIG['TIME_ZONE'] = 'Etc/GMT-8';"

				. "\$CONFIG['MAIL_SMTPHOST'] = '".$CONFIG['MAIL_SMTPHOST']."';"
				. "\$CONFIG['MAIL_SMTPPORT'] = '".$CONFIG['MAIL_SMTPPORT']."';"
				. "\$CONFIG['MAIL_AUTH'] = '".$CONFIG['MAIL_AUTH']."';"
				. "\$CONFIG['MAIL_ADDRESS'] = '".$CONFIG['MAIL_ADDRESS']."';"
				. "\$CONFIG['MAIL_PASSWORD'] = '".$CONFIG['MAIL_PASSWORD']."';"
			);

		//.Start Install
		require './includes/profile/settings.php';
		$MysqlTableObject= raysn_object( 'mysql_table' );
		if ( $MysqlTableObject->_check_table_exist( 'role' ) ) {
			$RoleTableInstalled = TRUE;
		}
		if ( $MysqlTableObject->_check_table_exist( 'user' ) ) {
			$UserTableInstalled = TRUE;
		}

		$Schemas = array( );
		$Modules = array( 'column', 'page', 'template', 'block', 'file', 'data', 'role', 'user', 'panel', 'article', 'attachment' );
		require_once './libraries/module.inc';
		foreach ( $Modules as $ModuleName ) {
			$InstallFile = "./modules/$ModuleName/$ModuleName.install";
			if ( ! is_file( $InstallFile ) ) {
				raysn_clewbox( translate( 'check module files', array( '@dirpath'=> dirname( $InstallFile ) ) ) );
			}
			require_once $InstallFile;
			$Schemas = array_merge( $Schemas, call_user_func( $ModuleName . "_schema" ) );
			_Make_ModulePermitFile( $ModuleName );
		}

		foreach ( $Schemas as $tablename=> $table ) {
			$MysqlTableObject->create_table( $tablename, $table );
		}

		//.Insert Data
		if ( ! $RoleTableInstalled ) {
			$MysqlTableObject->insert( 'role', array( 'name'=> translate( 'guest user' ) ) );
			$MysqlTableObject->update( 'role', array( 'rid'=> 0 ), '`rid`= ' . $MysqlTableObject->_Get_InsertId( ) );
			$MysqlTableObject->insert( 'role', array( 'rid'=> 1, 'name'=> translate( 'register user' ) ) );
			$MysqlTableObject->insert( 'role', array( 'rid'=> 2, 'name'=> translate( 'content editor' ) ) );
		}
		if ( ! $UserTableInstalled ) {
			$MysqlTableObject->insert( 'user', array( 'rid'=> 0, 'name'=> translate( 'guest user' ) ) );
			$MysqlTableObject->update( 'user', array( 'uid'=> 0 ), '`uid`= ' . $MysqlTableObject->_Get_InsertId( ) );
			$MysqlTableObject->insert( 'user', $SqlArray );
		}

		watchdog( 'install site success' );
		variable_set( 'RAYSN_INSTALLED_VERSION', RAYSN_VERSION );
		raysn_clewbox ( translate( 'install site success' ), url( 'install' ) );
	}
}
