<?php
/*
	file:	/modules/install/update.php
	modify:	2010/04/23 - 2010/05/04
*/

function Install_update( &$p )
{
	//.check installed
	if ( ! Raysn_Check_Installed( ) ) {
		raysn_goto_page( ROOT_DIR . 'index.php/install' );
	}

	//.Process Tables
	$Schemas = array( );
	require_once './libraries/module.inc';
	foreach ( raysn_object( 'file' )->path( './modules/' )->dirs( ) as $ModuleName ) {
		$InstallFile = "./modules/$ModuleName/$ModuleName.install";
		if ( is_file( $InstallFile ) ) {
			if ( filemtime( $InstallFile ) != raysn_check_timestamp( ) ) {
				message_set( 'file has been modified', array( '@file'=> $InstallFile ) );
			}
			require_once $InstallFile;
			$Schemas = array_merge( $Schemas, call_user_func( $ModuleName . "_schema" ) );
		}
	}

	if ( empty ( $p['confirm'] ) ) {
		return array( 'Updated'=> variable_get( 'RAYSN_INSTALLED_VERSION' ) == RAYSN_VERSION );
	}
	else
	{
		if ( variable_get( 'RAYSN_INSTALLED_VERSION' ) == RAYSN_VERSION ) {
			raysn_clewbox( translate( 'already updated', array( '@Version'=> RAYSN_VERSION ) ) );
		}

		//.Start Update
		$MysqlTableObject= raysn_object( 'mysql_table' );
		foreach ( $Schemas as $tablename=> $table ) {
			if ( $TableFields = $MysqlTableObject->_show_table_fields( $tablename ) ) {
				if ( $AlterAdds = array_diff_key( $table['fields'], $TableFields ) ) {
					foreach ( $AlterAdds as $fieldname=> $filedset ) {
						while ( list( $field ) = each( $table['fields'] ) ) {
							if ( $fieldname == $field ) {
								prev( $table['fields'] );prev( $table['fields'] );
								list( $field ) = each( $table['fields'] );
								$AlterAdds[ $fieldname ]['after'] = $field;
								next( $table['fields'] );next( $table['fields'] );
							}
						}
					}
					$MysqlTableObject->alter_add( $tablename, $AlterAdds );
				}
				if ( $AlterDrops = array_diff_key( $TableFields, $table['fields'] ) ) {
					$MysqlTableObject->alter_drop( $tablename, $AlterDrops );
				}
			}
		}

		//.Update Success
		watchdog( 'update site success' );
		variable_set( 'RAYSN_INSTALLED_VERSION', RAYSN_VERSION );
		raysn_clewbox ( translate( 'update site success' ) );
	}
}
