<?php
/*
	file:	/modules/page/edit.php
	modify:	2009/09/07 - 2010/05/18
*/

function Page_edit( &$p )
{
	//.Check Request
	if ( ! empty ( $p['id'] )
		&& is_numeric( $p['id'] ) )
		$pid = $p['id'];
	else
		raysn_clewbox ( translate( 'page id empty' ) );

	require_once './modules/page/page.inc';
	if ( ! $Page= _Get_PageById( $pid ) ) {
		raysn_clewbox ( translate( 'page not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		$Page['Directorys'] = array( );
		foreach ( raysn_object( 'mysql' )
			->select( 'page', array( 'select'=> 'directory', 'group'=> 'directory', 'where'=> "`directory`!=''" ) ) as $page ) {
			$Page['Directorys'][] = $page['directory'];
		}
		$Page['text'] = htmlspecialchars( $Page['text'] );
		$Page['changed'] = date( 'Y-m-d H:i:s', $Page['changed'] );

		if ( ! empty ( $Page['directory'] ) ) {
			$Page['name'] = $Page['directory'].'/'.$Page['name'];
		}

		require_once './modules/template/template.inc';
		return $Page;
	}
	else
	{
		//.Process Data
		require_once './libraries/string.inc';
		//Check Title
		if ( isset ( $p['title'] )
			&& $p['title']!= $Page['title'] )
		{
			if ( ! _Check_Strlen( $p['title'], 2, 16 ) )
				raysn_clewbox ( translate( 'title format error', array( '@min'=> 2, '@max'=> 16 ) ) );
			elseif ( _Check_PageTitleExist( $p['title'] ) )
				raysn_clewbox ( translate( 'title already exist' ) );
			else
				$SqlArray['title']= $p['title'];
		}

		//.Check Template
		require_once './modules/template/template.inc';
		if ( isset ( $p['template'] )
			&& $p['template']!= $Page['template'] ) {
			if ( _Check_templateNameExist( $p['template'] ) )
				$SqlArray['template']= $p['template'];
			else
				raysn_clewbox ( translate( 'template empty' ) );
		}

		//Check Directory
		if ( isset ( $p['directory'] )
			&& $p['directory'] != $Page['directory']
			&& _Check_Chrlen( $p['directory'], 0, 16 ) ) {
			$SqlArray['directory']= trim( $p['directory'] );
			_Drop_PageFile( $Page['pid'] );
		}

		//Check Data
		if ( isset ( $p['text'] ) ) {
			if ( strlen( $p['text'] ) > 65535 )
				raysn_clewbox ( translate( 'text too long' ) );
			else
				$SqlArray['text']= $p['text'];
		}

		$SqlArray['changed']= time( );

		//.Update Data
		raysn_object( 'mysql' )->update( 'page', $SqlArray, "`pid`= '$pid'" );

		//.Make Page
		_Make_PageFile( $Page['name'] );

		//.Operation Complete
		raysn_clewbox ( translate( 'edit page success' ) );
	}
}
