<?php
/*
	file:	/modules/page/make.php
	modify:	2009/09/07 - 2010/05/18
*/

function Page_make( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( 'AllowedTypes' => explode( ',', variable_get( "Page_AllowedTypes", "html,xml" ) ) );
	}	
	else
	{
		//.Check Request
		require_once './libraries/string.inc';
		require_once './modules/page/page.inc';

		//Check Title
		if ( ! empty ( $p['title'] )
			&& _Check_Strlen( $p['title'], 2, 16 ) )
		{
			if ( ! _Check_PageTitleExist( $p['title'] ) )
				$SqlArray['title']= htmlspecialchars( trim( $p['title'] ) );
			else
				raysn_clewbox ( translate( 'title already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'title length illegal', array( '@min'=> 2, '@max'=> 16 ) ) );

		//Check Type
		if ( empty ( $p['type'] )
			|| ! in_array( $p['type'], explode( ',', variable_get( "Page_AllowedTypes", "html,xml" ) ) ) ) {
			raysn_clewbox ( translate( 'type not allowed' ) );
		}

		//Check Name
		if ( ! empty ( $p['name'] )
			&& preg_match( "/^[a-zA-Z0-9\-\_]{3,16}$/", $p['name'] ) )
		{
			if ( ! _Check_PageNameExist( $p['name'] ) )
				$SqlArray['name']= $p['name'] .".". $p['type'];
			else
				raysn_clewbox ( translate( 'name already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'name format error' ) );

		$SqlArray['template']= variable_get( "Page_DefaultTemplate", "page_default" );
		$SqlArray['created']= $SqlArray['changed']= time( );

		//.Insert Data
		raysn_object( 'mysql' )->insert( 'page', $SqlArray );

		//.Operation Complete
		raysn_clewbox ( translate( 'make page success' ), url( 'page/' . $GLOBALS['OBJECT']['mysql']->_Get_InsertId() . '/edit' ) );
	}
}
