<?php
/*
	file:	/modules/panel/logs.php
	modify:	2010/01/15 - 2010/03/15
*/

define( 'CLEAN_EVENT_INTERVAL', 604800 );
define( 'PAGE_SIZE', variable_get( 'PageSize', 10 ) );

function Panel_logs( &$p )
{
	if ( empty ( $p['id'] ) ) {
		$p['id'] = 'event';
	}

	switch ( $p['id'] ) {
		case 'clean' :
			raysn_object( 'mysql' )
				->delete( 'watchdog', "`timestamp` < " . ( time( ) - CLEAN_EVENT_INTERVAL ) );

			if ( $GLOBALS['OBJECT']['mysql']->db_affected_rows( ) ) {
				raysn_clewbox ( translate( 'clean event success' ) );
			}
			else {
				raysn_clewbox ( translate( 'already cleared' ) );
			}
		case 'error' :
			$LogsType = WATCHDOG_ERROR;
			$DataArray['ViewName'] = 'Panel_error';
			break;
		case 'event' :
		default :
			$LogsType = WATCHDOG_EVENT;
			$DataArray['ViewName'] = 'Panel_event';
	}

	//.Check Request
	$GLOBALS['BackupPath']= 'panel/logs/'. $p['id'] .'/';
	if ( empty ( $p['page'] ) || $p['page'] < 1 ) {
		$NowIndex= 1;
	} else {
		$NowIndex= $p['page'];
	}

	$SqlWhere = "`type`= '" . $LogsType . "'";

	//Page List
	$DataArray['Pagelist']= raysn_object( 'pagelist' )->_Set_PageInfo( array(
			'TotalNumber'=> $GLOBALS['OBJECT']['mysql']->select_count( 'watchdog', $SqlWhere ),
			'NowIndex'=> $NowIndex
		) )->_Get_Pagelist( );

	if ( $NowIndex > $GLOBALS['OBJECT']['pagelist']->TotalPage ) {
		$NowIndex = 1;
	}

	//.Select Data
	$DataArray['LogsList']= raysn_object( 'mysql' )->select( 'watchdog', array(
			'where'=> $SqlWhere,
			'order'=> '`timestamp`',
			'limit'=> ( ( $NowIndex- 1 ) * PAGE_SIZE ) . ',' . PAGE_SIZE
		) );

	require_once './modules/user/user.inc';
	return $DataArray;
}
