<?php
/*
	file:	/modules/panel/module.php
	modify:	2009/10/25 - 2010/05/18
*/

function Panel_module( &$p )
{
	require_once './libraries/module.inc';
	if ( ! isset ( $p['id'] )
		|| ! $ModuleInfo= _Get_ModuleInfo( strtolower( $p['id'] ) ) ) {
		raysn_clewbox ( translate( 'module not exist' ) );
	}
	if ( ! _Check_ModuleWriteable( $p['id'] ) ) {
		raysn_clewbox ( translate( 'permit file disabled', array( '@filepath'=> _Get_ModulePermitFilePath( $p['id'] ) ) ) );
	}

	if ( _Check_ModuleEnabled( $p['id'] ) ) {
		if ( empty ( $ModuleInfo['type'] )
			|| $ModuleInfo['type'] != 'plus-module' ) {
			raysn_clewbox ( translate( 'can not disable base-module' ) );
		}
		_Disable_ModuleAccess( $p['id'] );
		watchdog( 'disabled module', array( '@module'=> $p['id'] ) );
		raysn_clewbox( translate( 'disable module success' ), url( 'panel/setting/'. $p['id'] ) );
	}
	else {
		if ( isset( $ModuleInfo['depend'] )
			&& ! _Check_ModuleEnabled( $ModuleInfo['depend'] ) ) {
			$DependModule= _Get_ModuleInfo( $ModuleInfo['depend'] );
			raysn_clewbox( translate( 'Depend module not enable', array( '@name'=> $DependModule['title'] ) ) );
		}
		_Enable_ModuleAccess( $p['id'] );
		if ( isset( $ModuleInfo['depend'] )
			&& $ModuleInfo['depend'] == 'column' ) {
			variable_set( 'Column_ModuleTypes', serialize( array() ) );
		}
		watchdog( 'enabled module', array( '@module'=> $p['id'] ) );
		raysn_clewbox( translate( 'enable module success' ), url( 'panel/setting/'. $p['id'] ) );
	}
}
