<?php
/*
	file:	/modules/panel/permit.php
	modify:	2009/07/25 - 2010/05/18
*/

function Panel_permit( &$p )
{
	require_once './libraries/module.inc';
	if ( ! isset ( $p['id'] )
		|| ! $ModuleInfo= _Get_ModuleInfo( strtolower( $p['id'] ) ) )
	{
		$ModuleList = array( 'base-module'=> array(), 'plus-module'=> array() );
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs( ) as $ModuleName ) {
			$ModuleInfo = _Get_ModuleInfo( $ModuleName );
			if ( isset ( $ModuleInfo['type'] ) ) {
				$ModuleList[ $ModuleInfo['type'] ][]=  $ModuleInfo;
			}
		}

		return array( 'ViewName'=> 'Panel_permits', 'ModuleList'=> $ModuleList );
	}

	if ( $ModuleInfo['type'] == 'plus-module'
		&& ! _Check_ModuleEnabled( $p['id'] ) ) {
		$ModuleDisabled = TRUE;
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		if ( ! empty ( $ModuleDisabled ) ) {
			message_set( 'module disabled', array( '@module'=> $ModuleInfo["title"] ) );
		}
		if ( ! _Check_ModuleInstallFile( $p['id'] ) ) {
			message_set( 'install changed', array( '@file'=> './modules/' . $p['id'] . '/' . $p['id'] . '.install' ) );
		}

		require_once './modules/role/role.inc';
		$DataArray['ModuleInfo'] = $ModuleInfo;
		$DataArray['Rolelist'] = _Get_RoleList( );
		$DataArray['ActionTitles'] = _Get_ModuleActionTitles( $p['id'] );

		$DataArray['Permissions'] = _Get_ModulePermission( $p['id'] );
		$InstallPermissions = _Get_ModuleInstallPermission( $p['id'] );
		$DataArray['GuestActions']= $DataArray['GuestDisabled'] = array( );
		foreach ( $DataArray['Permissions']['access'] as $action => $permits ) {
			if ( in_array( 0, $permits ) ) {
				$DataArray['GuestActions'][]= $action;
			}
		}
		foreach ( $InstallPermissions['access'] as $action => $permits ) {
			if ( empty ( $permits ) ) {
				$DataArray['GuestDisabled'][]= $action;
			}
		}

		return $DataArray;
	}
	else
	{
		if ( ! empty ( $ModuleDisabled ) ) {
			raysn_clewbox ( translate( 'module disabled', array( '@module'=> $ModuleInfo["title"] ) ) );
		}

		//.Check Permits
		if ( ! isset ( $p['access'] ) ) {
			$p['access'] = array( );
		}
		elseif ( ! is_array( $p['access'] ) ) {
			raysn_clewbox ( translate( 'access empty' ) );
		}

		//.Check Unlocks
		if ( ! isset ( $p['unlock'] ) ) {
			$p['unlock'] = array( );
		}
		elseif ( ! is_array( $p['unlock'] ) ) {
			raysn_clewbox ( translate( 'unlock empty' ) );
		}

		//.Make Permits
		if ( ! _Make_ModulePermitFile( $p['id'], array( 'access'=> $p['access'], 'unlock'=> $p['unlock'] ) ) ) {
			raysn_clewbox ( translate( 'permit file disabled', array( '@filepath'=> $GLOBALS['OBJECT']['file']->path() ) ) );
		}

		//.Operation Complete
		watchdog( 'modify module permit', array( '@module'=> $p['id'] ) );
		raysn_clewbox ( translate( 'modify module success' ) );
	}
}
