<?php
/*
	file:	/modules/panel/setting.php
	modify:	2009/07/25 - 2010/03/11
*/

function Panel_setting( &$p )
{
	require_once './libraries/module.inc';
	if ( ! isset ( $p['id'] )
		|| ! _Check_ModuleExist( $p['id'] ) )
	{
		$ModuleList = array( 'base-module'=> array(), 'plus-module'=> array() );
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs( ) as $ModuleName ) {
			$ModuleInfo = _Get_ModuleInfo( $ModuleName );
			if ( isset ( $ModuleInfo['type'] ) ) {
				$ModuleInfo['status'] = _Check_ModuleEnabled( $ModuleName );
				$ModuleList[ $ModuleInfo['type'] ][]=  $ModuleInfo;
			}
		}

		return array( 'ViewName'=> 'Panel_settings', 'ModuleList'=> $ModuleList );
	}

	if ( empty ( $p['confirm'] ) )
	{
		$ModuleInfo = _Get_ModuleInfo( strtolower( $p['id'] ) );
		if ( isset( $ModuleInfo['depend'] )
			&& ! _Check_ModuleEnabled( $ModuleInfo['depend'] ) ) {
			$DependModule= _Get_ModuleInfo( $ModuleInfo['depend'] );
			message_set ( 'Depend module not enable', array( '@name'=> $DependModule['title'] ) );
		}
		return $ModuleInfo;
	}
	else
	{
		//.Check Request
		if ( isset ( $p['setting'] )
			&& is_array ( $p['setting'] ) )
		{
			//.Process Data
			foreach ( $p['setting'] as $name=> $value ) {
				if ( is_array( $value ) ) {
					variable_set( $name, serialize( $value ) );
				}
				else {
					variable_set( $name, htmlspecialchars( $value ) );
				}
			}

			watchdog( 'modified module setting', array( '@module'=> $p['id'] ) );
			//.Operation Complete
			raysn_clewbox ( translate( 'setting module success' ) );
		}
		else {
			raysn_clewbox ( translate( 'no setting change' ) );
		}
	}
}
