<?php
/*
	file:	/modules/panel/site.php
	modify:	2009/02/20 - 2010/05/18
*/

function panel_site( &$p )
{
	if ( empty ( $p['confirm'] ) ) {
		return array( 'SITE'=> $GLOBALS['SITE'], 'CONFIG'=> $GLOBALS['CONFIG'] );
	}
	else
	{
		//.Check settings file
		if ( ! is_writeable( './includes/profile/settings.php' ) ) {
			raysn_clewbox ( translate( 'settings not writeable' ) );
		}

		//.Check Request
		if ( ( empty ( $p['SITE'] ) || ! is_array( $p['SITE'] ) )
			&& ( empty ( $p['CONFIG'] ) || ! is_array( $p['CONFIG'] ) ) ) {
			raysn_clewbox ( translate( 'no settings change' ) );
		}

		global $SITE, $CONFIG;

		//.SITE
		if ( isset ( $p['SITE'] ) ) {
			foreach ( $p['SITE'] as $key=> $value ) {
				$SITE[ $key ] = htmlspecialchars( str_replace( '\"', '"', $value ) );
			}
		}

		//.CONFIG
		if ( isset( $p['CONFIG']['SITE_ACCESS'] )
			&& in_array( $p['CONFIG']['SITE_ACCESS'], array( 'opened', 'closed' ) ) ) {
			$CONFIG['SITE_ACCESS'] = $p['CONFIG']['SITE_ACCESS'];
		}
		if ( isset( $p['CONFIG']['CACHE_PAGE'] )
			&& in_array( $p['CONFIG']['CACHE_PAGE'], array( 'opened', 'closed' ) ) ) {
			$CONFIG['CACHE_PAGE'] = $p['CONFIG']['CACHE_PAGE'];
		}
		if ( isset( $p['CONFIG']['STATIC_LINK'] )
			&& in_array( $p['CONFIG']['STATIC_LINK'], array( 'opened', 'closed' ) ) ) {
			$CONFIG['STATIC_LINK'] = $p['CONFIG']['STATIC_LINK'];
		}
		if ( isset( $p['CONFIG']['TIME_ZONE'] )
			&& preg_match( "/^Etc\/GMT(\+|\-)\d{1,2}$/", $p['CONFIG']['TIME_ZONE'] ) ) {
			$CONFIG['TIME_ZONE'] = $p['CONFIG']['TIME_ZONE'];
		}
		if ( isset( $p['CONFIG']['UNLOCK'] ) ) {
			$CONFIG['UNLOCK'] = raysn_get_pass_encode( $p['CONFIG']['UNLOCK'] );
		}

		//.MAIL CONFIG
		if ( isset( $p['CONFIG']['MAIL_SMTPHOST'] ) ) {
			$CONFIG['MAIL_SMTPHOST'] = htmlspecialchars( str_replace( '\"', '"', $p['CONFIG']['MAIL_SMTPHOST'] ) );
		}
		if ( isset( $p['CONFIG']['MAIL_SMTPPORT'] )
			&& is_numeric( $p['CONFIG']['MAIL_SMTPPORT'] ) ) {
			$CONFIG['MAIL_SMTPPORT'] = $p['CONFIG']['MAIL_SMTPPORT'];
		}
		if ( isset( $p['CONFIG']['MAIL_AUTH'] )
			&& is_numeric( $p['CONFIG']['MAIL_AUTH'] ) ) {
			$CONFIG['MAIL_AUTH'] = $p['CONFIG']['MAIL_AUTH'];
		}
		if ( isset( $p['CONFIG']['MAIL_ADDRESS'] ) ) {
			$CONFIG['MAIL_ADDRESS'] = htmlspecialchars( str_replace( '\"', '"', $p['CONFIG']['MAIL_ADDRESS'] ) );
		}
		if ( isset( $p['CONFIG']['MAIL_PASSWORD'] ) ) {
			$CONFIG['MAIL_PASSWORD'] = htmlspecialchars( str_replace( '\"', '"', $p['CONFIG']['MAIL_PASSWORD'] ) );
		}

		raysn_object( 'file' )
			->path( './includes/profile/settings.php' )
			->make( "<?php\n"
			. "define( 'ROOT_DIR', '" . preg_replace( '/index\.php(.*)/','',$_SERVER['PHP_SELF'] ) . "' );"
			. "define( 'INDEX_PATH', '" . INDEX_PATH . "' );"

			. "\$SITE['NAME'] = '".$SITE['NAME']."';"
			. "\$SITE['HOST'] = '".$SITE['HOST']."';"
			. "\$SITE['EMAIL'] = '".$SITE['EMAIL']."';"
			. "\$SITE['BEIAN'] = '".$SITE['BEIAN']."';"
			. "\$SITE['KEYWORDS'] = '".$SITE['KEYWORDS']."';"
			. "\$SITE['DESCRIPTION'] = '".$SITE['DESCRIPTION']."';"

			. "\$CONFIG['DB_URL'] = '".$CONFIG['DB_URL']."';"
			. "\$CONFIG['UNLOCK'] = '".$CONFIG['UNLOCK']."';"
			. "\$CONFIG['SITE_ACCESS'] = '".$CONFIG['SITE_ACCESS']."';"
			. "\$CONFIG['CACHE_PAGE'] = '".$CONFIG['CACHE_PAGE']."';"
			. "\$CONFIG['STATIC_LINK'] = '".$CONFIG['STATIC_LINK']."';"
			. "\$CONFIG['TIME_ZONE'] = '".$CONFIG['TIME_ZONE']."';"

			. "\$CONFIG['MAIL_SMTPHOST'] = '".$CONFIG['MAIL_SMTPHOST']."';"
			. "\$CONFIG['MAIL_SMTPPORT'] = '".$CONFIG['MAIL_SMTPPORT']."';"
			. "\$CONFIG['MAIL_AUTH'] = '".$CONFIG['MAIL_AUTH']."';"
			. "\$CONFIG['MAIL_ADDRESS'] = '".$CONFIG['MAIL_ADDRESS']."';"
			. "\$CONFIG['MAIL_PASSWORD'] = '".$CONFIG['MAIL_PASSWORD']."';"
			);

		//.Operation Complete
		watchdog( 'modify site settings' );
		raysn_clewbox ( translate( 'site modified success' ) );
	}
}
