<?php
/*
	file:	/modules/report/index.php
	modify:	2009/04/20 - 2010/04/23
*/

function Report_index( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( 'Types'=> explode( ",", variable_get( "Report_Types", translate( 'Report_Types' ) ) ) );
	}
	else
	{
		//1.Check Request
		if ( ! isset ( $_COOKIE['RAYSN_SECCODE'] )
			|| strtolower( $p['code'] ) != $_COOKIE['RAYSN_SECCODE'] ) {
			raysn_clewbox ( language( 'check code error' ) );
		}

		require_once './libraries/string.inc';

		//Check Type
		if ( isset ( $p['type'] )
			&& is_numeric( $p['type'] ) )
			$SqlArray['type']= $p['type'];
		else
			raysn_clewbox ( translate( 'type format error' ) );

		//Check Name
		if ( isset ( $p['name'] )
			&& _Check_Strlen( $p['name'], 2, 8 ) )
			$SqlArray['name']= $p['name'];
		else
			raysn_clewbox ( translate( 'name format error' ) );

		//Check Email
		if ( isset ( $p['mail'] )
			&& _Check_EmailFormat( $p['mail'] ) )
			$SqlArray['mail']= $p['mail'];
		else
			raysn_clewbox ( translate( 'email format error' ) );

		//Check Text
		if ( isset ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 65535 ) )
			$SqlArray['text']= htmlspecialchars( trim( $p['text'] ) );
		else
			raysn_clewbox ( translate( 'text format error' ) );

		$SqlArray['created']= time( );

		//.Insert Data
		raysn_object( 'mysql' )->insert( 'report', $SqlArray );

		if ( variable_get( 'Report_Email' )
			&& raysn_object( 'mail' )->Connect( ) ) {
			$MessageArray = array(
				'@site'=> $GLOBALS['SITE']['NAME'],
				'@name'=> $SqlArray['name'],
				'@mail'=> $SqlArray['mail'],
				'@text'=> $SqlArray['text']
			);

			$GLOBALS['OBJECT']['mail']->Send( variable_get( 'Report_Email' ), 'report-index', $MessageArray );
		}

		raysn_clewbox ( translate( 'report success' ), url( 'report' ) );
	}
}
