<?php
/*
	file:	/modules/template/edit.php
	modify:	2009/02/28 - 2010/03/13
*/

function Template_edit( &$p )
{
	//.Check Request
	if ( ! empty ( $p['id'] )
		&& is_numeric( $p['id'] ) )
		$tid = $p['id'];
	else
		raysn_clewbox ( translate( 'template id empty' ) );

	require_once './modules/template/template.inc';
	if ( ! $Template= _Get_TemplateData( $tid ) ) {
		raysn_clewbox ( translate( 'template not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		$Template['Tools']= raysn_object('file')
			->path( './modules/template/tools/tools.ini' )
			->_Parse_Inifile( );

		return $Template;
	}
	else
	{
		//.Process Data
		//Check Title
		if ( isset ( $p['title'] )
			&& $p['title']!= $Template['title'] )
		{
			require_once './libraries/string.inc';
			if ( ! _Check_Strlen( $p['title'], 2, 16 ) )
				raysn_clewbox ( translate( 'title format error', array( '@min'=> 2, '@max'=> 16 ) ) );
			elseif ( _Check_TemplateTitleExist( $p['title'] ) )
				raysn_clewbox ( translate( 'title already exist' ) );
			else
				$SqlArray['title']= $p['title'];
		}

		//Check Data
		if ( isset ( $p['data'] )
			&& strlen( $p['data'] ) < 65535 )
		{
			if ( ! preg_match( "/<\?\s.*?\?>/", $p['data'] ) ) {
				$SqlArray['data']= $p['data'];
			}
			else {
				raysn_clewbox ( translate( 'do not use php tags' ) );
			}
		} else {
			raysn_clewbox ( translate( 'template data lenght illegal' ) );
		}

		//Check Type
		if ( isset ( $p['type'] )
			&& $p['type']!= $Template['type']
			&& in_array( $p['type'], array( 'home', 'list', 'text', 'other' ) ) ) {
			$SqlArray['type']= $p['type'];
		}

		$SqlArray['changed']= time( );

		//.Update Data
		raysn_object( 'mysql' )->update( 'template', $SqlArray, "`tid`= '$tid'" );

		//.Make Cache
		_Make_TemplateCache( $Template['name'] );

		//.Operation Complete
		watchdog( 'modified a template', array( '@template'=> $Template['title'], '@name'=> $Template['name'] ) );
		raysn_clewbox ( translate( 'edit template success' ) );
	}
}
