<?php
/*
	file:	/modules/template/make.php
	modify:	2009/02/28 - 2010/04/19
*/

function Template_make( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) ) {
		require_once './libraries/module.inc';
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs( ) as $ModuleName ) {
			$ModuleInfo = _Get_ModuleInfo( $ModuleName );
			if ( isset ( $ModuleInfo['name'] )
				&& ! in_array( $ModuleName, array('template','block','file','data','role','user','panel','attachment') ) ) {
				$DataArray['ModuleList'][]=  $ModuleInfo;
			}
		}

		return $DataArray;
	}	
	else
	{
		//.Check Request
		require_once './libraries/string.inc';
		require_once './modules/template/template.inc';

		//Check Title
		if ( ! empty ( $p['title'] )
			&& _Check_Strlen( $p['title'], 2, 16 ) )
		{
			if ( ! _Check_TemplateTitleExist( $p['title'] ) )
				$SqlArray['title']= htmlspecialchars( trim( $p['title'] ) );
			else
				raysn_clewbox ( translate( 'title already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'title length illegal', array( '@min'=> 2, '@max'=> 16 ) ) );

		//Check Module
		require_once './libraries/module.inc';
		if ( empty ( $p['module'] )
			|| ! _Check_ModuleExist( $p['module'] ) ) {
			raysn_clewbox ( translate( 'module empty' ) );
		}

		//Check Name
		if ( ! empty ( $p['name'] )
			&& preg_match( "/^[a-z0-9]+$/", $p['name'] ) )
		{
			if ( ! _Check_TemplateNameExist( $p['module'] .'_'. $p['name'] ) )
				$SqlArray['name']= trim( $p['module'] .'_'. $p['name'] );
			else
				raysn_clewbox ( translate( 'name already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'name format error' ) );

		$SqlArray['type']= 'other';
		$SqlArray['created']= $SqlArray['changed']= time( );

		//.Insert Data
		raysn_object( 'mysql' )->insert( 'template', $SqlArray );
		$tid = $GLOBALS['OBJECT']['mysql']->_Get_InsertId( );

		//.Make Cache
		_Make_TemplateCache( $p['name'] );

		//.Operation Complete
		watchdog( 'creating a template', array( '@template'=> $SqlArray['title'], '@name'=> $SqlArray['name'] ) );
		raysn_clewbox ( translate( 'make template success' ), url( 'template/' . $tid . '/edit' ) );
	}
}
