<?php
/*
	file:	/modules/user/add.php
	modify:	2009/03/01 - 2010/04/17
*/

function User_add( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './modules/role/role.inc';
		$DataArray['RoleList'] = array_slice( _Get_RoleList( ), 1 );
		$DataArray['ColumnPermission'] = variable_get( 'User_ColumnPermission', 'closed' );
		if ( $DataArray['ColumnPermission'] == 'opened' ) {
			require_once './modules/column/column.inc';
			$DataArray['ColumnOptionGroup'] = _Get_ColumnOptionGroup( );
		}
		return $DataArray;
	}
	else
	{
		//1.Check Request
		//2.Process Data
		require_once './libraries/string.inc';
		require_once './modules/user/user.inc';

		//Check User
		if ( ! empty ( $p['user'] )
			&& _Check_Chrlen( $p['user'], 3, 16 ) )
		{
			if ( ! _Check_UserExist( $p['user'] ) )
				$SqlArray['user']= $p['user'];
			else
				raysn_clewbox ( translate( 'user already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'user format error' ) );

		//Check Email
		if ( ! empty ( $p['mail'] ) )
		{
			if ( ! _Check_EmailFormat( $p['mail'] ) )
				raysn_clewbox ( translate( 'email format error' ) );
			elseif ( _Check_MailExist( $p['mail'] ) )
				raysn_clewbox ( translate( 'email already exist' ) );
			else
				$SqlArray['mail']= $p['mail'];
		}

		//Check Name
		if ( ! empty ( $p['name'] )
			&& _Check_Strlen( $p['name'], 2, 7 ) )
		{
			if ( ! _Check_NameExist( $p['name'] ) )
				$SqlArray['name']= trim ( $p['name'] );
			else
				raysn_clewbox ( translate( 'name already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'name format error' ) );

		//Check Role
		if ( ! empty ( $p['role'] )
			&& is_numeric ( $p['role'] ) )
		{
			require_once './modules/role/role.inc';
			if ( _Check_RoleExist( $p['role'] ) ) {
				$SqlArray['rid']= $p['role'];
			}
			else
				raysn_clewbox ( translate( 'role not exist' ) );
		}
		else
			raysn_clewbox ( translate( 'role format error' ) );

		//Check Pass
		if ( ! empty ( $p['pass1'] )
			&& ! empty ( $p['pass2'] ) )
		{
			if ( ! _Check_PasswordFormat( $p['pass1'], 6, 16 ) )
				raysn_clewbox ( translate( 'password format error' ) );
			elseif ( $p['pass2'] != $p['pass1'] )
				raysn_clewbox ( translate( 'password confirm error' ) );
			else
				$SqlArray['pass']= raysn_get_pass_encode( $p['pass1'] );
		}
		else
			raysn_clewbox ( translate( 'password empty' ) );

		//Check Status
		if ( ! empty ( $p['status'] )
			&& is_numeric ( $p['status'] ) ) {
			$SqlArray['status']= 1;
		}

		$SqlArray['created']= time( );

		//3.Add User
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->insert( 'user', $SqlArray );
		$uid= $MysqlObject->_Get_InsertId( );

		//.Check and Update Columns
		if ( ! empty ( $p['columns'] ) ) {
			if ( ! is_array( $p['columns'] ) ) {
				raysn_clewbox ( translate( 'columns error' ) );
			}
			foreach ( $p['columns'] as $cid ) {
				$MysqlObject->insert( 'user_column', array( 'uid'=> $uid, 'cid'=> $cid ) );
			}
		}

		watchdog( 'creating a user', array( '@user'=> $SqlArray['name'], '@uid'=> $uid ) );
		raysn_clewbox ( translate( 'add user success' ), url( 'user/list' ) );
	}
}
