<?php
/*
	file:	/modules/user/edit.php
	modify:	2009/03/01 - 2010/04/17
*/

function User_edit( &$p )
{
	//.Check Request
	if ( ! empty ( $p['id'] ) )
		$uid= $p['id'];
	else
		raysn_clewbox ( translate( 'user id empty' ) );

	require_once './modules/user/user.inc';
	if ( ! $User= _Get_UserData( $uid ) ) {
		raysn_clewbox ( translate( 'user not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './modules/role/role.inc';
		$User['RoleList'] = array_slice( _Get_RoleList( ), 1 );
		$User['ColumnPermission'] = variable_get( 'User_ColumnPermission', 'closed' );
		if ( $User['ColumnPermission'] == 'opened' ) {
			require_once './modules/column/column.inc';
			$User['UserColumns'] = _Get_UserColumns( $User['uid'] );
			$User['ColumnOptionGroup'] = _Get_ColumnOptionGroup( );
		}

		return $User;
	}
	else
	{
		//1.Check Request
		if ( in_array( $uid, array( 1, raysn_get_user_id( ) ) ) ) {
			raysn_clewbox ( translate( 'can not edit this' ) );
		}

		//2.Process Data
		require_once './libraries/string.inc';

		//Check Email
		if ( isset ( $p['mail'] )
			&& $User['mail'] != $p['mail'] )
		{
			if ( $p['mail'] != NULL ) {
				if ( ! _Check_EmailFormat( $p['mail'] ) )
					raysn_clewbox ( translate( 'email format error' ) );
				elseif ( _Check_MailExist( $p['mail'] ) )
					raysn_clewbox ( translate( 'email already exist' ) );
				else
					$SqlArray['mail'] = $p['mail'];
			}
			else
				$SqlArray['mail'] = NULL;
		}

		//Check Name
		if ( isset ( $p['name'] )
			&& $User['name'] != $p['name'] )
		{
			if ( ! _Check_Strlen( $p['name'], 2, 7 ) )
				raysn_clewbox ( translate( 'name format error' ) );
			elseif ( _Check_NameExist( $p['name'] ) )
				raysn_clewbox ( translate( 'name already exist' ) );
			else
				$SqlArray['name']= trim ( $p['name'] );
		}

		//Check Role
		if ( ! empty ( $p['role'] )
			&& is_numeric ( $p['role'] ) )
		{
			require_once './modules/role/role.inc';
			if ( _Check_RoleExist( $p['role'] ) ) {
				$SqlArray['rid']= $p['role'];
			}
			else
				raysn_clewbox ( translate( 'role not exist' ) );
		}

		//Check Pass
		if ( isset ( $p['pass1'] )
			&& $p['pass1'] != NULL )
		{
			if ( ! _Check_PasswordFormat( $p['pass1'], 6, 16 ) )
				raysn_clewbox ( translate( 'password format error' ) );
			elseif ( empty ( $p['pass2'] )
				|| $p['pass2'] != $p['pass1'] )
				raysn_clewbox ( translate( 'password confirm error' ) );
			else
				$SqlArray['pass']= raysn_get_pass_encode( $p['pass1'] );
		}

		//Check Status
		if ( isset ( $p['status'] )
			&& is_numeric ( $p['status'] ) ) {
			$SqlArray['status']= $p['status'];
		}

		//3.Update User
		if ( ! empty ( $SqlArray ) ) {
			raysn_object( 'mysql' )->update( 'user', $SqlArray, "`uid`= '$uid'");
		}

		//.Check and Update Columns
		if ( ! empty ( $p['columns'] ) ) {
			if ( ! is_array( $p['columns'] ) ) {
				raysn_clewbox ( translate( 'columns error' ) );
			}
			$GLOBALS['OBJECT']['mysql']->delete( 'user_column', "`uid`= '$uid'" );
			foreach ( $p['columns'] as $cid ) {
				$GLOBALS['OBJECT']['mysql']->insert( 'user_column', array( 'uid'=> $uid, 'cid'=> $cid ) );
			}
		}

		watchdog( 'modified a user', array( '@user'=> $User['name'], '@uid'=> $uid ) );
		raysn_clewbox ( translate( 'edit user success' ), url( 'user/list' ) );
	}
}
