<?php
/*
	file:	/modules/user/list.php
	modify:	2009/02/19 - 2010/03/24
*/

define( 'PAGE_SIZE', 8 );

function User_list( &$p )
{
	//.Check Request
	if ( isset ( $p['orderby'] )
		&& in_array( $p['orderby'], array( 'rid', 'status', 'point', 'login', 'active' ) ) ) {
		$DataArray['orderby'] = $UrlPrefix['orderby'] = $p['orderby'];
	}
	else {
		$DataArray['orderby'] = $UrlPrefix['orderby'] = 'uid';
	}

	if ( isset ( $p['orderway'] )
		&& in_array( $p['orderway'], array( 'ASC', 'DESC' ) ) ) {
		$DataArray['orderway'] = $UrlPrefix[ 'orderway' ]= $p['orderway'];
	}
	else {
		$DataArray['orderway'] = $UrlPrefix[ 'orderway' ]= 'ASC';
	}

	//.Check Page
	$GLOBALS['BackupPath']= 'user/list/';
	if ( empty ( $p['id'] ) || $p['id'] < 1 ) {
		$NowIndex= 1;
	} else {
		$NowIndex= $p['id'];
	}

	//Page List
	$DataArray['Pagelist']= raysn_object( 'pagelist' )->_Set_PageInfo( array(
			'TotalNumber'=> $GLOBALS['OBJECT']['mysql']->select_count( 'user' ),
			'NowIndex'=> $NowIndex,
			'UrlPrefix'=> $UrlPrefix
		) )->_Get_Pagelist( );

	if ( $NowIndex > $GLOBALS['OBJECT']['pagelist']->TotalPage ) {
		$NowIndex = 1;
	}

	//2.Select Data
	$DataArray['Userlist']= $GLOBALS['OBJECT']['mysql']
		->select( 'user', array(
			'select'=> "`user`.`uid`,`user`.`rid`,`user`.`name`,`user`.`status`,`user`.`point`,`user`.`login`,`user_session`.`active`",
			'join'=> array(	'table'=> 'user_session', 'way'=> 'left', 'on'=> 'uid' ),
			'where'=> "`user`.`uid`> 0",
			'group'=> "`uid`",
			'order'=> "`{$UrlPrefix['orderby']}`",
			'way'=> $UrlPrefix[ 'orderway' ],
			'limit'=> ( ( $NowIndex- 1 ) * PAGE_SIZE ) . ',' . PAGE_SIZE
		) );

	require_once './modules/user/user.inc';
	require_once './modules/role/role.inc';
	$RoleNames= _Get_RoleNames( );
	$CheckTime= time() - SESSION_ACTIVE;
	foreach ( $DataArray['Userlist'] as $k=> $User ) {
		$DataArray['Userlist'][ $k ]['type']= $User['rid']> 1? 1: 2;
		$DataArray['Userlist'][ $k ]['role']= $RoleNames[ $User['rid'] ];
		$DataArray['Userlist'][ $k ]['online']= $User['active']> $CheckTime? 1: 0;
	}

	return $DataArray;
}
