<?php
/*
	file:	/modules/user/modify.php
	modify:	2009/02/18 - 2010/05/31
*/

function User_modify( &$p )
{
	//1.Check Request
	if ( ! isset( $p['id'] ) ) {
		$p['id'] = '';
	}

	switch ( $p['id'] ) {
		case 'email':
			return User_Modify_Email( $p );

		default:
			return User_Modify_Password( $p );
	}
}

function User_Modify_Password( &$p )
{
	require_once './modules/user/user.inc';
	if ( ! $User= _Get_UserData( raysn_get_user_id() ) ) {
		raysn_clewbox ( translate( 'user not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './modules/role/role.inc';
		$User['role']= _Get_RoleName( raysn_get_user_role( ) );
		return $User;
	}
	else
	{
		//Check faild times
		raysn_start_user_session( );
		if ( isset ( $_SESSION['Modify_Faild'] )
			&& $_SESSION['Modify_Faild'] > 3 ) {
			raysn_clewbox ( translate( 'too many failed modifies' ) );
		}

		//Check Old Password
		if ( empty ( $p['password'] )
			|| ! raysn_object( 'mysql' )->select_row( 'user', array(
				'select'=> "`uid`",
				'where'	=> "`uid`= '" . raysn_get_user_id() . "' && `pass`= '" . raysn_get_pass_encode( $p['password'] ) . "'"
				) )
			) {
			empty ( $_SESSION['Modify_Faild'] )? $_SESSION['Modify_Faild'] = 1: $_SESSION['Modify_Faild']++;
			raysn_clewbox ( translate( 'verify password failed' ) );
		}

		require_once './libraries/string.inc';

		//Check Name
		if ( isset ( $p['name'] )
			&& $User['name'] != $p['name'] )
		{
			if ( ! _Check_Strlen( $p['name'], 2, 7 ) )
				raysn_clewbox ( translate( 'name format error' ) );
			elseif ( _Check_NameExist( $p['name'] ) )
				raysn_clewbox ( translate( 'name already exist' ) );
			else
				$SqlArray['name']= trim ( $p['name'] );
		}

		//Check Pass
		if ( isset ( $p['pass1'] )
			&& $p['pass1'] != NULL )
		{
			if ( ! _Check_PasswordFormat( $p['pass1'], 6, 16 ) )
				raysn_clewbox ( translate( 'password format error' ) );
			elseif ( empty ( $p['pass2'] )
				|| $p['pass2'] != $p['pass1'] )
				raysn_clewbox ( translate( 'password confirm error' ) );
			else
				$SqlArray['pass']= raysn_get_pass_encode( $p['pass1'] );
		}

		//2.Update Data
		if ( ! empty ( $SqlArray ) ) {
			$GLOBALS['OBJECT']['mysql']->update( 'user', $SqlArray, "`uid`= '" . raysn_get_user_id() . "'" );
			unset ( $_SESSION['Modify_Faild'] );

			raysn_clewbox ( translate( 'modify passport success' ) );
		}
		else {
			raysn_clewbox ( translate( 'there is no change here' ) );
		}
	}
}

function User_Modify_Email( &$p )
{
	require_once './modules/user/user.inc';
	if ( ! $User= _Get_UserData( raysn_get_user_id() ) ) {
		raysn_clewbox ( translate( 'user not exist' ) );
	}

	if ( empty ( $p['uid'] )
		|| ! isset ( $p['cid'] ) )
	{
		//Check Email
		require_once './libraries/string.inc';
		if ( ! isset ( $p['mail'] ) || ! _Check_EmailFormat( $p['mail'] ) ) {
			raysn_clewbox ( translate( 'email format error' ) );
		}
		elseif ( $User['mail'] == $p['mail'] || _Check_MailExist( $p['mail'] ) ) {
			raysn_clewbox ( translate( 'email already exist' ) );
		}

		$ModifyCode = md5( time() );
		$GLOBALS['OBJECT']['mysql']->replace( 'user_code', array( 'uid'=> $User['uid'], 'cid'=> $ModifyCode, 'data'=> serialize( array( 'email'=> $p['mail'] ) ), 'stamp'=> time() ) );

		if ( ! raysn_object( 'mail' )->Connect( ) ) {
			raysn_clewbox ( language( 'connect mail server failed' ) );
		}
		$MailPage = 'modify-email';
		$MessageArray=  array(
			'@site'=> $GLOBALS['SITE']['NAME'],
			'@name'=> $User['name'],
			'@mail'=> $p['mail'],
			'@hour'=> variable_get( "User_EmailValidTime", "86400" )/ 3600,
			'@link'=> $GLOBALS['SITE']['HOST'] . url( 'user/modify/email', array( 'uid'=> $User['uid'], 'cid'=> $ModifyCode ) ),
		);

		$GLOBALS['OBJECT']['mail']->Send( $p['mail'], $MailPage, $MessageArray );
		raysn_clewbox( translate( 'confirm the email', array( '@mail'=> $p['mail'], '@hour'=> $MessageArray['@hour'] ) ) );
	}
	else {
		if ( ! $Modify = raysn_object( 'mysql' )->select_row( 'user_code', array(
				'join'=> array(	'table'=> 'user', 'way'=> 'left', 'on'=> 'uid' ),
				'where'=> "`user_code`.`cid`= '{$p['cid']}' && `user_code`.`uid`= {$p['uid']}" )
			) ) {
			raysn_clewbox ( translate( 'Link not exist' ) );
		}
		if ( $Modify['stamp']< time()- variable_get( "User_EmailValidTime", "86400" ) ) {
			$GLOBALS['OBJECT']['mysql']->delete( 'user_code', "`stamp`< ". ( time()- variable_get( "User_EmailValidTime", "86400" ) ) );
			raysn_clewbox( translate( 'Link has expired' ) );
		}

		if ( empty ( $Modify['uid'] ) ) {
			raysn_clewbox( translate( 'user already deleted' ) );
		}
		$ModifyData = unserialize( $Modify['data'] );
		$GLOBALS['OBJECT']['mysql']->update( 'user', array( 'mail'=> $ModifyData['email'] ), '`uid`= '. $Modify['uid'] );
		if ( ! $GLOBALS['OBJECT']['mysql']->db_affected_rows( ) ) {
			raysn_clewbox( translate( 'modify email error' ) );
		}

		$GLOBALS['OBJECT']['mysql']->delete( 'user_code', "`cid`= '{$p['cid']}' && `uid`= ". $p['uid'] );
		if ( ! empty ( $User['mail'] )
			&& raysn_object( 'mail' )->Connect( ) ) {
			$MailPage = 'modify-success';
			$MessageArray=  array(
				'@site'=> $GLOBALS['SITE']['NAME'],
				'@name'=> $User['name'],
				'@user'=> $User['user'],
				'@mail'=> $ModifyData['email'],
			);

			$GLOBALS['OBJECT']['mail']->Send( $User['mail'], $MailPage, $MessageArray );
		}
		raysn_clewbox( translate( 'modify email success' ) );
	}
}
