<?php
/*
	file:	/modules/user/register.php
	modify:	2010/02/11 - 2010/05/18
*/

function User_register( &$p )
{
	if ( variable_get( "User_Register", "closed" ) == 'closed' ) {
		raysn_clewbox ( translate( 'register closed' ) );
	}
	if ( raysn_get_user_id( ) ) {
		raysn_goto_page( url( 'user/login' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( );
	}
	else
	{
		//1.Check Request
		if ( ! isset ( $_COOKIE['RAYSN_SECCODE'] )
			|| strtolower( $p['code'] ) != $_COOKIE['RAYSN_SECCODE'] ) {
			raysn_clewbox ( language( 'check code error' ) );
		}

		raysn_start_user_session( );
		if ( isset ( $_SESSION['Register_Mark'] )
			&& $_SESSION['Register_Mark'] > 1 ) {
			raysn_clewbox ( translate( 'too many register' ) );
		}

		//2.Process Data
		require_once './libraries/string.inc';
		require_once './modules/user/user.inc';

		//Check User
		if ( ! empty ( $p['user'] )
			&& _Check_Chrlen( $p['user'], 3, 16 ) )
		{
			if ( ! _Check_UserExist( $p['user'] ) )
				$SqlArray['user']= $p['user'];
			else
				raysn_clewbox ( translate( 'user already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'user format error' ) );

		//Check Name
		if ( ! empty ( $p['name'] )
			&& _Check_Strlen( $p['name'], 2, 7 ) )
		{
			if ( ! _Check_NameExist( $p['name'] ) )
				$SqlArray['name']= trim ( $p['name'] );
			else
				raysn_clewbox ( translate( 'name already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'name format error' ) );

		//Check Email
		if ( ! empty ( $p['mail'] )
			&& _Check_EmailFormat( $p['mail'] ) )
		{
			if ( ! _Check_MailExist( $p['mail'] ) )
				$SqlArray['mail']= $p['mail'];
			else
				raysn_clewbox ( translate( 'email already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'email format error' ) );

		mt_srand( );
		$Characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
		$max = strlen( $Characters ) - 1;
		for ( $i = 0; $i < mt_rand( 6, 8 ); $i++ ) {
			$Password .= $Characters[ mt_rand( 0, $max ) ];
		}

		$SqlArray['rid'] = 1;
		$SqlArray['pass']= raysn_get_pass_encode( $Password );
		$SqlArray['point'] = variable_get( 'User_RegisterPoint', 0 );
		$RegisterActive = variable_get( 'User_RegisterActive', 1 );

		if ( $RegisterActive == 1 ) {
			$ActiveId = md5( time( ) );
		}
		elseif ( $RegisterActive == 2 ) {
			$SqlArray['status'] = 1;
		}

		$SqlArray['created']= time( );

		//3.Add User
		raysn_object( 'mysql' )->insert( 'user', $SqlArray );
		$uid = $GLOBALS['OBJECT']['mysql']->_Get_InsertId( );

		//.Column permission
		if ( variable_get( "User_ColumnPermission", "closed" )== "opened" ) {
			foreach ( unserialize( variable_get( 'User_RegisterColumnPermission', serialize( array() ) ) ) as $cid ) {
				$GLOBALS['OBJECT']['mysql']->insert( 'user_column', array( 'uid'=> $uid, 'cid'=> $cid ) );
			}
		}

		//.Check active
		if ( $ActiveId ) {
			$GLOBALS['OBJECT']['mysql']->insert( 'user_code', array( 'uid'=> $uid, 'cid'=> $ActiveId, 'stamp'=> time() ) );
		}

		if ( isset ( $SqlArray['mail'] )
			&& raysn_object( 'mail' )->Connect( ) ) {
			$MessageArray= array(
				'@site'=> $GLOBALS['SITE']['NAME'],
				'@name'=> $SqlArray['name'],
				'@user'=> $SqlArray['user'],
				'@pass'=> $Password,
				'@hour'=> variable_get( "User_ActiveValidTime", "86400" )/ 3600
			);

			if ( $ActiveId ) {
				$MessageArray['@link']= $GLOBALS['SITE']['HOST'] . url( 'user/active/'. $uid, array( 'cid'=> $ActiveId ) );
				$MailPage = 'user-active';
				$SuccessMessage= translate( 'active mail success', array( '@hour'=> $MessageArray['@hour'] ) );
			}
			else {
				$MailPage = 'register-success';
				$SuccessMessage= translate( 'register user success' );
			}

			$GLOBALS['OBJECT']['mail']->Send( $SqlArray['mail'], $MailPage, $MessageArray );
		}
		empty ( $_SESSION['Register_Mark'] )? $_SESSION['Register_Mark'] = 1: $_SESSION['Register_Mark']++;
		raysn_clewbox ( $SuccessMessage );
	}
}
