// $Id: collapse.js,v 1.0 2010/02/17 20:16:25 goba Exp $

RaysnWeb.behaviors.collapse = function (context) {
	$('div.collapsible > div.legend:not(.collapse-processed)', context).each(function() {
		var fieldset = $(this.parentNode);
		var legend = $(this).text();

		$(this).empty().append($('<span><a href="#">'+ legend +'</a></span>').click(function() {
			var fieldset = $(this).parents('div.fieldset:first')[0];
			// Don't animate multiple times
			if (!fieldset.animating) {
				fieldset.animating = true;
				RaysnWeb.toggleFieldset(fieldset);
			}
			return false;
		}))
		.after($('<div class="fieldset-wrapper"></div>').append(fieldset.children(':not(div.legend)')))
		.addClass('collapse-processed');
	});
};

/**
 * Toggle the visibility of a fieldset using smooth animations
 */
RaysnWeb.toggleFieldset = function(fieldset) {
	if ($(fieldset).is('.collapsed')) {
		// Action div containers are processed separately because of a IE bug
		// that alters the default submit button behavior.
		var content = $('> div.fieldset-wrapper', fieldset);
		$(fieldset).removeClass('collapsed');
		content.hide();
		content.slideDown( {
			duration: 'fast',
			easing: 'linear',
			complete: function() {
				RaysnWeb.ScrollIntoView(this.parentNode);
				this.parentNode.animating = false;
			},
			step: function() {
				// Scroll the fieldset into view
				RaysnWeb.ScrollIntoView(this.parentNode);
			}
		});
	}
	else {
		$('> div.fieldset-wrapper', fieldset).slideUp('fast', function() {
			$(this.parentNode).addClass('collapsed');
			this.parentNode.animating = false;
		});
	}
};
