// $Id: raysn.js,v 1.0 2010/03/05 13:12:57 goba Exp $

var RaysnWeb = RaysnWeb || { 'settings': {}, 'behaviors': {}, 'locale': {} };

/**
 * Set the variable that indicates if JavaScript behaviors should be applied
 */
RaysnWeb.jsEnabled = document.getElementsByTagName && document.createElement && document.createTextNode && document.documentElement && document.getElementById;

// Global Killswitch on the <html> element
if (RaysnWeb.jsEnabled) {
	// Global Killswitch on the <html> element
	$(document.documentElement).addClass('js');
	// 'js enabled' cookie
	document.cookie = 'has_js=1; path=/';
	// Attach all behaviors.
	$(document).ready(function() {
		jQuery.each(RaysnWeb.behaviors, function() {
			this(document);
		});
	});
}

/**
 * Encode special characters in a plain-text string for display as HTML.
 */
RaysnWeb.checkPlain = function(str) {
	str = String(str);
	var replace = { '&': '&amp;', '"': '&quot;', '<': '&lt;', '>': '&gt;' };
	for (var character in replace) {
		var regex = new RegExp(character, 'g');
		str = str.replace(regex, replace[character]);
	}
	return str;
};

/**
 * Translate strings to the page language or a given language.
 */
RaysnWeb.translate = function(str, args) {
	// Fetch the localized version of the string.
	if (RaysnWeb.locale.strings && RaysnWeb.locale.strings[str]) {
		str = RaysnWeb.locale.strings[str];
	}

	if (args) {
		// Transform arguments before inserting them
		for (var key in args) {
			switch (key.charAt(0)) {
				// Escaped only
				case '@':
					args[key] = RaysnWeb.checkPlain(args[key]);
				break;
				// Pass-through
				case '!':
					break;
				// Escaped and placeholder
				case '%':
				default:
					args[key] = RaysnWeb.theme('placeholder', args[key]);
					break;
			}
			str = str.replace(key, args[key]);
		}
	}
	return str;
};

/**
 * Get the text selection in a textarea.
 */
RaysnWeb.getSelection = function (element) {
	if (typeof(element.selectionStart) != 'number' && document.selection) {
		// The current selection
		var range1 = document.selection.createRange();
		var range2 = range1.duplicate();
		// Select all text.
		range2.moveToElementText(element);
		// Now move 'dummy' end point to end point of original range.
		range2.setEndPoint('EndToEnd', range1);
		// Now we can calculate start and end points.
		var start = range2.text.length - range1.text.length;
		var end = start + range1.text.length;
		return { 'start': start, 'end': end };
	}
	return { 'start': element.selectionStart, 'end': element.selectionEnd };
};

/**
 * Scroll a given fieldset into view as much as possible.
 */
RaysnWeb.ScrollIntoView = function (node) {
	var h = self.innerHeight || document.documentElement.clientHeight || $('body')[0].clientHeight || 0;
	var offset = self.pageYOffset || document.documentElement.scrollTop || $('body')[0].scrollTop || 0;
	var posY = $(node).offset().top;
	var fudge = 55;
	if (posY + node.offsetHeight + fudge > h + offset) {
		if (node.offsetHeight > h) {
			window.scrollTo(0, posY);
		} else {
			window.scrollTo(0, posY + node.offsetHeight - h + fudge);
		}
	}
};

/**
 * Generate the themed representation of a RaysnWeb object.
 */
RaysnWeb.Openwindow = function(url, dialog) {
	var OpenWindow= {};

	if ( dialog == null ) {
		OpenWindow.Height = window.screen.height ;
		if ( window.screen.width > 800 ) {
			OpenWindow.Width = 980 ;
		} else {
			OpenWindow.Width = window.screen.width ;
		}
	} else {
		if ( window.screen.width > 800 ) {
			OpenWindow.Width = 930 ;
			OpenWindow.Height = 740 ;
		} else {
			OpenWindow.Width = window.screen.width ;
			OpenWindow.Height = window.screen.height ;
		}
	}

	return window.open(url,dialog,'toolbar=no,location=no,status=yes,menubar=no,scrollbars=yes,resizable=yes,width='+OpenWindow.Width+',height='+OpenWindow.Height+',left='+Math.round(window.screen.width- OpenWindow.Width));
};
