<?php


if (!defined('ABSPATH'))
    exit('Access Denied');
define('DEBUG', true);
/**
 * 启用ucenter
 */
define('IS_UCENTER', false);
if (IS_UCENTER)
{
    require_once (ABSPATH . 'config/uc_config.php');
    require_once (ABSPATH . 'includes/uc_client/client.php');
}
@error_reporting(E_ALL ^ E_NOTICE);
/**
 * 加载基本库
 */
require_once (ABSPATH . 'includes/library.php');
timer_start();
set_magic_quotes_runtime(0);
@ini_set('magic_quotes_sybase', 0);
if (get_magic_quotes_gpc())
{
    $_POST = stripslashe($_POST);
    $_GET = stripslashe($_GET);
    $_COOKIE = stripslashe($_COOKIE);
}
header('Content-Type: text/html; charset=utf-8');
/**
 * 安全处理
 */
if (version_compare('4.3', phpversion(), '>'))
{
    exit('当前服务器php版本过低.当前' . phpversion() . ',需要4.3+');
}
/**
 * 配置文件
 */
if (file_exists(ABSPATH . 'config/config.php'))
{
    $_ini = require (ABSPATH . 'config/config.php');
} else
{
    die('Not installed correctly');
}
/**
 * 运行时间初始化
 */
timer_start();
/**
 * 数据库实例
 */
$db = new mysql($_ini['dbhost'], $_ini['dbuser'], $_ini['dbpw'], $_ini['dbname'],
    $_ini['dbprefix']);
/**
 * 销毁$_ini前,定义部分常量
 */
define('PF', $_ini['dbprefix']);
define('ROOTPATH', $_ini['rootpath']);
define('TIMEZONE', $_ini['timezone']);
unset($_ini);
function_exists('date_default_timezone_set') && date_default_timezone_set(TIMEZONE);
define('TIME', time());
$conf = $cache = array();
require_once (ABSPATH . 'includes/config.php');
get_val();
define('IS_CACHE', !empty($conf['sys_cache']));

define('IS_REWRITE', empty($conf['sys_rewritecolse']) && !empty($conf['sys_rewrite']));

/**
 * 一级菜单ID数组　及　全部子菜单数组
 */
$conf['sys_pmenus'] = array();
$conf['sys_pmenus_sub'] = array();
foreach ($conf['sys_menus'] as $k => $v)
{
    if ($v['pid'] == 0 || !isset($conf['sys_menus'][$v['pid']]))
    {
        $conf['sys_pmenus'][$k] = $v;
        continue;
    }
    $conf['sys_pmenus_sub'][$v['pid']][$k] = $v;
}
/**
 * 当前语种
 */
if (!empty($_GET['lang']) && isset($conf['sys_langs'][$_GET['lang']]))
{
    define('LANG', $_GET['lang']);
} else
    define('LANG', $conf['sys_lang']);
/**
 * 声明应用变量
 */
$yun_hooks = array();
$__sys__ = array();
define('IS_WIN', isset($_GET['win']) ? true : false);
/**
 *  请求方式
 */
define('IS_POST', strtoupper($_SERVER['REQUEST_METHOD']) == 'POST');
define('IS_AJAX', isset($_GET['ajax']) || isset($_POST['ajax']));

define('IS_IFRAME', isset($_GET['iframe']) || isset($_POST['iframe']));

define('IS_WIN', isset($_GET['win']));

/**
 * 禁止客户端缓存
 */
(IS_WIN || IS_AJAX) && nocache();
/**
 * 载入模块配置及语言
 */
$conf['sys_modules'] = array();
$conf['langs'] = array();
foreach ($conf['main_modules'] as $v)
{
    $_v = require_once (ABSPATH . 'modules/' . $v . '/__conf.php');
    $conf['sys_modules'] = array_merge($_v, $conf['sys_modules']);
    if (file_exists($_t = ABSPATH . 'modules/' . $v . '/languages/' . LANG . '.php'))
    {
        $conf['langs'][$v] = require_once ($_t);
    }
}
/**
 * 确定当前模块与应用
 */
@$mod = strtolower($_GET['mod']);
@$action = strtolower($_GET['action']);
/**
 * ACTION CMOD MOD确值
 */
empty($mod) && $mod = $conf['sys_default_mod'];
empty($action) && $action = 'index';
if (!module_exists($mod))
{

    if (isset($conf['sys_subjects'][$mod]))
    {
        $_GET['gid'] = $mod;
        $mod = 'subject';
    } else
    {
        $break = false;
        foreach ($conf['sys_menus'] as $k => $v)
        {
            if ($v['mod'] == 'fun_' && $mod == $v['fun_'])
            {
                $mod = 'func';
                $action = $v['fun_'];
                $_GET['a'] = $k;
                $break = true;
                break;
            }
        }
        if (!$break)
        {
            foreach ($conf['sys_menus'] as $k => $v)
            {
                if ($v['mod'] == 'page_' && $v['page_'] == $mod)
                {
                    $mod = 'page';
                    $_GET['a'] = $k;
                    break;
                }
            }
        }
    }
}
/**
 * action 筛选
 */
define('ACTION', $action);
$_action = explode('.', ACTION);
if (count($_action) > 1)
{
    define('CMOD', $mod == $_action[0] ? false : $mod);
    define('MOD', $_action[0]);
} else
{
    define('CMOD', false);
    define('MOD', $mod);
}
/**
 * 菜单ID及其它;
 */
define('GID', ereg("^[a-z]+$", $_GET['gid']) && isset($conf['sys_subjects'][$_GET['gid']]) ?
    $_GET['gid'] : false);
define('A', intval($_GET['a']));

define('B', intval($_GET['b']));

define('C', intval($_GET['c']));

define('G', GID ? (GID . '-') : '');
define('RP', ROOTPATH . (LANG == $conf['sys_lang'] ? '' : (LANG . '/')));
define('RPG', RP . G);
define('RPM', RP . MOD . '/');
define('RPGM', RP . G . MOD . '/');
define('RPMA', RPM . ACTION . '/');
define('RPGMA', RPGM . ACTION . '/');
define('RPC', RP . CMOD . '/');
define('RPGC', RP . G . CMOD . '/');
define('RPCA', RPCM . ACTION . '/');
define('RPGCA', RPGC . ACTION . '/');
/**
 *信息页刷新,判断返回页面
 **/
msgrefresh();
/**
 * $mod
 * $action 合法性
 */
ereg("[a-zA-Z0-9_.]+$", ACTION) or die('非法应用!');
module_exists(MOD) or die('模块不存在!');
/**
 * 父模块
 */
define('PMOD', is_submodule(MOD));
/**
 * 是否为子模块
 */
define('IS_SUBMOD', PMOD !== false);
/**
 * 模块路径
 */
define('MODPATH', ABSPATH . 'modules/' . (IS_SUBMOD ? (PMOD . '/') : '') . MOD .
    '/');
/**
 * 模板主题
 */
define('THEMENAME', MOD <> 'admin' ? $conf['sys_theme'] : 'admin');
define('THEMEDIR', ABSPATH . 'themes/' . THEMENAME . '/');
define('THEMEPATH', ROOTPATH . 'themes/' . THEMENAME . '/');
/**
 * 加载模板语言
 */
if (file_exists($_t = THEMEDIR . '/languages/' . LANG . '.php'))
{
    $conf['langs']['-tpl'] = require_once ($_t);
}
/**
 * 是否为首页
 */
define('IS_HOME', MOD == $conf['sys_default_mod'] && ACTION == 'index');

/**
 * 应用模块的函数重定义文件;
 */
if (file_exists($file = MODPATH . '__func.php'))
    require_once ($file);
if (IS_SUBMOD)
{
    if (file_exists($file = ABSPATH . 'modules/' . PMOD . '/__func.php'))
        require_once ($file);
}
/**
 * 模板初始化
 */
require_once (THEMEDIR . '__init.php');
/**
 * 加载应用函数;
 */
require_once (ABSPATH . 'includes/function.php');
/**
 * 当前用户资料 ;
 */
$user = currentuser();
/**
 * 用户基本权限
 */
$bpv = basepv();
/**
 * 当前用户无登录权限,状态为游客
 */
$user['id'] > 0 && empty($bpv[0]) && $user = currentuser(false);
/**
 * 加载模块的类库
 */
if (file_exists($file = MODPATH . '__class.php'))
    require_once ($file);
/**
 * 模块入口初始化
 */
if (IS_SUBMOD)
{
    if (file_exists($file = ABSPATH . 'modules/' . PMOD . '/__init.php'))
        require_once ($file);
}
if (file_exists($file = MODPATH . '/__init.php'))
    require_once ($file);
/**
 * 应用
 */
yun_model();
/**
 * 加载模板
 */
include_once template();
exit;

?>