<?php

/**
 * 允许被重定义的函数 
 * 参数说明(发送到, 邮件主题, 邮件内容, 收件人姓名)
 * yun_mail('xxx@xxx.com', '邮件主题', '内容', 'username');
 */
if (!function_exists('yun_mail'))
{
    function yun_mail($sendto_email, $subject, $body, $user_name)
    {
        global $user, $conf;
        require_once (ABSPATH . 'includes/PHPMailer_v5.1/class.phpmailer.php');
        $mail = new PHPMailer();
        $mail->IsSMTP();
        $mail->Host = $conf['sys_mail_host'];
        $mail->Port = $conf['sys_mail_port'];
        $mail->SMTPAuth = true;
        $mail->Username = $conf['sys_mail_username'];
        $mail->Password = $conf['sys_mail_password'];
        $mail->From = $conf['sys_mail_from'];
        $mail->FromName = $conf['sys_mail_fromname'];
        $mail->CharSet = "UTF-8";
        $mail->Encoding = "base64";
        $mail->AddAddress($sendto_email, $user_name);
        $mail->IsHTML(true);
        $mail->Subject = $subject;
        $mail->Body = '
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"></head>
<body>' . $body . '
</body>
</html>
';
        if ($mail->Send())
        {
            return true;
        } else
        {
            return $mail->ErrorInfo;
        }
    }
}
if (!function_exists('basepv'))
{
    function basepv()
    {
        global $user;
        return bpv($user['team']);
    }
}
if (!function_exists('currentuser'))
{
    function currentuser($g = true)
    {
        global $db;
        list($uid, $name) = explode("\t", decrypt($_COOKIE[PF . 'yun_user']));
        $uid = intval($uid);
        $user = get_user(empty($g) ? 0 : $uid);
        if ($user['id'] > 0 && ($name <> $user['name']))
        {
            $user = get_user(0);
        }
        /**
         * 访问标识符;
         */
        $user['sid'] = substr(md5($_SERVER['HTTP_USER_AGENT'] . microtime(true)), 0, 5);
        return $user;
    }
}
if (!function_exists('yun_error'))
{
    function yun_error($msg, $re = '')
    {
        do_apply('yun_error', null, $msg, $re);
        $method = getval('method');
        $reurl = urlencode(isset($_GET['url']) ? $_GET['url'] : $_SERVER['REQUEST_URI']);
        if (IS_AJAX || $method === 'ajax')
        {
            echo $re, '$(\'#yun_jgrowl\').jGrowl("', htmlspecialchars($msg), '");';
        } elseif (IS_IFRAME || $method === 'iframe')
        {
            echo '<script type="text/javascript">parent.HideLoading();', $re, 'parent.$(\'#yun_jgrowl\').jGrowl("',
                htmlspecialchars($msg), '");', '</script>';
        } elseif (IS_WIN)
        {
            echo '<script type="text/javascript">', $re, '$(\'#yun_jgrowl\').jGrowl("',
                htmlspecialchars($msg), '");$.fn.colorbox.close();</script>';
        } else
        {
            header('Location: ' . url(RPG . 'system/message/?msg=' . urlencode(encrypt($msg)) .
                '&url=' . $reurl));
        }
        exit;
    }
}
if (!function_exists('yun_succeed'))
{
    /**
     * $main 应用于主框架
     * refresh
     * winclose
     * home
     */
    function yun_succeed($msg, $re = '', $main = true)
    {
        do_apply('yun_succeed', null, $msg, $re, $main);
        $method = getval('method');
        if (IS_IFRAME || $method === 'iframe')
        {
            if ($re === 'winclose')
            {
                echo '<script type="text/javascript">', $main ? ('parent.$(\'#yun_jgrowl\').jGrowl("' .
                    htmlspecialchars($msg) . '");parent.$.fn.colorbox.close();') : ('$(\'#yun_jgrowl\').jGrowl("' .
                    htmlspecialchars($msg) . '");$.fn.colorbox.close();'), '</script>';
            } elseif ($re === 'refresh')
            {
                empty($msg) or setcookie('yun_message', rawurlencode($msg), 0, ROOTPATH);
                echo '<script type="text/javascript">parent.location=parent.location.href;</script>';
            } elseif (substr($re, 0, 1) === '/')
            {
                if ($main)
                {
                    empty($msg) or setcookie('yun_message', rawurlencode($msg), 0, ROOTPATH);
                    echo '<script type="text/javascript">parent.location="' . $re . '";</script>';
                } else
                {
                    echo '<script type="text/javascript">parent.HideLoading();parent.$(\'#yun_jgrowl\').jGrowl("' .
                        htmlspecialchars($msg) . '");', 'parent.$.fn.colorbox({href:"', $re, '"});',
                        '</script>';
                }
            } else
            {
                echo '<script type="text/javascript">';
                echo $re;
                if (!empty($msg))
                    echo 'parent.HideLoading();parent.$(\'#yun_jgrowl\').jGrowl("', htmlspecialchars($msg),
                        '");';
                echo '</script>';
            }
        } else
            if (IS_AJAX || $method === 'ajax')
            {
                if ($re === 'winclose')
                {
                    echo ('$(\'#yun_jgrowl\').jGrowl("' . htmlspecialchars($msg) .
                        '");$.fn.colorbox.close();');
                } elseif ($re === 'refresh')
                {
                    empty($msg) or setcookie('yun_message', rawurlencode($msg), 0, ROOTPATH);
                    echo 'location=location.href;';
                } elseif ($re == 'home')
                {
                    empty($msg) or setcookie('yun_message', rawurlencode($msg), 0, ROOTPATH);
                    echo 'location="' . ROOTPATH . '";';
                } elseif (substr($re, 0, 1) === '/')
                {
                    if ($main)
                    {
                        empty($msg) or setcookie('yun_message', rawurlencode($msg), 0, ROOTPATH);
                        echo 'location="' . $re . '";';
                    } else
                    {
                        echo '$(\'#yun_jgrowl\').jGrowl("' . htmlspecialchars($msg) . '");',
                            '$.fn.colorbox({href:"', $re, '"});';
                    }
                } else
                {
                    echo $re;
                    if (!empty($msg))
                        echo '$(\'#yun_jgrowl\').jGrowl("', htmlspecialchars($msg), '");';
                }
            } else
                if (substr($re, 0, 1) === '/')
                {
                    empty($msg) or setcookie('yun_message', rawurlencode($msg), 0, ROOTPATH);
                    echo $main ? 'parent.location="' . $re . '";' : 'location="' . $re . '";';
                }
        exit;
    }
}
if (!function_exists('page'))
{
    function page($url, $pg_c, $pg_m, $pg_d = 20, $pg_l = 10)
    {
        $query = $_SERVER['QUERY_STRING'];
        $_q = parse_url($url);
        $_q['query'] <> '' && $query .= '&' . $_q['query'];
        $urlarr = array();
        $arr = explode('&', $query);
        while (null !== ($str = array_shift($arr)))
        {
            $arr2 = explode('=', $str);
            in_array($arr2[0], array('lang', 'gid', 'msg', 'mod', 'mid', 'action', 'a', 'b',
                'c')) or $urlarr[] = $arr2[0] . '=' . $arr2[1];
        }
        $urlarr = array_unique($urlarr);
        require_once (ABSPATH . 'includes/class_page.php');
        $pages = new page($pg_d, $pg_m, $pg_c, $pg_l, $_q['path'] . (empty($urlarr) ? '' :
            ('?' . implode('&', $urlarr))), true);
        return $pages->pages;
    }
}
if (!function_exists('timer_end'))
{
    function timer_end($display = false)
    {
        global $timestart;
        $_t = sprintf('%01.3f', microtime(true) - $timestart);
        if (empty($display))
            return $_t;
        echo $_t;
    }
}
if (!function_exists('ini_editor'))
{
    function ini_editor($type = 'ckeditor')
    {
        if ($type == 'ckeditor' || $type == 'ckeditor_mini')
        {
            apply('head', '
                  <script type="text/javascript" src="' . ROOTPATH .
                'includes/ckeditor/ckeditor.js"></script>
                  ');
        } else
            if ($type == 'xheditor')
            {
                apply('head', '<script type="text/javascript" src="' . ROOTPATH .
                    'includes/xheditor/xheditor-zh-cn.js"></script>
            ');
            } else
                if ($type == 'xheditor_ubb' || $type == 'xheditor_ubb_mini')
                {
                    apply('head', '<script type="text/javascript" src="' . ROOTPATH .
                        'includes/xheditor/xheditor-zh-cn.js"></script>
            <script type="text/javascript" src="' . ROOTPATH .
                        'includes/xheditor/xheditor_plugins/ubb.js"></script>
            ');
                }
        setval('editor_type', $type);
    }
}
if (!function_exists('set_editor'))
{
    function set_editor($id)
    {
        $type = getval('editor_type');
        if ($type == 'xheditor')
        {
            echo '<script type="text/javascript">
            $(function(){
		   $(\'#', $id, '\').xheditor(true,{emots:{\'qq\':{\'name\':\'QQ\',\'count\':55,\'width\':25,\'height\':25,\'line\':11}},emotMark:true});
		   });
</script>';
        } else
            if ($type == 'xheditor_ubb')
            {
                echo '<script type="text/javascript">
            $(function(){
		   $(\'#', $id, '\').xheditor(true,{
		tools:\'full\',forcePtag:false,showBlocktag:false,beforeSetSource:ubb2html,beforeGetSource:html2ubb,emots:{\'qq\':{\'name\':\'QQ\',\'count\':55,\'width\':25,\'height\':25,\'line\':11}},emotMark:true});
		   });
</script>';
            } else
                if ('xheditor_ubb_mini')
                {
                    echo '<script type="text/javascript">
            $(function(){
		   $(\'#', $id, '\').xheditor(true,{tools:\'mini\'});
		   });
</script>';
                }
    }
}
if (!function_exists('del_user'))
{
    function del_user($id, $name)
    {
        global $db;
        if (IS_UCENTER && uc_user_delete($name) < 1)
        {
            return false;
        }
        $db->query("delete from " . PF . "user where id='$id'");
        return true;
    }
}
if (!function_exists('new_topic'))
{
    function new_topic()
    {
        global $db, $user, $bpv, $mpv, $conf;
        require_once (ABSPATH . 'includes/class_content.php');
        foreach ($conf['sys_elangs'] as $k => $v)
        {
            mb_strlen($_POST['title'][$k], 'UTF-8') > (65535 / count($conf['sys_elangs'])) &&
                yun_error(mlang('标题太长', 'system'));
            mb_strlen($_POST['content'][$k], 'UTF-8') > (4294967295 / count($conf['sys_elangs'])) &&
                yun_error(mlang('内容太长', 'system'));
            mb_strlen($_POST['doc'][$k], 'UTF-8') > 65535 && yun_error(mlang('概述太长',
                'system'));
        }
        mb_strlen($_POST['keyword'][$k], 'UTF-8') > 255 && yun_error(mlang('关键字太长',
            'system'));
        mb_strlen($_POST['thumb'][$k], 'UTF-8') > 255 && yun_error(mlang('缩略图地址太长',
            'system'));
        $_title = postlangdatas('title');
        $_doc = postlangdatas('doc');
        $_content = postlangdatas('content');
        $arr = array();
        $arr['authorid'] = $user['id'];
        $arr['post_time'] = TIME;
        $arr['title'] = serialize($_title);
        $arr['module'] = MOD;
        $db->query("insert into " . PF . "posts () values()");
        $pid = $db->insert_id();
        foreach ($conf['sys_elangs'] as $k => $v)
        {
            $arr['content'][$k] = content::annex('p' . $pid, date('y_', TIME) . ceil(date('z',
                TIME) / 5), $_content[$k]);
        }
        $arr['content'] = serialize($arr['content']);
        $arr['doc'] = serialize($_doc);
        $arr['keyword'] = trim($_POST['keyword']);
        $arr['thumb'] = trim($_POST['thumb']);
        $arr['items'] = do_apply('topicitem', 'array_merge', MOD);
        $arr['items'] = serialize($arr['items']);
        if (is_array($_POST['mids']) && $mpv[3])
        {
            $_POST['mids'][] = MID;
        } else
        {
            $_POST['mids'] = array(MID);
        }
        $arr['mids'] = array_unique(array_map('intval', $_POST['mids']));
        foreach ($arr['mids'] as $mid)
        {
            do_apply('newtopic', null, $mid, $pid, $arr);
        }
        $arr['mids'] = serialize($arr['mids']);
        $arr2 = array();
        foreach ($arr as $k => $v)
        {
            $arr2[] = $k . '=\'' . addslashes($v) . '\'';
        }
        $str = implode(',', $arr2);
        $db->query("update " . PF . "posts set $str where id='$pid'");
        return $pid;
    }
}
if (!function_exists('show_topic'))
{
    function show_topic($pid)
    {
        global $db;
        require_once (ABSPATH . 'includes/class_content.php');
        if (!$row = $db->fetch_first('select * from (' . PF . MOD . ' as m left join ' .
            PF . 'posts as post on m.post_id=post.id) left join ' . PF .
            'user as user on user.id=post.authorid where m.menu_id=' . MID . ' && post.id=' .
            $pid))
        {
            yun_error(mlang('主题不存在', 'system'));
        }
        module_exists($row['module']) or yun_error(mlang('主题隶属模块不存在', 'system'));
        method_exists($row['module'], 'show_topic') or yun_error(mlang('主题无法渲染',
            'system'));
        eval('$arr=' . $row['module'] . '::show_topic($pid,$row);');
        $db->query("update " . PF . "posts set hits=hits+1 where id='$pid'");
        if ($row['module'] <> MOD)
        {
            setval('actiontplfile', array($row['module'], 'show'));
        }
        return $arr;
    }
}
if (!function_exists('edit_topic'))
{
    function edit_topic($pid)
    {
        global $db;
        if (!$row = $db->fetch_first('select * from (' . PF . MOD . ' as m left join ' .
            PF . 'posts as post on m.post_id=post.id) left join ' . PF .
            'user as user on user.id=post.authorid where m.menu_id=' . MID . ' && post.id=' .
            $pid))
        {
            yun_error(mlang('主题不存在', 'system'));
        }
        $row['items'] = unserialize($row['items']);
        method_exists($row['module'], 'edit_topic') or yun_error(mlang('系统错误,无法编辑',
            'system'));
        eval($row['module'] . '::edit_topic($pid,&$row);');
        if ($row['module'] <> MOD)
        {
            setval('actiontplfile', array($row['module'], 'edittopic'));
        }
        $row['content'] = array_map('htmlspecialchars', unserialize($row['content']));
        $row['title'] = array_map('htmlspecialchars', unserialize($row['title']));
        $row['doc'] = array_map('htmlspecialchars', unserialize($row['doc']));
        $row['keyword'] = htmlspecialchars($row['keyword']);
        $row['thumb'] = htmlspecialchars($row['thumb']);
        return $row;
    }
}
if (!function_exists('new_comment'))
{
    function new_comment($pid)
    {
        global $db, $user, $bpv, $mpv, $conf;
        $len = mb_strlen($_POST['content'], 'UTF-8');
        $len < 1 && yun_error(mlang('评论内容不能为空', 'system'));
        $len > 65535 && yun_error(mlang('评论内容太长', 'system'));
        if (empty($bpv[1]))
        {
            $len > 500 && yun_error(mlang('评论内容太长', 'system'));
        }
        $arr = array();
        $arr['authorid'] = $user['id'];
        $arr['post_time'] = TIME;
        $db->query("insert into " . PF . "comments () values()");
        $cid = $db->insert_id();
        $arr['content'] = $_POST['content'];
        $arr['post_id'] = $pid;
        $arr2 = array();
        foreach ($arr as $k => $v)
        {
            $arr2[] = $k . '=\'' . addslashes($v) . '\'';
        }
        $str = implode(',', $arr2);
        $db->query("update " . PF . "comments set $str where id='$cid'");
        $db->query("update " . PF . "posts set comment=comment+1 where id='$pid'");
        return true;
    }
}
if (!function_exists('edit_comment'))
{
    function edit_comment($cid, $row)
    {
        global $db, $user, $bpv, $mpv, $conf;
        $len = mb_strlen($_POST['content'], 'UTF-8');
        $len < 1 && yun_error(mlang('评论内容不能为空', 'system'));
        $len > 65535 && yun_error(mlang('评论内容太长', 'system'));
        if (empty($bpv[1]))
        {
            $len > 500 && yun_error(mlang('评论内容太长', 'system'));
        }
        $arr = array();
        $arr['content'] = $_POST['content'];
        $arr2 = array();
        foreach ($arr as $k => $v)
        {
            $arr2[] = $k . '=\'' . addslashes($v) . '\'';
        }
        $str = implode(',', $arr2);
        $db->query("update " . PF . "comments set $str where id='$cid'");
        return true;
    }
}
if (!function_exists('edittopic'))
{
    function edittopic($pid, $row)
    {
        global $db, $user, $bpv, $mpv, $conf;
        require_once (ABSPATH . 'includes/class_content.php');
        foreach ($conf['sys_elangs'] as $k => $v)
        {
            mb_strlen($_POST['title'][$k], 'UTF-8') > (65535 / count($conf['sys_elangs'])) &&
                yun_error(mlang('标题太长', 'system'));
            mb_strlen($_POST['content'][$k], 'UTF-8') > (4294967295 / count($conf['sys_elangs'])) &&
                yun_error(mlang('内容太长', 'system'));
            mb_strlen($_POST['doc'][$k], 'UTF-8') > 65535 && yun_error(mlang('概述太长',
                'system'));
        }
        mb_strlen($_POST['keyword'][$k], 'UTF-8') > 255 && yun_error(mlang('关键字太长',
            'system'));
        mb_strlen($_POST['thumb'][$k], 'UTF-8') > 255 && yun_error(mlang('缩略图地址太长',
            'system'));
        $_title = postlangdatas('title');
        $_doc = postlangdatas('doc');
        $_content = postlangdatas('content');
        $arr = array();
        $arr['authorid'] = $row['authorid'];
        $arr['post_time'] = $row['post_time'];
        $arr['title'] = serialize($_title);
        $arr['module'] = $row['module'];
        foreach ($conf['sys_elangs'] as $k => $v)
        {
            $arr['content'][$k] = content::annex('p' . $pid, date('y_', TIME) . ceil(date('z',
                TIME) / 5), $_content[$k]);
        }
        $arr['content'] = serialize($arr['content']);
        $arr['doc'] = serialize($_doc);
        $arr['keyword'] = trim($_POST['keyword']);
        $arr['thumb'] = content::annex('p' . $pid, date('y_', TIME) . ceil(date('z',
            TIME) / 5), trim($_POST['thumb']));
        $arr['items'] = do_apply('topicitem', 'array_merge', MOD);
        $arr['items'] = serialize($arr['items']);
        $dirname = 'uploads\/softs\/' . date('y_', $arr['post_time']) . ceil(date('z', $arr['post_time']) /
            5);
        preg_match_all("/" . $dirname . "\/p" . $pid . "_\d{12}_\d{4}\.[a-z_0-9]+/is", $row['content'] .
            $row['thumb'], $s);
        preg_match_all("/" . $dirname . "\/p" . $pid . "_\d{12}_\d{4}\.[a-z_0-9]+/is", $arr['content'] .
            $arr['thumb'], $c);
        foreach (array_diff($s[0], $c[0]) as $v)
        {
            @unlink(ABSPATH . $v);
        }
        if (is_array($_POST['mids']) && $mpv[3])
        {
            $_POST['mids'][] = MID;
        } else
        {
            $_POST['mids'] = array(MID);
        }
        $arr['mids'] = array_unique(array_map('intval', $_POST['mids']));
        $_arr = unserialize($row['mids']);
        foreach (array_diff($_arr, $arr['mids']) as $mid)
        {
            do_apply('deltopic', null, $mid, $row);
        }
        foreach (array_diff($arr['mids'], $_arr) as $mid)
        {
            do_apply('newtopic', null, $mid, $row);
        }
        foreach (array_intersect($arr['mids'], $_arr) as $mid)
        {
            do_apply('updatetopic', null, $mid, $row);
        }
        $arr['mids'] = serialize($arr['mids']);
        $arr2 = array();
        foreach ($arr as $k => $v)
        {
            $arr2[] = $k . '=\'' . addslashes($v) . '\'';
        }
        $str = implode(',', $arr2);
        $db->query("update " . PF . "posts set $str where id='$pid'");
        return true;
    }
}
if (!function_exists('del_comment'))
{
    function del_comment($cid, $arr)
    {
        global $db, $conf;
        $db->query("delete from " . PF . "comments where id='$cid'");
        $db->query("update " . PF . "posts set comment=comment-1 where id='$arr[post_id]'");
        return true;
    }
}
if (!function_exists('del_topic'))
{
    function del_topic($pid, $row, $mid = 0, $full = true)
    {
        global $db, $conf;
        $mids = unserialize($row['mids']);
        if ($mid > 0)
        {
            if ($mids == array($mid) && $full)
            {
                del_topic($pid, $row);
            }
            do_apply('deltopic', null, $pid, $mid, $conf['sys_menus'][$mid]['mod'], $row);
            @$k = array_search($mid, $mids);
            unset($mids[$k]);
            empty($mids) && $mids = array($mid);
            $db->query("update " . PF . "posts set mids='" . addslashes(serialize($mids)) .
                "' where id='$pid'");
        } else
        {
            foreach ($mids as $v)
            {
                do_apply('deltopic', null, $pid, $v, $conf['sys_menus'][$v]['mod'], $row);
            }
            $db->query("delete from " . PF . "posts where id='$pid'");
            $db->query("delete from " . PF . "comments where post_id='$pid'");
            $dir = 'uploads/softs/' . date('y_', $row['post_time']) . ceil(date('z', $row['post_time']) /
                5);
            if (is_dir($dir))
            {
                foreach (glob($dir . '/p' . $pid . '_*.*') as $file)
                {
                    unlink($file);
                }
            }
        }
        return true;
    }
}
if (!function_exists('move_topic'))
{
    function move_topic($pid, $row, $mid, $tomid)
    {
        global $db, $conf;
        if ($mid == $tomid)
            retrun;
        $tomod = $conf['sys_menus'][$tomid]['mod'];
        if (!method_exists($tomod, 'newtopic'))
            return;
        eval($tomod . '::newtopic($tomid,$pid,$row);');
        del_topic($pid, $row, $mid, false);
    }
}
if (!function_exists('show_comment'))
{
    function show_comment($pid, $pg_d = 5)
    {
        global $db;
        $comment = array();
        $rs = $db->query('select *,comments.id as id from ' . PF .
            'comments as comments left join ' . PF .
            'user as user on user.id=comments.authorid where comments.post_id=' . $pid .
            ' order by comments.post_time desc LIMIT 0,' . $pg_d);
        while ($row = $db->fetch_array($rs))
        {
            $comment[$row['id']]['post_time'] = showtime($row['post_time']);
            $comment[$row['id']]['author'] = htmlspecialchars($row['name']);
            $comment[$row['id']]['content'] = htmlspecialchars($row['content']);
        }
        return $comment;
    }
}
if (!function_exists('uannex'))
{
    function uannex($uid = 0)
    {
        global $user;
        $uid = empty($uid) ? $user['id'] : 0;
        $uannex = array();
        $time = 3600;
        $farr = glob(ABSPATH . 'uploads/temp/*.*');
        $farr === false && $farr = array();
        foreach ($farr as $file)
        {
            $filename = strtolower(str_replace('/', '', strrchr($file, '/')));
            $ex = explode('_', $filename);
            if ((TIME - $time) > $ex[1])
            {
                unlink($file);
                continue;
            }
            if ($uid == $ex[0])
                $uannex[] = array('time' => date('H:i:s', $ex[1]), 'filename' => ROOTPATH .
                    'uploads/temp/' . $filename);
        }
        rsort($uannex);
        return $uannex;
    }
}
if (!function_exists('tpl_ad'))
{
    function tpl_ad($c)
    {
        global $conf;
        if ($conf['sys_ad'][$c]['time'] < TIME)
            return;
        $str = '';
        preg_replace("/\[" . LANG . "\](.+?)\[\/" . LANG . "\]/eis", "\$str='\\1'", $conf['sys_ad'][$c]['code']);
        return preg_replace("/\[code\](.+?)\[\/code\]/eis", "runcode('\\1')",
            stripslashes($str));
    }
}
if (!function_exists('tpl_doc'))
{
    function tpl_doc($c)
    {
        global $conf;
        $str = '';
        preg_replace("/\[" . LANG . "\](.+?)\[\/" . LANG . "\]/eis", "\$str='\\1'", $conf['sys_doc'][$c]);
        return preg_replace("/\[code\](.+?)\[\/code\]/eis", "runcode('\\1')",
            stripslashes($str));
    }
}
if (!function_exists('xstr'))
{
    function xstr($str, $len, $pf = false)
    {
        if ($len >= mb_strlen($str, 'UTF-8'))
        {
            return $str;
        }
        return mb_substr($str, 0, $len - 1, 'UTF-8') . (empty($pf) ? '' : '...');
    }
}
/**
 * 以下代码供系统自动获取语言使用
 * mlang('创建目录时失败')
 * mlang('用户中心')
 * mlang('游客')mlang('普通会员')mlang('受限制的会员')mlang('冻结的会员')mlang('高级会员')
 * mlang('值得信任的好友')mlang('撰稿人') mlang('网站编辑') mlang('网站协管员') mlang('管理员') 
 */

?>