<?php

require 'global.php';

function _index(){
	extract(user::init());

	$types=$GLOBALS['bar_types'];

	$db=new db;
	$sql='threadid,typeid,hit,reply,isbest,username,lastusername,lastdate,style,title';
	$url='bar_PID.htm';
	$where='';
	$order='lastdate desc,threadid desc';
	$res=$db->select('%s_thread', $sql, $url, $where, $order);
	$title=kc_config('site.bartitle');
	$keywords=kc_config('site.barkeywords');
	$description=kc_config('site.bardescription');
	
	$s='<h1>'.kc_config('site.barname').'<a href="#post" title="发布帖子"><img src="images/post.gif" alt="发布帖子"/></a></h1>';
	$s.='<div id="nav"><a href="./">'.kc_config('site.name').'</a> / <strong>'.kc_config('site.barname').'</strong></div>';

	if ($userid==1) {
		$s.='<table>';
		$s.='<tr><th>名称</th><td><input type="input" class="k_in w200" maxlength="50" value="'.htmlspecialchars(kc_config('site.barname')).'" onchange="$.kc_ajax({URL:\'index.php\',CMD:\'saveconfig\',name:\'barname\',\'class\':\'site\',value:$(this).val()})"/></td></tr>';
		$s.='<tr><th>标题</th><td><input type="input" class="k_in w500" maxlength="100" value="'.htmlspecialchars(kc_config('site.bartitle')).'" onchange="$.kc_ajax({URL:\'index.php\',CMD:\'saveconfig\',name:\'bartitle\',\'class\':\'site\',value:$(this).val()})"/></td></tr>';
		$s.='<tr><th>关键词</th><td><input type="input" class="k_in w500" maxlength="100" value="'.htmlspecialchars(kc_config('site.barkeywords')).'" onchange="$.kc_ajax({URL:\'index.php\',CMD:\'saveconfig\',name:\'barkeywords\',\'class\':\'site\',value:$(this).val()})"/></td></tr>';
		$s.='<tr><th>简述</th><td><input type="input" class="k_in w500" maxlength="200" value="'.htmlspecialchars(kc_config('site.bardescription')).'" onchange="$.kc_ajax({URL:\'index.php\',CMD:\'saveconfig\',name:\'bardescription\',\'class\':\'site\',value:$(this).val()})"/></td></tr>';
		$s.='</table>';
	}

	$s.='<ul id="typeList">';
	foreach ($types as $key => $type) {
		$s.='<li><a href="bar_type_'.$key.'_1.htm">'.$type.'</a></li>';
	}
	$s.='<li><a href="bar_best_1.htm">精华</a></li>';
	$s.='</ul>';
	$s.=$db->pagelist;
	$s.='<div id="bar">';
	if (!empty($res)) {
		$s.='<ul>';
		$s.='<li class="b">';
		$s.='<span>主题</span>';
		$s.='<i>回复/点击</i>';
		$s.='<em>作者</em>';
		$s.='<i>最后回复</i>';
		$s.='<em>回复人</em>';
		foreach ($res as $rs) {
			$s.='<li>';
			$s.='<span>';
			$s.='<a href="bar_type_'.$rs['typeid'].'_1.htm">['.$types[$rs['typeid']].']</a>';
			if ($rs['isbest']) {
				$s.='<a href="bar_best_1.htm">[精华]</a>';
			}
			$s.='<a href="bar_thread_'.$rs['threadid'].'_1.htm"'.(empty($rs['style'])?'':' style="'.$rs['style'].'"').'>'.htmlspecialchars($rs['title']).'</a>';
			if ($ismanage) {
				$s.='<a href="javascript:;" class="manage" onclick="$.kc_ajax({URL:\'bar.php\',CMD:\'edit\',threadid:'.$rs['threadid'].'})"><img src="images/edit.gif"/></a>';
				$s.='<a href="javascript:;" class="manage" onclick="$.kc_ajax({URL:\'bar.php\',CMD:\'delete\',threadid:'.$rs['threadid'].'})"><img src="images/delete.gif"/></a>';
			}
			$s.='</span>';
			$s.='<i>'.$rs['reply'].'/'.$rs['hit'].'</i>';
			$s.='<em>'.htmlspecialchars($rs['username']).'</em>';
			$s.='<i>'.str::formatDate($rs['lastdate'],'m-d',1).'</i>';
			$s.='<em>'.htmlspecialchars($rs['lastusername']).'</em>';
			$s.='</li>';
		}
		$s.='</ul>';
	}
	$s.='</div>';
	$s.=$db->pagelist;

	$s.='<script type="text/javascript">';
	$s.='$(pageInit);';
	$s.="function pageInit(){\$('#content').xheditor(true,{tools:'GStart,Pastetext,GEnd,Separator,GStart,Fontface,Bold,Italic,Underline,FontColor,BackColor,Removeformat,GEnd,Separator,GStart,Align,List,Outdent,Indent,GEnd,Separator,GStart,Link,Unlink,Img,Flash,Media,Emot,GEnd,Separator,GStart,About,GEnd',upImgUrl:'upload.php',upImgExt:'jpg,jpeg,gif,png'})}";
	$s.='</script>';

	$s.='<form id="post">';
	$s.='<ul>';

	$s.='<li class="post">';
	$s.='<strong>分类</strong>';
	foreach ($types as $key => $type) {
		$s.='<input type="radio" value="'.$key.'" id="type_'.$key.'" name="typeid"/>';
		$s.='<label for="type_'.$key.'">'.$type.'</label>';
	}
	$s.='</li>';

	$s.='<li class="post">';
	$s.='<strong class="h50">标题</strong>';
	$s.='<input class="w400 k_in" name="title" id="title" maxlength="80" />';
	$s.='</li>';
	
	$s.='<li>';
	$s.='<strong class="h50">内容</strong>';
	$s.='<textarea name="content" id="content" cols="90" rows="10"></textarea>';
	$s.='</li>';

	$s.='</ul>';
	$s.='<div class="k_submit">';
	$s.='<input type="submit" value="发布!" onclick="$.kc_ajax({URL:\'bar.php\',CMD:\'post\',FORM:\'post\',METHOD:\'POST\'});return false;" />';
	$s.='<strong style="margin-left:10px;">请输入验证码：</strong>';
	$s.='<input class="k_in w50" type="text" id="verify" name="verify" maxlength="4" onfocus="if($(\'#verify\').val()==\'\'){$.kc_ajax({URL:\'verify.php\',id:\'verify\'})}" />';
	$s.='<em class="k_verify" id="verify_image"></em>';
	$s.='<input type="hidden" id="verify_salt" name="verify_salt"/>';
	$s.='<span style="color:#F00;margin-left:10px;">共同营造和谐环境，杜绝诬陷、谩骂及骗子信息！</span>';
	$s.='</div>';

	$s.='</form>';

	require ROOT.TEMPLATE;
}


function _post(){
	extract(user::init());
	user::lockip();
	if ($userid==0) kc_ajax(array('JS'=>'alert(\'请先登录或注册成为会员后再发布帖子!\')'));;
	if(!kc_validate(kc_post('typeid'),2)) kc_ajax(array('JS'=>'alert(\'请选择一个类型!\')'));
	if(empty($_POST['title'])) kc_ajax(array('JS'=>'alert(\'标题不能为空!\')'));
	if(str::len($_POST['title'])>50) kc_ajax(array('JS'=>'alert(\'标题过长，不能超过50个字符!\')'));
	if(empty($_POST['content'])) kc_ajax(array('JS'=>'alert(\'内容不能为空!\')'));
	if(str::len($_POST['content'])>50000) kc_ajax(array('JS'=>'alert(\'内容过长，不能超过50000个字符!\')'));
	user::blackword($_POST['content']);
	//验证码
	$salt=$_POST['verify_salt'];
	if(empty($_POST['verify'])) kc_ajax(array('JS'=>'alert(\'请输入验证码!\')'));
	$fullCode=file::get(PATH_CACHE.'/verify/'.$salt.'.php');
	$code=substr($fullCode,13);
	$js="alert('您输入的验证码有误!');\$.kc_ajax({URL:'verify.php',id:'verify',salt:'$salt'});";
	if($code!=strtoupper($_POST['verify'])) kc_ajax(array('JS'=>$js));
	file::delete(PATH_CACHE.'/verify/'.$salt.'.php');
	
	$array=array(
		'typeid'=>kc_post('typeid',2,1),

		'userid'=>$userid,
		'username'=>$username,

		'title'=>kc_post('title'),
		'lastuserid'=>$userid,
		'lastusername'=>$username,
		'lastdate'=>$time,
	);
	$db=new db;
	$threadid=$db->insert('%s_thread', $array);
	
	$array=array(
		'threadid'=>$threadid,
		'userid'=>$userid,
		'username'=>$username,
		'ip'=>str::ip(),
		'date'=>$time,
		'floor'=>$db->newid('%s_reply','threadid='.$threadid),
		'content'=>kc_post('content')
	);
	$db->insert('%s_reply',$array);

	kc_ajax(array('JS'=>"go('bar_thread_{$threadid}_1.htm')"));
	
}

function _edit(){

	extract(user::init());
	if (!$ismanage) kc_tip('您无权编辑帖子属性');

	$db=new db;

	$threadid=kc_post('threadid',2,1);

	$data=array();
	if (METHOD=='GET') {
		$data=$db->getRows_one('%s_thread','style,norder,ishome,isbest,typeid','threadid='.$threadid);
		//kc_tip(print_r($data,1));
	}elseif(METHOD=='POST'){
		if(!kc_validate(kc_post('norder'),2)) kc_ajax(array('JS'=>'alert(\'排序必须为数字!\')'));

		$array=array(
			'norder'=>kc_post('norder'),
			'style'=>kc_post('style'),
			'isbest'=>kc_post('isbest') ? 1:0,
			'ishome'=>kc_post('ishome') ? 1:0,
			'typeid'=>kc_post('typeid'),
		);

		$db->update('%s_thread',$array,'threadid='.$threadid);
//kc_tip(print_r($array,1));
		$referer=kc_post('HTTP_REFERER');
		kc_ajax(array('JS'=>"go('$referer')"));
	}

	$s='<table class="k_table_form">';
	$s.='<tr><th>样式</th><td><input type="text" name="style" value="'.kc_val($data,'style').'" class="k_in w300" maxlength="100"/></td></tr>';
	$s.='<tr><th>分类</th><td><select name="typeid" >';
	foreach ($GLOBALS['bar_types'] as $k=>$v) {
		$s.='<option value="'.$k.'"'.($k==kc_val($data,'typeid') ? 'selected="true"':'').'>'.$v.'</option>';
	}
	$s.='</select></td></tr>';
	$s.='<tr><th>首页推荐</th><td><input type="checkbox" name="ishome" value="1" '.(kc_val($data,'ishome')?'checked="true"':'').'/></td></tr>';
	$s.='<tr><th>精华</th><td><input type="checkbox" name="isbest" value="1" '.(kc_val($data,'isbest')?'checked="true"':'').'/></td></tr>';
	$s.='<tr><th>排序</th><td><input type="text" name="norder" value="'.kc_val($data,'norder').'" class="k_in w50" maxlength="1"/></td></tr>';
	$s.='</table>';
	kc_ajax(array(
		'TITLE'=>'编辑属性',
		'MAIN'=>$s,
		'ID'=>'k_ajax',
		'WIDTH'=>480,
		'HEIGHT'=>180,
		'BUTTON'=>'<button onclick="$.kc_ajax({URL:\'bar.php\',CMD:\'edit\',FORM:\'k_ajaxForm\',METHOD:\'POST\',threadid:\''.$threadid.'\'})">保存</button>',
	));
}

function _delete(){
	extract(user::init());
	if(!$ismanage) kc_tip('您无权删除帖子');
	$threadid=kc_post('threadid',2,1);

	$db=new db;
	$db->delete('%s_thread','threadid='.$threadid);
	$db->delete('%s_reply','threadid='.$threadid);
	$referer=kc_post('HTTP_REFERER');
	kc_ajax(array('JS'=>"go('$referer')"));
}

?>