-- 参数配置 config ------------------------------
DROP TABLE IF EXISTS `utcms_config`;
CREATE TABLE `utcms_config` (
	`class` CHAR(15) NOT NULL,-- 分类
	`name` CHAR(20) NOT NULL,-- 键名
	`value` text NULL,-- 保存的值
	INDEX(`class`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO utcms_config (class,name,value) VALUES
('site','name','珲春·生活网'),-- 网站名称
('site','title','珲春生活网 - 珲春人自己的供求信息发布平台!'),-- 首页标题
('site','keywords','珲春 信息发布 房产信息 二手信息 人才招聘 商家促销'),-- 首页关键词
('site','description','珲春生活网为您提供 信息发布 房产信息 二手信息 人才招聘 交友 等服务'),-- 首页简述
('site','beian','吉ICP00008888号'),-- 备案号
('site','homead','珲春品牌展示'),-- 首页品牌展示标题
('site','service','珲春便民服务信息'),-- 首页服务信息标题
('site','barname','珲春生活贴吧'),-- 贴吧名称
('site','bartitle','珲春生活贴吧 - 记录珲春生活的点点滴滴 了解真实的珲春'),-- 贴吧标题
('site','barkeywords','珲春 贴吧 生活'),-- 贴吧标题
('site','bardescription','珲春 生活的点点滴滴 互动方式进一步了解珲春'),-- 贴吧标题
('site','link','实用链接');-- 首页服务信息标题

INSERT INTO utcms_config (class,name,value) VALUES
('black','word','\d{7,}'),-- 敏感词
('black','ip','');-- 首页服务信息标题

-- 单页 page ------------------------------
DROP TABLE IF EXISTS `utcms_page`;
CREATE TABLE `utcms_page` (
	id int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	norder int(10) UNSIGNED NOT NULL default 1,-- 排序
	type tinyint(1) UNSIGNED NOT NULL default 1,-- 类型 1首页 2形象页
	`name` CHAR(50) NOT NULL,-- 页面名称
	`title` CHAR(100) NOT NULL,-- 标题
	`keywords` CHAR(100) NULL,-- 关键词
	`description` CHAR(200) NULL,-- 简述
	`content` text NULL,-- 内容
	INDEX(type,norder,id),
	PRIMARY KEY (id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO utcms_page (norder,name,title,content) VALUES
(1,'我要发广告','广告及服务价格','
<h3>为什么我要在首页中投放</h3>
<p>“珲春123”作为本地领先的便民网站，以真诚服务的理念，免费为大家提供快捷地信息发布与查询服务，以信息量大，诚信度高，操作简单等优点深受晖春广大网友喜爱。</p>
<p>在“珲春123”发布您的广告，具有全天候、全时段、超人气的展示效果，比报纸、电视等传统方式更具优势，而您只需要更低的预算成本。</p>
<h3>广告展示报价</h3>
<p>首页品牌展示100元/月</p>
<p>信息列表页头部广告：100元/一月</p>
<p><u>一次预定半年首页品牌展示广告，免费制作首页品牌展示广告</u></p>
<h3>广告制作报价</h3>
<p>首页品牌展示广告设计制作：100元/一个</p>
<p>信息页头部广告设计制作：100元/一个</p>
<p>企业形象页设计制作：300元/一页</p>
<p>独立网站设计制作：1500元/20页以内</p>
<h3>联系我们</h3>
<p>手机：13500929250</p>
<p>联系人：申先生</p>
<p><a href="javascript:;" onclick="$.kc_ajax({URL:\'index\',CMD:\'feedback\'})">给管理员留言!</a></p>
<h3>付款方式</h3>
<p>中国工商银行 开户名：YYY 帐号：123345267718899</p>
<p>中国银行 开户名：ZZZ 帐号：879273128308031</p>
');

-- 留言反馈 ----------------------------
DROP TABLE IF EXISTS utcms_feedback;
CREATE TABLE utcms_feedback (
	id int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	content char(200) NOT NULL,-- 留言内容
	mail char(50) NULL,-- 邮箱地址
	isread tinyint(1) UNSIGNED NOT NULL default 0,-- 阅读状态 1已阅
	qq char(15) NULL,-- qq
	tel char(15) NULL,-- 电话
	name char(20) NULL,-- 联系人
	username char(20) NULL,-- 站内会员ID
	date int(10) UNSIGNED NOT NULL default 0,-- 留言时间
	ip int(10) UNSIGNED NOT NULL default 0,-- IP
	INDEX(isread,id),
	INDEX(id,isread),
	PRIMARY KEY (id)
) ENGINE=MyISAM  default CHARSET=utf8;


-- 用户 ----------------------------
DROP TABLE IF EXISTS utcms_user;
CREATE TABLE utcms_user (
	userid int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	username char(12) NULL,-- 用户名
	userpass char(32) NULL,-- 密码
	ismanage tinyint(1) UNSIGNED NOT NULL default 0,-- 是否为管理员
	date int(10) UNSIGNED NOT NULL default 0,-- 注册时间
	ip int(10) UNSIGNED NOT NULL default 0,-- 注册IP
	info_pub int(10) UNSIGNED NOT NULL default 0,-- 发帖
	info_del int(10) UNSIGNED NOT NULL default 0,-- 被删除
	bar_pub int(10) UNSIGNED NOT NULL default 0,-- 发布
	bar_del int(10) UNSIGNED NOT NULL default 0,-- 删除
	PRIMARY KEY (userid)
) ENGINE=MyISAM  default CHARSET=utf8;
-- 添加默认管理员
INSERT INTO utcms_user (username,userpass,ismanage) VALUES ('admin','7fef6171469e80d32c0559f88b377245',1);

-- 黄页列表 ----------------------------
DROP TABLE IF EXISTS utcms_yplist;
CREATE TABLE utcms_yplist (
	listid int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	norder int(10) UNSIGNED NOT NULL default 0,-- 排序
	name char(50) NULL,-- 列表名称
	title char(50) NULL,-- 列表标题
	keywords char(100) NULL,-- 关键词
	description char(200) NULL,-- 简述
	INDEX(`norder`,`listid`),
	PRIMARY KEY (listid)
) ENGINE=MyISAM  default CHARSET=utf8;
-- 黄页列表 
INSERT INTO utcms_yplist (norder,name,title) VALUES
(1,'航空机票','航空机票'),
(2,'搬家公司','搬家公司'),
(3,'保洁公司','保洁公司'),
(4,'开锁公司','开锁公司'),
(5,'宾馆订房','宾馆订房'),
(6,'卡拉OK','卡拉OK'),
(7,'快递公司','快递公司'),
(8,'花店鲜花','花店鲜花'),
(9,'洗浴中心','洗浴中心'),
(10,'家电维修','家电维修'),
(11,'送液化气','送液化气'),
(12,'饭店餐饮','饭店餐饮'),
(12,'婚庆摄影','婚庆摄影');

-- 公司信息 ----------------------------
DROP TABLE IF EXISTS utcms_ypage;
CREATE TABLE utcms_ypage (
	id int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	listid int(10) UNSIGNED NOT NULL default 0,-- 所属分类
	norder int(10) UNSIGNED NOT NULL default 0,-- 排序
	style char(100) NULL,-- 样式

	name char(50) NULL,-- 企业名称
	tel char(50) NULL,-- 电话
	url char(100) NULL,-- 网址
	address char(100) NULL,-- 地址

	status tinyint(1) NULL,-- 状态 1:已审 2:待审
	index(status,listid,norder,id),
	PRIMARY KEY (id)
) ENGINE=MyISAM  default CHARSET=utf8;

-- 广告位 ----------------------------
DROP TABLE IF EXISTS utcms_ad;
CREATE TABLE utcms_ad (
	id int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID

	norder int(10) UNSIGNED NOT NULL default 0,-- 排序
	sdate int(10) UNSIGNED NOT NULL default 0,-- 上架时间
	edate int(10) UNSIGNED NOT NULL default 0,-- 下架时间

	type char(30) NULL,-- 显示位

	alt char(50) NULL,-- alt属性
	url char(200) NULL,-- 网址
	src char(50) NULL,-- 图片地址

	price float(10) NOT NULL default 0,-- 收取费用

	cname char(20) NULL,-- 客户姓名
	ctel char(20) NULL,-- 电话
	cmail char(50) NULL,-- 邮箱
	address char(100) NULL,-- 地址
	notes char(200) NULL,-- 备注

	status tinyint(1) UNSIGNED NOT NULL default 1,-- 状态
	INDEX(type,status,sdate,edate,norder,id),
	PRIMARY KEY (id)
) ENGINE=MyISAM  default CHARSET=utf8;
-- 默认广告数据
INSERT INTO utcms_ad (norder,sdate,edate,type,alt,url,src) VALUES
(1,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/1.gif'),
(2,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/2.gif'),
(3,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/3.gif'),
(4,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/4.gif'),
(5,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/5.gif'),
(6,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/6.gif'),
(7,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/7.gif'),
(8,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/8.gif'),
(9,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/9.gif'),
(10,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/10.gif'),
(11,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/11.gif'),
(12,1112223330,1360340136,'home','品牌展示','http://www.utcms.com/','120x60/12.gif');

-- 友情链接 ----------------------------
DROP TABLE IF EXISTS utcms_link;
CREATE TABLE utcms_link (
	id int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	norder int(10) UNSIGNED NOT NULL default 0,-- 排序
	title char(50) NULL,-- 网站名称
	url char(100) NULL,-- 网址
	type tinyint(1) UNSIGNED NOT NULL default 1,-- 类型 1:实用链接,2:友情链接
	INDEX(type,norder,id),
	PRIMARY KEY (id)
) ENGINE=MyISAM  default CHARSET=utf8;

INSERT INTO utcms_link (norder,title,url,type) VALUES
(1,'珲春天气预报','http://qq.ip138.com/weather/jilin/HuiChun.htm',1),
(2,'珲春机动车违章查询','http://www.ybjg.gov.cn/wzch/index.asp?Modid=013001',1),
(3,'全国列车时刻表','http://www.hao123.com/ss/lccx.htm',1),
(4,'福利彩票查询','http://www.jilintz.com/SelfServiceStation/kjgg/kjgg1.jsp',1),
(1,'珲春生活网','http://www.hunchun123.com/',2),
(2,'KingCMS','http://www.kingcms.com/',2),
(3,'北京通州网','http://www.bjtzh.com/',2);

-- 信息列表 ----------------------------
DROP TABLE IF EXISTS utcms_infolist;
CREATE TABLE utcms_infolist (
	listid int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	name char(50) NULL,-- 信息列表名称
	title char(50) NULL,-- 信息列表标题
	keywords char(100) NULL,-- 关键词
	description char(200) NULL,-- 简述
	PRIMARY KEY (listid)
) ENGINE=MyISAM  default CHARSET=utf8;

INSERT INTO utcms_infolist (listid,name,title) VALUES
(1,'珲春房产','珲春房产信息'),
(2,'珲春二手','珲春二手信息'),
(3,'珲春人才','珲春人才 招聘 招工信息'),
(4,'商家促销','珲春商家促销信息'),
(5,'珲春交友','珲春交友 征婚信息');

-- 信息内容 ----------------------------
DROP TABLE IF EXISTS utcms_info;
CREATE TABLE utcms_info (
	id int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	listid tinyint(1) UNSIGNED NOT NULL default 1,-- 所属
	typeid smallint(2) UNSIGNED NOT NULL default 1,-- 分类

	norder tinyint(1) UNSIGNED NOT NULL default 0,-- 排序
	style char(100) NULL,-- 样式
	image char(100) NULL,-- 图片显示
	url char(100) NULL,-- 图片链接

	content char(200) NULL,-- 信息内容
	name char(20) NULL,-- 联系人
	tel char(15) NULL,-- 电话
	qq char(15) NULL,-- qq

	userid int(10) UNSIGNED NOT NULL default 0,-- 用户ID
	username char(12) NOT NULL,-- 用户名
	ip int(10) UNSIGNED NOT NULL default 0,-- 用户
	date int(10) UNSIGNED NOT NULL default 0,-- 发布时间

	INDEX(listid,norder,id),
	INDEX(typeid,norder,id),
	PRIMARY KEY (id)
) ENGINE=MyISAM  default CHARSET=utf8;


DROP TABLE IF EXISTS `utcms_thread`;
CREATE TABLE `utcms_thread` (
	`threadid` int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	`typeid` int(10) UNSIGNED NOT NULL default 0,-- 主题分类

	`hit` int(10) UNSIGNED NOT NULL default 0,-- 查看统计
	`reply` int(10) UNSIGNED NOT NULL default 1,-- 回复统计

	`userid` int(10) UNSIGNED NOT NULL default 0,-- 用户ID
	`username` char(20) NOT NULL,-- 用户名

	`lastuserid` int(10) UNSIGNED NOT NULL default 0,-- 最后回复用户
	`lastusername` char(20) NOT NULL,-- 用户名
	`lastdate` int(10) UNSIGNED NOT NULL default 0,-- 最后回复时间，以这个为排序

	ishome tinyint(1) UNSIGNED NOT NULL default 0,-- 首页推荐
	`isbest` tinyint(1) UNSIGNED NOT NULL default 0,-- 精华
	`style` char(100) NULL,-- 样式
	`norder` tinyint(1) UNSIGNED NOT NULL default 0,-- 置顶 3/2/1

	`title` char(80) NOT NULL,-- 标题
	INDEX(ishome,threadid),
	INDEX(isbest,threadid),
	INDEX(`lastdate`,`threadid`),
	INDEX(`typeid`,`lastdate`,`threadid`),
	PRIMARY KEY (`threadid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- 回帖 reply ----------------------------

DROP TABLE IF EXISTS `utcms_reply`;
CREATE TABLE `utcms_reply` (
	`replyid` int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	`threadid` int(10) UNSIGNED NOT NULL default 0,-- 所属主题

	`userid` int(10) UNSIGNED NOT NULL default 0,-- 用户ID
	`username` char(20) NOT NULL,-- 用户名

	`ip` int(10) UNSIGNED NOT NULL default 0,-- IP地址
	`date` int(10) UNSIGNED NOT NULL default 0,-- 日期
	`floor` int(10) UNSIGNED NOT NULL default 0,-- 楼层

	`content` text NULL,-- 主题内容
	INDEX(`threadid`,`replyid`),
	PRIMARY KEY (`replyid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- 图片上传 image ----------------------------

DROP TABLE IF EXISTS `utcms_image`;
CREATE TABLE `utcms_image` (
	`imageid` int(10) UNSIGNED NOT NULL auto_increment,-- 递增ID
	`userid` int(10) UNSIGNED NOT NULL default 0,-- 用户ID
	`username` char(20) NOT NULL,-- 用户名

	image char(100) NOT NULL,-- 图片地址

	`ip` int(10) UNSIGNED NOT NULL default 0,-- IP地址
	`date` int(10) UNSIGNED NOT NULL default 0,-- 日期

	INDEX(`userid`),
	PRIMARY KEY (`imageid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;



