<?php
/**
 * 文件缓存
 * 
 * cache目录的定义：className/functionName
 * 即为：model类里的getModelTables()函数对应的缓存文件为：model/getModelTable.php
 *
 */
class cache{

	/**
	 * 设置缓存
	 *
	 * @param string $name 键名
	 * @param string $value 值
	 * @param integer $time 时间,默认为30天
	 * @return string 写入值,即$value
	 */
	function set($name,$value,$time=2592000){

		$path=PATH_CACHE."/$name.php";
		$array=array(
			'time'=>time()+$time,
			'value'=>$value,
		);
		
		$text='<?php exit ?>'.serialize($array);
		file::put($path,$text);
		return $value;

	}

	/**
	 * 读取缓存
	 * @param string $name 键名
	 */
	function get($name){

		$path=ROOT.PATH_CACHE."/$name.php";
		if (is_file($path)) {
			$text=file_get_contents($path);
			$array=unserialize(substr($text,13));
			$time=kc_val($array,'time');
			//如果有效时间小于当前时间，则作废
			if ($time<time()){
				cache::del($name);
				return false;
			}
			return kc_val($array,'value');
		}else{
			return false;
		}


	}

	/**
	 * 删除缓存
	 * @param string $name 键值
	 */
	function del($name){

		$path=ROOT.PATH_CACHE."/$name.php";
		if(is_file($path)){
			unlink($path);
		}

	}

	/**
	 * 清理缓存
	 */
	function flush(){
		file::rd(PATH_CACHE);
	}

}

?>