<?php
/**
 * MySQL传统方式操作数据库
 */
class db {

    private $link;
    private $query_ID;
    private $result;
    private $type;
    public $pagelist;

    public function __construct() {
		$this->pagelist=array();
    }

    /**
     * 链接数据库服务器
     * @param string $info MySQL链接信息
     * @param string $user 帐号
     * @param string $pass 密码
     * @return object
     */
    public function connect($info=null,$user=null,$pass=null) {

		if(!isset($this->link)) {

			if (empty($info)) {
			$info='mysql:host='.DB_HOST.';dbname='.DB_DATA;
			$host=DB_HOST;
			$dbname=DB_DATA;
			$user=DB_USER;
			$pass=DB_PASS;
			}

			$this->type='mysql';

			try {
				$this->link=@mysql_connect($host,$user,$pass);
				@mysql_select_db($dbname,$this->link);
			}catch(Exception $e ) {
				$tip=kc_lang('db.tip');
				$msg=$e->getMessage();
				foreach ($tip as $key => $val) {
					if (false !== strpos($msg,(string)$key)) {
					$tipMsg=$val;continue;
					}
				}
				kc_tip( (empty($tipMsg) ?  kc_lang('db.error.connect') : $tipMsg) .'<br/>'.$msg);
			}

		}

		return $this->link;
    }
    /**
     * 查询
     * @param string $sql 查询语句
     * @return object
     */
    public function query($sql) {

		if(!isset($this->link)) {
			$this->connect();//判断数据库连接是否可用
		}

		try {
			mysql_query('set names '.DB_CHARSET);//设置字符集
			$this->query_ID = mysql_query($sql);
		}catch(Exception $e ) {
			$tip=kc_lang('db.tip');
			$msg=$e->getMessage();
			foreach ($tip as $key => $val) {
				if (false !== strpos($msg,(string)$key)) {
					$tipMsg=$val;continue;
				}
			}
			kc_tip( (empty($tipMsg) ?  kc_lang('db.error.query') : $tipMsg) .'<br/>&lt;&lt;&lt;<br/>'.$sql.'<br/>&gt;&gt;&gt;<br/>'.$msg);
		}

		return $this->query_ID;
    }
    /**
     * sql直接利用sql获得数据
     * @param string $sql SQL代码
     * @return array 记录集
     */
    public function get($sql) {

		$res=array();
		$this->query($sql);
		if (empty($this->query_ID)) {
			return array();
		}
		$rows=mysql_num_rows($this->query_ID);

		for($i=0;$i<$rows;$i++) {
			if(!mysql_data_seek($this->query_ID,$i)) {
			kc_tip('<label>'.kc_lang('dberr.err3').'</label><textarea>'.htmlspecialchars($_sql).'</textarea>');
			}
			$rs=mysql_fetch_array($this->query_ID);
			foreach ($rs as $k=>$r) {
				if (is_int($k) && $k!==0) {
					unset($rs[$k]);
				}
			}
			$res[$i]=$rs;
		//echo ('<pre>'.print_r(mysql_fetch_array($this->query_ID),1).'</pre>');
		}
		//释放资源
		$this->free();

		return $res;

    }
    /**
     * 数组方式读取数据
     *
     * @param string $table 表
     * @param string $insql 检索对象
     * @param string $where 条件
     * @param string $order 排序
     */
    public function getRows($table,$insql='*',$where=null,$order=null,$limit=null) {
		$table=str_replace('%s',DB_PRE,$table);

		$sql="SELECT $insql FROM $table ";
		$sql.= empty($where) ? '' : " WHERE $where";
		$sql.= empty($order) ? '' : " ORDER BY $order";
		$sql.= empty($limit) ? '' : " LIMIT $limit";

		return $this->get($sql);

    }
    /**
     * 读取数据，带分页
     *
     * @param string $table 表
     * @param string $insql 检索对象
     * @param string $where 条件
     * @param string $order 排序
     * @param string $url 分页模板
     * @param integer $pid 当前页
     * @param integer $order 每页显示数
     */
    public function select($table,$insql='*',$url=null,$where=null,$order=null,$pid=null,$rn=null) {
		$table=str_replace('%s',DB_PRE,$table);

		if (empty($pid)) {
			$pid=empty($_GET['pid']) ? 1 : $_GET['pid'];
			$pid=kc_validate($pid,2) ? $pid :1;
		}
		if (empty($rn)) {
			$rn=empty($_GET['rn']) ? 20 : $_GET['rn'];
			$rn=kc_validate($rn,2) ? $rn : 20;
			if ($rn>100) $rn=100;
		}
		$limit=($rn*($pid-1)).','.$rn.';';

		$sql="SELECT $insql FROM $table ";
		$sql.= empty($where) ? '' : " WHERE $where";
		$sql.= empty($order) ? '' : " ORDER BY $order";
		$sql.= empty($limit) ? '' : " LIMIT $limit";

		//设置pagelist
		$rcount=$this->getCount($table,$where);
		$this->pagelist=str::pagelist($url,$rcount,$pid,$rn);

		return $this->get($sql);

    }
    /**
     * 添加数据
     *
     * @param type $table 数据表
     * @param type $array 操作值
     * @param bool $is 是否批量添加,批量添加的时候，$array为二位数组
     * @return integer 返回新添加的ID
     */
    public function insert($table,$array,$is=0) {
		$fields = $values = array();
		$table=str_replace('%s',DB_PRE,$table);

		if(empty($array)) return false;

		$sql_array=array();
		if($is) {//批量添加

			foreach ($array[0] as $key => $val) {
			$fields[]=$key;
			}

			foreach ($array as $arr) {
			foreach ($arr as $key => $val) {
				$values[]=$this->encode($val);
			}
			$sql_array[]='(\''.implode('\',\'',$values).'\')';
			$values=array();
			}

		}else {

			foreach($array as $key=>$val) {
			$fields[]=$key;
			$values[]=$this->encode($val);
			}
			$sql_array[]='(\''.implode('\',\'',$values).'\')';
		}
		$sql='INSERT INTO '.$table.' ('.implode(',',$fields).') VALUES ';
		$sql.=implode(',',$sql_array).';';

		$this->query($sql);

		$newid=mysql_insert_id($this->link);//$this->link->lastInsertRowid();

		return $newid;
    }
    /**
     * 更新数据
     *
     * @param string $table 数据表
     * @param array $array 要更新的数据
     * @param string $where 条件语句
     */
    public function update($table,$array,$where=null) {
		$fields = $values = array();
		$table=str_replace('%s',DB_PRE,$table);
		foreach($array as $key=>$val) {

			$values[]=preg_match("/^\[\[.+\]\]$/",$val)//[[hit=hit+1]]
			? $key.'='.substr($val,2,-2)
			: $key.'=\''.$this->encode($val).'\'';
		}

		$sql='UPDATE '.$table.' SET '.implode(',',$values).(empty($where) ?  ';' : ' WHERE '.$where.';');
		$this->query($sql);
    }


    /**
     * 返回记录集，单行操作
     * @param string $table 表
     * @param string $insql 调用的代码
     * @param string $where 条件
     * @return array 记录集数组
     */
    public function getRows_one($table,$insql='*',$where=null) {

		$table=str_replace('%s',DB_PRE,$table);

		$sql="SELECT $insql FROM $table ";
		$sql.=empty($where) ? '' : " WHERE $where";

		$this->query($sql);
		if(empty($this->query_ID)) {
			return false;
		}
		$rs=mysql_fetch_assoc($this->query_ID);

		$this->free();

		return $rs;
    }

    /**
     * 获得表信息
     * @param string $table 表名称
     * @return array 表信息
     */
    public function getField($table='') {
		$like='';
		if (!empty($table)) {
			$table=str_replace('%s',DB_PRE,$table);
			$like=" like '$table'";
			$this->query('SHOW TABLE STATUS'.$like);
			if (empty($this->query_ID)) {
			return false;
			}
			$res=mysql_fetch_assoc($this->query_ID);;
		}else {
			$res=$this->get('SHOW TABLE STATUS');
		}

		$this->free();
		return $res;
    }

    /**
     * 释放资源
     */
    public function free() {
		if(!empty($this->query_ID))
			@mysql_free_result($this->query_ID);
    }
    /**
     * 获得当前最大值+1
     *
     * @param string $table 表
     * @param string $where 条件
     * @param string $field 字段
     * @return int
     */
    public function newid($table,$where='',$field='norder') {
	$res=$this->getRows_one($table,"MAX($field) AS c",$where);
	return $res['c']+1;
    }
    /**
     * 获得总数
     *
     * @param string $table 表
     * @param string $where 条件
     * @param string $field 字段
     * @return integer 总数量
     */
    public function getCount($table,$where='',$field='*') {
	$res=$this->getRows_one($table,"COUNT($field) AS c",$where);
	return $res['c'];
    }
    /**
     * 返回数据库版本
     *
     * @return string 版本号
     */
    public function version() {
	if(!isset($this->link)) $this->connect();
	return 'MySQL/'.mysql_get_server_info();
    }

    /**
     * 修改数据表
     *
     * @param string $tableName  表名
     * @param string $sql
     * @param int    $is         0 ADD 1 RENAME TO
     */
    public function alterTable($tableName,$sql,$is=0) {
	$alteration = $is ? " RENAME TO " : "ADD" ;
	$this->query("ALTER TABLE $tableName $alteration $sql ;");
    }
    /**
     * 删除记录
     * @param string $table 要操作的数据表名称
     * @param string $where 条件
     */
    public function delete($table,$where='') {
	$table=str_replace('%s',DB_PRE,$table);
	$this->query("DELETE FROM $table ".(empty($where)?'' :" WHERE $where"));
    }
    /**
     * 安全字符转换
     *
     * 写这个函数是为了统一处理各个不同的数据库在单引号处理方式上的区分
     *
     * @param string $s 输出的字符
     * @return string 转换后的字符
     */
    public function encode($s) {
	return addslashes($s);
    }
    /**
     * 数据排序
     * @param type $table 排序表单
     * @param type $id 条件字段
     * @param type $field 字段
     */
    public function order($table,$id='id',$field='norder') {
	$table=str_replace('%s',DB_PRE,$table);

	$IDS=$_POST['IDS'];
	$order=$_POST[$IDS];
	if(!kc_validate($order,2)) kc_tip(kc_lang('error.order'));
	if(strlen($order)>10) kc_tip(kc_lang('error.order_size'));

	$idValue=kc_post('id',2,1);

	$sql="UPDATE $table SET $field='$order' WHERE $id='$idValue' ";

	$this->query($sql);

	exit('{}');

    }




} //!DB_CLASS

?>