<?php
/**
 * 文件操作类，可以直接访问
 */
class file{

	/**
	 * 读取指定的目录下面的文件和文件夹列表
	 *
	 * @param <type> $path 要读取的路径，必须以/结尾
	 * @param string $type 遍历并返回的文件类型 *:所有文件和目录 dir:目录 file:文件 [ext]:指定扩展名，如：xml|doc
	 * @param array $ignore 过滤的文件或目录名称
	 * @return array 列表 array('不包含ROOT的完整路径'=>'文件名')
	 */
	function getDir($path='',$type='*',$ignore=array('.','..','.svn')){

		if (!is_dir(ROOT.$path)) {
			return array();
		}

		$dirs = $files = array();

		$handle=opendir(ROOT.$path);
		if($handle){
			while (false !== ($file=@readdir($handle))){
				$file=file::encode($file);
				if(!in_array($file,$ignore)){

					if(is_dir(ROOT.$path.$file)){//如果是dir
						if($type=='*'||$type=='dir')
							$dirs[$path.$file]=$file;
					}else{//文件
						if($type=='*'||$type=='file'||preg_match("/^.+\.({$type})$/i",$file))
							$files[$path.$file]=$file;
					}
				}
			}
			closedir($handle);

			//sort($files);
			//sort($dirs);
			$union=array_merge($dirs,$files);
			return $union;
		}else{
			kc_tip(kc_lang('file.error.notdir').'<br/>'.$path);
		}
	}
	/**
	 * 根据文件类型返回目录
	 *
	 * @param string $filetype 文件类型
	 * @return string 目录
	 */
	public function fileType2path($filetype){
		switch ($filetype) {
			case 'template':
				$path=PATH_TEMPLATE;
				break;
			case 'image':
				$path=PATH_UP.'/'.PATH_UP_IMAGE;
				break;
			case 'media':
				$path=PATH_UP.'/'.PATH_UP_MEDIA;
				break;
			case 'flash':
				$path=PATH_UP.'/'.PATH_UP_FLASH;
				break;
			case 'file':
				$path=PATH_UP.'/'.PATH_UP_FILE;
				break;
			default:
				kc_tip(kc_lang('brow.error.type'));
				break;
		}
		return $path;
	}
	/**
	 * 读取文件
	 * @param string $filename 要读取的文件路径
	 * @return string 文件内容
	 */
	public function get($filename){

		$s='';
		$filename=file::encode($filename,1);

		if(empty($GLOBALS['file_get_contents_array']))
			$GLOBALS['file_get_contents_array']=array();

		if(is_file(ROOT.$filename)){//如果存在则读取

			$s='';
			$fh = fopen(ROOT.$filename,"r");
				while (!feof($fh)) {
				$s.=fgets($fh);
			}

			fclose($fh);

		}

		return $s;

	}

	/**
	 * 把字符串写入文件，返回是否成功
	 *
	 * @param string $filename 要写入的文件地址，相对于安装目录
	 * @param string $s 要写入的文本内容
	 * @param bool $is 当写入失败的时候，是否提示错误，默认为不提示
	 * @return bool true:成功 false:写入失败
	 */
	function put($filename,$s,$is=false){

		$filename=file::encode($filename,1);

		file::md(dirname($filename));//创建目录

		//去掉bom
		if(substr($s,0,3)==pack("CCC",0xef,0xbb,0xbf)){
			$s=substr($s,3);
		}
//exit($filename);
		if( file_put_contents(ROOT.$filename,$s,LOCK_EX) !== false ) {//写入成功
			return true;
		}else{//写入失败
			if($is){
				kc_tip(kc_lang('file.error.put').'<br/>'.$filename);
			}
		}

	}
	/**
	 * 递归方式创建目录
	 *
	 * @param string $path 目录路径
	 * @return bool true:成功创建目录 false:失败
	 */
	public function md($path){
		$path=file::encode($path,1);
		$array=explode('/',$path);
		$new='';
		$is=true;
		foreach($array as $val){
			$new.=$val.'/';
			if(isset($val{0})){
				if(!file_exists(ROOT.$new)){
					if(!@mkdir(ROOT.$new))
						$is=false;
				}
			}
		}
		return $is;
	}
	/**
	 * 删除文件夹/删除目录
	 *
	 * @param type $path 要删除的文件夹路径
	 * @param type $is
	 * @return type
	 */
	function rd($path,$is=0){

		$path=file::encode($path,1);

		if(!is_dir(ROOT.$path)) return;

		$array=file::getDir($path);
		foreach($array as $val){
			$file=$path.'/'.$val;
			if($val!=''){
				if(is_dir(ROOT.$file)){//目录
					file::rd($file,1);
					rmdir(ROOT.$file);
				}else{
					file::delete($file);
				}
			}
		}

		if(!$is && is_dir(ROOT.$path)){
			rmdir(ROOT.$path);
		}

	}
	/**
	 * 删除文件
	 *
	 * @param string $path 文件路径
	 * @return bool true:成功 false:失败
	*/
	function delete($path){

		$path=file::encode($path,1);

		if(is_file(ROOT.$path)){
			return unlink(ROOT.$path);
		}
		return false;
	}
	/**
	 * 文件编码转换
	 *
	 * @param string $s 传入的字符串
	 * @param bool $is 默认读取，1的时候是写入
	 * @return string 转换后的字符串
	 */
	public function encode($s,$is=0){

		$lang=kc_val($_SERVER,'HTTP_ACCEPT_LANGUAGE');

		if(substr($lang,0,5)=="zh-cn"){
			$code='GBK';
		}elseif(substr($lang,0,5) == "zh-tw"){
			$code='BIG5';
		}

		if(isset($code)){
			$s=$is ? kc_iconv($s,$code,'utf-8') : kc_iconv($s,'utf-8',$code);
		}

		return $s;
	}


	/**
	 * 分析HTML代码，并把其中的远程图片抓取到本地
	 * @param string $s 要分析的HTML代码
	 * @return string HTML代码
	 */
	function grabImg($s){
		$dom=new simple_html_dom;
		$dom->load($s,true);
		foreach ($dom->find('img') as $g) {//$img='';完整的图片HTML代码
			$src=$g->src;
			$g->src=PATH.file::saveImage($src);//设置新的图片路径地址
		}
		return $dom->outertext;
	}

	/**
	 * 远程图片路径
	 * @param string $s 本地图片路径
	 */
	function saveImage($s){
		if (kc_validate($s,6)) {
			$fext=strtolower(substr(strrchr($s,'.'),1));
			if (!in_array(strtolower($fext),array('jpeg','jpeg','gif','png'))) {
				$fext='jpg';
			}
			$name=time().str::random(6,1).'.'.$fext;
			$localPath=PATH_UP.'/'.PATH_UP_IMAGE.'/'.gmdate(FORMAT_PATH,time()).'/'.$name;
			//抓图
			$image=file_get_contents($s);
			if(!empty($image)){//这个可能得做strlen判断
				//保存
				file::put($localPath,$image);
				return $localPath;
			}
		}
		return $s;
	}

	/**
	 * 上传文件
	 * @param string $inputname FILE表单名称
	 * @param string $filetype 文件类型
	 * @param string $path 默认上传路径,根据config参数和当前时间计算,必须以/
	 * @param integer $filesize 最大上传文件大小 单位KB
	 * @return bool 当成功的时候，返回true
	 */
	public function uploadFile($inputname,$filetype='image',$path=null,$filesize=2048){
		
		//exit(print_r($_FILES,1));
		if (!isset($_FILES[$inputname])) {
			return 4;
		}
		$upfile=$_FILES[$inputname];
		//上传错误的时候
		if (!empty($upfile['error'])) {
			return $upfile['error'];
		}
		/**
			Array
			(
				[upload] => Array
					(
						[name] => logo_cn.gif
						[type] => image/gif
						[tmp_name] => C:\WINDOWS\temp\php6D.tmp
						[error] => 0
						[size] => 7763
					)

			)
		 */
		$filename=$upfile['name'];//文件名
		$fext=strtolower(substr(strrchr($filename,'.'),1));
		//若常量未被定义，则退出
		$FILETYPE='EXT_'.strtoupper($filetype);//转为大写
		if (!defined($FILETYPE)) {
			return 1001;
		}		

		$filetypeValue=constant('EXT_'.strtoupper($filetype));//获得常量值
		//判断文件扩展名是否符合要求
		if (!preg_match('/^('.$filetypeValue.')$/',$fext)) {
			return 1002;
		}
		//判断文件大小
		$filesize *= 1024;//kb转换为字节
		if ($upfile['size']>$filesize) {
			return 1003;
		}

		//获得对应的上传分类目录
		$uppath=constant('PATH_UP_'.strtoupper($filetype));
		
		$name=time().str::random(6,1).'.'.$fext;//新的文件名
		$localPath=empty($path) 
		? PATH_UP.'/'.$uppath.'/'.gmdate(FORMAT_PATH,time()).'/'.$name
		: $path.$name;

		file::md(dirname($localPath));
		move_uploaded_file($upfile['tmp_name'],ROOT.$localPath);

		return $localPath;//返回图片路径

	}
	/**
	 * 返回文件类型ICO图片
	 *
	 * @param string $filename 完整的文件名
	 */
	function ico($filename){

		$path=pathinfo($filename);
		$ext=strtolower(empty($path['extension']) ? 'dir' : $path['extension']);

		if(is_file(ROOT.'include/images/filetype/'.$ext.'.png')){
			$ico=$ext;
		}elseif (in_array($ext,array('html','shtm','shtml'))) {
			$ico='htm';
		}elseif(in_array($ext,array('sqlite','db3'))){
			$ico='db';
		}elseif(in_array($ext,array('jpg','jpeg','gif','png','bmp'))){
			$ico='img';
		}elseif(in_array($ext,array('rar','bz','bz2','7z'))){
		}else{
			$ico='sys';
		}
		return $ico;

	}


}
?>