<?php

class image{

	public function _thumb($path,$width=640,$height=640){
		$size=@getimagesize(ROOT.$path);
		$_width=$size[0];
		$_height=$size[1];
		if($_width/$_height>=$width/$height){
			$w=$width;
			$h=round(($_height/$_width)*$width);
			if($width>$_width) {
				$w=$_width;
				$h=$_height;
			}
		}else{
			$w=round(($_width/$_height)*$height);
			$h=$height;
			if($height>$_height) {
				$w=$_width;
				$h=$_height;
			}
		}
		$ext=strtolower(substr(strrchr($size['mime'], '/'),1));
		if(in_array($ext,array('jpg','jpeg','gif','png'))){
			$fext= ($ext=='jpg') ? 'jpeg' : strtolower($ext);
		}else{
			return;
		}
		$func='imagecreatefrom'.$fext;
		$source=$func(ROOT.$path);
		$im=imagecreatetruecolor($w, $h);
		//拷贝图像新建
		imagecopyresampled($im,$source,0,0,0,0,$w,$h,$_width,$_height);

		//装载水印图片
		list($w1,$h1)=@getimagesize(ROOT.'images/water.gif');
		$water=imagecreatefromgif(ROOT.'images/water.gif');
		imagecopymerge($im,$water,$w-$w1-3,$h-$h1-3,0,0,$w1,$h1,80); // 左上
		//开启抗锯齿
		imageantialias($im,True);
		$func='image'.$fext;
		//保存缩略图
		$func($im,ROOT.$path);
	}

	/**
	 * 获得缩略图路径
	 * 
	 * @param string $old 原始路径
	 */
	public function getThumbPath($old,$attrib){
		$width=kc_val($attrib,'width');
		$height=kc_val($attrib,'height');
		$width=kc_validate($width,2) ? $width : 120 ;
		$height=kc_validate($height,2) ? $height : 90;

		$fileName=basename($old);

		$path=dirname($old).'/thumb/'.$width.'x'.$height.'/'.$fileName;
		return $path;
	}
	/**
	 * 图像处理
	 *
	 * @param string $s       图片路径
	 * @param array  $attrib  图片属性
			需要有width和height属性
			外加一些滤镜
	 * @return string 返回缩略图地址
	*/
	public function thumb($s,$attrib){

		$width=kc_val($attrib,'width');
		$height=kc_val($attrib,'height');
		$position=kc_val($attrib,'position');

		if(!is_file(ROOT.$s))//确定文件存在
			return $s;
		list($_width, $_height)=@getimagesize(ROOT.$s);

		if($_width && $_height){
			$width=kc_validate($width,2) ? $width : 120;
			$height=kc_validate($height,2) ? $height : 90;
		}else{
			return $s;
		}

		$newimg=image::getThumbPath($s,$attrib);//新文件
		$newdir=dirname($newimg);//新目录

		//如果缩略图文件存在，则直接返回缩略图文件地址
		if(is_file(ROOT.$newimg)){
			return PATH.$newimg;
		}
		/*
		 * 如果加入截图位置的话，
		 * location=top,left,right,bottom,topleft,topright,leftbottom,rightbottom,
		 */
		if($_width/$_height>=$width/$height){
			$w=round(($_width/$_height)*$height);
			$h=$height;
			$x=round(($width-$w)/2);
			$y=0;
		}else{
			$w=$width;
			$h=round(($_height/$_width)*$width);
			$x=0;
			$y=round(($height-$h)/2);
		}


		switch ($position){
			case 'top':$y=0;break;
			case 'left':$x=0;break;
			case 'right':$x=$x*2;break;
			case 'bottom':$y=$y*2;break;

			case 'lefttop':$x=0;$y=0;break;
			case 'topleft':$x=0;$y=0;break;

			case 'righttop':$x=$x*2;$y=0;break;
			case 'topright':$x=$x*2;$y=0;break;

			case 'leftbottom':$x=0;$y=$y*2;break;
			case 'bottomleft':$x=0;$y=$y*2;break;

			case 'rightbottom':$x=$x*2;$y=$y*2;break;
			case 'bottomright':$x=$x*2;$y=$y*2;break;

			default:
				if (kc_validate($position,'/^\-?\d+\,\-?\d+$/')){
					list($x,$y)=explode(',',$position);
				}
		}

		$size=@getimagesize(ROOT.$s);
		$ext=strtolower(substr(strrchr(kc_val($size,'mime'), '/'),1));

		if(in_array($ext,array('jpg','jpeg','gif','png'))){
			$fext= ($ext=='jpg') ? 'jpeg' : strtolower($ext);
		}else{
			return $s;
		}

		$func='imagecreatefrom'.$fext;
		$source=$func(ROOT.$s);
		$im=imagecreatetruecolor($width, $height);

		//拷贝图像新建
		imagecopyresampled($im,$source,$x,$y,0,0,$w,$h,$_width,$_height);

		//重设长宽，减1是位置像素问题
		$w1=$width-1;
		$h1=$height-1;

		//置空
		$empty=kc_val($attrib,'empty');
		if(isset($empty{0})){

			$c1=kc_validate(kc_val($attrib,'empty-color'),13)?$attrib['empty-color']:'FFFFFF';//颜色
			$s1=kc_validate(kc_val($attrib,'empty-size'),2)?$attrib['empty-size']:0;//边框的厚度
			$r1=kc_validate(kc_val($attrib,'empty-r'),2)?$attrib['empty-r']:5;//圆角(半径)
			$empty_filter=kc_val($attrib,'empty-filter');//滤镜
			$empty_filter_color=kc_validate(kc_val($attrib,'empty-filter-color'),13) ? $attrib['empty-filter-color'] : '#666666';//颜色

			$color=kc_hex2rgb($im,$c1);//转换颜色

			for($i=0;$i<$s1;$i++){
				imagerectangle($im,$i,$i,$w1-$i,$h1-$i,$color);//方框填充
			}

			switch(strtolower($empty)){
				case 'rectangle'://矩形

					//滤镜
					switch(strtolower($empty_filter)){
						case 'shadow':
							for($i=0;$i<$s1;$i++){
								$color=kc_hex2rgb($im,$empty_filter_color,(1-$i/$s1)*100);
								imageline($im,$s1+$i,$h1-$s1+$i,$w1-$s1+$i,$h1-$s1+$i,$color);
								imageline($im,$w1-$s1+$i,$s1+$i,$w1-$s1+$i,$h1-$s1+$i,$color);
							}
						break;
					}

				break;

				case 'fillet'://圆角矩形
					$d1=$s1+$r1-1;//位置

					for($i=0;$i<$r1+$s1;$i++){
						//画ARC
						$r=($r1+$i)*2-1;
						imagearc($im, $d1,    $d1,    $r,$r, 180,270,$color);//左上
						imagearc($im, $w1-$d1,$d1,    $r,$r, 270,360,$color);//右上
						imagearc($im, $w1-$d1,$h1-$d1,$r,$r,   0, 90,$color);//右下
						imagearc($im, $d1,    $h1-$d1,$r,$r,  90,180,$color);//左下
					}

					//滤镜
					switch(strtolower($empty_filter)){
						case 'shadow':
							for($i=0;$i<$s1;$i++){
								$r=($r1+$i)*2-1;
								$color=kc_hex2rgb($im,$empty_filter_color,(1-$i/$s1)*100);
								imageline($im,$d1+$i,$h1-$s1+$i,$w1-$d1,$h1-$s1+$i,$color);
								imageline($im,$w1-$s1+$i,$d1+$i+1,$w1-$s1+$i,$h1-$d1,$color);
								imagearc($im, $w1-$d1,$h1-$d1,$r,$r,   0, 90,$color);//右下

							}
						break;
					}

				break;

				case 'chamfer'://斜切矩形
					$d1=$s1+$r1-1;//位置

					for($i=0;$i<$r1;$i++){
						imageline($im,$w1-$d1+$i,$s1,$w1-$s1,$d1-$i,$color);//右上
						imageline($im,$w1-$s1,$h1-$d1+$i,$w1-$d1+$i,$h1-$s1,$color);//右下
						imageline($im,$d1-$i,    $h1-$s1,$s1,    $h1-$d1+$i,$color);//左下
						imageline($im,$s1,    $d1-$i,$d1-$i,    $s1,$color);//左上
					}

					//滤镜
					switch(strtolower($empty_filter)){
						case 'shadow':
							for($i=0;$i<$s1;$i++){
								$r=($r1+$i)*2-1;
								$color=kc_hex2rgb($im,$empty_filter_color,(1-$i/$s1)*100);
								imageline($im,$d1+$i+1,$h1-$s1+$i,$w1-$d1,$h1-$s1+$i,$color);
								imageline($im,$w1-$s1+$i,$d1+$i+1,$w1-$s1+$i,$h1-$d1,$color);
								imageline($im,$w1-$s1+$i,$h1-$d1,$w1-$d1,$h1-$s1+$i,$color);//右下

							}
						break;
					}

				break;

			}
		}

		//border
		$border=kc_val($attrib,'border');
		if(isset($border{0})){

			$c1=kc_validate(kc_val($attrib,'border-color'),13)?$attrib['border-color']:'000000';//颜色
			$m1=kc_validate(kc_val($attrib,'border-margin'),2)?$attrib['border-margin']:0;//移位
			$r1=kc_validate(kc_val($attrib,'border-r'),2)?$attrib['border-r']:5;//圆角(半径)
			$s1=kc_validate(kc_val($attrib,'border-size'),2)?$attrib['border-size']:1;//宽度

			$color=kc_hex2rgb($im,$c1);//转换颜色

			switch(strtolower($border)){
				case 'rectangle':
					for($i=0;$i<$s1;$i++){//边框要一层层加
						imagerectangle($im,$i+$m1,$i+$m1,$w1-$i-$m1,$h1-$i-$m1,$color);
					}
				break;

				case 'fillet'://圆角矩形

					$d1=$m1+$r1;//设置距离
					for($i=0;$i<$s1;$i++){//边框要一层层加
						$d=$r1*2-$i*2;//直径
						//画线
						imageline($im,$d1,    $m1+$i,    $w1-$d1,$m1+$i,    $color);//上
						imageline($im,$w1-$m1-$i,$d1,    $w1-$m1-$i,$h1-$d1,$color);//右
						imageline($im,$d1,    $h1-$m1-$i,$w1-$d1,$h1-$m1-$i,$color);//下
						imageline($im,$m1+$i,    $d1,    $m1+$i,    $h1-$d1,$color);//左
						//画ARC
						imagearc($im,$d1,    $d1,    $d,$d,180,270,$color);//左上
						imagearc($im,$w1-$d1,$d1,    $d,$d,270,360,$color);//右上
						imagearc($im,$w1-$d1,$h1-$d1,$d,$d,  0, 90,$color);//右下
						imagearc($im,$d1,    $h1-$d1,$d,$d, 90,180,$color);//左下
					}
				break;

				case 'chamfer'://斜切矩形
					$d1=$m1+$r1-1;//设置距离
					for($i=0;$i<$s1;$i++){//边框要一层层加
						$d=$r1*2-$i*2;//直径
						//画线
						imageline($im,$d1,    $m1+$i,    $w1-$d1,$m1+$i,    $color);//上
						imageline($im,$w1-$m1-$i,$d1,    $w1-$m1-$i,$h1-$d1,$color);//右
						imageline($im,$d1,    $h1-$m1-$i,$w1-$d1,$h1-$m1-$i,$color);//下
						imageline($im,$m1+$i,    $d1,    $m1+$i,    $h1-$d1,$color);//左
					}
					$s2=ceil(sqrt(2)*$s1);
					for($i=0;$i<$s2;$i++){//边框要一层层加
						imageline($im,$w1-$d1-$i,$m1,$w1-$m1,$d1+$i,$color);//右上
						imageline($im,$w1-$m1,$h1-$d1-$i,$w1-$d1-$i,$h1-$m1,$color);//右下
						imageline($im,$d1+$i,    $h1-$m1,$m1,    $h1-$d1-$i,$color);//左下
						imageline($im,$m1,    $d1+$i,$d1+$i,    $m1,$color);//左上
					}
				break;
			}
		}

		//水印
		$watermark=kc_val($attrib,'watermark');
		if(isset($watermark{0})){
			//先判断文件是否存在
			if(is_file(ROOT.$watermark)){
				list($_width_water,$_height_water)=getimagesize(ROOT.$watermark);

				if(kc_validate($_width_water,2)&&kc_validate($_height_water,2)){

					$wx=kc_validate(kc_val($attrib,'watermark-x'),2)?$attrib['watermark-x']:10;
					$wy=kc_validate(kc_val($attrib,'watermark-y'),2)?$attrib['watermark-y']:10;
					$pct=kc_validate(kc_val($attrib,'watermark-opacity'),2)?$attrib['watermark-opacity']:100;
					$water_color=kc_val($attrib,'watermark-color') ? $attrib['watermark-color']:'FFFFFF';//透明色

					$ext_water=kc_f_ext($watermark);

					if(in_array(strtolower($ext_water),array('jpg','jpeg','gif','png'))){
						$fext_water=$ext_water=='jpg'?'jpeg':strtolower($ext_water);
					}

					$func_water='imagecreatefrom'.$fext_water;
					$water=$func_water(ROOT.$watermark);//装载水印图片

					$color=kc_hex2rgb($water,$water_color);//转换颜色
					imagecolortransparent($water,$color);
					imagecopymerge($im,$water,$wx,$wy,0,0,$_width_water,$_height_water,$pct); // 左上

				}
			}
		}

		//插入字体
		$text=kc_val($attrib,'text');
		if(isset($text{0})){
			$tx=kc_validate(kc_val($attrib,'text-x'),2)?$attrib['text-x']:10;
			$ty=kc_validate(kc_val($attrib,'text-y'),2)?$attrib['text-y']:20;
			$s1=kc_validate(kc_val($attrib,'text-size'),2)?$attrib['text-size']:12;
			$a1=kc_validate(kc_val($attrib,'text-angle'),2)?$attrib['text-angle']:0;
			$f1=is_file(ROOT.kc_val($attrib,'text-font'))?$attrib['text-font']:'system/verify_font/MilkCocoa.TTF';
			$c1=kc_validate(kc_val($attrib,'text-color'),13)?$attrib['text-color']:'000000';//颜色

			$color=kc_hex2rgb($im,$c1);//转换颜色

			imagettftext($im,$s1,$a1, $tx,$ty,$color,ROOT.$f1,$text);

		}

		//开启抗锯齿
		imageantialias($im,True);

		file::md($newdir);//创建目录

		$func='image'.$fext;
		if($func($im,ROOT.$newimg)){//保存缩略图
			$s=$newimg;
		}

		return PATH.$s;
	}

	/**
	20         //扭曲，变形
	21         $distortion_im = imagecreatetruecolor ($im_x*1.5 , $im_y);
	22         imagefill($distortion_im, 0, 0, imagecolorallocate($distortion_im,255,255,255) );
	23         for ( $i=0; $i<$im_x; $i++) {
	24             for ( $j=0; $j<$im_y; $j++) {
	25                 $rgb = imagecolorat($im, $i , $j);
	26                 if( (int)($i+20+sin($j/$im_y*2*M_PI)*10) <= imagesx($distortion_im) && (int)($i+20+sin($j/$im_y*2*M_PI)*10) >=0 ) {
	27                     imagesetpixel ($distortion_im, (int)($i+20+sin($j/$im_y*2*M_PI-M_PI*0.4)*8) , $j , $rgb);
	28                 }
	29             }
	30         }

	 */

}
?>