<?php
/*!
 * upload demo for php
 * @requires xhEditor
 * 
 * @author Yanis.Wang<yanis.wang@gmail.com>
 * @site http://pirate9.com/
 * @licence LGPL(http://www.opensource.org/licenses/lgpl-license.php)
 * 
 * 注：本程序仅为演示用，请您根据自己需求进行相应修改，或者重开发。
 */

require 'global.php';

function _index()
{
	extract(user::init());
	if($userid==0){
		exit(json_encode(array('err'=>'请先登录或注册成为会员后才可以上传文件','msg'=>'')));
	}
	$maxattachsize=2097152;//最大上传大小，默认是2M
	$upext='jpg,jpeg,gif,png';//上传扩展名
	
	$err = "";
	$msg = "";
	$upfile=$_FILES['upload'];
	if(!empty($upfile['error']))
	{
		switch($upfile['error'])
		{
			case '1':
				$err = '文件大小超过了php.ini定义的upload_max_filesize值';
				break;
			case '2':
				$err = '文件大小超过了HTML定义的MAX_FILE_SIZE值';
				break;
			case '3':
				$err = '文件上传不完全';
				break;
			case '4':
				$err = '无文件上传';
				break;
			case '6':
				$err = '缺少临时文件夹';
				break;
			case '7':
				$err = '写文件失败';
				break;
			case '8':
				$err = '上传被其它扩展中断';
				break;
			case '999':
			default:
				$err = '无有效错误代码';
		}
	}
	elseif(empty($upfile['tmp_name']) || $upfile['tmp_name'] == 'none')$err = '无文件上传';
	else
	{
			$temppath=$upfile['tmp_name'];
			$fileinfo=pathinfo($upfile['name']);
			$extension=$fileinfo['extension'];
			if(preg_match('/'.str_replace(',','|',$upext).'/i',$extension))
			{
				$filesize=filesize($temppath);
				if($filesize <= $maxattachsize)
				{
					$attach_subdir = gmdate('Y/m/d/h',time());
					$attach_dir = 'upfiles/'.$attach_subdir;
					file::md($attach_dir);
					file::put($attach_dir.'/index.htm','');

					PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
					$filename=date("YmdHis").mt_rand(1000,9999).'.'.$extension;
					$target = $attach_dir.'/'.$filename;
					
					move_uploaded_file($upfile['tmp_name'],ROOT.$target);
					image::_thumb($target);
					$db=new db;
					$array=array(
						'userid'=>$userid,
						'username'=>$username,
						'ip'=>str::ip(),
						'date'=>time(),
						'image'=>$target,
					);
					$db->insert('%s_image',$array);
					//这里还要加入生成缩略图并覆盖、加水印的功能和绑定到会员帐号的功能
					$msg=$target;
				}
				else $err='文件大小超过'.$maxattachsize.'字节';
			}
			else $err='上传文件扩展名必需为：'.$upext;

			@unlink($temppath);
	}
	echo json_encode(array('err'=>$err,'msg'=>$msg));
}


?>