<?php 
/**
 * 验证码显示
 */
require 'global.php';

/**
 * 调用验证码
 */
function _index(){
	$id=kc_post('id',0,1);
	$oldSalt=kc_post('salt',1);//原来的随机数,以便删除垃圾文件
	if (!empty($oldSalt)) {
		verify_delete($oldSalt);
	}
	$salt=str::random(12);
	$s="<img src=\"verify.php?CMD=image&salt=$salt\"/>";
	$s.="<label onclick=\"\$.kc_ajax({URL:\'verify.php\',id:\'$id\',salt:\'$salt\'})\">".kc_lang('tip.verify')."</label>";
	$js="\$('#{$id}_salt').val('$salt');";//设置验证码给隐藏域
	$js.="\$('#{$id}_image').html('$s');";
	kc_ajax(array('JS'=>$js));
}

/**
 * 显示验证码
 */
function _image(){

	//header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
	//header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // 过去的时间
	header("Content-type: image/png");
	$salt=kc_get('salt',1,1);

	$width=70;//图片宽度
	$height=24;//高度
	$size=16;//文字大小
	$num=4;//文字数量
	$content='A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z';//随机数
	//随机数转换为数组
	$contents=explode('|',$content);$contents=array_diff($contents,array(null));
	$fonts=file::getDir('font/','ttf|ttc');

	$s='';//存储到服务器里的值，也就是验证码值
	$img=imageCreate($width,$height);//创建一个空白图像

	imageFilledRectangle($img, 0, 0, $width, $height, imagecolorallocate($img,255,255,255));
	//写字
	for($i=0;$i<$num;$i++){
		$code=$contents[array_rand($contents)];
		$s.=$code;//验证码字符
		$color=imageColorAllocate($img,rand(0,128),rand(0,128),rand(0,128));
		$font=ROOT.array_rand($fonts);//随机读取一个字体
		$left=rand(round($size*0.2),round($size*0.4))+$i*$size;
		imagettftext($img,rand(round($size*0.9),$size), rand(-20,20), $left,rand(round($size*1.2),$size*1.4),$color,$font,$code);
	}
	//画星号
	$max=$width*$height/400;
	for($i=0;$i<$max;$i++){
		imagestring($img, 15, rand(0,$width), rand(0,$height), '*',rand(192,250));
	}
	//画点
	$max=$width*$height/40;
	for($i=0;$i<$max;$i++){
		imageSetPixel($img, rand(0, $width), rand(0, $height), rand(1,200));
	}
	//画线
	$max=$width*$height/800;
	for($i=0;$i<$max;$i++){
		imageline($img,rand(0,$width),rand(0,$height),rand(0,$width),rand(0,$height),rand(0,255));
	}


	//写验证码到verify中
	verify_put($salt,$s);

	imagePng($img);
	imageDestroy($img);

	verify_clear();

}
//写验证CODE文件
function verify_put($salt,$s){
	file::put(PATH_CACHE.'/verify/'.$salt.'.php','<?php exit ?>'.$s);
}
//删除验证文件
function verify_delete($salt){
	file::delete(PATH_CACHE.'/verify/'.$salt.'.php');
}
//清理验证文件
function verify_clear(){
	$files=file::getDir(PATH_CACHE.'/verify/','php');
	$time=time();
	foreach ($files as $filepath=>$name) {
		$mtime=filemtime(ROOT.$filepath);
		if ($time-$mtime>60) {
			file::delete($filepath);
		}
	}
}



?>