<?php
/*
+-----------------------------------------------------------------------------+
| $Id: admin.php 2010-05-24 12:37:44Z Bleakwind $
| Manage admin
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

function question_select($id, $select, $value)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$sys, $member_info;
    $ajax_response = new xajaxResponse();
    if (preg_match("/^add|amend$/i", $sys->get['ope'])) {
        if ( $value == "custom"){
            $ajax_response->assign($select, "style.width", '80px');
            $ajax_response->assign($id, "style.display", 'inline');
        } else {
            $ajax_response->assign($select, "style.width", '255px');
            $ajax_response->assign($id, "style.display", 'none');
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "question_select");

// Member add and amend ajax
function submit_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_cover,$setting_attach;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    if ($type == "amend") {
        $submit_value   = "编辑";
    } else {
        $submit_value   = "添加";
    }

    if( $ADMIN['ag_privilege']['admin_amend'] != "1" ) {
        $error = true;
        $ajax_response->alert("您没有权限修改管理员!");
    }

    if( empty($value['username']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "username"; }
        $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_bubble\"><p>名称必须填写!<!-- username_empty --></p></span>");
    } elseif ( mb_strwidth($value['username'],"UTF-8") < 4 ||
               mb_strwidth($value['username'],"UTF-8") > 60 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "username"; }
        $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_bubble\"><p>名称不能小于4字节且不能大于60字节!<!-- username_empty --></p></span>");
    } elseif ( preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['username']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "username"; }
        $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_bubble\"><p>名称不能包含非法字符!<!-- username_character --></p></span>");
    } else {
        $ajax_response->assign("username_return", "innerHTML", "");
    }

    if( empty($value['email']) ) {
        // ...
    } elseif ( mb_strwidth($value['email'],"UTF-8") > 60 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "email"; }
        $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_bubble\"><p>信箱不能大于60字节!<!-- email_empty --></p></span>");
    } elseif ( !preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['email']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "email"; }
        $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_bubble\"><p>信箱格式错误<!-- email_format --></p></span>");
    } else {
        $ajax_response->assign("email_return", "innerHTML", "");
    }

    if( empty($value['card']) ) {
        // ...
    } elseif ( !preg_match("/^[a-z0-9-]{1,60}$/i",$value['card']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "card"; }
        $ajax_response->assign("card_return", "innerHTML", "<span class=\"prompt_bubble\"><p>卡号格式错误<!-- card_format --></p></span>");
    } else {
        $ajax_response->assign("card_return", "innerHTML", "");
    }

    if( empty($value['password']) ) {
        // ...
    } elseif ( mb_strwidth($value['password'],"UTF-8") < 6 ||
               mb_strwidth($value['password'],"UTF-8") > 60 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "password"; }
        $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码不能小于6字节且不能大于60字节!<!-- password_empty --></p></span>");
    } elseif ( preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['password']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "password"; }
        $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码不能包含非法字符!<!-- password_character --></p></span>");
    } else {
        $ajax_response->assign("password_return", "innerHTML", "");
    }

    if( empty($value['question']) && empty($value['answer']) ) {
        // ...
    } elseif( empty($value['question']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "question"; }
        $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示答案设定时密码提示问题也必须设定!</p></span>");
    } elseif( empty($value['answer']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "answer"; }
        $ajax_response->assign("answer_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示问题设定时密码提示答案也必须设定</p></span>");
    } elseif ( $value['question'] == "custom" ) {
        if( empty($value['question_custom']) ) {
            $error = true;
            if(empty($anchor)) { $anchor = "question"; }
            $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示问题自定义时必须填写内容!<!-- question_custom_empty --></p></span>");
        } elseif ( mb_strwidth($value['question_custom'],"UTF-8") < 6 ||
                   mb_strwidth($value['question_custom'],"UTF-8") > 30 ) {
            $error = true;
            if(empty($anchor)) { $anchor = "question"; }
            $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示问题自定义时不能小于6字节且不能大于30字节!<!-- question_custom_long --></p></span>");
        } elseif ( mb_strwidth($value['answer'],"UTF-8") < 6 ||
                   mb_strwidth($value['answer'],"UTF-8") > 30 ) {
            $error = true;
            if(empty($anchor)) { $anchor = "question"; }
            $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示答案不能小于6字节且不能大于30字节!<!-- answer_long --></p></span>");
        } else {
            $question_type  = "2";
            $question       = $value['question_custom'];
            $answer         = $value['answer'];
            $ajax_response->assign("question_return", "innerHTML", "");
        }
    } elseif( !preg_match("/^[1-9][0-9]{0,10}$/",$value['question']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "question"; }
        $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示问题发生错误!<!-- question_custom_long --></p></span>");
    } elseif ( mb_strwidth($value['answer'],"UTF-8") < 6 ||
               mb_strwidth($value['answer'],"UTF-8") > 30 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "question"; }
        $ajax_response->assign("question_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码提示答案不能小于6字节且不能大于30字节!<!-- answer_long --></p></span>");
    } else {
        $question_type  = "1";
        $question       = $value['question'];
        $answer         = $value['answer'];
        $ajax_response->assign("question_return", "innerHTML", "");
    }

    if( empty($value['mg_type']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "mg_type"; }
        $ajax_response->assign("mg_type_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须选择群组<!-- mg_type error --></p></span>");
    } elseif( !preg_match("/^[0-9a-z_]{1,30}$/i",$value['mg_type']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "mg_type"; }
        $ajax_response->assign("mg_type_return", "innerHTML", "<span class=\"prompt_bubble\"><p>群组格式错误<!-- mg_type error --></p></span>");
    } else {
        $ajax_response->assign("mg_type_return", "innerHTML", "");
    }

    if( !preg_match("/^[0-9-]{10}|0$/",$value['mg_type_expired']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "mg_type_expired"; }
        $ajax_response->assign("mg_type_expired_return", "innerHTML", "<span class=\"prompt_bubble\"><p>时间限制格式错误,不限制请填写0<!-- mg_type_expired error --></p></span>");
    } else {
        $ajax_response->assign("mg_type_expired_return", "innerHTML", "");
    }

    if( !preg_match("/^[0-9]{1,20}\.[0-9]{2}$/",$value['silver']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "point"; }
        $ajax_response->assign("point_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须设定管理员资金,只能为两位小数<!-- point error --></p></span>");
    } else {
        $ajax_response->assign("point_return", "innerHTML", "");
    }

    if( !preg_match("/^[0-9]{1,20}\.[0-9]{2}$/",$value['offer']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "offer"; }
        $ajax_response->assign("offer_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须设定管理员捐助,只能为两位小数<!-- offer error --></p></span>");
    } else {
        $ajax_response->assign("offer_return", "innerHTML", "");
    }

    if( !preg_match("/^[0-9]{1,11}$/",$value['point']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "point"; }
        $ajax_response->assign("point_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须设定积分,只能为数字<!-- point error --></p></span>");
    } else {
        $ajax_response->assign("point_return", "innerHTML", "");
    }

    if( !preg_match("/^[0-9]{1,11}$/",$value['bonus']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "bonus"; }
        $ajax_response->assign("bonus_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须设定管理员红利,只能为数字<!-- bonus error --></p></span>");
    } else {
        $ajax_response->assign("bonus_return", "innerHTML", "");
    }

    if( !preg_match("/^[123]+$/",$value['if_active']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "if_active"; }
        $ajax_response->assign("if_active_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须选择是否激活<!-- if_active error --></p></span>");
    } else {
        $ajax_response->assign("if_active_return", "innerHTML", "");
    }

    if( !preg_match("/^[123]+$/",$value['if_enable']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "if_enable"; }
        $ajax_response->assign("if_enable_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须选择管理员状态<!-- if_enable error --></p></span>");
    } else {
        $ajax_response->assign("if_enable_return", "innerHTML", "");
    }

    if( !preg_match("/^[123]+$/",$value['if_email']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "if_email"; }
        $ajax_response->assign("if_email_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须选择是否订阅邮件<!-- if_email error --></p></span>");
    } else {
        $ajax_response->assign("if_email_return", "innerHTML", "");
    }

    if($error){
        $ajax_response->assign($submit,"value",$submit_value);
        $ajax_response->assign($submit,"disabled",false);
        $ajax_response->redirect("#".$anchor);
    }else{

        if ($type == "amend") {

            if (!preg_match("/^[1-9][0-9]{0,10}$/",$sys->get['mid'])){
                $ajax_response->alert("用户ID错误!");
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            } else {

                $result_member = func::db_select(DB_TABLE_MEMBER, "*", "id=".$sys->get['mid']);
                $result_member = $result_member[0];
                if (!preg_match("/^[1-9][0-9]{0,10}$/",$result_member['id'])) {
                    $error = true;
                    $ajax_response->alert("此管理员不存在!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {

                    $total_record['username']   = func::db_count_record(DB_TABLE_MEMBER, "username='".addslashes($value['username'])."' AND id!=".(int)$sys->get['mid']);
                    if ($total_record['username'] > 0) {
                        $error = true;
                        if(empty($anchor)) { $anchor = "username"; }
                        $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_bubble\"><p>此名称已经存在,请重新填写!<!-- username error --></p></span>");
                    } else {
                        $sql_username  = "username='".addslashes($value['username'])."',";
                    }

                    if (!empty($total_record['email'])) {
                        $total_record['email']  = func::db_count_record(DB_TABLE_MEMBER, "email='".addslashes($value['email'])."' AND id!=".(int)$sys->get['mid']);
                        if ($total_record['email'] > 0) {
                            $error = true;
                            if(empty($anchor)) { $anchor = "email"; }
                            $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_bubble\"><p>此信箱已经存在,请重新填写!<!-- email error --></p></span>");
                        } else {
                            $sql_email  = "email='".addslashes($value['email'])."',";
                        }
                    } else {
                        $sql_email   = "";
                    }

                    if (!empty($total_record['card'])) {
                        $total_record['card']  = func::db_count_record(DB_TABLE_MEMBER, "card='".addslashes($value['card'])."' AND id!=".(int)$sys->get['mid']);
                        if ($total_record['card'] > 0) {
                            $error = true;
                            if(empty($anchor)) { $anchor = "card"; }
                            $ajax_response->assign("card_return", "innerHTML", "<span class=\"prompt_bubble\"><p>此卡号已经存在,请重新填写!<!-- card error --></p></span>");
                        } else {
                            $sql_card  = "card='".addslashes($value['card'])."',";
                        }
                    } else {
                        $sql_card   = "";
                    }

                    if ( !empty($value['password']) ){
                        $sql_password = "password='".func::str_encrypt($value['password'])."',";
                    } else {
                        $sql_password = "";
                    }

                    if ( $value['if_active'] == "1" && $result_member['if_active'] != "1"){
                        $sql_active = "if_active    = '".addslashes($value['if_active'])."',
                                        active_id   = '".(int)$ADMIN['mid']."',
                                        ip_active   = '".func::return_ip()."',
                                        time_active = '".$sys->nowtime."',";
                        $sql_enable = "if_enable    = '".addslashes($value['if_enable'])."',";
                    } elseif ( $value['if_active'] == "1"){
                        $sql_active = "if_active    = '".addslashes($value['if_active'])."',";
                        $sql_enable = "if_enable    = '".addslashes($value['if_enable'])."',";
                    } elseif ( $value['if_active'] != "1"){
                        if ($value['if_enable'] == "1") {
                            $error = true;
                            if(empty($anchor)) { $anchor = "if_enable"; }
                            $ajax_response->assign("if_enable_return", "innerHTML", "<span class=\"prompt_bubble\"><p>修改管理员状态必须先激活用户!<!-- if_enable error --></p></span>");
                        } else {
                            $sql_active = "if_active    = '".addslashes($value['if_active'])."',";
                            $sql_enable = "if_enable    = '".addslashes($value['if_enable'])."',";
                        }
                    }

                    if ($value['mg_type_expired'] != 0) {
                        $value['mg_type_expired'] = strtotime($value['mg_type_expired']);
                    }

                    if ($value['silver'] != $result_member['silver']) {
                        $value['cumulant_silver'] = $value['silver'] - $result_member['silver'] + $result_member['cumulant_silver'];
                        $sql_cumulant_silver = "cumulant_silver = '".addslashes((int)$value['cumulant_silver'])."',";
                    }

                    if($error){
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                        $ajax_response->redirect("#".$anchor);
                    }else{

                        $sql = "UPDATE ".DB_TABLE_MEMBER." SET
                                    ".$sql_username."
                                    ".$sql_email."
                                    ".$sql_card."
                                    ".$sql_password."
                                    question_type   = ".(int)$question_type.",
                                    question        = '".addslashes($question)."',
                                    answer          = '".addslashes($answer)."',
                                    mg_type         = '".addslashes($value['mg_type'])."',
                                    mg_type_expired = '".addslashes((int)$value['mg_type_expired'])."',
                                    silver          = '".addslashes($value['silver'])."',
                                    offer           = '".addslashes($value['offer'])."',
                                    point           = '".addslashes((int)$value['point'])."',
                                    bonus           = '".addslashes((int)$value['bonus'])."',
                                    ".$sql_active."
                                    ".$sql_enable."
                                    ".$sql_cumulant_silver."
                                    if_email        = '".addslashes($value['if_email'])."'
                                WHERE id=".$sys->get['mid']."";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg());
                            $ajax_response->assign($submit,"value",$submit_value);
                            $ajax_response->assign($submit,"disabled",false);
                        }else{
                            $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=admin&pag=".$sys->get['pag']);
                        }
                    }
                }
            }

        } else {

            $total_record['username']   = func::db_count_record(DB_TABLE_MEMBER, "username='".addslashes($value['username'])."'");
            if ($total_record['username'] > 0) {
                $error = true;
                if(empty($anchor)) { $anchor = "username"; }
                $ajax_response->assign("username_return", "innerHTML", "<span class=\"prompt_bubble\"><p>此名称已经存在,请重新填写!<!-- username error --></p></span>");
            } else {
                $sql_username  = "username='".addslashes($value['username'])."',";
            }

            if (!empty($total_record['email'])) {
                $total_record['email']  = func::db_count_record(DB_TABLE_MEMBER, "email='".addslashes($value['email'])."'");
                if ($total_record['email'] > 0) {
                    $error = true;
                    if(empty($anchor)) { $anchor = "email"; }
                    $ajax_response->assign("email_return", "innerHTML", "<span class=\"prompt_bubble\"><p>此信箱已经存在,请重新填写!<!-- email error --></p></span>");
                } else {
                    $sql_email  = "email='".addslashes($value['email'])."',";
                }
            } else {
                $sql_email   = "";
            }

            if (!empty($total_record['card'])) {
                $total_record['card']  = func::db_count_record(DB_TABLE_MEMBER, "card='".addslashes($value['card'])."'");
                if ($total_record['card'] > 0) {
                    $error = true;
                    if(empty($anchor)) { $anchor = "card"; }
                    $ajax_response->assign("card_return", "innerHTML", "<span class=\"prompt_bubble\"><p>此卡号已经存在,请重新填写!<!-- card error --></p></span>");
                } else {
                    $sql_card  = "card='".addslashes($value['card'])."',";
                }
            } else {
                $sql_card   = "";
            }

            if ( empty($value['password']) ){
                $error = true;
                if(empty($anchor)) { $anchor = "password"; }
                $ajax_response->assign("password_return", "innerHTML", "<span class=\"prompt_bubble\"><p>密码不能为空,请重新填写!<!-- password error --></p></span>");
            } else {
                $sql_password = "password='".func::str_encrypt($value['password'])."',";
            }

            if ( $value['if_active'] == "1"){
                $sql_active = "if_active    = '".addslashes($value['if_active'])."',
                                active_id   = '".(int)$ADMIN['mid']."',
                                ip_active   = '".func::return_ip()."',
                                time_active = '".$sys->nowtime."',";
                $sql_enable = "if_enable    = '".addslashes($value['if_enable'])."',";
            } elseif ( $value['if_active'] != "1"){
                if ($value['if_enable'] == "1") {
                    $error = true;
                    if(empty($anchor)) { $anchor = "if_enable"; }
                    $ajax_response->assign("if_enable_return", "innerHTML", "<span class=\"prompt_bubble\"><p>修改管理员状态必须先激活用户!<!-- if_enable error --></p></span>");
                } else {
                    $sql_active = "if_active    = '".addslashes($value['if_active'])."',";
                    $sql_enable = "if_enable    = '".addslashes($value['if_enable'])."',";
                }
            }

            if ($value['mg_type_expired'] != 0) {
                $value['mg_type_expired'] = strtotime($value['mg_type_expired']);
            }

            if ($value['silver'] != "0") {
                $value['cumulant_silver'] = $value['silver'];
                $sql_cumulant_silver = "cumulant_silver = '".addslashes((int)$value['cumulant_silver'])."',";
            }

            if($error){
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
                $ajax_response->redirect("#".$anchor);
            }else{

                $sql = "INSERT INTO ".DB_TABLE_MEMBER." SET
                            ".$sql_username."
                            ".$sql_email."
                            ".$sql_card."
                            ".$sql_password."
                            question_type   = ".(int)$question_type.",
                            question        = '".addslashes($question)."',
                            answer          = '".addslashes($answer)."',
                            mg_type         = '".addslashes($value['mg_type'])."',
                            mg_type_expired = '".addslashes((int)$value['mg_type_expired'])."',
                            silver          = '".addslashes($value['silver'])."',
                            offer           = '".addslashes($value['offer'])."',
                            point           = '".addslashes((int)$value['point'])."',
                            bonus           = '".addslashes((int)$value['bonus'])."',
                            ".$sql_active."
                            ".$sql_enable."
                            ".$sql_cumulant_silver."
                            if_email        = '".addslashes($value['if_email'])."',
                            ip_created      = '".func::return_ip()."',
                            time_created    = '".$sys->nowtime."',
                            cumulant_online = '0'";
                $result = $db->Execute($sql);
                if (!$result) {
                    $ajax_response->alert($db->ErrorMsg());
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                }else{
                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=admin&pag=".$sys->get['pag']);
                }
            }
        }
    }


    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "submit_form");
//////

if($sys->get['ope'] == "add"){

    if ($ADMIN['ag_privilege']['admin_amend'] != "1"){
        $sys->prompt("failed","您没有权限添加管理员!<!-- admin_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mid'])){

        $sql = "SELECT mg_id, mg_type, mg_point_begin, mg_point_end, mg_name
                FROM ".DB_TABLE_MEMBER_GROUP."
                WHERE mg_type!='".$CONFIG['default_group_guest']."'
                GROUP BY mg_type
                ORDER BY mg_rank,mg_id";
        $result_member_group = &$db->Execute($sql);
        if (!$result_member_group) {
            echo $db->ErrorMsg();
        } else {
            while(!$result_member_group->EOF) {
                $member_group_list[] = array(
                    "mg_id"             => $result_member_group->fields['mg_id'],
                    "mg_type"           => $result_member_group->fields['mg_type'],
                    "mg_point_begin"    => $result_member_group->fields['mg_point_begin'],
                    "mg_point_end"      => $result_member_group->fields['mg_point_end'],
                    "mg_ag_id"          => $result_member_group->fields['mg_ag_id'],
                    "mg_name"           => $result_member_group->fields['mg_name'],
                    "mg_icon"           => $result_member_group->fields['mg_icon'],
                );
                $result_member_group->MoveNext();
            }
        }

        $array_select  = array("question");
        $select_option = $sys->return_select($array_select);

        $t->assign(array(
            "member_group_list"     => $member_group_list,
            "select_option"         => $select_option,
        ));
    }

}elseif($sys->get['ope'] == "amend"){

    if ($ADMIN['ag_privilege']['admin_view'] != "1"){
        $sys->prompt("failed","您没有权限查看管理员资料!<!-- admin_view error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mid'])){
        $sys->prompt("failed","非法操作!<!-- mid error -->");
    }else{

        $sql = "SELECT m.*, mg.*, ag.*
                FROM ".DB_TABLE_MEMBER." m
                LEFT JOIN ".DB_TABLE_MEMBER_GROUP." mg ON mg.mg_type=m.mg_type
                    AND (mg.mg_point_begin<=m.point || mg.mg_point_begin IS NULL)
                    AND (mg.mg_point_end>=m.point || mg.mg_point_end IS NULL)
                LEFT JOIN ".DB_TABLE_ADMIN_GROUP." ag ON ag.ag_id=mg.mg_ag_id
                WHERE m.id=".$sys->get['mid']."
                GROUP BY m.id";
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        } else {
            if (!$result->EOF) {
                $member_info = array(
                    "id"                        => $result->fields['id'],
                    "username"                  => $result->fields['username'],
                    "email"                     => $result->fields['email'],
                    "card"                      => $result->fields['card'],
                    "password"                  => $result->fields['password'],
                    "question_type"             => $result->fields['question_type'],
                    "question"                  => $result->fields['question'],
                    "answer"                    => $result->fields['answer'],
                    "mg_type"                   => $result->fields['mg_type'],
                    "mg_type_expired"           => $result->fields['mg_type_expired'],
                    "silver"                    => $result->fields['silver'],
                    "offer"                     => $result->fields['offer'],
                    "point"                     => $result->fields['point'],
                    "bonus"                     => $result->fields['bonus'],
                    "pile1"                     => $result->fields['pile1'],
                    "pile2"                     => $result->fields['pile2'],
                    "pile3"                     => $result->fields['pile3'],
                    "pile4"                     => $result->fields['pile4'],
                    "pile5"                     => $result->fields['pile5'],
                    "pile6"                     => $result->fields['pile6'],
                    "active_id"                 => $result->fields['active_id'],
                    "if_active"                 => $result->fields['if_active'],
                    "if_enable"                 => $result->fields['if_enable'],
                    "if_email"                  => $result->fields['if_email'],
                    "ip_active"                 => $result->fields['ip_active'],
                    "ip_created"                => $result->fields['ip_created'],
                    "ip_change"                 => $result->fields['ip_change'],
                    "ip_lastvisit"              => $result->fields['ip_lastvisit'],
                    "time_active"               => $result->fields['time_active'],
                    "time_created"              => $result->fields['time_created'],
                    "time_change"               => $result->fields['time_change'],
                    "time_lastvisit"            => $result->fields['time_lastvisit'],
                    "cumulant_silver"           => $result->fields['cumulant_silver'],
                    "cumulant_online"           => $result->fields['cumulant_online'],

                    'mg_id'                     => $result->fields['mg_id'],
                    'mg_type'                   => $result->fields['mg_type'],
                    'mg_point_begin'            => $result->fields['mg_point_begin'],
                    'mg_point_end'              => $result->fields['mg_point_end'],
                    'mg_ag_id'                  => $result->fields['mg_ag_id'],
                    'mg_name'                   => $result->fields['mg_name'],
                    'mg_brief'                  => $result->fields['mg_brief'],
                    'mg_icon'                   => $result->fields['mg_icon'],
                    'mg_privilege'              => unserialize($result->fields['mg_privilege']),
                    'mg_fileallow'              => unserialize($result->fields['mg_fileallow']),
                    'mg_rank'                   => $result->fields['mg_rank'],
                    'mg_if_enable'              => $result->fields['mg_if_enable'],

                    'ag_id'                     => $result->fields['ag_id'],
                    'ag_name'                   => $result->fields['ag_name'],
                    'ag_brief'                  => $result->fields['ag_brief'],
                    'ag_privilege'              => unserialize($result->fields['ag_privilege']),
                    'ag_fileallow'              => unserialize($result->fields['ag_fileallow']),
                    'ag_rank'                   => $result->fields['ag_rank'],
                    'ag_if_enable'              => $result->fields['ag_if_enable'],
                );
            }
        }
        if (empty($member_info['id'])) {
            $sys->prompt("failed","此管理员不存在<!-- mid not exists -->");
        } elseif ($member_info['mg_ag_id'] = 0) {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member&ope=amend&mid=".$member_info['id']);
        } else {

            $sql = "SELECT mg_id, mg_type, mg_point_begin, mg_point_end, mg_name
                    FROM ".DB_TABLE_MEMBER_GROUP."
                    WHERE mg_type!='".$CONFIG['default_group_guest']."'
                    GROUP BY mg_type
                    ORDER BY mg_rank,mg_id";
            $result_member_group = &$db->Execute($sql);
            if (!$result_member_group) {
                echo $db->ErrorMsg();
            } else {
                while(!$result_member_group->EOF) {
                    $member_group_list[] = array(
                        "mg_id"             => $result_member_group->fields['mg_id'],
                        "mg_type"           => $result_member_group->fields['mg_type'],
                        "mg_point_begin"    => $result_member_group->fields['mg_point_begin'],
                        "mg_point_end"      => $result_member_group->fields['mg_point_end'],
                        "mg_ag_id"          => $result_member_group->fields['mg_ag_id'],
                        "mg_name"           => $result_member_group->fields['mg_name'],
                        "mg_icon"           => $result_member_group->fields['mg_icon'],
                    );
                    $result_member_group->MoveNext();
                }
            }

            $array_select  = array("question");
            $select_option = $sys->return_select($array_select);

            if (preg_match("/^[1-9][0-9]{0,10}$/i", $member_info['active_id'])) {
                $active_member_info = $sys->return_member($member_info['active_id'], array("id","username"));
            } else {
                $active_member_info = array();
            }

            $t->assign(array(
                "member_info"           => $member_info,
                "member_group_list"     => $member_group_list,
                "select_option"         => $select_option,
                "active_member_info"    => $active_member_info,
            ));
        }
    }

}elseif($sys->get['ope'] == "if_active"){

    if ($ADMIN['ag_privilege']['admin_amend'] != "1"){
        $sys->prompt("failed","您没有权限修改管理员!<!-- admin_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mid'])) {
        $sys->prompt("failed","非法操作!<!-- mid error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_active'])) {
        $sys->prompt("failed","非法操作!<!-- if_active error -->");
    } else {

        $member_info    = $sys->return_member_info($sys->get['mid'], array("id,username", "mg_id,mg_name,mg_type,mg_icon,mg_ag_id"));
        if (empty($member_info['m_id'])) {
            $sys->prompt("failed","此管理员不存在<!-- mid not exists -->");
        } elseif ($member_info['mg_ag_id'] = 0) {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member&if_active&mid=".$member_info['id']."&if_active=".$sys->get['if_active']);
        } else {
            $sql_data = array(
                "if_active" => $sys->get['if_active'],
            );
            $result = func::db_update(DB_TABLE_MEMBER, $sql_data, "id='".$sys->get['mid']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            }

            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=admin&pag=".$sys->get['pag']);
        }
   }

}elseif($sys->get['ope'] == "if_enable"){

    if ($ADMIN['ag_privilege']['admin_amend'] != "1"){
        $sys->prompt("failed","您没有权限修改管理员!<!-- admin_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mid'])) {
        $sys->prompt("failed","非法操作!<!-- mid error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_enable'])) {
        $sys->prompt("failed","非法操作!<!-- if_enable error -->");
    } else {

        $member_info    = $sys->return_member_info($sys->get['mid'], array("id,username", "mg_id,mg_name,mg_type,mg_icon,mg_ag_id"));
        if (empty($member_info['m_id'])) {
            $sys->prompt("failed","此管理员不存在<!-- mid not exists -->");
        } elseif ($member_info['mg_ag_id'] = 0) {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member&if_enable&mid=".$member_info['id']."&if_enable=".$sys->get['if_enable']);
        } else {
            $sql_data = array(
                "if_enable" => $sys->get['if_enable'],
            );
            $result = func::db_update(DB_TABLE_MEMBER, $sql_data, "id='".$sys->get['mid']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            }

            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=admin&pag=".$sys->get['pag']);
        }
   }

}elseif($sys->get['ope'] == "if_email"){

    if ($ADMIN['ag_privilege']['admin_amend'] != "1"){
        $sys->prompt("failed","您没有权限修改管理员!<!-- admin_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mid'])) {
        $sys->prompt("failed","非法操作!<!-- mid error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_email'])) {
        $sys->prompt("failed","非法操作!<!-- if_email error -->");
    } else {

        $member_info    = $sys->return_member_info($sys->get['mid'], array("id,username", "mg_id,mg_name,mg_type,mg_icon,mg_ag_id"));
        if (empty($member_info['m_id'])) {
            $sys->prompt("failed","此管理员不存在<!-- mid not exists -->");
        } elseif ($member_info['mg_ag_id'] = 0) {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member&if_email&mid=".$member_info['id']."&if_email=".$sys->get['if_email']);
        } else {

            $sql_data = array(
                "if_email" => $sys->get['if_email'],
            );
            $result = func::db_update(DB_TABLE_MEMBER, $sql_data, "id='".$sys->get['mid']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            }

            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=admin&pag=".$sys->get['pag']);
        }
   }

}elseif($sys->get['ope'] == "del"){

    // check the post
    if ($ADMIN['ag_privilege']['admin_amend'] != "1"){
        $sys->prompt("failed","您没有权限修改管理员!<!-- admin_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mid'])){
        $sys->prompt("failed","非法操作!<!-- mid error -->");
    }else{

        $member_info    = $sys->return_member_info($sys->get['mid'], array("id,username", "mg_id,mg_name,mg_type,mg_icon,mg_ag_id"));
        if (empty($member_info['m_id'])) {
            $sys->prompt("failed","此管理员不存在<!-- mid not exists -->");
        } elseif ($member_info['mg_ag_id'] = 0) {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member&del&mid=".$member_info['id']);
        } else {

            $sql = "DELETE FROM ".DB_TABLE_MEMBER."
                    WHERE id=".$sys->get['mid'];
            $result = $db->Execute($sql);
            if (!$result) {
                echo $db->ErrorMsg();
            } else {
                $sql = "DELETE FROM ".DB_TABLE_MEMBER_FAVORITE."
                        WHERE mid=".$sys->get['mid'];
                $result = $db->Execute($sql);
            }

            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=admin&pag=".$sys->get['pag']);
        }
    }

}else{

    $where          = "mg.mg_ag_id>0";
    $where_total    = "";
    $page_url       = "";

    if (!empty($sys->get['mid'])) {
        $where          .= "AND m.id='".addslashes($sys->get['mid'])."'";
        $where_total    .= "AND id='".addslashes($sys->get['mid'])."'";
        $page_url       .= "&id=".$sys->get['mid']."";
    }
    if (!empty($sys->get['username'])) {
        $where          .= "AND m.username='".addslashes($sys->get['username'])."'";
        $where_total    .= "AND username='".addslashes($sys->get['username'])."'";
        $page_url       .= "&username=".$sys->get['username']."";
    }
    if (!empty($sys->get['email'])) {
        $where          .= "AND m.email='".addslashes($sys->get['email'])."'";
        $where_total    .= "AND email='".addslashes($sys->get['email'])."'";
        $page_url       .= "&email=".$sys->get['email']."";
    }
    if (!empty($sys->get['card'])) {
        $where          .= "AND m.card='".addslashes($sys->get['card'])."'";
        $where_total    .= "AND card='".addslashes($sys->get['card'])."'";
        $page_url       .= "&card=".$sys->get['card']."";
    }
    $where       = substr(trim($where), 0, 3) == "AND" ? substr(trim($where), 3) : trim($where);
    $where_total = substr(trim($where_total), 0, 3) == "AND" ? substr(trim($where_total), 3) : trim($where_total);
    $where       = $where != "" ? "WHERE ".$where : "";

    $total_record = func::db_count_record(DB_TABLE_MEMBER, $where_total);
    $bwpage->set_record_listnum($CONFIG['page_record_member_list']);
    $bwpage->set_record($total_record);
    $bwpage->page($CONFIGURE['common']['control_admin']."?act=admin".$page_url."&pag=%s");
    $sql = "SELECT m.*,mg.mg_id,mg.mg_name
            FROM ".DB_TABLE_MEMBER." m
            LEFT JOIN ".DB_TABLE_MEMBER_GROUP." mg ON mg.mg_type=m.mg_type
                AND (mg.mg_point_begin<=m.point || mg.mg_point_begin IS NULL)
                AND (mg.mg_point_end>=m.point || mg.mg_point_end IS NULL)
            ".$where."
            GROUP BY m.id
            ORDER BY m.id DESC
            LIMIT ".$bwpage->record_listfirst.",".$bwpage->record_listnum;
    $result = &$db->Execute($sql);
    if (!$result) {
        echo $db->ErrorMsg();
    } else {
        while(!$result->EOF) {
            $member_list[] = array(
                "id"                        => $result->fields['id'],
                "username"                  => $result->fields['username'],
                "email"                     => $result->fields['email'],
                "card"                      => $result->fields['card'],
                "password"                  => $result->fields['password'],
                "question_type"             => $result->fields['question_type'],
                "question"                  => $result->fields['question'],
                "answer"                    => $result->fields['answer'],
                "mg_type"                   => $result->fields['mg_type'],
                "mg_type_expired"           => $result->fields['mg_type_expired'],
                "silver"                    => $result->fields['silver'],
                "offer"                     => $result->fields['offer'],
                "point"                     => $result->fields['point'],
                "bonus"                     => $result->fields['bonus'],
                "pile1"                     => $result->fields['pile1'],
                "pile2"                     => $result->fields['pile2'],
                "pile3"                     => $result->fields['pile3'],
                "pile4"                     => $result->fields['pile4'],
                "pile5"                     => $result->fields['pile5'],
                "pile6"                     => $result->fields['pile6'],
                "active_id"                 => $result->fields['active_id'],
                "if_active"                 => $result->fields['if_active'],
                "if_enable"                 => $result->fields['if_enable'],
                "if_email"                  => $result->fields['if_email'],
                "ip_active"                 => $result->fields['ip_active'],
                "ip_created"                => $result->fields['ip_created'],
                "ip_change"                 => $result->fields['ip_change'],
                "ip_lastvisit"              => $result->fields['ip_lastvisit'],
                "time_active"               => $result->fields['time_active'],
                "time_created"              => $result->fields['time_created'],
                "time_change"               => $result->fields['time_change'],
                "time_lastvisit"            => $result->fields['time_lastvisit'],
                "cumulant_silver"           => $result->fields['cumulant_silver'],
                "cumulant_online"           => $result->fields['cumulant_online'],

                "mg_id"                     => $result->fields['mg_id'],
                "mg_name"                   => $result->fields['mg_name'],
            );
            $result->MoveNext();
        }
    }
    $t->assign(array(
        "member_list"   => $member_list,
        "pagination"    => $bwpage->pagination,
    ));
}
?>
