<?php
/*
+-----------------------------------------------------------------------------+
| $Id: admin_group.php 2010-05-24 12:37:44Z Bleakwind $
| Manguage admin group
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// Admin group add and amend ajax
function submit_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_cover,$setting_attach;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    if ($type == "amend") {
        $submit_value   = "编辑";
    } else {
        $submit_value   = "添加";
    }

    if ($ADMIN['ag_privilege']['admin_group_amend'] != "1"){
        $error = true;
        $ajax_response->alert("您没有权限修改管理员群组!");
    } else {

        if( empty($value['ag_name']) ) {
            $error = true;
            if(empty($anchor)) { $anchor = "ag_name"; }
            $ajax_response->assign("ag_name_return", "innerHTML", "<span class=\"prompt_failed\">管理员群组名称必须填写<!-- ag_name error --></span>");
        } else {
            $ajax_response->assign("ag_name_return", "innerHTML", "");
        }

        if(!preg_match("/^[0-9]+$/",$value['ag_rank'])) {
            $error = true;
            if(empty($anchor)) { $anchor = "ag_rank"; }
            $ajax_response->assign("ag_rank_return", "innerHTML", "<span class=\"prompt_failed\">排序不能为空且必须为数字<!-- ag_rank error --></span>");
        } else {
            $ajax_response->assign("ag_rank_return", "innerHTML", "");
        }

        if( !preg_match("/^[123]+$/",$value['ag_if_enable']) ) {
            $error = true;
            if(empty($anchor)) { $anchor = "ag_if_enable"; }
            $ajax_response->assign("ag_if_enable_return", "innerHTML", "<span class=\"prompt_failed\">必须选择管理员状态<!-- ag_if_enable error --></span>");
        } else {
            $ajax_response->assign("ag_if_enable_return", "innerHTML", "");
        }

        if($error){
            $ajax_response->assign($submit,"value",$submit_value);
            $ajax_response->assign($submit,"disabled",false);
            $ajax_response->redirect("#".$anchor);
        }else{

            if ($type == "amend") {

                if (!preg_match("/^[0-9]+$/",$sys->get['ag_id'])){
                    $ajax_response->alert("用户ID错误!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {

                    $total_record = func::db_count_record(DB_TABLE_ADMIN_GROUP, "ag_name='".addslashes($value['ag_name'])."' AND ag_id!=".(int)$sys->get['ag_id'], "ag_id");
                    if ($total_record > 0) {
                        $ajax_response->alert("此群组名称已经存在,请重新填写!");
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    } else {
                        $ag_privilege = !empty($value['ag_privilege']) ? serialize($value['ag_privilege']) : "";
                        $ag_fileallow = !empty($value['ag_fileallow']) ? serialize($value['ag_fileallow']) : "";
                        $sql = "UPDATE ".DB_TABLE_ADMIN_GROUP." SET
                                    ag_name         = '".addslashes(func::str_stripbr($value['ag_name']))."',
                                    ag_brief        = '".addslashes($value['ag_brief'])."',
                                    ag_privilege    = '".$ag_privilege."',
                                    ag_fileallow    = '".$ag_fileallow."',
                                    ag_rank         = '".addslashes($value['ag_rank'])."',
                                    ag_if_enable    = '".addslashes($value['ag_if_enable'])."'
                                WHERE ag_id=".$sys->get['ag_id']."";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg());
                            $ajax_response->assign($submit,"value",$submit_value);
                            $ajax_response->assign($submit,"disabled",false);
                        }else{
                            $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=admin_group&pag=".$sys->get['pag']);
                        }
                    }
                }

            } else {

                $total_record = func::db_count_record(DB_TABLE_ADMIN_GROUP, "ag_name='".addslashes($sys->post['ag_name'])."'");
                if ($total_record > 0) {
                    $ajax_response->alert("此群组名称已经存在,请重新填写!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $ag_privilege = !empty($value['ag_privilege']) ? serialize($value['ag_privilege']) : "";
                    $ag_fileallow = !empty($value['ag_fileallow']) ? serialize($value['ag_fileallow']) : "";
                    $sql = "INSERT INTO ".DB_TABLE_ADMIN_GROUP." SET
                                    ag_name         = '".addslashes(func::str_stripbr($value['ag_name']))."',
                                    ag_brief        = '".addslashes($value['ag_brief'])."',
                                    ag_privilege    = '".$ag_privilege."',
                                    ag_fileallow    = '".$ag_fileallow."',
                                    ag_rank         = '".addslashes($value['ag_rank'])."',
                                    ag_if_enable    = '".addslashes($value['ag_if_enable'])."'";
                    $result = $db->Execute($sql);
                    $last_record = $db->Insert_ID();
                    if (!$result) {
                        $ajax_response->alert($db->ErrorMsg());
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    }else{
                        $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=admin_group&pag=".$sys->get['pag']);
                    }
                }
            }
        }
    }


    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "submit_form");
//////

if($sys->get['ope'] == "add"){

    if ($ADMIN['ag_privilege']['admin_group_amend'] != "1"){
        $sys->prompt("failed","您没有权限添加管理员群组!<!-- admin_group_amend error -->");
    } else {
        $t->assign(array(
            "list_privilege_admin"  => $SYSCHECK['list_privilege_admin'],
            "list_fileallow_admin"  => $SYSCHECK['list_fileallow_admin'],
        ));
    }

}elseif($sys->get['ope'] == "amend"){

    if ($ADMIN['ag_privilege']['admin_group_view'] != "1"){
        $sys->prompt("failed","您没有权限查看管理员群组!<!-- admin_group_view error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['ag_id'])){
        $sys->prompt("failed","非法操作!<!-- ag_id error -->");
    }else{

        $sql = "SELECT *
                FROM ".DB_TABLE_ADMIN_GROUP."
                WHERE ag_id=".$sys->get['ag_id'];
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }else {
            if (!$result->EOF) {
                $ag_privilege = unserialize($result->fields['ag_privilege']);
                $ag_fileallow = unserialize($result->fields['ag_fileallow']);
                $admin_group_detail = array(
                    "ag_id"         => $result->fields['ag_id'],
                    "ag_name"       => $result->fields['ag_name'],
                    "ag_brief"      => $result->fields['ag_brief'],
                    "ag_privilege"  => $ag_privilege,
                    "ag_fileallow"  => $ag_fileallow,
                    "ag_rank"       => $result->fields['ag_rank'],
                    "ag_if_enable"  => $result->fields['ag_if_enable'],
                );
            }
        }
    }
    $t->assign(array(
        "admin_group_detail"    => $admin_group_detail,
        "list_privilege_admin"  => $SYSCHECK['list_privilege_admin'],
        "list_fileallow_admin"  => $SYSCHECK['list_fileallow_admin'],
    ));

}elseif($sys->get['ope'] == "if_enable"){

    if ($ADMIN['ag_privilege']['admin_group_amend'] != "1"){
        $sys->prompt("failed","您没有权限修改管理员群组!<!-- admin_group_amend error -->");
    } elseif (!preg_match("/^[0-9]+$/",$sys->get['ag_id'])) {
        $sys->prompt("failed","非法操作!<!-- ag_id error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_enable'])) {
        $sys->prompt("failed","非法操作!<!-- if_enable error -->");
    } else {

        $sql_data = array(
           "ag_if_enable"   => $sys->get['if_enable'],
        );
        $result = func::db_update(DB_TABLE_ADMIN_GROUP, $sql_data, "ag_id='".$sys->get['ag_id']."'");
        if (!$result) {
           $sys->prompt("failed","非法操作!<!-- db_update failed -->");
        }

        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=admin_group&pag=".$sys->get['pag']);
    }

}elseif($sys->get['ope'] == "del"){

    // check the post
    if ($ADMIN['ag_privilege']['admin_group_amend'] != "1"){
        $sys->prompt("failed","您没有权限删除管理员群组!<!-- admin_group_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['ag_id'])){
        $sys->prompt("failed","非法操作!<!-- ag_id error -->");
    }else{

        $total_record = func::db_count_record(DB_TABLE_ADMIN, "ag_id=".$sys->get['ag_id']."");
        if ($total_record > 0) {
            $sys->prompt("failed","群组非空!");
        }

        $sql = "DELETE FROM ".DB_TABLE_ADMIN_GROUP."
                WHERE ag_id=".$sys->get['ag_id'];
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }

        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=admin_group&pag=".$sys->get['pag']);
    }

}else{

    $total_record = func::db_count_record(DB_TABLE_ADMIN_GROUP);
    $bwpage->set_record_listnum("20");
    $bwpage->set_record($total_record);
    $bwpage->page($CONFIGURE['common']['control_admin']."?act=admin_group&pag=%s");
    $sql = "SELECT *
            FROM ".DB_TABLE_ADMIN_GROUP."
            ORDER BY ag_rank, ag_id
            LIMIT ".$bwpage->record_listfirst.",".$bwpage->record_listnum;
    $result = &$db->Execute($sql);
    if (!$result) {
        echo $db->ErrorMsg();
    }else {
        while(!$result->EOF) {
            $admin_group_list[] = array(
                "ag_id"         => $result->fields['ag_id'],
                "ag_name"       => $result->fields['ag_name'],
                "ag_brief"      => $result->fields['ag_brief'],
                "ag_privilege"  => $result->fields['ag_privilege'],
                "ag_fileallow"  => $result->fields['ag_fileallow'],
                "ag_rank"       => $result->fields['ag_rank'],
                "ag_if_enable"  => $result->fields['ag_if_enable'],
            );
            $result->MoveNext();
        }
    }
    $t->assign(array(
        "admin_group_list"  => $admin_group_list,
        "pagination"        => $bwpage->pagination,
    ));
}
?>
