<?php
/*
+-----------------------------------------------------------------------------+
| $Id: article.php 2010-05-24 12:37:44Z Bleakwind $
| Manage article
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

$setting_cover['length']    = 40;
$setting_cover['size']      = 2097152;
$setting_cover['type']      = ".gif,.jpg,.png";
$setting_cover['dir']       = date("Y")."/".date("Ym")."/".date("Ymd")."/";

$setting_attach['length']   = 40;
$setting_attach['size']     = 2097152;
$setting_attach['type']     = ".gif,.jpg,.png,.swf,.pdf,.doc,.ppt,.zip,.rar";
$setting_attach['dir']      = date("Y")."/".date("Ym")."/".date("Ymd")."/";

// public ajax
function upload_submit($form,$action,$prompt)  
{
    global $LANGUAGE,$LANGLIST,$SETTING;
    $ajax_response = new xajaxResponse();
    $ajax_response->assign($prompt, "innerHTML", "<img src=\"".$SETTING['dir_images_admin']."/loading.gif\" border=\"0\" align=\"absmiddle\" />");
    $ajax_response->remove($form."_upload_target");
    $ajax_response->append($prompt, "innerHTML", "<iframe id=\"".$form."_upload_target\" name=\"".$form."_upload_target\" width=\"0\" height=\"0\" scrolling=\"no\" frameborder=\"0\" src=\"about:blank\" style=\"display:none;\"></iframe>");
    $ajax_response->assign($form,"action",$action);
    $ajax_response->assign($form,"target",$form."_upload_target");
    $ajax_response->script("document.".$form.".submit();");
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "upload_submit");
function article_if_turn($id, $value, $detail="")
{
    global $LANGUAGE,$LANGLIST,$SETTING,$article_info;
    $ajax_response = new xajaxResponse();
    if (!empty($detail) && !is_array($detail)) {
        $detail = preg_split("/[\s,|]+/", $detail);
    }
    if ( $value == "true"){
        $ajax_response->assign($id, "style.display", 'inline');
        if (is_array($detail) && count($detail)>0) {
            foreach ($detail as $v) {
                $ajax_response->assign($v, "style.display", 'none');
            }
        }
    }else{
        $ajax_response->assign($id, "style.display", 'none');
        if (is_array($detail) && count($detail)>0) {
            foreach ($detail as $v) {
                $ajax_response->assign($v, "style.display", 'inline');
            }
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "article_if_turn");
function page_type($id, $value, $subinput)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$article_info;
    $ajax_response = new xajaxResponse();
    if ( $value == "2"){
        $ajax_response->assign($id, "innerHTML", '每页字节:<input type="text" id="'.$subinput.'" name="'.$subinput.'" size="12" style="width:80px;" maxlength="255" value="10000" class="input"> (1中文=1字节)');
    }else{
        $ajax_response->assign($id, "innerHTML", '请在适当地方插入<span class="salient">[PAGESPLIT]</span>');
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "page_type");
function article_if_enable($id, $value)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$article_info;
    $ajax_response = new xajaxResponse();
    if ( $value == "3"){
        $ajax_response->assign($id, "style.display", 'inline');
    } else {
        $ajax_response->assign($id, "style.display", 'none');
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "article_if_enable");
function article_if_top($id, $value)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$article_info;
    $ajax_response = new xajaxResponse();
    if ( $value == "3"){
        $ajax_response->assign($id, "style.display", 'inline');
    } else {
        $ajax_response->assign($id, "style.display", 'none');
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "article_if_top");
//////
// cover ajax
function cover_upload_return($state,$type,$search,$form,$input,$input_value,$submit,$list,$prompt,$msg)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_cover;
    $ajax_response = new xajaxResponse();
    $ajax_response->assign($form,"action","javascript:void(null);");
    $ajax_response->assign($form,"target","_self");

    if ($state == "1") {
        $ajax_response->assign($input, "innerHTML", $input_value);
    }

    if ($type == "amend"){
        $article_id = $search;
        $file_str = "";
        $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$article_id, "", "id DESC");
        $file_value = $filelist['0'];
        if (!empty($file_value)){
            $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
            if (!file_exists($path)) { func::make_dir($path); }
            if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                $size = $width > $height ? "width=45" : "height=45";
                $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('amend','".$article_id."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
            }
        }
        if (empty($file_str)) {
            $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
        }
    } else {
        $admin_id = $search;
        $file_str = "";
        $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=0 AND admin_id=".$admin_id, "", "id DESC");
        $file_value = $filelist['0'];
        if (!empty($file_value)){
            $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
            if (!file_exists($path)) { func::make_dir($path); }
            if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                $size = $width > $height ? "width=45" : "height=45";
                $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('add','".$admin_id."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
            }
        }
        if (empty($file_str)) {
            $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
        }
    }
    $ajax_response->assign($list,"innerHTML",$file_str);

    $ajax_response->assign($prompt, "innerHTML", $msg);
    $ajax_response->assign($submit,"disabled",false);
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "cover_upload_return");
function cover_get($type,$search,$file_input,$file,$submit,$list,$prompt)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_cover;
    $ajax_response = new xajaxResponse();

    $ajax_response->assign($prompt, "innerHTML", "<img src=\"".$SETTING['dir_images_admin']."/loading.gif\" border=\"0\" align=\"absmiddle\" />");
    $cover_type = explode(",",$setting_cover['type']);
    if (empty($file)) {
        $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">请输入文件地址</span>");
        $ajax_response->assign($submit,"disabled",false);
    }else{
        preg_match("/([^\/.]*)\.[^\/.]*$/", $file, $name_primal); $name_primal = $name_primal[1];
        preg_match("/[^\/.]*(\.[^\/.]*)$/", $file, $name_extend); $name_extend = strtolower($name_extend[1]);
        if (empty($name_primal)) {
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">获取文件名失败</span>");
            $ajax_response->assign($submit,"disabled",false);
        } elseif (!in_array($name_extend, $cover_type)) {
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">文件类型不符合要求<!-- file type error --></span>");
            $ajax_response->assign($submit,"disabled",false);
        } else {

            $result_state = "1";

            if ($type == "amend"){
                $article_id = $search;
                if (!preg_match("/^[1-9][0-9]*$/",$article_id)){
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- article_id error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$article_id, "", "id DESC");
                    if (count($filelist) > 1){
                        $result = func::db_delete(DB_TABLE_ARTICLE_COVER, "article_id=".$article_id." AND id!=".$filelist[0]['id']);
                        if (!$result) {
                            $result_state = "0";
                            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">删除多余的记录失败<!-- delete excrescent error --></span>");
                            $ajax_response->assign($submit,"disabled",false);
                        }
                    }
                    if ($result_state == "1") {
                        $file_value = $filelist[0];
                        if (!empty($file_value['dir'])){
                            $dir    = $file_value['dir'];
                            $path   = $SETTING['dir_article_cover']."/".$dir;
                        } else {
                            $dir    = $setting_cover['dir'];
                            $path   = $SETTING['dir_article_cover']."/".$dir;
                        }
                        if (!file_exists($path)) { func::make_dir($path); }

                        $filename       = "";
                        $file_notexists = false;
                        while($file_notexists === false){
                            $name_base = func::return_lenstr(sha1($name_primal.microtime()),$setting_cover['length']);
                            $filename = $name_base.$name_extend;
                            if(!file_exists($path.$filename)) {
                                $file_notexists = true;
                            }
                        }

                        if (!@copy($file, $path.$filename)) {
                            $result_state = "0";
                            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">获取内容失败<!-- copy error --></span>");
                            $ajax_response->assign($submit,"disabled",false);
                        } else {
                            if (!empty($file_value['filename'])){
                                if (file_exists($path.$file_value['filename'])) {
                                    @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                                    @unlink($path.$file_value['filename']);
                                }
                            }
                            $sql_data = array(
                                "dir"       => "'".$dir."'",
                                "filename"  => "'".$filename."'",
                                "article_id"   => "'".$article_id."'",
                                "admin_id"  => "'".$ADMIN['mid']."'",
                            );
                            if (count($filelist) > 0) {
                                $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "id=".$file_value['id']);
                            } else {
                                $result = func::db_insert(DB_TABLE_ARTICLE_COVER, $sql_data);
                            }
                            if (!$result) {
                                if (file_exists($path.$filename)) {
                                    @chmod($path.$filename, $SETTING['chmod_mode_file']);
                                    @unlink($path.$filename);
                                }
                                $result_state = "0";
                                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                                $ajax_response->assign($submit,"disabled",false);
                            }
                        }
                    }
                }
            } else {
                $admin_id = $search;
                if (!preg_match("/^[1-9][0-9]*$/",$admin_id)){
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- admin_id error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=0 AND admin_id=".$admin_id, "", "id DESC");
                    if (count($filelist) > 1){
                        $result = func::db_delete(DB_TABLE_ARTICLE_COVER, "article_id=0 AND admin_id=".$admin_id." AND id!=".$filelist[0]['id']);
                        if (!$result) {
                            $result_state = "0";
                            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">删除多余的记录失败<!-- delete excrescent error --></span>");
                            $ajax_response->assign($submit,"disabled",false);
                        }
                    }
                    if ($result_state == "1") {
                        $file_value = $filelist[0];
                        if (!empty($file_value['dir'])){
                            $dir    = $file_value['dir'];
                            $path   = $SETTING['dir_article_cover']."/".$dir;
                        } else {
                            $dir    = $setting_cover['dir'];
                            $path   = $SETTING['dir_article_cover']."/".$dir;
                        }
                        if (!file_exists($path)) { func::make_dir($path); }

                        $filename       = "";
                        $file_notexists = false;
                        while($file_notexists === false){
                            $name_base = func::return_lenstr(sha1($name_primal.microtime()),$setting_cover['length']);
                            $filename = $name_base.$name_extend;
                            if(!file_exists($path.$filename)) {
                                $file_notexists = true;
                            }
                        }

                        if (!@copy($file, $path.$filename)) {
                            $result_state = "0";
                            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">获取内容失败<!-- copy error --></span>");
                            $ajax_response->assign($submit,"disabled",false);
                        } else {
                            if (!empty($file_value['filename'])){
                                if (file_exists($path.$file_value['filename'])) {
                                    @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                                    @unlink($path.$file_value['filename']);
                                }
                            }
                            $sql_data = array(
                                "dir"       => "'".$dir."'",
                                "filename"  => "'".$filename."'",
                                "article_id"   => "'0'",
                                "admin_id"  => "'".$ADMIN['mid']."'",
                            );
                            if (count($filelist) > 0) {
                                $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "id=".$file_value['id']);
                            } else {
                                $result = func::db_insert(DB_TABLE_ARTICLE_COVER, $sql_data);
                            }
                            if (!$result) {
                                if (file_exists($path.$filename)) {
                                    @chmod($path.$filename, $SETTING['chmod_mode_file']);
                                    @unlink($path.$filename);
                                }
                                $result_state = "0";
                                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                                $ajax_response->assign($submit,"disabled",false);
                            }
                        }
                    }
                }
            }

            if ($result_state == "1"){
                if ($type == "amend"){
                    $article_id = $search;
                    $file_str = "";
                    $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$article_id, "", "id DESC");
                    $file_value = $filelist['0'];
                    if (!empty($file_value)){
                        $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
                        if (!file_exists($path)) { func::make_dir($path); }
                        if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                            list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                            $size = $width > $height ? "width=45" : "height=45";
                            $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('amend','".$article_id."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
                        }
                    }
                    if (empty($file_str)) {
                        $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
                    }
                } else {
                    $admin_id = $search;
                    $file_str = "";
                    $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=0 AND admin_id=".$admin_id, "", "id DESC");
                    $file_value = $filelist['0'];
                    if (!empty($file_value)){
                        $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
                        if (!file_exists($path)) { func::make_dir($path); }
                        if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                            list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                            $size = $width > $height ? "width=45" : "height=45";
                            $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('add','".$admin_id."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
                        }
                    }
                    if (empty($file_str)) {
                        $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
                    }
                }
                $ajax_response->assign($list,"innerHTML",$file_str);
                $ajax_response->assign($file_input, "value", "");
                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_succeed\">文件获取成功<!-- get file succeed --></span>");
            }

            $ajax_response->assign($submit,"disabled",false);
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "cover_get");
function cover_del($type,$search,$del,$list,$prompt)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_cover;
    $ajax_response = new xajaxResponse();

    $ajax_response->assign($prompt, "innerHTML", "");

    $result_state = "1";

    if ($type == "amend"){
        $article_id = $search;
        if (!preg_match("/^[1-9][0-9]*$/",$article_id)){
            $result_state = "0";
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- article_id error --></span>");
            $ajax_response->assign($submit,"disabled",false);
        } else {
            if (!preg_match("/^[1-9][0-9]*$/",$del)){
                $result_state = "0";
                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- del error --></span>");
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "id=".$del, "", "id DESC");
                $file_value = $filelist[0];
                if (!empty($file_value['dir'])){
                    $dir    = $file_value['dir'];
                    $path   = $SETTING['dir_article_cover']."/".$dir;
                    if (!empty($file_value['filename'])){
                        if (file_exists($path.$file_value['filename'])) {
                            @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                            @unlink($path.$file_value['filename']);
                        }
                    }
                }
                $sql_data = array(
                    "filename" => "''",
                );
                if (count($filelist) > 0) {
                    $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "id=".$file_value['id']);
                }
                if (!$result) {
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                }

            }
        }
    } else {
        $admin_id = $search;
        if (!preg_match("/^[1-9][0-9]*$/",$admin_id)){
            $result_state = "0";
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- admin_id error --></span>");
            $ajax_response->assign($submit,"disabled",false);
        } else {
            if (!preg_match("/^[1-9][0-9]*$/",$del)){
                $result_state = "0";
                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- del error --></span>");
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "id=".$del, "", "id DESC");
                $file_value = $filelist[0];
                if (!empty($file_value['dir'])){
                    $dir    = $file_value['dir'];
                    $path   = $SETTING['dir_article_cover']."/".$dir;
                    if (!empty($file_value['filename'])){
                        if (file_exists($path.$file_value['filename'])) {
                            @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                            @unlink($path.$file_value['filename']);
                        }
                    }
                }
                $sql_data = array(
                    "filename" => "''",
                );
                if (count($filelist) > 0) {
                    $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "id=".$file_value['id']);
                }
                if (!$result) {
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                }

            }
        }
    }

    if ($result_state == "1"){
        if ($type == "amend"){
            $article_id = $search;
            $file_str = "";
            $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$article_id, "", "id DESC");
            $file_value = $filelist['0'];
            if (!empty($file_value)){
                $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
                if (!file_exists($path)) { func::make_dir($path); }
                if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                    list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                    $size = $width > $height ? "width=45" : "height=45";
                    $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('amend','".$article_id."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
                }
            }
            if (empty($file_str)) {
                $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
            }
        } else {
            $admin_id = $search;
            $file_str = "";
            $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=0 AND admin_id=".$admin_id, "", "id DESC");
            $file_value = $filelist['0'];
            if (!empty($file_value)){
                $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
                if (!file_exists($path)) { func::make_dir($path); }
                if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                    list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                    $size = $width > $height ? "width=45" : "height=45";
                    $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('add','".$admin_id."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
                }
            }
            if (empty($file_str)) {
                $file_str = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
            }
        }
        $ajax_response->assign($list, "innerHTML", $file_str);
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "cover_del");
//////
// attach ajax
function attach_showselect($select, $prompt, $value)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_attach;
    $ajax_response = new xajaxResponse();
    if (empty($value)) {
        $ajax_response->assign($select, "innerHTML", "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />预览</div>\n");
        $ajax_response->assign($prompt, "innerHTML", "");
    } else {
        $attach_type = explode(",",$setting_attach['type']);
        preg_match("/[^\/.]*(\.[^\/.]*)$/", $value, $name_extend); $name_extend = strtolower($name_extend[1]);
        if (!preg_match("/[a-z0-9\.]{1,9}/i", $name_extend) || !in_array($name_extend, $attach_type)) {
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">文件类型不符合要求<!-- file type error --></span>");
        } else {
            if (preg_match("/^(\.gif|\.jpg|\.png)$/i", $name_extend) && $prompt == "attach_get_prompt"){
                $size = "width=45 height=45";
                $ajax_response->assign($select, "innerHTML", "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><img src=\"".$value."\" ".$size." border=\"0\" align=\"absmiddle\" /></div>");
            } else {
                $ajax_response->assign($select, "innerHTML", "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />".$name_extend."</div>\n");
            }
            $ajax_response->assign($prompt, "innerHTML", "");
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "attach_showselect");
function attach_upload_return($state,$type,$search,$form,$file_input,$input_value,$submit,$list,$detail_input,$select,$prompt,$msg)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_attach;
    $ajax_response = new xajaxResponse();
    $ajax_response->assign($form,"action","javascript:void(null);");
    $ajax_response->assign($form,"target","_self");

    if ($state == "1") {
        $ajax_response->assign($detail_input, "value", "");
        $ajax_response->assign($select, "innerHTML", "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />预览</div>\n");
        $ajax_response->assign($file_input, "innerHTML", $input_value);
    }

    if ($type == "amend"){
        $attach_list    = $list;
        $attach_type    = "amend";
        $attach_where   = "article_id=".$search;
        $attach_table   = DB_TABLE_ARTICLE_ATTACH;
        $attach_dir     = $SETTING['dir_article_attach'];
        list($file_str, $file_str_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
    } else {
        $attach_list    = $list;
        $attach_type    = "add";
        $attach_where   = "article_id=0 AND admin_id=".$search;
        $attach_table   = DB_TABLE_ARTICLE_ATTACH;
        $attach_dir     = $SETTING['dir_article_attach'];
        list($file_str, $file_str_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
    }

    $ajax_response->assign($list,"innerHTML",$file_str);
    $ajax_response->script($file_str_js);

    $ajax_response->assign($prompt, "innerHTML", $msg);
    $ajax_response->assign($submit,"disabled",false);
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "attach_upload_return");
function attach_get($type,$search,$file_input,$file,$submit,$list,$detail_input,$brief,$select,$prompt)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_attach;
    $ajax_response = new xajaxResponse();
    //$ajax_response->alert(print_r($value['brief'], true)); return $ajax_response;

    $ajax_response->assign($prompt, "innerHTML", "<img src=\"".$SETTING['dir_images_admin']."/loading.gif\" border=\"0\" align=\"absmiddle\" />");
    $attach_type = explode(",",$setting_attach['type']);
    if (empty($file)) {
        $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">请输入文件地址</span>");
        $ajax_response->assign($submit,"disabled",false);
    }else{
        preg_match("/([^\/.]*)\.[^\/.]*$/", $file, $name_primal); $name_primal = $name_primal[1];
        preg_match("/[^\/.]*(\.[^\/.]*)$/", $file, $name_extend); $name_extend = strtolower($name_extend[1]);
        if (empty($name_primal)) {
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">获取文件名失败</span>");
            $ajax_response->assign($submit,"disabled",false);
        } elseif (!preg_match("/[a-z0-9\.]{1,9}/i", $name_extend) || !in_array($name_extend, $attach_type)) {
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">文件类型不符合要求<!-- file type error --></span>");
            $ajax_response->assign($submit,"disabled",false);
        } else {

            $result_state = "1";

            if ($type == "amend"){
                $article_id = $search;
                if (!preg_match("/^[1-9][0-9]*$/",$article_id)){
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- article_id error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $dir    = $setting_attach['dir'];
                    $path   = $SETTING['dir_article_attach']."/".$dir;
                    if (!file_exists($path)) { func::make_dir($path); }

                    $filename       = "";
                    $file_notexists = false;
                    while($file_notexists === false){
                        $name_base = func::return_lenstr(sha1($name_primal.microtime()),$setting_attach['length']);
                        $filename = $name_base.$name_extend;
                        if(!file_exists($target_dir.$filename)) {
                            $file_notexists = true;
                        }
                    }

                    if (!@copy($file, $path.$filename)) {
                        $result_state = "0";
                        $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">获取内容失败<!-- copy error --></span>");
                        $ajax_response->assign($submit,"disabled",false);
                    }else{
                        $sql_data   = array(
                            "brief"             => "'".addslashes($brief)."'",
                            "dir"               => "'".$dir."'",
                            "filename"          => "'".$filename."'",
                            "article_id"           => "'".(int)$article_id."'",
                            "admin_id"          => "'".(int)$ADMIN['mid']."'",
                            "time"              => $sys->nowtime,
                            "down"              => "0",
                        );
                        $result = func::db_insert(DB_TABLE_ARTICLE_ATTACH, $sql_data);
                        if (!$result) {
                            if (file_exists($path.$filename)) {
                                @chmod($path.$filename, $SETTING['chmod_mode_file']);
                                @unlink($path.$filename);
                            }
                            $result_state = "0";
                            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                            $ajax_response->assign($submit,"disabled",false);
                        }
                    }
                }
            } else {
                $admin_id = $search;
                if (!preg_match("/^[1-9][0-9]*$/",$admin_id)){
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- admin_id error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $dir    = $setting_attach['dir'];
                    $path   = $SETTING['dir_article_attach']."/".$dir;

                    $filename       = "";
                    $file_notexists = false;
                    while($file_notexists === false){
                        $name_base = func::return_lenstr(sha1($name_primal.microtime()),$setting_attach['length']);
                        $filename = $name_base.$name_extend;
                        if(!file_exists($target_dir.$filename)) {
                            $file_notexists = true;
                        }
                    }

                    if (!file_exists($path)) { func::make_dir($path); }
                    if (!@copy($file, $path.$filename)) {
                        $result_state = "0";
                        $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">获取内容失败<!-- copy error --></span>");
                        $ajax_response->assign($submit,"disabled",false);
                    } else {
                        $sql_data = array(
                            "brief"             => "'".addslashes($brief)."'",
                            "dir"               => "'".$dir."'",
                            "filename"          => "'".$filename."'",
                            "article_id"           => "'0'",
                            "admin_id"          => "'".(int)$ADMIN['mid']."'",
                            "time"              => $sys->nowtime,
                            "down"              => "0",
                        );
                        $result = func::db_insert(DB_TABLE_ARTICLE_ATTACH, $sql_data);
                        if (!$result) {
                            if (file_exists($path.$filename)) {
                                @chmod($path.$filename, $SETTING['chmod_mode_file']);
                                @unlink($path.$filename);
                            }
                            $result_state = "0";
                            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                            $ajax_response->assign($submit,"disabled",false);
                        }
                    }
                }
            }

            if ($result_state == "1"){

                if ($type == "amend"){
                    $attach_list    = $list;
                    $attach_type    = "amend";
                    $attach_where   = "article_id=".$search;
                    $attach_table   = DB_TABLE_ARTICLE_ATTACH;
                    $attach_dir     = $SETTING['dir_article_attach'];
                    list($file_str, $file_str_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
                } else {
                    $attach_list    = $list;
                    $attach_type    = "add";
                    $attach_where   = "article_id=0 AND admin_id=".$search;
                    $attach_table   = DB_TABLE_ARTICLE_ATTACH;
                    $attach_dir     = $SETTING['dir_article_attach'];
                    list($file_str, $file_str_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
                }

                $ajax_response->assign($list,"innerHTML",$file_str);
                $ajax_response->script($file_str_js);

                $ajax_response->assign($file_input, "value", "");
                $ajax_response->assign($detail_input, "value", "");
                $ajax_response->assign($select, "innerHTML", "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />预览</div>\n");
                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_succeed\">文件获取成功<!-- get file succeed --></span>");
            }

            $ajax_response->assign($submit,"disabled",false);
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "attach_get");
function attach_del($type,$search,$del,$list)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$MEMBER,$ADMIN,$sys,$setting_attach;
    $ajax_response = new xajaxResponse();

    $result_state = "1";

    if ($type == "amend"){
        $article_id = $search;
        if (!preg_match("/^[1-9][0-9]*$/",$article_id)){
            $result_state = "0";
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- article_id error --></span>");
            $ajax_response->assign($submit,"disabled",false);
        } else {
            if (!preg_match("/^[1-9][0-9]*$/",$del)){
                $result_state = "0";
                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- del error --></span>");
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $filelist = func::db_select(DB_TABLE_ARTICLE_ATTACH, "*", "id=".$del, "", "id DESC");
                $file_value = $filelist[0];
                if (!empty($file_value['dir'])){
                    $dir    = $file_value['dir'];
                    $path   = $SETTING['dir_article_attach']."/".$dir;
                    if (!empty($file_value['filename'])){
                        if (file_exists($path.$filelist[0]['filename'])) {
                            @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                            @unlink($path.$file_value['filename']);
                        }
                    }
                }
                $result = func::db_delete(DB_TABLE_ARTICLE_ATTACH,  "id=".$file_value['id']);
                if (!$result) {
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                }
            }
        }
    } else {
        $admin_id = $search;
        if (!preg_match("/^[1-9][0-9]*$/",$admin_id)){
            $result_state = "0";
            $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- admin_id error --></span>");
            $ajax_response->assign($submit,"disabled",false);
        } else {
            if (!preg_match("/^[1-9][0-9]*$/",$del)){
                $result_state = "0";
                $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">非法操作<!-- del error --></span>");
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $filelist = func::db_select(DB_TABLE_ARTICLE_ATTACH, "*", "id=".$del, "", "id DESC");
                $file_value = $filelist[0];
                if (!empty($file_value['dir'])){
                    $dir    = $file_value['dir'];
                    $path   = $SETTING['dir_article_attach']."/".$dir;
                    if (!empty($file_value['filename'])){
                        if (file_exists($path.$filelist[0]['filename'])) {
                            @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                            @unlink($path.$file_value['filename']);
                        }
                    }
                }
                $result = func::db_delete(DB_TABLE_ARTICLE_ATTACH,  "id=".$file_value['id']);
                if (!$result) {
                    $result_state = "0";
                    $ajax_response->assign($prompt, "innerHTML", "<span class=\"prompt_failed\">更新数据库失败<!-- db update error --></span>");
                    $ajax_response->assign($submit,"disabled",false);
                }
            }
        }
    }

    if ($result_state == "1"){
        if ($type == "amend"){
            $attach_list    = $list;
            $attach_type    = "amend";
            $attach_where   = "article_id=".$search;
            $attach_table   = DB_TABLE_ARTICLE_ATTACH;
            $attach_dir     = $SETTING['dir_article_attach'];
            list($file_str, $file_str_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
        } else {
            $attach_list    = $list;
            $attach_type    = "add";
            $attach_where   = "article_id=0 AND admin_id=".$search;
            $attach_table   = DB_TABLE_ARTICLE_ATTACH;
            $attach_dir     = $SETTING['dir_article_attach'];
            list($file_str, $file_str_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
        }
        $ajax_response->assign($list,"innerHTML",$file_str);
        $ajax_response->script($file_str_js);
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "attach_del");
//////
// form post ajax
function submit_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_cover,$setting_attach;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    if ($type == "amend") {
        $submit_value   = "编辑";
        $iderror        = "类别错误";
    } else {
        $submit_value   = "添加";
        $iderror        = "所属类别错误";
    }

    if ( $ADMIN['ag_privilege']['article'] != "1" ) {
        $ajax_response->alert($iderror."!<!-- privilege not allow -->");
        $ajax_response->assign($submit,"value",$submit_value);
        $ajax_response->assign($submit,"disabled",false);
    } else {

        if( empty($value['phrase']) ) {
            $error = true;
            if(empty($anchor)) { $anchor = "phrase"; }
            $ajax_response->assign("phrase_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须填写简短标题<!-- phrase error --></p></span>");
        } elseif( mb_strlen($value['phrase'], "utf-8") > 60) {
            $error = true;
            if(empty($anchor)) { $anchor = "phrase"; }
            $ajax_response->assign("phrase_return", "innerHTML", "<span class=\"prompt_bubble\"><p>简短标题不能大于60字节<!-- phrase error --></p></span>");
        } else {
            $ajax_response->assign("phrase_return", "innerHTML", "");
        }

        if( empty($value['subject']) ) {
            $error = true;
            if(empty($anchor)) { $anchor = "subject"; }
            $ajax_response->assign("subject_return", "innerHTML", "<span class=\"prompt_bubble\"><p>必须填写完整标题<!-- subject error --></p></span>");
        } elseif( mb_strlen($value['subject'], "utf-8") > 120) {
            $error = true;
            if(empty($anchor)) { $anchor = "subject"; }
            $ajax_response->assign("subject_return", "innerHTML", "<span class=\"prompt_bubble\"><p>完整标题不能大于120字节<!-- subject error --></p></span>");
        } else {
            $ajax_response->assign("subject_return", "innerHTML", "");
        }

        if( mb_strlen($value['keyword'], "utf-8") > 255) {
            $error = true;
            if(empty($anchor)) { $anchor = "keyword"; }
            $ajax_response->assign("keyword_return", "innerHTML", "<span class=\"prompt_bubble\"><p>关键字不能大于255字节<!-- keyword error --></p></span>");
        } else {
            $ajax_response->assign("keyword_return", "innerHTML", "");
        }

        if( $value['if_enable'] == "3" ) {
            if( empty($value['if_enable_begin']) || empty($value['if_enable_end']) ) {
                $error = true;
                if(empty($anchor)) { $anchor = "if_enable"; }
                $ajax_response->assign("if_enable_return", "innerHTML", "<span class=\"prompt_bubble\"><p>对是否开启定时必须填写开始和结束时间<!-- if_enable error --></p></span>");
            } else {
                $ajax_response->assign("if_enable_return", "innerHTML", "");
            }
        }

        if( $value['if_top'] == "3" ) {
            if( empty($value['if_top_begin']) || empty($value['if_top_end']) ) {
                $error = true;
                if(empty($anchor)) { $anchor = "if_top"; }
                $ajax_response->assign("if_top_return", "innerHTML", "<span class=\"prompt_bubble\"><p>对是否开启置顶必须填写开始和结束时间<!-- if_top error --></p></span>");
            } else {
                $ajax_response->assign("if_top_return", "innerHTML", "");
            }
        }

        if( $value['if_turn'] == "1" ) {
            if( !preg_match("/^1|2$/i", $value['if_turn_type']) ) {
                $error = true;
                if(empty($anchor)) { $anchor = "if_turn_detail"; }
                $ajax_response->assign("if_turn_detail_return", "innerHTML", "<span class=\"prompt_bubble\"><p>转向类型发生错误!<!-- if_turn_type error --></p></span>");
            } elseif( empty($value['if_turn_url']) ) {
                $error = true;
                if(empty($anchor)) { $anchor = "if_turn_detail"; }
                $ajax_response->assign("if_turn_detail_return", "innerHTML", "<span class=\"prompt_bubble\"><p>转向地址必须填写<!-- if_turn_url error --></p></span>");
            } else {
                $ajax_response->assign("if_turn_detail_return", "innerHTML", "");
            }
        }

        if($error){
            $ajax_response->assign($submit,"value",$submit_value);
            $ajax_response->assign($submit,"disabled",false);
            $ajax_response->redirect("#".$anchor);
        }else{

            if ($type == "amend") {
                // article amend
                if (!empty($value['keyword'])) {
                    $this_keyword = implode(",", preg_split("/[\s,]+/", $value['keyword']));
                } else {
                    $this_keyword = "";
                }
                $sql = "UPDATE ".DB_TABLE_ARTICLE." SET
                            phrase                  ='".addslashes(func::str_stripbr($value['phrase']))."',
                            subject                 ='".addslashes(func::str_stripbr($value['subject']))."',
                            prefix                  ='".addslashes((int)$value['prefix'])."',
                            color                   ='".addslashes((int)$value['color'])."',
                            fontstyle               ='".addslashes((int)$value['fontstyle'])."',
                            decoration              ='".addslashes((int)$value['decoration'])."',
                            keyword                 ='".addslashes($this_keyword)."',
                            brief                   ='".addslashes($value['brief'])."',
                            amend_id                ='".$ADMIN['mid']."',
                            amend_username          ='".$MEMBER['username']."',
                            amend_ip                ='".func::return_ip()."',
                            amend_time              =".$sys->nowtime.",
                            click                   ='".addslashes((int)$value['click'])."',
                            if_enable               ='".addslashes((int)$value['if_enable'])."',
                            if_enable_begin         ='".addslashes((int)strtotime($value['if_enable_begin']))."',
                            if_enable_end           ='".addslashes((int)strtotime($value['if_enable_end']))."',
                            if_top                  ='".addslashes((int)$value['if_top'])."',
                            if_top_begin            ='".addslashes((int)strtotime($value['if_top_begin']))."',
                            if_top_end              ='".addslashes((int)strtotime($value['if_top_end']))."',
                            if_turn                 ='".addslashes((int)$value['if_turn'])."',
                            if_turn_type            ='".addslashes((int)$value['if_turn_type'])."',
                            if_turn_url             ='".addslashes($value['if_turn_url'])."'
                        WHERE id=".$sys->get['article_id']."";
                $result = &$db->Execute($sql);
                if (!$result) {
                    $ajax_response->alert($db->ErrorMsg());
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                }else{

                    // article detail
                    $result = func::db_delete(DB_TABLE_ARTICLE_DETAIL, "article_id=".$sys->get['article_id']);
                    if (!$result) {
                        $ajax_response->alert("清理详细信息失败");
                    } else {
                        if ($value['detail_page_type'] == "2") {
                            $this_detail = str_replace("[PAGESPLIT]","",$value['detail']);
                            $this_detail_result = "";
                            $detail_count = ceil(mb_strlen($this_detail,"UTF-8") / (int)$value['detail_page_word']);
                            for($i=0;$i<$detail_count;$i++){
                                $this_detail_result .= "[PAGESPLIT]".mb_substr($this_detail, (int)$value['detail_page_word'] * $i, (int)$value['detail_page_word'], "UTF-8");
                            }
                            $this_detail_result = substr($this_detail_result, 11);
                        } else {
                            $this_detail_result = $value['detail'];
                        }
                        $sql = "INSERT INTO ".DB_TABLE_ARTICLE_DETAIL." SET
                                    article_id     = '".addslashes($sys->get['article_id'])."',
                                    detail      ='".addslashes($this_detail_result)."'";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg().$sql);
                        }
                    }
                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=article&pag=".$sys->get['pag']);
                }

            } else {
                // article insert
                if (!empty($value['keyword'])) {
                    $this_keyword = implode(",", preg_split("/[\s,]+/", $value['keyword']));
                } else {
                    $this_keyword = "";
                }
                $sql = "INSERT INTO ".DB_TABLE_ARTICLE." SET
                            phrase                  ='".addslashes(func::str_stripbr($value['phrase']))."',
                            subject                 ='".addslashes(func::str_stripbr($value['subject']))."',
                            prefix                  ='".addslashes((int)$value['prefix'])."',
                            color                   ='".addslashes((int)$value['color'])."',
                            fontstyle               ='".addslashes((int)$value['fontstyle'])."',
                            decoration              ='".addslashes((int)$value['decoration'])."',
                            keyword                 ='".addslashes($this_keyword)."',
                            brief                   ='".addslashes($value['brief'])."',
                            post_id                 ='".$ADMIN['mid']."',
                            post_username           ='".$MEMBER['username']."',
                            post_ip                 ='".func::return_ip()."',
                            post_time               =".$sys->nowtime.",
                            amend_id                ='".$ADMIN['mid']."',
                            amend_username          ='".$MEMBER['username']."',
                            amend_ip                ='".func::return_ip()."',
                            amend_time              =".$sys->nowtime.",
                            click                   ='".addslashes((int)$value['click'])."',
                            if_enable               ='".addslashes((int)$value['if_enable'])."',
                            if_enable_begin         ='".addslashes((int)strtotime($value['if_enable_begin']))."',
                            if_enable_end           ='".addslashes((int)strtotime($value['if_enable_end']))."',
                            if_top                  ='".addslashes((int)$value['if_top'])."',
                            if_top_begin            ='".addslashes((int)strtotime($value['if_top_begin']))."',
                            if_top_end              ='".addslashes((int)strtotime($value['if_top_end']))."',
                            if_turn                 ='".addslashes((int)$value['if_turn'])."',
                            if_turn_type            ='".addslashes((int)$value['if_turn_type'])."',
                            if_turn_url             ='".addslashes($value['if_turn_url'])."'";
                $result = &$db->Execute($sql);
                $last_record = $db->Insert_ID();
                if (!$result) {
                    $ajax_response->alert($db->ErrorMsg());
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                }else{

                    // article detail
                    $result = func::db_delete(DB_TABLE_ARTICLE_DETAIL, "article_id=".$last_record);
                    if (!$result) {
                        $ajax_response->alert("清理详细信息失败");
                    } else {
                        if ($value['detail_page_type'] == "2") {
                            $this_detail = str_replace("[PAGESPLIT]","",$value['detail']);
                            $this_detail_result = "";
                            $detail_count = ceil(mb_strlen($this_detail,"UTF-8") / (int)$value['detail_page_word']);
                            for($i=0;$i<$detail_count;$i++){
                                $this_detail_result .= "[PAGESPLIT]".mb_substr($this_detail, (int)$value['detail_page_word'] * $i, (int)$value['detail_page_word'], "UTF-8");
                            }
                            $this_detail_result = substr($this_detail_result, 11);
                        } else {
                            $this_detail_result = $value['detail'];
                        }
                        $sql = "INSERT INTO ".DB_TABLE_ARTICLE_DETAIL." SET
                                    article_id     = '".addslashes($last_record)."',
                                    detail      ='".addslashes($this_detail_result)."'";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg().$sql);
                        }
                    }

                    // cover update
                    $sql_data = array(
                        "article_id" => "'".$last_record."'",
                    );
                    $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "article_id=0 AND admin_id='".$ADMIN['mid']."'");
                    if (!$result) {
                        $ajax_response->alert("封面数据库更新失败!");
                    }

                    // article update
                    $sql_data = array(
                        "article_id" => "'".$last_record."'",
                    );
                    $result = func::db_update(DB_TABLE_ARTICLE_ATTACH, $sql_data, "article_id=0 AND admin_id='".$ADMIN['mid']."'");
                    if (!$result) {
                        $ajax_response->alert("附件数据库更新失败!");
                    }

                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=article&pag=".$sys->get['pag']);
                }
            }
        }
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "submit_form");
//////

if($sys->get['ope'] == "add"){

    if ( $ADMIN['ag_privilege']['article'] != "1" ) {
        $sys->prompt("failed","您没有权限进行此操作!<!-- privilege not allow -->");
    } else {

        $array_select  = array("article_prefix","article_color","article_fontstyle","article_decoration");
        $select_option = $sys->return_select($array_select);

        $prompt = "cover_upload_prompt";
        $list   = "cover_str";
        $thumb  = "";
        $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=0 AND admin_id=".$ADMIN['mid'], "", "id DESC");
        $file_value = $filelist['0'];
        if (!empty($file_value)){
            $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
            if (!file_exists($path)) { func::make_dir($path); }
            if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                $size = $width > $height ? "width=45" : "height=45";
                $thumb = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('add','".$ADMIN['mid']."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
            }
        }
        if (empty($thumb)) {
            $thumb = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
        }
        $t->assign( $list, $thumb );

        $attach_list            = "attach_list";
        $attach_type            = "add";
        $attach_where           = "article_id=0 AND admin_id=".$ADMIN['mid'];
        $attach_table           = DB_TABLE_ARTICLE_ATTACH;
        $attach_dir             = $SETTING['dir_article_attach'];
        list($attach_list_result, $attach_list_result_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
        $attach_list_result_js  = trim($attach_list_result_js);
        if (!empty($attach_list_result_js)) {
            $attach_list_result     = $attach_list_result."\n<script type=\"text/javascript\">\n<!-- \n".$attach_list_result_js."\n //-->\n</script>\n";
        }
        $attach_select          = "attach_select";
        $attach_select_result   = "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />预览</div>\n";

        $t->assign(array(
            "attach_list_result"    => $attach_list_result,
            "attach_select_result"  => $attach_select_result,

            "select_option"         => $select_option,
            "setting_cover"         => $setting_cover,
            "setting_attach"        => $setting_attach,
        ));
    }

}elseif($sys->get['ope'] == "amend"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['article_id'])){
        $sys->prompt("failed","非法操作!<!-- article_id error -->");
    }else{

        if ( $ADMIN['ag_privilege']['article'] != "1" ) {
            $sys->prompt("failed","您没有权限进行此操作!<!-- privilege not allow -->");
        } else {

            $sql = "SELECT article.*,
                        detail.detail, detail.page_type, detail.page_word
                    FROM ".DB_TABLE_ARTICLE." article
                        LEFT JOIN ".DB_TABLE_ARTICLE_DETAIL." detail ON detail.article_id=article.id
                    WHERE article.id=".$sys->get['article_id']."";
            $result = &$db->Execute($sql);
            if (!$result) {
                echo $db->ErrorMsg();
            } else {
                if ($result->EOF) {
                    $sys->prompt("failed","无法查询此公告!<!-- article_id not found -->");
                } else {
                    $article_info = array(
                        'id'                    => $result->fields['id'],
                        'phrase'                => $result->fields['phrase'],
                        'phrase_len'            => mb_strwidth($result->fields['phrase'],"UTF-8"),
                        'subject'               => $result->fields['subject'],
                        'subject_len'           => mb_strwidth($result->fields['subject'],"UTF-8"),
                        'prefix'                => $result->fields['prefix'],
                        'color'                 => $result->fields['color'],
                        'fontstyle'             => $result->fields['fontstyle'],
                        'decoration'            => $result->fields['decoration'],
                        'keyword'               => $result->fields['keyword'],
                        'brief'                 => $result->fields['brief'],
                        'post_id'               => $result->fields['post_id'],
                        'post_username'         => $result->fields['post_username'],
                        'post_ip'               => $result->fields['post_ip'],
                        'post_time'             => $result->fields['post_time'],
                        'amend_id'              => $result->fields['amend_id'],
                        'amend_username'        => $result->fields['amend_username'],
                        'amend_ip'              => $result->fields['amend_ip'],
                        'amend_time'            => $result->fields['amend_time'],
                        'click'                 => $result->fields['click'],
                        'if_enable'             => $result->fields['if_enable'],
                        'if_enable_begin'       => $result->fields['if_enable_begin'],
                        'if_enable_end'         => $result->fields['if_enable_end'],
                        'if_top'                => $result->fields['if_top'],
                        'if_top_begin'          => $result->fields['if_top_begin'],
                        'if_top_end'            => $result->fields['if_top_end'],
                        'if_turn'               => $result->fields['if_turn'],
                        'if_turn_type'          => $result->fields['if_turn_type'],
                        'if_turn_url'           => $result->fields['if_turn_url'],

                        'detail'                => $result->fields['detail'],
                        'page_type'             => $result->fields['page_type'],
                        'page_word'             => $result->fields['page_word'],
                    );

                    $array_select  = array("article_prefix","article_color","article_fontstyle","article_decoration");
                    $select_option = $sys->return_select($array_select);

                    $prompt = "cover_upload_prompt";
                    $list   = "cover_str";
                    $thumb  = "";
                    $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$sys->get['article_id'], "", "id DESC");
                    $file_value = $filelist['0'];
                    if (!empty($file_value)){
                        $path   = $SETTING['dir_article_cover']."/".$file_value['dir'];
                        if (!file_exists($path)) { func::make_dir($path); }
                        if (!empty($file_value['filename']) && file_exists($path.$file_value['filename'])) {
                            list($width, $height, $type, $attr) = getimagesize($path.$file_value['filename']);
                            $size = $width > $height ? "width=45" : "height=45";
                            $thumb = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\"><span onclick=\"xajax_cover_del('amend','".$sys->get['article_id']."','".$file_value['id']."','".$list."','".$prompt."');\" style=\"cursor:pointer;color:#EA7408;\"><img src=\"".$SETTING['dir_images_admin']."/icon_delete.gif\" alt=\"Delete\" /></span></td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;\"><img src=\"".$path.$file_value['filename']."\" ".$size." border=\"0\" align=\"absmiddle\" /></div></td></tr></table>\n";
                        }
                    }
                    if (empty($thumb)) {
                        $thumb = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr align=\"center\"><td width=\"30%\">&nbsp;</td><td width=\"70%\"><div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />缩略图</div></td></tr></table>\n";
                    }
                    $t->assign( $list, $thumb );

                    $attach_list            = "attach_list";
                    $attach_type            = "amend";
                    $attach_where           = "article_id=".$sys->get['article_id'];
                    $attach_table           = DB_TABLE_ARTICLE_ATTACH;
                    $attach_dir             = $SETTING['dir_article_attach'];
                    list($attach_list_result, $attach_list_result_js) = $sys->return_article_attach_list($attach_list,$attach_type,$attach_where,$attach_table,$attach_dir);
                    $attach_list_result_js  = trim($attach_list_result_js);
                    if (!empty($attach_list_result_js)) {
                        $attach_list_result     = $attach_list_result."\n<script type=\"text/javascript\">\n<!-- \n".$attach_list_result_js."\n //-->\n</script>\n";
                    }
                    $attach_select          = "attach_select";
                    $attach_select_result   = "<div style=\"border:1px solid #CCCCCC;background-color:#EEEEEE;width:45px;height:45px;\"><br />预览</div>\n";

                    $t->assign(array(
                        "attach_list_result"    => $attach_list_result,
                        "attach_select_result"  => $attach_select_result,

                        "select_option"         => $select_option,
                        "article_info"          => $article_info,
                        "setting_cover"         => $setting_cover,
                        "setting_attach"        => $setting_attach,
                    ));
                }
            }
        }
    }

}elseif($sys->get['ope'] == "savecover_upload"){
    $bwupload->lang_msg = array(
        '0'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['0'],
        '1'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['1'],
        '2'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['2'],
        '3'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['3'],
        '4'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['4'],
        '6'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['6'],
        '7'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['7'],
        '8'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['8'],
        'invalid'       => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['invalid'],
        'error_size'    => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['error_size'],
        'error_type'    => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['error_type'],
        'upload_failed' => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['upload_failed'],
        'error_empty'   => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['error_empty'],
    );
    $bwupload->set_size($setting_cover['size']);
    $bwupload->set_type($setting_cover['type']);

    $result_state   = "1";
    $error_msg      = "";

    if ($sys->get['type'] == "amend"){

        $article_id = $sys->get['article_id'];
        if (!preg_match("/^[1-9][0-9]*$/",$article_id)){
            $result_state = "0";
            $error_msg = "非法操作<!-- article_id error -->";
        } else {
            $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$article_id, "", "id DESC");
            if (count($filelist) > 1){
                $result = func::db_delete(DB_TABLE_ARTICLE_COVER, "article_id=".$article_id." AND id!=".$filelist[0]['id']);
                if (!$result) {
                    $result_state = "0";
                    $error_msg = "删除多余的记录失败<!-- delete excrescent error -->";
                }
            }
            if ($result_state == "1") {
                $file_value = $filelist[0];
                if (!empty($file_value['dir'])){
                    $dir    = $file_value['dir'];
                    $path   = $SETTING['dir_article_cover']."/".$dir;
                } else {
                    $dir    = $setting_cover['dir'];
                    $path   = $SETTING['dir_article_cover']."/".$dir;
                }
                if (!file_exists($path)) { func::make_dir($path); }

                if( !$bwupload->upload_file($path,"cover_upload") ){
                    $result_state = "0";
                    $error_msg = $bwupload->error_msg."<!-- upload error -->";
                }else{
                    $result_state = $bwupload->proceed['cover_upload']['succeed'];
                    $error_msg = $bwupload->proceed['cover_upload']['error']."<!-- upload error message -->";
                    if ($result_state == "1") {
                        if (!empty($file_value['filename'])){
                            if (file_exists($path.$file_value['filename'])) {
                                @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                                @unlink($path.$file_value['filename']);
                            }
                        }
                        $sql_data = array(
                            "dir"       => "'".$dir."'",
                            "filename"  => "'".$bwupload->proceed['cover_upload']['result_name']."'",
                            "article_id"   => "'".$article_id."'",
                            "admin_id"  => "'".$ADMIN['mid']."'",
                        );
                        if (count($filelist) > 0) {
                            $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "id=".$file_value['id']);
                        } else {
                            $result = func::db_insert(DB_TABLE_ARTICLE_COVER, $sql_data);
                        }
                        if (!$result) {
                            if (file_exists($path.$bwupload->proceed['cover_upload']['result_name'])) {
                                @chmod($path.$bwupload->proceed['cover_upload']['result_name'], $SETTING['chmod_mode_file']);
                                @unlink($path.$bwupload->proceed['cover_upload']['result_name']);
                            }
                            $result_state = "0";
                            $error_msg = "更新数据库失败<!-- upload db cover error -->";
                        }
                    }
                }
            }
        }
        $CONFIGURE['common']['if_output_template'] = "0";
        $prompt_style = $result_state == "1" ? "prompt_succeed" : "prompt_failed";
        $bwjs->write("parent.xajax_cover_upload_return('".$result_state."',
                   'amend',
                   '".$sys->get['article_id']."',
                   'article_amend',
                   'cover_upload_input',
                   '<input type=\"file\" id=\"cover_upload\" name=\"cover_upload\" size=\"30\" style=\"width:250px;\" class=\"input\" />',
                   'cover_upload_submit',
                   'cover_str',
                   'cover_upload_prompt',
                   '<span class=\"".$prompt_style."\">".$error_msg."</span>');");
    } else {

        $admin_id = $ADMIN['mid'];
        if (!preg_match("/^[1-9][0-9]*$/",$admin_id)){
            $result_state = "0";
            $error_msg = "非法操作<!-- admin_id error -->";
        } else {
            $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=0 AND admin_id=".$admin_id, "", "id DESC");
            if (count($filelist) > 1){
                $result = func::db_delete(DB_TABLE_ARTICLE_COVER, "article_id=0 AND admin_id=".$admin_id." AND id!=".$filelist[0]['id']);
                if (!$result) {
                    $result_state = "0";
                    $error_msg = "删除多余的记录失败<!-- delete excrescent error -->";
                }
            }
            if ($result_state == "1") {
                $file_value = $filelist[0];
                if (!empty($file_value['dir'])){
                    $dir    = $file_value['dir'];
                    $path   = $SETTING['dir_article_cover']."/".$dir;
                } else {
                    $dir    = $setting_cover['dir'];
                    $path   = $SETTING['dir_article_cover']."/".$dir;
                }
                if (!file_exists($path)) { func::make_dir($path); }

                if( !$bwupload->upload_file($path,"cover_upload") ){
                    $result_state = "0";
                    $error_msg = $bwupload->error_msg."<!-- upload error -->";
                }else{
                    $result_state = $bwupload->proceed['cover_upload']['succeed'];
                    $error_msg = $bwupload->proceed['cover_upload']['error']."<!-- upload error message -->";
                    if ($result_state == "1") {
                        if (!empty($file_value['filename'])){
                            if (file_exists($path.$file_value['filename'])) {
                                @chmod($path.$file_value['filename'], $SETTING['chmod_mode_file']);
                                @unlink($path.$file_value['filename']);
                            }
                        }
                        $sql_data = array(
                            "dir"       => "'".$dir."'",
                            "filename"  => "'".$bwupload->proceed['cover_upload']['result_name']."'",
                            "article_id"   => "'0'",
                            "admin_id"  => "'".$ADMIN['mid']."'",
                        );
                        if (count($filelist) > 0) {
                            $result = func::db_update(DB_TABLE_ARTICLE_COVER, $sql_data, "id=".$file_value['id']);
                        } else {
                            $result = func::db_insert(DB_TABLE_ARTICLE_COVER, $sql_data);
                        }
                        if (!$result) {
                            if (file_exists($path.$bwupload->proceed['cover_upload']['result_name'])) {
                                @chmod($path.$bwupload->proceed['cover_upload']['result_name'], $SETTING['chmod_mode_file']);
                                @unlink($path.$bwupload->proceed['cover_upload']['result_name']);
                            }
                            $result_state = "0";
                            $error_msg = "更新数据库失败<!-- upload db cover error -->";
                        }
                    }
                }
            }
        }
        $CONFIGURE['common']['if_output_template'] = "0";
        $prompt_style = $result_state == "1" ? "prompt_succeed" : "prompt_failed";
        $bwjs->write("parent.xajax_cover_upload_return('".$result_state."',
                   'add',
                   '".$ADMIN['mid']."',
                   'article_add',
                   'cover_upload_input',
                   '<input type=\"file\" id=\"cover_upload\" name=\"cover_upload\" size=\"30\" style=\"width:250px;\" class=\"input\" />',
                   'cover_upload_submit',
                   'cover_str',
                   'cover_upload_prompt',
                   '<span class=\"".$prompt_style."\">".$error_msg."</span>');");
    }

}elseif($sys->get['ope'] == "saveattach_upload"){
    $bwupload->lang_msg = array(
        '0'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['0'],
        '1'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['1'],
        '2'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['2'],
        '3'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['3'],
        '4'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['4'],
        '6'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['6'],
        '7'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['7'],
        '8'             => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['8'],
        'invalid'       => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['invalid'],
        'error_size'    => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['error_size'],
        'error_type'    => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['error_type'],
        'upload_failed' => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['upload_failed'],
        'error_empty'   => $LANGUAGE['s']['_public']['lib_class_bwupload_class']['error_empty'],
    );
    $bwupload->set_size($setting_attach['size']);
    $bwupload->set_type($setting_attach['type']);

    $result_state   = "1";
    $error_msg      = "";

    if ($sys->get['type'] == "amend"){

        $article_id = $sys->get['article_id'];
        if (!preg_match("/^[1-9][0-9]*$/",$article_id)){
            $result_state = "0";
            $error_msg = "非法操作<!-- article_id error -->";
        } else {
            $dir    = $setting_attach['dir'];
            $path   = $SETTING['dir_article_attach']."/".$dir;
            if (!file_exists($path)) { func::make_dir($path); }

            if( !$bwupload->upload_file($path,"attach_upload") ){
                $result_state = "0";
                $error_msg = $bwupload->error_msg."<!-- upload error -->";
            }else{
                $result_state = $bwupload->proceed['attach_upload']['succeed'];
                $error_msg = $bwupload->proceed['attach_upload']['error']."<!-- upload error message -->";
                if ($result_state == "1") {
                    $sql_data = array(
                        "brief"             => "'".addslashes($_POST['attach_brief'])."'",
                        "dir"               => "'".$dir."'",
                        "filename"          => "'".$bwupload->proceed['attach_upload']['result_name']."'",
                        "article_id"           => "'".(int)$sys->get['article_id']."'",
                        "admin_id"          => "'".(int)$ADMIN['mid']."'",
                        "time"              => $sys->nowtime,
                        "down"              => "0",
                    );
                    $result = func::db_insert(DB_TABLE_ARTICLE_ATTACH, $sql_data);
                    if (!$result) {
                        if (file_exists($path.$bwupload->proceed['attach_upload']['result_name'])) {
                            @chmod($path.$bwupload->proceed['attach_upload']['result_name'], $SETTING['chmod_mode_file']);
                            @unlink($path.$bwupload->proceed['attach_upload']['result_name']);
                        }
                        $result_state = "0";
                        $error_msg = "更新数据库失败<!-- upload db attach_name error -->";
                    }
                }
            }
            //$bwjs->write("parent.xajax_set_value('assign','test_output','".serialize($path)."');"); exit;
            //$ajax_response->alert(print_r($_POST, true)); return $ajax_response;
        }
        $CONFIGURE['common']['if_output_template'] = "0";
        $prompt_style = $result_state == "1" ? "prompt_succeed" : "prompt_failed";
        $bwjs->write("parent.xajax_attach_upload_return('".$result_state."',
            'amend',
            '".$article_id."',
            'article_amend',
            'attach_upload_input',
            '<input type=\"file\" id=\"attach_upload\" name=\"attach_upload\" size=\"12\" style=\"width:140px;\" class=\"input\" onchange=\"xajax_attach_showselect(\'attach_select\',\'attach_upload_prompt\',this.value)\" />',
            'attach_upload_submit',
            'attach_list',
            'attach_brief',
            'attach_select',
            'attach_upload_prompt',
            '<span class=\"".$prompt_style."\">".$error_msg."</span>');");
    } else {

        $admin_id = $ADMIN['mid'];
        if (!preg_match("/^[1-9][0-9]*$/",$admin_id)){
            $result_state = "0";
            $error_msg = "非法操作<!-- admin_id error -->";
        } else {
            $dir    = $setting_attach['dir'];
            $path   = $SETTING['dir_article_attach']."/".$dir;
            if (!file_exists($path)) { func::make_dir($path); }

            if( !$bwupload->upload_file($path,"attach_upload") ){
                $result_state = "0";
                $error_msg = $bwupload->error_msg."<!-- upload error -->";
            }else{
                $result_state = $bwupload->proceed['attach_upload']['succeed'];
                $error_msg = $bwupload->proceed['attach_upload']['error']."<!-- upload error message -->";
                if ($result_state == "1") {
                    $sql_data = array(
                        "brief"             => "'".addslashes($_POST['attach_brief'])."'",
                        "dir"               => "'".$dir."'",
                        "filename"          => "'".$bwupload->proceed['attach_upload']['result_name']."'",
                        "article_id"           => "'0'",
                        "admin_id"          => "'".(int)$ADMIN['mid']."'",
                        "time"              => $sys->nowtime,
                        "down"              => "0",
                    );
                    $result = func::db_insert(DB_TABLE_ARTICLE_ATTACH, $sql_data);
                    if (!$result) {
                        if (file_exists($path.$bwupload->proceed['attach_upload']['result_name'])) {
                            @chmod($path.$bwupload->proceed['attach_upload']['result_name'], $SETTING['chmod_mode_file']);
                            @unlink($path.$bwupload->proceed['attach_upload']['result_name']);
                        }
                        $result_state = "0";
                        $error_msg = "更新数据库失败<!-- upload db attach_name error -->";
                    }
                }
            }
        }
        $CONFIGURE['common']['if_output_template'] = "0";
        $prompt_style = $result_state == "1" ? "prompt_succeed" : "prompt_failed";
        $bwjs->write("parent.xajax_attach_upload_return('".$result_state."',
            'add',
            '".$admin_id."',
            'article_add',
            'attach_upload_input',
            '<input type=\"file\" id=\"attach_upload\" name=\"attach_upload\" size=\"12\" style=\"width:140px;\" class=\"input\" onchange=\"xajax_attach_showselect(\'attach_select\',\'attach_upload_prompt\',this.value)\" />',
            'attach_upload_submit',
            'attach_list',
            'attach_brief',
            'attach_select',
            'attach_upload_prompt',
            '<span class=\"".$prompt_style."\">".$error_msg."</span>');");
    }
}elseif($sys->get['ope'] == "if_enable"){
    // check the post
    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['article_id'])) {
        $sys->prompt("failed","非法操作!<!-- article_id error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_enable'])) {
        $sys->prompt("failed","非法操作!<!-- if_enable error -->");
    } else {

        if ( $ADMIN['ag_privilege']['article'] != "1" ) {
            $sys->prompt("failed","您没有权限进行此操作!<!-- privilege not allow -->");
        } else {

            $sql_data = array(
                "if_enable" => $sys->get['if_enable'],
            );
            $result = func::db_update(DB_TABLE_ARTICLE, $sql_data, "id='".$sys->get['article_id']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            }
        }
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=article&pag=".$sys->get['pag']);
   }

}elseif($sys->get['ope'] == "if_top"){
    // check the post
    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['article_id'])) {
        $sys->prompt("failed","非法操作!<!-- article_id error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_top'])) {
        $sys->prompt("failed","非法操作!<!-- if_top error -->");
    } else {

        if ( $ADMIN['ag_privilege']['article'] != "1" ) {
            $sys->prompt("failed","您没有权限进行此操作!<!-- privilege not allow -->");
        } else {

            $sql_data = array(
                "if_top" => $sys->get['if_top'],
            );
            $result = func::db_update(DB_TABLE_ARTICLE, $sql_data, "id='".$sys->get['article_id']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            }
        }
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=article&pag=".$sys->get['pag']);
   }

}elseif($sys->get['ope'] == "del"){
    // check the post
    if ( $ADMIN['ag_privilege']['article'] != "1" ) {
        $sys->prompt("failed","您没有权限进行此操作!<!-- privilege not allow -->");
    } else {

        $this_array = array();
        if (!empty($sys->get['article_id'])){
            if (is_array($sys->get['article_id'])) {
                foreach ($sys->get['article_id'] as $v) {
                    if (preg_match("/^[1-9][0-9]{0,10}$/",$v)) {
                        $this_array[$v] = $v;
                    }
                }
            } else {
                if (preg_match("/^[1-9][0-9]{0,10}$/",$sys->get['article_id'])) {
                    $this_array[$sys->get['article_id']] = $sys->get['article_id'];
                }
            }
        }
        if (!empty($sys->post['article_id'])){
            if (is_array($sys->post['article_id'])) {
                foreach ($sys->post['article_id'] as $v) {
                    if (preg_match("/^[1-9][0-9]{0,10}$/",$v)) {
                        $this_array[$v] = $v;
                    }
                }
            } else {
                if (preg_match("/^[1-9][0-9]{0,10}$/",$sys->post['article_id'])) {
                    $this_array[$sys->post['article_id']] = $sys->post['article_id'];
                }
            }
        }

        if (!empty($sys->get['choice'])){
            if (is_array($sys->get['choice'])) {
                foreach ($sys->get['choice'] as $v) {
                    if (preg_match("/^[1-9][0-9]{0,10}$/",$v)) {
                        $this_array[$v] = $v;
                    }
                }
            } else {
                if (preg_match("/^[1-9][0-9]{0,10}$/",$sys->get['choice'])) {
                    $this_array[$sys->get['choice']] = $sys->get['choice'];
                }
            }
        }
        if (!empty($sys->post['choice'])){
            if (is_array($sys->post['choice'])) {
                foreach ($sys->post['choice'] as $v) {
                    if (preg_match("/^[1-9][0-9]{0,10}$/",$v)) {
                        $this_array[$v] = $v;
                    }
                }
            } else {
                if (preg_match("/^[1-9][0-9]{0,10}$/",$sys->post['choice'])) {
                    $this_array[$sys->post['choice']] = $sys->post['choice'];
                }
            }
        }
        if (!empty($this_array)) {
            foreach ($this_array as $v) {
                $article_list = func::db_select(DB_TABLE_ARTICLE, "*", "id=".$v);
                $article_list = $article_list[0];
                if (!preg_match("/^[1-9][0-9]{0,10}$/",$article_list['id'])) {
                    $sys->prompt("failed","此公告不存在!<!-- id error -->");
                } else {

                    $this_article_id      = (int)$article_list['id'];

                    $result = func::db_delete(DB_TABLE_ARTICLE, "id=".$v."");
                    if (!$result) {
                        $sys->prompt("failed","公告删除失败!<!-- db_update failed -->");
                    } else {

                        $filelist = func::db_select(DB_TABLE_ARTICLE_COVER, "*", "article_id=".$this_article_id, "", "id DESC");
                        if (!empty($filelist)){
                            foreach($filelist as $file){
                                @chmod($SETTING['dir_article_cover']."/".$file['dir']."/".$file['filename'], $SETTING['chmod_mode_file']);
                                @unlink($SETTING['dir_article_cover']."/".$file['dir']."/".$file['filename']);
                            }
                            $result = func::db_delete(DB_TABLE_ARTICLE_COVER, "article_id=".$this_article_id."");
                            if (!$result) {
                                $sys->prompt("failed","封面数据库信息删除失败!<!-- DB_TABLE_ARTICLE_COVER delete failed -->");
                            }
                        }

                        $filelist = func::db_select(DB_TABLE_ARTICLE_ATTACH, "*", "article_id=".$this_article_id, "", "id DESC");
                        if (!empty($filelist)){
                            foreach($filelist as $file){
                                @chmod($SETTING['dir_article_attach']."/".$file['dir']."/".$file['filename'], $SETTING['chmod_mode_file']);
                                @unlink($SETTING['dir_article_attach']."/".$file['dir']."/".$file['filename']);
                            }
                            $result = func::db_delete(DB_TABLE_ARTICLE_ATTACH, "article_id=".$this_article_id."");
                            if (!$result) {
                                $sys->prompt("failed","附件数据库信息删除失败!<!-- DB_TABLE_ARTICLE_ATTACH delete failed -->");
                            }
                        }
                        $result = func::db_delete(DB_TABLE_ARTICLE, "id=".$this_article_id."");
                        if (!$result) {
                            $sys->prompt("failed","公告数据库信息删除失败!<!-- DB_TABLE_ARTICLE delete failed -->");
                        }
                        $result = func::db_delete(DB_TABLE_ARTICLE_DETAIL, "article_id=".$this_article_id."");
                        if (!$result) {
                            $sys->prompt("failed","公告详细信息数据库信息删除失败!<!-- DB_TABLE_ARTICLE_DETAIL delete failed -->");
                        }
                    }
                }
            }
        }
    }
    $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=article&pag=".$sys->get['pag']);

} else {

    $total_record = func::db_count_record(DB_TABLE_ARTICLE);
    $bwpage->set_record_listnum($CONFIG['page_record_article_list']);
    $bwpage->set_record($total_record);
    $bwpage->page($CONFIGURE['common']['control_admin']."?act=article&pag=%s");
    $sql = "SELECT article.*,
                cover.id as cover_id, cover.dir as cover_dir, cover.filename as cover_filename
            FROM ".DB_TABLE_ARTICLE." article
                LEFT JOIN ".DB_TABLE_ARTICLE_COVER." cover ON cover.article_id=article.id
            ORDER BY article.if_top, article.post_time DESC
            LIMIT ".$bwpage->record_listfirst.",".$bwpage->record_listnum;
    $result = &$db->Execute($sql);
    if (!$result) {
        echo $db->ErrorMsg();
    } else {
        while (!$result->EOF) {
            $article_list[$result->fields['id']] = array(
                'id'                    => $result->fields['id'],
                'phrase'                => $result->fields['phrase'],
                'phrase_len'            => mb_strwidth($result->fields['phrase'],"UTF-8"),
                'subject'               => $result->fields['subject'],
                'subject_len'           => mb_strwidth($result->fields['subject'],"UTF-8"),
                'prefix'                => $result->fields['prefix'],
                'color'                 => $result->fields['color'],
                'fontstyle'             => $result->fields['fontstyle'],
                'decoration'            => $result->fields['decoration'],
                'keyword'               => $result->fields['keyword'],
                'brief'                 => $result->fields['brief'],
                'post_id'               => $result->fields['post_id'],
                'post_username'         => $result->fields['post_username'],
                'post_ip'               => $result->fields['post_ip'],
                'post_time'             => $result->fields['post_time'],
                'amend_id'              => $result->fields['amend_id'],
                'amend_username'        => $result->fields['amend_username'],
                'amend_ip'              => $result->fields['amend_ip'],
                'amend_time'            => $result->fields['amend_time'],
                'click'                 => $result->fields['click'],
                'if_enable'             => $result->fields['if_enable'],
                'if_enable_begin'       => $result->fields['if_enable_begin'],
                'if_enable_end'         => $result->fields['if_enable_end'],
                'if_top'                => $result->fields['if_top'],
                'if_top_begin'          => $result->fields['if_top_begin'],
                'if_top_end'            => $result->fields['if_top_end'],
                'if_turn'               => $result->fields['if_turn'],
                'if_turn_type'          => $result->fields['if_turn_type'],
                'if_turn_url'           => $result->fields['if_turn_url'],

                'cover_id'              => $result->fields['cover_id'],
                'cover_dir'             => $result->fields['cover_dir'],
                'cover_filename'        => $result->fields['cover_filename'],
            );
            $result->MoveNext();
        }
    }

    $t->assign(array(
        "article_list"  => $article_list,
        "pagination"    => $bwpage->pagination,
    ));
}
?>
