<?php
/*
+-----------------------------------------------------------------------------+
| $Id: initialize.php 2010-05-24 12:37:44Z Bleakwind $
| Initialize SYSTEM
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')) {
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// Include all public files
include_once './config.php';

include_once './lib/class/bwsession.class.php';
include_once './lib/class/bwcookie.class.php';
include_once './lib/class/bwverify.class.php';
include_once './lib/class/bwcurve.class.php';
include_once './lib/class/bwupload.class.php';
include_once './lib/class/bwpage.class.php';
include_once './lib/class/bwbbcode.class.php';
include_once './lib/class/bwjs.class.php';

include_once './lib/smarty/Smarty.class.php';
include_once './lib/lib.mail.php';
include_once './lib/function.php';

// Include all private files
include_once './admin/source/lib/sys.class.php';
include_once './admin/source/lib/function.php';
include_once './admin/source/setting_database.php';
include_once './admin/source/configure.php';

// Set CONFIG_ROOTDIR
$page_http              = $_SERVER['HTTPS'] == "on" ? "https://" : "http://";
$page_server_name       = $_SERVER['SERVER_NAME'];
$page_ports             = $_SERVER['SERVER_PORT'] != "80" ? ":".$_SERVER['SERVER_PORT'] : "";
$PAGE_PATH['rootdir']   = $page_http.$page_server_name.$page_ports.substr($_SERVER['SCRIPT_NAME'],0,strrpos($_SERVER['SCRIPT_NAME'],'/')+1);
$PAGE_PATH['fulldir']   = $page_http.$page_server_name.$page_ports.$_SERVER['REQUEST_URI'];
if ( CONFIG_ROOT_ADMIN == "") {
    define('CONFIG_ROOTDIR', $PAGE_PATH['rootdir']);
} else {
    $parse_config_root = parse_url(CONFIG_ROOT_ADMIN);
    if (empty($parse_config_root['scheme'])) {
        $config_root = $page_http.CONFIG_ROOT_ADMIN;
    } else {
        $config_root = CONFIG_ROOT_ADMIN;
    }
    define('CONFIG_ROOTDIR', $config_root);
}

$new_template = null;

// Start the sys
$sys = new sys();
$sys->stand_url();
if (!preg_match("/^[a-z0-9_]{1,30}$/",$sys->get['act'])) {
    $sys->get['act'] = "index";
}

// Initialize db
include_once './lib/lib.database.php';

// Start the Session
$SESSION = & new bwsession(CONFIG_DB_HOSTNAME,
                         CONFIG_DB_USERNAME,
                         CONFIG_DB_PASSWORD,
                         CONFIG_DB_DATABASE,
                         CONFIG_DB_CHARSET,
                         DB_TABLE_SESSION);
// Start the Cookie
$c = new bwcookie($SESSION);
$c->set_cookie_params($CONFIGURE['sys']['cookie_lifetime'], $CONFIGURE['sys']['cookie_path'], $CONFIGURE['sys']['cookie_domain']);
$c->set_session_name($CONFIGURE['sys']['cookie_prefix']."sessid");
$c->set_check_cookie(array($CONFIGURE['sys']['cookie_prefix']."mid", $CONFIGURE['sys']['cookie_prefix']."musername"),
                     array("mid","musername"));
$c->start();
//$c->debug();

// Start the Session
$ASESSION = & new bwsession(CONFIG_DB_HOSTNAME,
                          CONFIG_DB_USERNAME,
                          CONFIG_DB_PASSWORD,
                          CONFIG_DB_DATABASE,
                          CONFIG_DB_CHARSET,
                          DB_TABLE_ADMIN_SESSION);
// Start the Cookie
$ac = new bwcookie($ASESSION);
$ac->set_cookie_params($CONFIGURE['sys']['cookie_lifetime'], $CONFIGURE['sys']['cookie_path'], $CONFIGURE['sys']['cookie_domain']);
$ac->set_session_name($CONFIGURE['sys']['cookie_prefix']."sessid");
$ac->set_check_cookie(array($CONFIGURE['sys']['cookie_prefix']."aid", $CONFIGURE['sys']['cookie_prefix']."ausername"),
                      array("aid", "ausername"));
$ac->start();
//$ac->debug();

// Get prompt_id
$prompt_id = $ASESSION->session_id;

// Auto run
$sys->auto_run();

// Get the Config setting
$sql = "SELECT name, value, if_multi FROM ".DB_TABLE_CONFIG." WHERE if_auto=1";
$result = &$db->Execute($sql);
if (!$result) {
    echo $db->ErrorMsg();
} else {
    while (!$result->EOF) {
        if ($result->fields['if_multi'] == "1") {
            $CONFIG[$result->fields['name']] = unserialize($result->fields['value']);
        } else {
            $CONFIG[$result->fields['name']] = $result->fields['value'];
        }
        $result->MoveNext();
    }
}

// Set default timezone
date_default_timezone_set($CONFIG['default_timezone']);
// Set encoding for multibyte regex
mb_regex_encoding("UTF-8");

// Get the Language
$sql = "SELECT *
        FROM ".DB_TABLE_ADMIN_LANGUAGE."
        ORDER BY rank, id";
$result = &$db->Execute($sql);
if (!$result) {
    echo $db->ErrorMsg();
} else {
    while (!$result->EOF) {
        $LANGLIST[$result->fields['id']]['id']    = $result->fields['id'];
        $LANGLIST[$result->fields['id']]['name']  = $result->fields['name'];
        $LANGLIST[$result->fields['id']]['code']  = $result->fields['code'];
        $LANGLIST[$result->fields['id']]['icon']  = $result->fields['icon'];
        $LANGLIST[$result->fields['id']]['dir']   = $result->fields['dir'];
        $LANGLIST[$result->fields['id']]['rank']  = $result->fields['rank'];
        $result->MoveNext();
    }
}

// Get the Template
$sql = "SELECT *
        FROM ".DB_TABLE_ADMIN_TEMPLATE."
        ORDER BY rank, id";
$result = &$db->Execute($sql);
if (!$result) {
    echo $db->ErrorMsg();
} else {
    while (!$result->EOF) {
        $TEMPLATE[$result->fields['id']]['id']    = $result->fields['id'];
        $TEMPLATE[$result->fields['id']]['name']  = $result->fields['name'];
        $TEMPLATE[$result->fields['id']]['dir']   = $result->fields['dir'];
        $TEMPLATE[$result->fields['id']]['rank']  = $result->fields['rank'];
        $result->MoveNext();
    }
}

// Set the Language
$CONFIG['language_admin'] = $CONFIG['default_language_admin'];
if ( preg_match("/^[0-9]{1,11}$/i",$sys->get['alang']) && array_key_exists($sys->get['alang'],$LANGLIST) ) {
    $ASESSION->set("language", $sys->get['alang']);
    $ASESSION->_['language'] = $sys->get['alang'];
}
if ( preg_match("/^[0-9]{1,11}$/i",$ASESSION->_['language'])
    && array_key_exists($ASESSION->_['language'],$LANGLIST)
    && file_exists('language/'.$LANGLIST[$ASESSION->_['language']]['dir'].'/source/_public.php') ) {
    $CONFIG['language_admin'] = $ASESSION->_['language'];
}
include_once './admin/language/'.$LANGLIST[$CONFIG['language_admin']]['dir'].'/source/_public.php';
include_once './admin/language/'.$LANGLIST[$CONFIG['language_admin']]['dir'].'/template/_public.php';
$current_lang_s = './admin/language/'.$LANGLIST[$CONFIG['language_admin']]['dir'].'/source/'.$sys->get['act'].'.php';
$current_lang_t = './admin/language/'.$LANGLIST[$CONFIG['language_admin']]['dir'].'/template/'.$sys->get['act'].'.php';
if ( file_exists($current_lang_s) ) { include_once $current_lang_s; }
if ( file_exists($current_lang_t) ) { include_once $current_lang_t; }
header('Content-Type: text/html; charset='.$LANGUAGE['s']['_public']['global']['charset']);

// Start the Template
$CONFIG['template_admin'] = $CONFIG['default_template'];
if ( preg_match("/^[0-9]{1,11}$/i",$sys->get['atpl']) && array_key_exists($sys->get['atpl'],$TEMPLATE) ) {
    $SESSION->set("template", $sys->get['atpl']);
    $SESSION->_['template_admin'] = $sys->get['atpl'];
}
if ( preg_match("/^[0-9]{1,11}$/i",$SESSION->_['template_admin'])
    && array_key_exists($SESSION->_['template_admin'],$TEMPLATE)
    && file_exists('template/'.$TEMPLATE[$SESSION->_['template_admin']]['dir']) ) {
    $CONFIG['template_admin'] = $SESSION->_['template_admin'];
}
$compile_dir_admin = "./admin/cache/compile/".$TEMPLATE[$CONFIG['template_admin']]['dir']."/";
$cache_dir_admin   = "./admin/cache/cache/".$TEMPLATE[$CONFIG['template_admin']]['dir']."/";
if (!file_exists($compile_dir_admin)) { func::make_dir($compile_dir_admin); }
if (!file_exists($cache_dir_admin))   { func::make_dir($cache_dir_admin); }
$t = new Smarty();
include_once './lib/function.smarty.php';
include_once './admin/source/lib/function.smarty.php';
$t->template_dir   = "./admin/template/".$TEMPLATE[$CONFIG['template_admin']]['dir']."/";
$t->compile_dir    = $compile_dir_admin;
$t->cache_dir      = $cache_dir_admin;
$t->compile_check  = true;
$t->cache_lifetime = 60;
//$t->caching        = true;
//$t->debugging      = true;

// ajax
include_once './lib/lib.ajax.php';
include_once './admin/source/lib/function.ajax.php';

// Upload
$bwupload = new bwupload();

// pagination
$bwpage = new bwpage();

// Start the javascript
$bwjs = new bwjs();

// Include Setting
include_once './admin/source/setting.php';

// Return ip
$sys->return_ip();
// Check login
$sys->check_login($ac);
// Forbid ip
$if_isset_ip = $sys->forbid_ip();

// Get the Member info
$MEMBER['iflogin']  = "0";
$ADMIN['iflogin']   = "0";
if ($c->iflogin() && $if_isset_ip != "1") {
    // Check if member login and get information
    $sql = "SELECT m.*, mg.*
            FROM ".DB_TABLE_MEMBER." m
            LEFT JOIN ".DB_TABLE_MEMBER_GROUP." mg ON mg.mg_type=m.mg_type
                AND (mg.mg_point_begin<=m.point || mg.mg_point_begin IS NULL)
                AND (mg.mg_point_end>=m.point || mg.mg_point_end IS NULL)
            WHERE m.id=".$SESSION->_['mid']."
            GROUP BY m.id";
    $result = &$db->Execute($sql);
    if (!$result) {
        $c->destroy();
        echo $db->ErrorMsg();
    } else {
        if (!$result->EOF) {
            $MEMBER = array(
                "id"                        => $result->fields['id'],
                "username"                  => $result->fields['username'],
                "email"                     => $result->fields['email'],
                "card"                      => $result->fields['card'],
                "password"                  => $result->fields['password'],
                "question_type"             => $result->fields['question_type'],
                "question"                  => $result->fields['question'],
                "answer"                    => $result->fields['answer'],
                "mg_type"                   => $result->fields['mg_type'],
                "mg_type_expired"           => $result->fields['mg_type_expired'],
                "silver"                    => $result->fields['silver'],
                "offer"                     => $result->fields['offer'],
                "point"                     => $result->fields['point'],
                "bonus"                     => $result->fields['bonus'],
                "pile1"                     => $result->fields['pile1'],
                "pile2"                     => $result->fields['pile2'],
                "pile3"                     => $result->fields['pile3'],
                "pile4"                     => $result->fields['pile4'],
                "pile5"                     => $result->fields['pile5'],
                "pile6"                     => $result->fields['pile6'],
                "active_id"                 => $result->fields['active_id'],
                "if_active"                 => $result->fields['if_active'],
                "if_enable"                 => $result->fields['if_enable'],
                "if_email"                  => $result->fields['if_email'],
                "ip_active"                 => $result->fields['ip_active'],
                "ip_created"                => $result->fields['ip_created'],
                "ip_change"                 => $result->fields['ip_change'],
                "ip_lastvisit"              => $result->fields['ip_lastvisit'],
                "time_active"               => $result->fields['time_active'],
                "time_created"              => $result->fields['time_created'],
                "time_change"               => $result->fields['time_change'],
                "time_lastvisit"            => $result->fields['time_lastvisit'],
                "cumulant_silver"           => $result->fields['cumulant_silver'],
                "cumulant_online"           => $result->fields['cumulant_online'],

                'mg_id'                     => $result->fields['mg_id'],
                'mg_type'                   => $result->fields['mg_type'],
                'mg_point_begin'            => $result->fields['mg_point_begin'],
                'mg_point_end'              => $result->fields['mg_point_end'],
                'mg_ag_id'                  => $result->fields['mg_ag_id'],
                'mg_name'                   => $result->fields['mg_name'],
                'mg_brief'                  => $result->fields['mg_brief'],
                'mg_icon'                   => $result->fields['mg_icon'],
                'mg_privilege'              => unserialize($result->fields['mg_privilege']),
                'mg_fileallow'              => unserialize($result->fields['mg_fileallow']),
                'mg_if_enable'              => $result->fields['mg_if_enable'],
                'mg_rank'                   => $result->fields['mg_rank'],
            );
            $MEMBER['iflogin'] = "1";
            if ($MEMBER['mg_type_expired'] > 0) {
                if ($sys->check_member_group($MEMBER['id'], $MEMBER['mg_type_expired'])) {
                    $MEMBER['mg_type']                  = $CONFIG['default_group_member'];
                    $MEMBER['mg_type_expired']  = 0;
                    $this_member_group = $sys->return_member_group($MEMBER['mg_type'], $MEMBER['point'], "*");
                    $MEMBER['mg_id']                    = $this_member_group['mg_id'];
                    $MEMBER['mg_type']                  = $this_member_group['mg_type'];
                    $MEMBER['mg_point_begin']           = $this_member_group['mg_point_begin'];
                    $MEMBER['mg_point_end']             = $this_member_group['mg_point_end'];
                    $MEMBER['mg_ag_id']                 = $this_member_group['mg_ag_id'];
                    $MEMBER['mg_name']                  = $this_member_group['mg_name'];
                    $MEMBER['mg_brief']                 = $this_member_group['mg_brief'];
                    $MEMBER['mg_icon']                  = $this_member_group['mg_icon'];
                    $MEMBER['mg_privilege']             = unserialize($this_member_group['mg_privilege']);
                    $MEMBER['mg_fileallow']             = unserialize($this_member_group['mg_fileallow']);
                    $MEMBER['mg_if_enable']             = $this_member_group['mg_if_enable'];
                    $MEMBER['mg_rank']                  = $this_member_group['mg_rank'];
                }
            }
        }
    }
    if ($MEMBER['iflogin'] == "1") {
        // Check if admin login and get information
        if ($ac->iflogin()) {
            if(preg_match("/^[1-9][0-9]{0,10}$/i",$MEMBER['mg_ag_id'])) {
                $sql = "SELECT * FROM ".DB_TABLE_ADMIN."
                        WHERE mid=".$MEMBER['id']."";
                $result = &$db->Execute($sql);
                if (!$result) {
                    echo $db->ErrorMsg();
                } else {
                    if (!$result->EOF) {
                        $ADMIN['mid']               = $result->fields['mid'];
                        $ADMIN['ag_id']             = $result->fields['ag_id'];
                        $ADMIN['history']           = $result->fields['history'];
                        $ADMIN['process']           = $result->fields['process'];
                        $ADMIN['ip_created']        = $result->fields['ip_created'];
                        $ADMIN['ip_change']         = $result->fields['ip_change'];
                        $ADMIN['ip_lastvisit']      = $result->fields['ip_lastvisit'];
                        $ADMIN['time_created']      = $result->fields['time_created'];
                        $ADMIN['time_change']       = $result->fields['time_change'];
                        $ADMIN['time_lastvisit']    = $result->fields['time_lastvisit'];
                        $ADMIN['cumulant_online']   = $result->fields['cumulant_online'];
                    } else {
                        $sql = "INSERT INTO ".DB_TABLE_ADMIN." SET
                                   mid  = '".$MEMBER['id']."'";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            echo $db->ErrorMsg();
                        } else {
                            $ADMIN['mid']           = $MEMBER['id'];
                        }
                    }
                }
                $sql = "SELECT * FROM ".DB_TABLE_ADMIN_GROUP." WHERE ag_id=".$MEMBER['mg_ag_id']."";
                $result = &$db->Execute($sql);
                if (!$result) {
                    $c->destroy();
                    echo $db->ErrorMsg();
                } else {
                    if (!$result->EOF) {
                        $ADMIN['ag_id']            = $result->fields['ag_id'];
                        $ADMIN['ag_name']          = $result->fields['ag_name'];
                        $ADMIN['ag_brief']         = $result->fields['ag_brief'];
                        $ADMIN['ag_privilege']     = unserialize($result->fields['ag_privilege']);
                        $ADMIN['ag_fileallow']     = unserialize($result->fields['ag_fileallow']);
                        $ADMIN['ag_rank']          = $result->fields['ag_rank'];
                        $ADMIN['ag_if_enable']     = $result->fields['ag_if_enable'];
                        $ADMIN['iflogin'] = "1";
                    }
                }
            }
            if ($ADMIN['iflogin'] == "1") {
                // Member some update
                $str_where      = "";
                $time_lastvisit = $sys->nowtime - $ADMIN['time_lastvisit'];
                if ( $time_lastvisit < $CONFIG['time_online_admin'] ) {
                    $str_where .= "cumulant_online =cumulant_online+".$time_lastvisit.",";
                }
                $sql = "UPDATE ".DB_TABLE_ADMIN." SET
                            ".$str_where."
                            ip_lastvisit   = '".func::return_ip()."',
                            time_lastvisit = ".$sys->nowtime."
                        WHERE id=".$ADMIN['mid']."";
                $db->Execute($sql);
                if (!$result) {
                    echo $db->ErrorMsg();
                }
                // Check member
                if ($sys->get['act'] != "prompt"
                    && $sys->get['act'] != "login"
                    && !in_array($sys->get['act'], $SYSCHECK['list_except_member']) ) {
                    if($MEMBER['if_active'] != "1") {
                        $sys->prompt("failed",$LANGUAGE['s']['_public']['source_initialize']['member_if_active_no']."<!-- member_if_active_no -->");
                    } elseif($MEMBER['if_enable'] != "1") {
                        $sys->prompt("failed",$LANGUAGE['s']['_public']['source_initialize']['member_if_enable_no']."<!-- member_if_enable_no -->");
                    }
                }
            }
        }
    }
}

if($if_isset_ip == "1") {
    $sql = "SELECT *
            FROM ".DB_TABLE_MEMBER_GROUP."
            WHERE mg_type='".$CONFIG['default_group_forbidip']."'
            ORDER BY mg_rank";
    $result = &$db->Execute($sql);
    if (!$result) {
        echo $db->ErrorMsg();
    } else {
        if (!$result->EOF) {
            $MEMBER['mg_id']            = $result->fields['mg_id'];
            $MEMBER['mg_type']          = $result->fields['mg_type'];
            $MEMBER['mg_point_begin']   = $result->fields['mg_point_begin'];
            $MEMBER['mg_point_end']     = $result->fields['mg_point_end'];
            $MEMBER['mg_ag_id']         = $result->fields['mg_ag_id'];
            $MEMBER['mg_name']          = $result->fields['mg_name'];
            $MEMBER['mg_brief']         = $result->fields['mg_brief'];
            $MEMBER['mg_icon']          = $result->fields['mg_icon'];
            $MEMBER['mg_privilege']     = unserialize($result->fields['mg_privilege']);
            $MEMBER['mg_fileallow']     = unserialize($result->fields['mg_fileallow']);
            $MEMBER['mg_if_enable']     = $result->fields['mg_if_enable'];
            $MEMBER['mg_rank']          = $result->fields['mg_rank'];
        }
    }
}

if ($MEMBER['mg_privilege']['if_forbidvisit'] == "1"
    && $sys->get['act'] != "login"
    && !in_array($sys->get['act'], $SYSCHECK['list_except_member'])) {
    $sys->get['act'] = "prompt_forbid";
}

// Check admin iflogin
if($ADMIN['iflogin'] != "1") {
    if ($sys->get['act'] != "login") {
        $returnurl      = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        $login_warning  = "非法操作,请您重新登录!<!-- ".$sys->get['act']." error for admin information -->";
        if (in_array($sys->get['act'], $SYSCHECK['list_login_admin'])) {
            $sys->prompt("jump", $CONFIGURE['common']['control_admin']."?act=login&msg=".htmlentities(urlencode($login_warning))."&ret=".htmlentities(urlencode($returnurl)));
            exit;
        }
    }
}

// Check fileallow
$sys->check_fileallow();

// BBCODE
$bwbbcode = new bwbbcode();
$bwbbcode->add_tag(array('bw_bb_name'       => 'b',
                         'bw_html_begin'    => '<span style="font-weight: bold;">',
                         'bw_html_end'      => '</span>'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'i',
                         'bw_html_begin'    => '<span style="font-style: italic;">',
                         'bw_html_end'      => '</span>'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'u',
                         'bw_html_begin'    => '<span style="text-decoration: underline;">',
                         'bw_html_end'      => '</span>'));
$bwbbcode->add_tag(array('bw_bb_name'       => 's',
                         'bw_html_begin'    => '<span style="text-decoration: line-through;">',
                         'bw_html_end'      => '</span>'));

$bwbbcode->add_tag(array('bw_bb_name'       => 'font',
                         'bw_html_begin'    => '<span style="font-family: #p#;">',
                         'bw_html_end'      => '</span>',
                         'bw_if_param'      => 'yes',
                         'bw_param_regex'   => '[a-zA-Z0-9- ]{1,30}'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'size',
                         'bw_html_begin'    => '<span style="font-size: #p#px;">',
                         'bw_html_end'      => '</span>',
                         'bw_if_param'      => 'yes',
                         'bw_param_regex'   => '[1-5][0-9]'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'color',
                         'bw_html_begin'    => '<span style="color: #p#;">',
                         'bw_html_end'      => '</span>',
                         'bw_if_param'      => 'yes',
                         'bw_param_regex'   => '#?[a-zA-Z0-9]{1,30}',
                         'bw_param_replace' => array('/^(#?[a-zA-Z0-9]{1,30})$/' => '$1')));
$bwbbcode->add_tag(array('bw_bb_name'       => 'bgcolor',
                         'bw_html_begin'    => '<span style="background-color: #p#;">',
                         'bw_html_end'      => '</span>',
                         'bw_if_param'      => 'yes',
                         'bw_param_regex'   => '#?[a-zA-Z0-9]{1,30}',
                         'bw_param_replace' => array('/^(#?[a-zA-Z0-9]{1,30})$/' => '$1')));
$bwbbcode->add_tag(array('bw_bb_name'       => 'align',
                         'bw_html_begin'    => '<div style="text-align: #p#;">',
                         'bw_html_end'      => '</div>',
                         'bw_if_param'      => 'yes',
                         'bw_param_regex'   => '(left|right|center)'));

$bwbbcode->add_tag(array('bw_bb_name'       => 'quote',
                         'bw_html_begin'    => '<div class="block_quote"><div class="block_quote_title">引用:</div><div class="block_quote_content">',
                         'bw_html_end'      => '</div></div>'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'code',
                         'bw_html_begin'    => '<div id="block_code_#s#" class="block_code"><div class="block_code_title"><span class="block_code_title_left">代码:</span><span title="复制代码" class="block_code_title_right"></span></div><div class="block_code_content">',
                         'bw_html_end'      => '</div></div>',
                         'bw_value_replace' => 'handle_code'));

$bwbbcode->add_tag(array('bw_bb_name'       => 'url',
                         'bw_html_begin'    => '<a href="#p#" target="_blank">',
                         'bw_html_end'      => '</a>',
                         'bw_if_param'      => 'both'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'email',
                         'bw_html_begin'    => '<a href="mailto: #p#">',
                         'bw_html_end'      => '</a>',
                         'bw_if_param'      => 'both'));
$bwbbcode->add_tag(array('bw_bb_name'       => 'img',
                         'bw_html_begin'    => '<img src="#v#" border="0" />',
                         'bw_html_end'      => '',
                         'bw_if_param'      => 'no',
                         'bw_if_value'      => 'no'));

$bwbbcode->add_alias('link','url');
$bwbbcode->add_code_copyfun("function bbcode_code_get(serial) { return $('#'+serial).val(); } function bbcode_code_ret(serial) { alert('复制成功...'); return; }\n");

// Update session
if (!in_array($sys->get['act'], $SYSCHECK['list_except_admin'])) {
    $session_update = array(
        'time'  => $sys->nowtime,
        'ip'    => func::return_ip(),
        'act'   => $sys->get['act'],
    );
    $SESSION->set($session_update);
    $ASESSION->set($session_update);
}

// Get ths prompt message
$sql = "SELECT * FROM ".DB_TABLE_PROMPT." WHERE prompt_id='".$prompt_id."'";
$result = &$db->Execute($sql);
if (!$result) {
    echo $db->ErrorMsg();
} else {
    if (!$result->EOF) {
        $PROMPT['prompt_type']       = $result->fields['prompt_type'];
        $PROMPT['prompt_if']         = $result->fields['prompt_if'];
        $PROMPT['prompt_message']    = $result->fields['prompt_message'];
        $PROMPT['prompt_returnurl']  = $result->fields['prompt_returnurl'];
        $PROMPT['prompt_returntext'] = $result->fields['prompt_returntext'];
        $PROMPT['prompt_image']      = $result->fields['prompt_image'];
        $PROMPT['prompt_act']        = $result->fields['prompt_act'];
    } else {
        $sql = "DELETE FROM ".DB_TABLE_PROMPT." WHERE prompt_time<".($sys->nowtime - $CONFIGURE['sys']['lifetime'])."";
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }
        $sql = "INSERT INTO ".DB_TABLE_PROMPT." SET prompt_id='".$prompt_id."'";
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }
    }
    if (!in_array($sys->get['act'], $SYSCHECK['list_except_admin'])) {
        $sql = "UPDATE ".DB_TABLE_PROMPT." SET
                    prompt_time='".$sys->nowtime."'
                WHERE prompt_id='".$prompt_id."'";
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }
    }
}

// Jump message
if($PROMPT['prompt_type'] == "jump") {
    if($PROMPT['prompt_if'] == "1") {
        $t->assign(array(
            "prompt_message" => $PROMPT['prompt_message'],
        ));
    }
}

// Delete Prompt
if( ($PROMPT['prompt_act'] != "") && ($PROMPT['prompt_act'] != $sys->get['act']) ) {
    if (!in_array($sys->get['act'], $SYSCHECK['list_except_admin'])) {
        $sys->set_prompt();
    }
}

// Other include
include_once './admin/source/box.php';
?>
