<?php
/*
+-----------------------------------------------------------------------------+
| $Id: function.smarty.php 2010-05-24 11:45:43Z Bleakwind $
| Private Smarty function
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_article_info.php
 * Type:     function
 * Name:     return_article_info
 * Purpose:  return article_info
 * -------------------------------------------------------------
 */
function smarty_function_return_article_info($params, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'article_id':
                $article_id = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_article_info: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[0-9a-z_]{1,30}$/i", $item)) {
        $smarty->trigger_error("return_article_info: missing 'item' attribute");
    }
    if ( $article_id == "0") {
        $smarty->trigger_error("return_article_info: missing 'article_id' attribute");
    }
    $smarty->assign($item, $sys->return_article_info($article_id));
    return;
}
$t->register_function("return_article_info", "smarty_function_return_article_info");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_article_list.php
 * Type:     function
 * Name:     return_article_list
 * Purpose:  return article_list
 * -------------------------------------------------------------
 */
function smarty_function_return_article_list($params, &$smarty)
{
    global $sys;
    $_output            = '';
    $condition          = array();
    $list_article_id  = array();

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'article_id':
                $article_id = (string)$_val;
                break;
            case 'except_article_id':
                $except_article_id = (string)$_val;
                break;
            case 'cover':
                $cover = (int)$_val;
                break;
            case 'if_top':
                $if_top = (int)$_val;
                break;
            case 'limit':
                $limit = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_article_list: unknown attribute '$_key'");
        }
    }
    if (empty($item)) {
        $smarty->trigger_error("return_article_list: missing 'item' attribute");
    }

    $condition['article_id']        = $article_id;
    $condition['except_article_id'] = $except_article_id;
    $condition['cover']             = $cover;
    $condition['if_top']            = $if_top;

    $list = $sys->return_article_list($limit, $condition);
    if (!empty($list)) {
        foreach ($list as $v) {
            $list_article_id[] = $v['id'];
        }
    }
    $smarty->assign($item, $list);
    if (!empty($list_article_id)) {
        $smarty->assign($item."_id", implode(",", $list_article_id));
    }
    return;
}
$t->register_function("return_article_list", "smarty_function_return_article_list");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_datum_info.php
 * Type:     function
 * Name:     return_datum_info
 * Purpose:  return datum_info
 * -------------------------------------------------------------
 */
function smarty_function_return_datum_info($params, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'datum_id':
                $datum_id = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_datum_info: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[0-9a-z_]{1,30}$/i", $item)) {
        $smarty->trigger_error("return_datum_info: missing 'item' attribute");
    }
    if ( $datum_id == "0") {
        $smarty->trigger_error("return_datum_info: missing 'datum_id' attribute");
    }
    $smarty->assign($item, $sys->return_datum_info($datum_id));
    return;
}
$t->register_function("return_datum_info", "smarty_function_return_datum_info");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_datum_list.php
 * Type:     function
 * Name:     return_datum_list
 * Purpose:  return datum_list
 * -------------------------------------------------------------
 */
function smarty_function_return_datum_list($params, &$smarty)
{
    global $sys;
    $_output            = '';
    $condition          = array();
    $list_datum_id      = array();

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'datum_id':
                $datum_id = (string)$_val;
                break;
            case 'except_datum_id':
                $except_datum_id = (string)$_val;
                break;
            case 'cover':
                $cover = (int)$_val;
                break;
            case 'if_top':
                $if_top = (int)$_val;
                break;
            case 'limit':
                $limit = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_datum_list: unknown attribute '$_key'");
        }
    }
    if (empty($item)) {
        $smarty->trigger_error("return_datum_list: missing 'item' attribute");
    }

    $condition['datum_id']          = $datum_id;
    $condition['except_datum_id']   = $except_datum_id;
    $condition['cover']             = $cover;
    $condition['if_top']            = $if_top;

    $list = $sys->return_datum_list($limit, $condition);
    if (!empty($list)) {
        foreach ($list as $v) {
            $list_datum_id[] = $v['id'];
        }
    }
    $smarty->assign($item, $list);
    if (!empty($list_datum_id)) {
        $smarty->assign($item."_id", implode(",", $list_datum_id));
    }
    return;
}
$t->register_function("return_datum_list", "smarty_function_return_datum_list");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_content_info.php
 * Type:     function
 * Name:     return_content_info
 * Purpose:  return content_info
 * -------------------------------------------------------------
 */
function smarty_function_return_content_info($params, &$smarty)
{
    global $sys;
    $_output = '';
    $content_info = array();

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'act':
                $act = (string)$_val;
                break;
            case 'scheduler_id':
                $scheduler_id = (string)$_val;
                break;
            case 'except_scheduler_id':
                $except_scheduler_id = (string)$_val;
                break;
            case 'content_id':
                $content_id = (string)$_val;
                break;
            case 'except_content_id':
                $except_content_id = (string)$_val;
                break;
            case 'channel_id':
                $channel_id = (string)$_val;
                break;
            case 'prefix':
                $prefix = (int)$_val;
                break;
            case 'if_top':
                $if_top = (int)$_val;
                break;
            case 'cover':
                $cover = (int)$_val;
                break;
            case 'rank':
                $rank = (int)$_val;
                break;
            case 'click':
                $click = (int)$_val;
                break;
            case 'rand':
                $rand = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_content_info: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[0-9a-z_]{1,30}$/i", $item)) {
        $smarty->trigger_error("return_content_info: missing 'item' attribute");
    }

    if (preg_match("/^[1-9][0-9]{0,10}$/i", $scheduler_id)) {
        $sys->clean_model_info();
        $content_info = $sys->return_content_info($scheduler_id);
        if ($act == "jump") {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=content&scheduler_id=".$content_info['scheduler_id']."");
        } else {
            $smarty->assign($item, $content_info);
        }
    } elseif (preg_match("/^[1-9][0-9]{0,10}$/i", $content_id) || preg_match("/^[0-9,]+$/i", $channel_id) ) {
        $condition['except_scheduler_id']   = $except_scheduler_id;
        $condition['content_id']            = $content_id;
        $condition['except_content_id']     = $except_content_id;
        $condition['channel_id']            = $channel_id;
        $condition['prefix']                = $prefix;
        $condition['if_top']                = $if_top;
        $condition['cover']                 = $cover;
        $condition['rank']                  = $rank;
        $condition['click']                 = $click;
        $condition['rand']                  = $rand;
        $content_list = $sys->return_content_list("1", $condition);
        if (preg_match("/^[1-9][0-9]{0,10}$/i",$content_list[0]['scheduler_id'])) {
            if ($act == "jump") {
                $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=content&scheduler_id=".$content_list[0]['scheduler_id']."");
            } else {
                $sys->clean_model_info();
                $content_info = $sys->return_content_info($content_list[0]['scheduler_id']);
                $smarty->assign($item, $content_info);
            }
        } else {
            $smarty->assign($item, $content_info);
        }
    } else {
        $smarty->trigger_error("return_content_info: missing 'scheduler_id|content_id' attribute");
    }
    return;
}
$t->register_function("return_content_info", "smarty_function_return_content_info");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_content_list.php
 * Type:     function
 * Name:     return_content_list
 * Purpose:  return content_list
 * -------------------------------------------------------------
 */
function smarty_function_return_content_list($params, &$smarty)
{
    global $sys;
    $_output            = '';
    $condition          = array();
    $list_content_id    = array();

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'scheduler_id':
                $scheduler_id = (string)$_val;
                break;
            case 'except_scheduler_id':
                $except_scheduler_id = (string)$_val;
                break;
            case 'content_id':
                $content_id = (string)$_val;
                break;
            case 'except_content_id':
                $except_content_id = (string)$_val;
                break;
            case 'channel_id':
                $channel_id = (string)$_val;
                break;
            case 'prefix':
                $prefix = (int)$_val;
                break;
            case 'if_enable':
                $if_enable = (int)$_val;
                break;
            case 'if_top':
                $if_top = (int)$_val;
                break;
            case 'if_view':
                $if_view = (int)$_val;
                break;
            case 'if_inerface':
                $if_inerface = (int)$_val;
                break;
            case 'if_turn':
                $if_turn = (int)$_val;
                break;
            case 'if_turn_type':
                $if_turn_type = (int)$_val;
                break;
            case 'cover':
                $cover = (int)$_val;
                break;
            case 'rank':
                $rank = (int)$_val;
                break;
            case 'click':
                $click = (int)$_val;
                break;
            case 'rand':
                $rand = (int)$_val;
                break;
            case 'limit':
                $limit = (int)$_val;
                break;
            case 'page_item':
                $page_item = (string)$_val;
                break;
            case 'page_current':
                $page_current = (int)$_val;
                break;
            case 'page_listnum':
                $page_listnum = (int)$_val;
                break;
            case 'page_url':
                $page_url = (string)$_val;
                break;
            default:
                $smarty->trigger_error("return_content_list: unknown attribute '$_key'");
        }
    }
    if (empty($item)) {
        $smarty->trigger_error("return_content_list: missing 'item' attribute");
    }

    $condition['scheduler_id']          = $scheduler_id;
    $condition['except_scheduler_id']   = $except_scheduler_id;
    $condition['content_id']            = $content_id;
    $condition['except_content_id']     = $except_content_id;
    $condition['channel_id']            = $channel_id;
    $condition['prefix']                = $prefix;
    $condition['if_enable']             = $if_enable;
    $condition['if_top']                = $if_top;
    $condition['if_view']               = $if_view;
    $condition['if_inerface']           = $if_inerface;
    $condition['if_turn']               = $if_turn;
    $condition['if_turn_type']          = $if_turn_type;
    $condition['cover']                 = $cover;
    $condition['rank']                  = $rank;
    $condition['click']                 = $click;
    $condition['rand']                  = $rand;
    $condition['page_item']             = preg_match("/^[a-z0-9_]+$/i", $page_item) ? $page_item : "pagination_".$item;
    $condition['page_current']          = preg_match("/^[1-9][0-9]{0,10}$/i", $page_current) ? $page_current : "1";
    $condition['page_listnum']          = preg_match("/^[1-9][0-9]{0,10}$/i", $page_listnum) ? $page_listnum : $CONFIG['page_record_content_list'];
    $condition['page_url']              = $page_url;

    $list = $sys->return_content_list($limit, $condition);
    if (!empty($list)) {
        foreach ($list as $v) {
            $list_content_id[] = $v['id'];
        }
    }
    $smarty->assign($item, $list);
    if (is_array($list_content_id) && count($list_content_id) > 0) {
        $smarty->assign($item."_id", implode(",", $list_content_id));
    }
    return;
}
$t->register_function("return_content_list", "smarty_function_return_content_list");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_channel_info.php
 * Type:     function
 * Name:     return_channel_info
 * Purpose:  return channel_info
 * -------------------------------------------------------------
 */
function smarty_function_return_channel_info($params, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'channel_id':
                $channel_id = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_channel_info: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[0-9a-z_]{1,30}$/i", $item)) {
        $smarty->trigger_error("return_channel_info: missing 'item' attribute");
    }
    if ( $channel_id == "0") {
        $smarty->trigger_error("return_channel_info: missing 'channel_id' attribute");
    }
    $smarty->assign($item, $sys->return_channel_info($channel_id));
    return;
}
$t->register_function("return_channel_info", "smarty_function_return_channel_info");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_channel_list.php
 * Type:     function
 * Name:     return_channel_list
 * Purpose:  return channel_list
 * -------------------------------------------------------------
 */
function smarty_function_return_channel_list($params, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'upper_id':
                $upper_id = (int)$_val;
                break;
            case 'allsub':
                $allsub = (int)$_val;
                break;
            case 'if_enable':
                $if_enable = (int)$_val;
                break;
            case 'if_show':
                $if_show = (int)$_val;
                break;
            case 'if_add':
                $if_add = (int)$_val;
                break;
            case 'if_splitword':
                $if_splitword = (int)$_val;
                break;
            case 'if_recommend':
                $if_recommend = (int)$_val;
                break;
            case 'if_view':
                $if_view = (int)$_val;
                break;
            case 'if_inerface':
                $if_inerface = (int)$_val;
                break;
            case 'if_turn':
                $if_turn = (int)$_val;
                break;
            case 'if_turn_type':
                $if_turn_type = (int)$_val;
                break;
            case 'rank':
                $rank = (int)$_val;
                break;
            case 'limit':
                $limit = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_channel_list: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[0-9a-z_]{1,30}$/i", $item)) {
        $smarty->trigger_error("return_channel_list: missing 'item' attribute");
    }
    $condition['allsub']            = $allsub;
    $condition['if_enable']         = $if_enable;
    $condition['if_show']           = $if_show;
    $condition['if_add']            = $if_add;
    $condition['if_splitword']      = $if_splitword;
    $condition['if_recommend']      = $if_recommend;
    $condition['if_view']           = $if_view;
    $condition['if_inerface']       = $if_inerface;
    $condition['if_turn']           = $if_turn;
    $condition['if_turn_type']      = $if_turn_type;
    $condition['rank']              = $rank;

    $smarty->assign($item, $sys->return_channel_list($upper_id, $limit, $condition));
    return;
}
$t->register_function("return_channel_list", "smarty_function_return_channel_list");

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.return_channel_manage.php
 * Type:     function
 * Name:     return_channel_manage
 * Purpose:  return_channel_manage
 * -------------------------------------------------------------
 */
function smarty_function_return_channel_manage($params, &$smarty)
{
    global $sys;
    $_output = '';

    foreach ($params as $_key => $_val) {
        switch ($_key) {
            case 'item':
                $item = (string)$_val;
                break;
            case 'channel_id':
                $channel_id = (int)$_val;
                break;
            default:
                $smarty->trigger_error("return_channel_manage: unknown attribute '$_key'");
        }
    }
    if (!preg_match("/^[0-9a-z_]{1,30}$/i", $item)) {
        $smarty->trigger_error("return_channel_manage: missing 'item' attribute");
    }
    if ( $channel_id == "0") {
        $smarty->trigger_error("return_channel_manage: missing 'channel_id' attribute");
    }
    $smarty->assign($item, $sys->return_channel_manage($channel_id));
    return;
}
$t->register_function("return_channel_manage", "smarty_function_return_channel_manage");
?>