<?php
/*
+-----------------------------------------------------------------------------+
| $Id: login.php 2010-05-24 12:37:44Z Bleakwind $
| Login for admin
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// Member login
function login_admin($value, $submit)
{
    global $SETTING,$LANGUAGE,$CONFIG,$CONFIGURE,$ASESSION,$PROMPT,$db,$sys,$c,$ac;
    $ajax_response = new xajaxResponse();
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    $error  = false;
    $aid    = "";
    $ausername    = "";

    if ( empty($value['verifycode']) || (strtolower($value['verifycode']) != strtolower($ASESSION->_['vc_login'])) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<div class=\"prompt_failed\">验证码错误!</div>";
            $ajax_response->script("xajax_switch_verifycode('vc_login_show','".$CONFIGURE['common']['control_admin']."','vc_login');");
        }
    }

    if ( empty($value['password']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<div class=\"prompt_failed\">密码必须填写!</div>";
        }
    } elseif ( mb_strwidth($value['password'],"UTF-8") < 4 ||
               mb_strwidth($value['password'],"UTF-8") > 60 ||
               preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['password']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<div class=\"prompt_failed\">密码格式错误!</div>";
        }
    }

    $value['username'] = strtolower(trim($value['username']));
    if ( empty($value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<div class=\"prompt_failed\">用户名不能为空!</div>";
        }
    } elseif ( (mb_strwidth($value['username'],"UTF-8") < 4 ||
                mb_strwidth($value['username'],"UTF-8") > 60 ||
                preg_match("/[\x01-\x2E]|[\\x2F]|[\x3A-\x40]|[\x5B-\x5E]|[\x60]|[\x7B-\x7F]/",$value['username']))
                && !preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['username']) ) {
        if (!$error) {
            $error = true;
            $prompt_message = "<div class=\"prompt_failed\">用户名格式错误!</div>";
        }
    }else{
        // check the password
        if (preg_match("/^[a-z0-9-_\.]+@([a-z0-9][a-z0-9-]*\.)+[a-z]{2,4}$/i",$value['username'])){
            $sql = "SELECT id, username, password FROM ".DB_TABLE_MEMBER." WHERE email='".$value['username']."'";
        } else {
            $sql = "SELECT id, username, password FROM ".DB_TABLE_MEMBER." WHERE username='".$value['username']."'";
        }
        $result = &$db->Execute($sql);
        if (!$result) {
            $ajax_response->alert($db->ErrorMsg());
        } else {
            if ($result->EOF) {
                if (!$error) {
                    $error = true;
                    $prompt_message = "<div class=\"prompt_failed\">用户名不存在!</div>";
                }
            } elseif ( $result->fields['password'] != func::str_encrypt($value['password'],$CONFIGURE['sys']['encrypt_mix']) ) {
                if (!$error) {
                    $error = true;
                    $prompt_message = "<div class=\"prompt_failed\">密码错误!</div>";
                }
            } else {
                $aid        = $result->fields['id'];
                $ausername  = $result->fields['username'];
            }
        }
    }

    if($error){
        $ajax_response->assign("prompt_message","innerHTML",$prompt_message);
        $ajax_response->assign($submit,"value","登录");
        $ajax_response->assign($submit,"disabled",false);
    }else{

        $ajax_response->assign("prompt_message","innerHTML","");
        // Front session
        if($value['lifetime'] == "1"){
            $c->set_lifetime("31536000");
        }
        if ($value['lifetime'] == "3600" ||
            $value['lifetime'] == "86400" ||
            $value['lifetime'] == "604800" ||
            $value['lifetime'] == "2592000" ||
            $value['lifetime'] == "31536000" ) {
            $c->set_lifetime($value['lifetime']);
        }
        $c->set_cookie(array(
            $CONFIGURE['sys']['cookie_prefix']."mid"        => $aid,
            $CONFIGURE['sys']['cookie_prefix']."musername"  => $ausername,
        ));
        $c->set_session(array(
            "mid"       => $aid,
            "musername" => $ausername,
        ));
        // Admin session
        if($value['lifetime'] == "1"){
            $ac->set_lifetime("31536000");
        }
        if ($value['lifetime'] == "3600" ||
            $value['lifetime'] == "86400" ||
            $value['lifetime'] == "604800" ||
            $value['lifetime'] == "2592000" ||
            $value['lifetime'] == "31536000" ) {
            $ac->set_lifetime($value['lifetime']);
        }
        $ac->set_cookie(array(
            $CONFIGURE['sys']['cookie_prefix']."aid"        => $aid,
            $CONFIGURE['sys']['cookie_prefix']."ausername"  => $ausername,
        ));
        $ac->set_session(array(
            "aid"       => $aid,
            "ausername" => $ausername,
        ));

        if (!empty($PROMPT['prompt_returnurl'])){
            $returnurl_admin = $PROMPT['prompt_returnurl'];
        } else {
            $returnurl_admin = $CONFIGURE['common']['control_admin'];
        }
        $ajax_response->redirect($returnurl_admin);
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "login_admin");

if($sys->get['ope'] == "logout"){

    if (!$ac->iflogin()){
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=login","您没有登录,无需退出!");
    }
    $ac->destroy();

    $sys->prompt("jump", $CONFIGURE['common']['control_admin']."");

}else{

    // check login
    if( $ADMIN['iflogin'] == "1" ) {
        $sys->prompt("jump", $CONFIGURE['common']['control_admin']."?act=index");
    }
    //////

    // outside prompt message
    if(!empty($sys->get['msg']) || !empty($sys->get['ret'])) {
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=login", $sys->get['msg'], $sys->get['ret']);
    }
    //////

}
?>
