<?php
/*
+-----------------------------------------------------------------------------+
| $Id: member_group.php 2010-05-24 12:37:44Z Bleakwind $
| Manage member group
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// Member add and amend ajax
function submit_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_cover,$setting_attach;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    if ($type == "amend") {
        $submit_value   = "编辑";
    } else {
        $submit_value   = "添加";
    }

    if ($ADMIN['ag_privilege']['member_group_amend'] != "1"){
        $error = true;
        $ajax_response->alert("您没有权限修改会员群组!");
    } else {

        if( empty($value['mg_type']) ) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_type"; }
            $ajax_response->assign("mg_type_return", "innerHTML", "<span class=\"prompt_failed\">会员群组代号必须填写,且只能为英文,数字或下划线<!-- mg_type error --></span>");
        } else {
            $ajax_response->assign("mg_type_return", "innerHTML", "");
        }

        if( empty($value['mg_name']) ) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_name"; }
            $ajax_response->assign("mg_name_return", "innerHTML", "<span class=\"prompt_failed\">会员群组名称必须填写<!-- mg_name error --></span>");
        } else {
            $ajax_response->assign("mg_name_return", "innerHTML", "");
        }

        if( !preg_match("/^[0-9]{1,11}$/",$value['mg_ag_id']) ) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_ag_id"; }
            $ajax_response->assign("mg_ag_id_return", "innerHTML", "<span class=\"prompt_failed\">管理员权限必须选择!<!-- mg_ag_id error --></span>");
        } else {
            $ajax_response->assign("mg_ag_id_return", "innerHTML", "");
        }

        if( !preg_match("/^[0-9-]*$/",$value['mg_point_begin']) ) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_point_begin"; }
            $ajax_response->assign("mg_point_begin_return", "innerHTML", "<span class=\"prompt_failed\">必须设定开始会员积分,开始会员积分只能为数字,不限制请留空!<!-- mg_point_begin error --></span>");
        } else {
            $ajax_response->assign("mg_point_begin_return", "innerHTML", "");
        }

        if( !preg_match("/^[0-9]*$/",$value['mg_point_end']) ) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_point_end"; }
            $ajax_response->assign("mg_point_end_return", "innerHTML", "<span class=\"prompt_failed\">必须设定结束会员积分,结束会员积分只能为数字,不限制请留空!<!-- mg_point_end error --></span>");
        } else {
            $ajax_response->assign("mg_point_end_return", "innerHTML", "");
        }

        if( !preg_match("/^[0-9]+$/",$value['mg_rank'])) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_rank"; }
            $ajax_response->assign("mg_rank_return", "innerHTML", "<span class=\"prompt_failed\">排序不能为空且必须为数字<!-- mg_rank error --></span>");
        } else {
            $ajax_response->assign("mg_rank_return", "innerHTML", "");
        }

        if( !preg_match("/^[123]+$/",$value['mg_if_enable']) ) {
            $error = true;
            if( empty($anchor)) { $anchor = "mg_if_enable"; }
            $ajax_response->assign("mg_if_enable_return", "innerHTML", "<span class=\"prompt_failed\">必须选择会员状态<!-- mg_if_enable error --></span>");
        } else {
            $ajax_response->assign("mg_if_enable_return", "innerHTML", "");
        }

        if( $error){
            $ajax_response->assign($submit,"value",$submit_value);
            $ajax_response->assign($submit,"disabled",false);
            $ajax_response->redirect("#".$anchor);
        }else{

            if (preg_match("/^[0-9-]+$/",$value['mg_point_begin'])){
                $value['mg_point_begin'] = (int)$value['mg_point_begin'];
            } else {
                $value['mg_point_begin'] = "null";
            }
            if (preg_match("/^[0-9-]+$/",$value['mg_point_end'])){
                $value['mg_point_end'] = (int)$value['mg_point_end'];
            } else {
                $value['mg_point_end'] = "null";
            }
            if ($type == "amend") {

                if (!preg_match("/^[0-9]+$/",$sys->get['mg_id'])){
                    $ajax_response->alert("用户ID错误!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {

                    $total_record_mg_name = func::db_count_record(DB_TABLE_MEMBER_GROUP, "mg_name='".addslashes($value['mg_name'])."' AND mg_id!=".(int)$sys->get['mg_id']);
                    if ($total_record_mg_name > 0) {
                        $ajax_response->alert("此群组名称已经存在,请重新填写!");
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    } else {
                        $mg_privilege = !empty($value['mg_privilege']) ? serialize($value['mg_privilege']) : "";
                        $mg_fileallow = !empty($value['mg_fileallow']) ? serialize($value['mg_fileallow']) : "";
                        $sql = "UPDATE ".DB_TABLE_MEMBER_GROUP." SET
                                    mg_type         = '".$value['mg_type']."',
                                    mg_point_begin  = ".$value['mg_point_begin'].",
                                    mg_point_end    = ".$value['mg_point_end'].",
                                    mg_ag_id        = '".(int)$value['mg_ag_id']."',
                                    mg_name         = '".addslashes(func::str_stripbr($value['mg_name']))."',
                                    mg_brief        = '".addslashes($value['mg_brief'])."',
                                    mg_icon         = '".addslashes($value['mg_icon'])."',
                                    mg_privilege    = '".$mg_privilege."',
                                    mg_fileallow    = '".$mg_fileallow."',
                                    mg_rank         = '".addslashes($value['mg_rank'])."',
                                    mg_if_enable    = '".addslashes($value['mg_if_enable'])."'
                                WHERE mg_id=".$sys->get['mg_id']."";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg());
                            $ajax_response->assign($submit,"value",$submit_value);
                            $ajax_response->assign($submit,"disabled",false);
                        }else{
                            $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=member_group&pag=".$sys->get['pag']);
                        }
                    }
                }

            } else {

                $total_record_mg_name = func::db_count_record(DB_TABLE_MEMBER_GROUP, "mg_name='".addslashes($sys->post['mg_name'])."'");
                if ($total_record_mg_name > 0) {
                    $ajax_response->alert("此群组名称已经存在,请重新填写!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $mg_privilege = !empty($value['mg_privilege']) ? serialize($value['mg_privilege']) : "";
                    $mg_fileallow = !empty($value['mg_fileallow']) ? serialize($value['mg_fileallow']) : "";
                    $sql = "INSERT INTO ".DB_TABLE_MEMBER_GROUP." SET
                                    mg_type         = '".$value['mg_type']."',
                                    mg_point_begin  = ".$value['mg_point_begin'].",
                                    mg_point_end    = ".$value['mg_point_end'].",
                                    mg_ag_id        = '".(int)$value['mg_ag_id']."',
                                    mg_name         = '".addslashes(func::str_stripbr($value['mg_name']))."',
                                    mg_brief        = '".addslashes($value['mg_brief'])."',
                                    mg_icon         = '".addslashes($value['mg_icon'])."',
                                    mg_privilege    = '".$mg_privilege."',
                                    mg_fileallow    = '".$mg_fileallow."',
                                    mg_rank         = '".addslashes($value['mg_rank'])."',
                                    mg_if_enable    = '".addslashes($value['mg_if_enable'])."'";
                    $result = $db->Execute($sql);
                    $last_record = $db->Insert_ID();
                    if (!$result) {
                        $ajax_response->alert($db->ErrorMsg());
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    }else{
                        $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=member_group&pag=".$sys->get['pag']);
                    }
                }
            }
        }
    }


    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "submit_form");
//////

if( $sys->get['ope'] == "add"){
    if ($ADMIN['ag_privilege']['member_group_amend'] != "1"){
        $sys->prompt("failed","您没有权限添加会员群组!<!-- member_group_amend error -->");
    } else {
        $sql = "SELECT ag_id, ag_name
                FROM ".DB_TABLE_ADMIN_GROUP."
                ORDER BY ag_rank,ag_id";
        $result_admin_group = &$db->Execute($sql);
        if (!$result_admin_group) {
            echo $db->ErrorMsg();
        } else {
            while(!$result_admin_group->EOF) {
                $admin_group_list[] = array(
                    "ag_id"             => $result_admin_group->fields['ag_id'],
                    "ag_name"           => $result_admin_group->fields['ag_name'],
                );
                $result_admin_group->MoveNext();
            }
        }
        $t->assign(array(
            "admin_group_list"      => $admin_group_list,
            "list_privilege_member" => $SYSCHECK['list_privilege_member'],
            "list_fileallow_member" => $SYSCHECK['list_fileallow_member'],
        ));
    }

}elseif( $sys->get['ope'] == "amend"){

    if ($ADMIN['ag_privilege']['member_group_view'] != "1"){
        $sys->prompt("failed","您没有权限查看会员群组!<!-- member_group_view error -->");
    }elseif (!preg_match("/^[1-9][0-9]{0,10}$/",$sys->get['mg_id'])){
        $sys->prompt("failed","非法操作!<!-- mg_id error -->");
    }else{

        $sql = "SELECT ag_id, ag_name
                FROM ".DB_TABLE_ADMIN_GROUP."
                ORDER BY ag_rank,ag_id";
        $result_admin_group = &$db->Execute($sql);
        if (!$result_admin_group) {
            echo $db->ErrorMsg();
        } else {
            while(!$result_admin_group->EOF) {
                $admin_group_list[] = array(
                    "ag_id"             => $result_admin_group->fields['ag_id'],
                    "ag_name"           => $result_admin_group->fields['ag_name'],
                );
                $result_admin_group->MoveNext();
            }
        }

        $sql = "SELECT *
                FROM ".DB_TABLE_MEMBER_GROUP."
                WHERE mg_id=".$sys->get['mg_id'];
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }else {
            if (!$result->EOF) {
                $mg_privilege = unserialize($result->fields['mg_privilege']);
                $mg_fileallow = unserialize($result->fields['mg_fileallow']);
                $member_group_detail = array(
                    "mg_id"             => $result->fields['mg_id'],
                    "mg_type"           => $result->fields['mg_type'],
                    "mg_point_begin"    => $result->fields['mg_point_begin'],
                    "mg_point_end"      => $result->fields['mg_point_end'],
                    "mg_ag_id"          => $result->fields['mg_ag_id'],
                    "mg_name"           => $result->fields['mg_name'],
                    "mg_brief"          => $result->fields['mg_brief'],
                    "mg_icon"           => $result->fields['mg_icon'],
                    "mg_privilege"      => $mg_privilege,
                    "mg_fileallow"      => $mg_fileallow,
                    "mg_rank"           => $result->fields['mg_rank'],
                    "mg_if_enable"      => $result->fields['mg_if_enable'],
                );
            }
        }
    }
    $t->assign(array(
        "member_group_detail"   => $member_group_detail,
        "admin_group_list"      => $admin_group_list,
        "list_privilege_member" => $SYSCHECK['list_privilege_member'],
        "list_fileallow_member" => $SYSCHECK['list_fileallow_member'],
    ));

}elseif( $sys->get['ope'] == "if_enable"){

    if ($ADMIN['ag_privilege']['member_group_amend'] != "1"){
        $sys->prompt("failed","您没有权限修改会员群组!<!-- member_group_amend error -->");
    } elseif (!preg_match("/^[0-9]+$/",$sys->get['mg_id'])) {
        $sys->prompt("failed","非法操作!<!-- mg_id error -->");
    } elseif (!preg_match("/^[123]{1}$/",$sys->get['if_enable'])) {
        $sys->prompt("failed","非法操作!<!-- if_enable error -->");
    } else {

        $sql_data = array(
           "mg_if_enable"   => $sys->get['if_enable'],
        );
        $result = func::db_update(DB_TABLE_MEMBER_GROUP, $sql_data, "mg_id='".$sys->get['mg_id']."'");
        if (!$result) {
           $sys->prompt("failed","非法操作!<!-- db_update failed -->");
        }

        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member_group&pag=".$sys->get['pag']);
    }

}elseif( $sys->get['ope'] == "del"){

    // check the post
    if ($ADMIN['ag_privilege']['member_group_amend'] != "1"){
        $sys->prompt("failed","您没有权限删除会员群组!<!-- member_group_amend error -->");
    }elseif (!preg_match("/^[0-9]+$/",$sys->get['mg_id'])){
        $sys->prompt("failed","非法操作!<!-- mg_id error -->");
    }else{

        $total_record = func::db_count_record(DB_TABLE_MEMBER, "mg_id=".$sys->get['mg_id']."");
        if ($total_record > 0) {
            $sys->prompt("failed","群组非空!");
        }

        $sql = "DELETE FROM ".DB_TABLE_MEMBER_GROUP."
                WHERE mg_id=".$sys->get['mg_id'];
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }

        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=member_group&pag=".$sys->get['pag']);
    }

}else{

    $total_record = func::db_count_record(DB_TABLE_MEMBER_GROUP);
    $bwpage->set_record_listnum("20");
    $bwpage->set_record($total_record);
    $bwpage->page($CONFIGURE['common']['control_admin']."?act=member_group&pag=%s");
    $sql = "SELECT member_group.*, admin_group.ag_id, admin_group.ag_name
            FROM ".DB_TABLE_MEMBER_GROUP." member_group
            LEFT JOIN ".DB_TABLE_ADMIN_GROUP." admin_group ON admin_group.ag_id=member_group.mg_ag_id
            GROUP BY member_group.mg_id
            ORDER BY mg_rank, mg_id
            LIMIT ".$bwpage->record_listfirst.",".$bwpage->record_listnum;
    $result = &$db->Execute($sql);
    if (!$result) {
        echo $db->ErrorMsg();
    }else {
        while(!$result->EOF) {
            $member_group_list[] = array(
                "mg_id"             => $result->fields['mg_id'],
                "mg_type"           => $result->fields['mg_type'],
                "mg_point_begin"    => $result->fields['mg_point_begin'],
                "mg_point_end"      => $result->fields['mg_point_end'],
                "mg_ag_id"          => $result->fields['mg_ag_id'],
                "mg_name"           => $result->fields['mg_name'],
                "mg_brief"          => $result->fields['mg_brief'],
                "mg_icon"           => $result->fields['mg_icon'],
                "mg_privilege"      => $result->fields['mg_privilege'],
                "mg_fileallow"      => $result->fields['mg_fileallow'],
                "mg_if_enable"      => $result->fields['mg_if_enable'],
                "mg_rank"           => $result->fields['mg_rank'],

                "ag_id"             => $result->fields['ag_id'],
                "ag_name"           => $result->fields['ag_name'],
            );
            $result->MoveNext();
        }
    }
    $t->assign(array(
        "member_group_list" => $member_group_list,
        "pagination"        => $bwpage->pagination,
    ));
}
?>
