<?php
/*
+-----------------------------------------------------------------------------+
| $Id: quicklaunch.php 2010-05-24 12:37:44Z Bleakwind $
| Manage quicklaunch
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

if($sys->get['ope'] == "add"){
    if ( $sys->post['name'] == "" ||
         $sys->post['url'] == "" ||
         $sys->post['rank'] == "" ){
        $sys->prompt("failed","名称,地址,排序必须填写!<!-- name,url,rank empty -->");
    } elseif ( !preg_match("/^[0-9]{1,11}$/",$sys->post['rank']) ) {
        $sys->prompt("failed","排序必须为数字!<!-- rank error -->");
    } else{
        $sys->post['name_color']    = preg_match("/^[1-9][0-9]{0,10}$/i",$sys->post['name_color']) ? $sys->post['name_color'] : "";
        $sys->post['name_bold']     = $sys->post['name_bold'] == "1" ? "1" : "2";

        $sql = "INSERT ".DB_TABLE_ADMIN_QUICKLAUNCH." SET
                    admin_id    ='".addslashes($ADMIN['mid'])."',
                    name        ='".addslashes(func::str_stripbr($sys->post['name']))."',
                    name_color  ='".addslashes((int)$sys->post['name_color'])."',
                    name_bold   ='".addslashes((int)$sys->post['name_bold'])."',
                    url         ='".addslashes($sys->post['url'])."',
                    rank        ='".addslashes((int)$sys->post['rank'])."',
                    time        ='".$sys->nowtime."'";
        $result_friend = $db->Execute($sql);
        if (!$result_friend) {
            echo $db->ErrorMsg();
        } else {
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=quicklaunch");
        }
    }

}elseif($sys->get['ope'] == "del"){

    if(!preg_match("/^[1-9][0-9]{0,10}$/i",$sys->get['id'])){
        $sys->prompt("failed","非法操作!<!-- id error -->");
    }else{
        $sql = "DELETE FROM ".DB_TABLE_ADMIN_QUICKLAUNCH." WHERE
                    admin_id=".$ADMIN['mid']." AND id=".$sys->get['id']."";
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }
    }
    $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=quicklaunch");

}else{

    function set_value_onfocus($name, $id, $value, $type="text", $maxlength="255", $style="")
    {
        global $SETTING, $LANGUAGE, $MEMBER, $ADMIN, $db, $sys, $select_option;
        $ajax_response = new xajaxResponse();
        if (!empty($style)) { $style = "style=\"".$style."\""; }

        if ($type == "text") {
            $result = '<input type="text" id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" value="'.$value.'" maxlength="'.$maxlength.'" size="6" class="input" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">';
            $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
            $ajax_response->script("$('#".$name."_".$id."_input').focus();");
        } elseif($type == "textarea") {
            $result = '<textarea id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" rows="1" cols="6" class="textarea" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\',  this.value);">'.$value.'</textarea>';
            $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
            $ajax_response->script("$('#".$name."_".$id."_input').focus();");
        } elseif ($type == "textarea_resize") {
            $result = '<textarea id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" rows="1" cols="6" class="textarea" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">'.$value.'</textarea>';
            $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
            $ajax_response->script("$('#".$name."_".$id."_input').resizable({ autohide: true, minWidth: 200, minHeight: 100,  maxWidth: 800, maxHeight: 600 });");
            $ajax_response->script("$('#".$name."_".$id."_input').focus();");
        } elseif($type == "checkbox") {
            $checked = $value == "1" ? "checked" : "";
            $result = '<input type="checkbox" id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" value="1" '.$checked.' class="checkbox" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.checked == true ? 1 : 2);">';
            $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
            $ajax_response->script("$('#".$name."_".$id."_input').focus();");
        } elseif($type == "name_color") {
            if (!empty($select_option['quicklaunch_color'])) {
                $result = '<select id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" class="select" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">';
                $result .= '<option value=""></option>';
                foreach ($select_option['quicklaunch_color'] as $v) {
                    if ($v['id'] == $value){
                        $result .= '<option value="'.$v['id'].'" style="background-color:'.$v['value'].'" selected="selected">'.$v['name'].'</option>';
                    } else {
                        $result .= '<option value="'.$v['id'].'" style="background-color:'.$v['value'].'">'.$v['name'].'</option>';
                    }
                }
                $result .= '</select>';
                $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                $ajax_response->script("$('#".$name."_".$id."_input').focus();");
            }
        }
        return $ajax_response;
    }
    $bwajax->register(XAJAX_FUNCTION, "set_value_onfocus");

    function set_value_onblur($name, $id, $value="")
    {
        global $SETTING, $LANGUAGE, $ASESSION, $ADMIN, $db, $sys;
        $ajax_response = new xajaxResponse();
        $if_error   = false;
        $error_msg  = array();

        // check
        if ($name == "rank") {
            if ( !preg_match("/^[0-9]{1,11}$/",$value) ) {
                $if_error       = true;
                $error_msg[]    = "排序必须为数字!";
            }
        }

        // update
        if (!$if_error) {
            $sql = "UPDATE ".DB_TABLE_ADMIN_QUICKLAUNCH." SET
                        ".$name."   = '".addslashes($value)."',
                        time        = '".$sys->nowtime."'
                    WHERE admin_id=".$ADMIN['mid']." AND id=".$id."";
            $result = $db->Execute($sql);
            if (!$result) {
                $if_error       = true;
                $error_msg[]    = $db->ErrorMsg();
            }
        }

        // select and set hidden value
        if (!$if_error) {
            $sql = "SELECT *
                    FROM ".DB_TABLE_ADMIN_QUICKLAUNCH."
                    WHERE admin_id=".$ADMIN['mid']." AND id=".$id."";
            $result = $db->Execute($sql);
            if (!$result) {
                $if_error       = true;
                $error_msg[]    = $db->ErrorMsg();
            } else {
                $ajax_response->assign($name."_".$id."_value", "value", $result->fields[$name]);
            }
        }

        // show new
        if (!$if_error) {
            if ($name == "name" ||
                $name == "name_color"||
                $name == "name_bold") {
                $update_name['value']                       = $result->fields['name'];

                $select_name_color  = $sys->return_select_value($result->fields['name_color']);
                if (preg_match("/^#?[0-F]{6}$/i",$select_name_color['value'])) {
                    $update_name['color']                   = "color:".$select_name_color['value'].";";
                    $update_name_color['value']             = $select_name_color['name'];
                    $update_name_color['background_color']  = "background-color:".$select_name_color['value'].";";
                } else {
                    $update_name['color']                   = "";
                    $update_name_color['value']             = "&nbsp;";
                    $update_name_color['background_color']  = "";
                }

                if ($result->fields['name_bold'] == "1") {
                    $update_name['font_weight']             = "font-weight:bold;";
                    $update_name_bold['font_weight']        = "&radic;";
                } else {
                    $update_name['font_weight']             = "";
                    $update_name_bold['font_weight']        = "";
                }

                $ajax_response->assign("name_".$id, "innerHTML", '<div style="'.$update_name['color'].$update_name['font_weight'].'">'.func::str_entag($update_name['value'], "space").'</div>');
                $ajax_response->assign("name_color_".$id, "innerHTML", '<div style="width: 60px;height:18px;border:1px solid #EEEEEE;'.$update_name_color['background_color'].'">'.$update_name_color['value'].'</div>');
                $ajax_response->assign("name_bold_".$id, "innerHTML", $update_name_bold['font_weight']);

            } elseif ($name == "rank") {
                $ajax_response->assign("rank_".$id, "innerHTML", $result->fields['rank']);
                $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=quicklaunch");

            } else {
                $ajax_response->assign($name."_".$id, "innerHTML", $result->fields[$name]);
            }
        }

        // alert error
        if ($if_error) {
            $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
        }
        return $ajax_response;
    }
    $bwajax->register(XAJAX_FUNCTION, "set_value_onblur");

    $array_select  = array("quicklaunch_color");
    $select_option = $sys->return_select($array_select);

    $add_name_color = '<select id="name_color" name="name_color" class="select" style="width:60px;text-align:center;">';
    $add_name_color .= '<option value=""></option>';
    if (count($select_option['quicklaunch_color']) > 0) {
        foreach ($select_option['quicklaunch_color'] as $name_color) {
            if ($name_color['if_default'] == "1"){
                $add_name_color .= '<option value="'.$name_color['id'].'" style="background-color:'.$name_color['value'].'" selected="selected">'.$name_color['name'].'</option>';
            } else {
                $add_name_color .= '<option value="'.$name_color['id'].'" style="background-color:'.$name_color['value'].'">'.$name_color['name'].'</option>';
            }
        }
    }
    $add_name_color .= '</select>';

    $t->assign(array(
        "add_name_color"    => $add_name_color,
    ));
}
?>
