<?php
/*
+-----------------------------------------------------------------------------+
| $Id: set_select.php 2010-05-24 12:37:44Z Bleakwind $
| Manage select option
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

if($sys->get['ope'] == "add"){
    if ( $sys->post['name'] == "" ||
         $sys->post['value'] == "" ||
         $sys->post['rank'] == ""){
        $sys->prompt("failed","名称,值,排序必须填写!<!-- name,value,rank empty -->");
    } elseif ( !array_key_exists($sys->get['sort'], $SELECTSORT) ) {
        $sys->prompt("failed","此类别不存在!<!-- sort empty -->");
    } elseif ( !preg_match("/^[0-9]{1,11}$/",$sys->post['rank']) ) {
        $sys->prompt("failed","排序必须为数字!<!-- rank error -->");
    } elseif ( !preg_match("/^[123]{0,1}$/",$sys->post['if_default']) ) {
        $sys->prompt("failed","是否默认错误!<!-- if_default error -->");
    } else {
        $if_default = $sys->post['if_default'] == "1" ? "1" : "2";
        $sql = "INSERT ".DB_TABLE_SELECT." SET
                    sort            ='".addslashes($sys->get['sort'])."',
                    name            ='".addslashes(func::str_stripbr($sys->post['name']))."',
                    value           ='".addslashes($sys->post['value'])."',
                    rank            ='".addslashes((int)$sys->post['rank'])."',
                    if_default      ='".$if_default."'";
        $result_friend = $db->Execute($sql);
        if (!$result_friend) {
            echo $db->ErrorMsg();
        }
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=set_select&sort=".$sys->get['sort']);
    }

}elseif($sys->get['ope'] == "del"){

    if (!array_key_exists($sys->get['sort'], $SELECTSORT) ) {
        $sys->prompt("failed","非法操作!<!-- sort error -->");
    }elseif(!preg_match("/^[1-9][0-9]{0,10}$/i",$sys->get['id'])){
        $sys->prompt("failed","非法操作!<!-- id error -->");
    }else{
        $sql = "DELETE FROM ".DB_TABLE_SELECT." WHERE
                    sort='".$sys->get['sort']."' AND id=".$sys->get['id']."";
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }
    }
    $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=set_select&sort=".$sys->get['sort']);

}else{

    if( array_key_exists($sys->get['sort'], $SELECTSORT) ) {

        function set_value_onfocus($name, $id, $value, $type="text", $maxlength="255", $style="")
        {
            global $SETTING, $LANGUAGE, $MEMBER, $ADMIN, $db, $sys, $select_option;
            $ajax_response = new xajaxResponse();
            if (!empty($style)) { $style = "style=\"".$style."\""; }

            if ($type == "text") {
                $result = '<input type="text" id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" value="'.$value.'" maxlength="'.$maxlength.'" size="6" class="input" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">';
                $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                $ajax_response->script("$('#".$name."_".$id."_input').focus();");
            } elseif($type == "textarea") {
                $result = '<textarea id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" rows="1" cols="6" class="textarea" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\',  this.value);">'.$value.'</textarea>';
                $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                $ajax_response->script("$('#".$name."_".$id."_input').focus();");
            } elseif ($type == "textarea_resize") {
                $result = '<textarea id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" rows="1" cols="6" class="textarea" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">'.$value.'</textarea>';
                $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                $ajax_response->script("$('#".$name."_".$id."_input').resizable({ autohide: true, minWidth: 200, minHeight: 100,  maxWidth: 800, maxHeight: 600 });");
                $ajax_response->script("$('#".$name."_".$id."_input').focus();");
            } elseif($type == "checkbox") {
                $checked = $value == "1" ? "checked" : "";
                $result = '<input type="checkbox" id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" value="1" '.$checked.' class="checkbox" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.checked == true ? 1 : 2);">';
                $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                $ajax_response->script("$('#".$name."_".$id."_input').focus();");
            }
            return $ajax_response;
        }
        $bwajax->register(XAJAX_FUNCTION, "set_value_onfocus");

        function set_value_onblur($name, $id, $value="")
        {
            global $SETTING, $LANGUAGE, $ASESSION, $ADMIN, $db, $sys;
            $ajax_response = new xajaxResponse();
            $if_error   = false;
            $error_msg  = array();

            // check
            if ($name == "rank") {
                if ( !preg_match("/^[0-9]{1,11}$/",$value) ) {
                    $if_error       = true;
                    $error_msg[]    = "排序必须为数字!";
                }
            } elseif ($name == "if_default") {
                $value = $value == "1" ? "1" : "2";
            }

            // update
            if (!$if_error) {
                $sql = "UPDATE ".DB_TABLE_SELECT." SET
                            ".$name."   = '".addslashes($value)."'
                        WHERE sort='".$sys->get['sort']."' AND id=".$id."";
                $result = $db->Execute($sql);
                if (!$result) {
                    $if_error       = true;
                    $error_msg[]    = $db->ErrorMsg();
                }
            }

            // other update
            if (!$if_error) {
                if ($name == "if_default" && $value == "1") {
                    $sql = "UPDATE ".DB_TABLE_SELECT." SET
                                if_default      = '2'
                            WHERE id!=".$id." AND sort='".$sys->get['sort']."'";
                    $result = $db->Execute($sql);
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = $db->ErrorMsg();
                    }
                }
            }

            // select and set hidden value
            if (!$if_error) {
                $sql = "SELECT *
                        FROM ".DB_TABLE_SELECT."
                        WHERE sort='".$sys->get['sort']."' AND id=".$id."";
                $result = $db->Execute($sql);
                if (!$result) {
                    $if_error       = true;
                    $error_msg[]    = $db->ErrorMsg();
                } else {
                    $ajax_response->assign($name."_".$id."_value", "value", $result->fields[$name]);
                }
            }

            // show new
            if (!$if_error) {
                if ($name == "if_default") {
                    if ($result->fields['if_default'] == "1") {
                        $update_if_default         = "&radic;";
                    } else {
                        $update_if_default         = "";
                    }
                    $ajax_response->assign("if_default_".$id, "innerHTML", $update_if_default);
                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=set_select&sort=".$sys->get['sort']);

                } elseif ($name == "rank") {
                    $ajax_response->assign("rank_".$id, "innerHTML", $result->fields['rank']);
                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=set_select&sort=".$sys->get['sort']);

                } elseif ($name == "name") {
                    $ajax_response->assign($name."_".$id, "innerHTML", func::str_entag($result->fields[$name], "space"));

                } else {
                    $ajax_response->assign($name."_".$id, "innerHTML", $result->fields[$name]);
                }
            }

            // alert error
            if ($if_error) {
                $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
            }
            return $ajax_response;
        }
        $bwajax->register(XAJAX_FUNCTION, "set_value_onblur");

        $sql = "SELECT *
                FROM ".DB_TABLE_SELECT."
                WHERE sort='".$sys->get['sort']."'
                ORDER BY rank, name";
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }else {
            while(!$result->EOF){
                $select_list[] = array(
                    "id"            => $result->fields['id'],
                    "sort"          => $result->fields['sort'],
                    "name"          => $result->fields['name'],
                    "value"         => $result->fields['value'],
                    "rank"          => $result->fields['rank'],
                    "if_default"    => $result->fields['if_default'],
                );
                $result->MoveNext();
            }
        }
        $t->assign(array(
            "select_list"    => $select_list,
        ));
    }
}
?>
