<?php
/*
+-----------------------------------------------------------------------------+
| $Id: setmodel.php 2010-05-24 12:37:44Z Bleakwind $
| Manage content model
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// field_form
function field_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_cover,$setting_attach,$sys,$setmodel_detail;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    if ($type == "amend") {
        $submit_value   = "编辑";
    } else {
        $submit_value   = "添加";
    }

    if ( mb_strwidth($value['name'],"UTF-8") < 1 ||
         mb_strwidth($value['name'],"UTF-8") > 60 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "name"; }
        $ajax_response->assign("name_return", "innerHTML", "<span class=\"prompt_failed\">名称必须填写且不能大于60字节<!-- name_return error --></span>");
    } else {
        $ajax_response->assign("name_return", "innerHTML", "");
    }

    if(!preg_match("/^[a-z0-9_]{1,24}$/i",$value['code'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "code"; }
        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">标识必须为英文字母数字或者下划线,少于24位!<!-- code error --></span>");
    } elseif ( substr($value['code'], 0, 5) == "content" ) {
        $error = true;
        if(empty($anchor)) { $anchor = "code"; }
        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">标识不能以model开头!<!-- code error --></span>");
    } else {
        $ajax_response->assign("code_return", "innerHTML", "");
    }

    if(!preg_match("/^[a-z0-9_]{1,24}$/i",$value['type'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "type"; }
        $ajax_response->assign("type_return", "innerHTML", "<span class=\"prompt_failed\">数据类型发生错误!<!-- type error --></span>");
    } else {
        $ajax_response->assign("type_return", "innerHTML", "");
    }

    if(!preg_match("/^[0-9\,]{0,11}$/i",$value['length'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "length"; }
        $ajax_response->assign("length_return", "innerHTML", "<span class=\"prompt_failed\">字段长度必须为数字或逗号!<!-- length error --></span>");
    } else {
        $ajax_response->assign("length_return", "innerHTML", "");
    }

    if ( mb_strwidth($value['prompt'],"UTF-8") < 0 ||
         mb_strwidth($value['prompt'],"UTF-8") > 255 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "prompt"; }
        $ajax_response->assign("prompt_return", "innerHTML", "<span class=\"prompt_failed\">提示信息不能超过255字节!<!-- prompt error --></span>");
    } else {
        $ajax_response->assign("prompt_return", "innerHTML", "");
    }

    if ( mb_strwidth($value['handle_before'],"UTF-8") < 0 ||
         mb_strwidth($value['handle_before'],"UTF-8") > 255 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "handle_before"; }
        $ajax_response->assign("handle_before_return", "innerHTML", "<span class=\"prompt_failed\">前期处理不能超过255字节!<!-- handle_before error --></span>");
    } else {
        $ajax_response->assign("handle_before_return", "innerHTML", "");
    }

    if ( mb_strwidth($value['handle_alfter'],"UTF-8") < 0 ||
         mb_strwidth($value['handle_alfter'],"UTF-8") > 255 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "handle_alfter"; }
        $ajax_response->assign("handle_alfter_return", "innerHTML", "<span class=\"prompt_failed\">后期处理不能超过255字节!<!-- handle_alfter error --></span>");
    } else {
        $ajax_response->assign("handle_alfter_return", "innerHTML", "");
    }

    if ( mb_strwidth($value['value'],"UTF-8") < 0 ||
         mb_strwidth($value['value'],"UTF-8") > 3000 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "value"; }
        $ajax_response->assign("value_return", "innerHTML", "<span class=\"prompt_failed\">字段值不能超过3000字节!<!-- value error --></span>");
    } else {
        $ajax_response->assign("value_return", "innerHTML", "");
    }

    if ( mb_strwidth($value['html'],"UTF-8") < 0 ||
         mb_strwidth($value['html'],"UTF-8") > 3000 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "html"; }
        $ajax_response->assign("html_return", "innerHTML", "<span class=\"prompt_failed\">自定义HTML不能超过3000字节!<!-- html error --></span>");
    } else {
        $ajax_response->assign("html_return", "innerHTML", "");
    }

    if(!preg_match("/^[12]{1}$/i",$value['if_preload'])){
        $error = true;
        if(empty($anchor)) { $anchor = "if_preload"; }
        $ajax_response->assign("if_preload_return", "innerHTML", "<span class=\"prompt_failed\">必须选择是否预先载入<!-- if_preload error --></span>");
    } else {
        $ajax_response->assign("if_preload_return", "innerHTML", "");
    }

    if(!preg_match("/^[12]{1}$/i",$value['if_enable'])){
        $error = true;
        if(empty($anchor)) { $anchor = "if_enable"; }
        $ajax_response->assign("if_enable_return", "innerHTML", "<span class=\"prompt_failed\">必须选择是否开启<!-- if_enable error --></span>");
    } else {
        $ajax_response->assign("if_enable_return", "innerHTML", "");
    }

    if(!preg_match("/^[0-9]+$/",$value['rank'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "rank"; }
        $ajax_response->assign("rank_return", "innerHTML", "<span class=\"prompt_failed\">排序不能为空且必须为数字<!-- rank error --></span>");
    } else {
        $ajax_response->assign("rank_return", "innerHTML", "");
    }

    if($error){
        $ajax_response->assign($submit,"value",$submit_value);
        $ajax_response->assign($submit,"disabled",false);
        $ajax_response->redirect("#".$anchor);
    }else{

        if ($type == "amend") {

            if (!preg_match("/^[1-9][0-9]*$/",$sys->get['field_id'])){
                $ajax_response->alert("字段ID错误!");
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $field_info   = $sys->return_field_info($sys->get['field_id']);
                if (!preg_match("/^[1-9][0-9]{0,10}$/", $field_info['id']) || !preg_match("/^[1-9][0-9]{0,10}$/", $field_info['table_id'])) {
                    $ajax_response->alert("此字段不存在!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $total_record = func::db_count_record(DB_TABLE_SETMODEL_FIELD, "table_id=".$field_info['table_id']." AND code='".addslashes($value['code'])."' AND type!='index' AND id!=".$field_info['id']."");
                    if ($total_record > 0) {
                        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">此标识已经存在,请重新填写不同标识!<!-- code error --></span>");
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    } else {

                        if ($field_info['code']         != $value['code']
                            || $field_info['type']      != $value['type']
                            || $field_info['length']    != $value['length']) {

                            $field_info_new         = $sys->build_field_sql($field_info['table_rowformat'], $value);
                            $value['length']        = $field_info_new['length'];
                            preg_match("/^([0-9]+)(\,[0-9]+)?$/i", $value['length'],$matches);
                            $value['length_pull']   = $matches[1];

                            // check len
                            if(!$error){
                                $sql = "UPDATE ".$field_info['table_fullcode']." SET ".$field_info['code']."=SUBSTRING(".$field_info['code'].",1,".$value['length_pull'].")";
                                $result = $db->Execute($sql);
                                if (!$result) {
                                    $error = true;
                                    $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">字段值缩小失败![".$db->ErrorMsg()."]<!-- SUBSTRING_error --></span>");
                                    $ajax_response->assign($submit,"value",$submit_value);
                                    $ajax_response->assign($submit,"disabled",false);
                                }
                            }
                            // check type
                            if(!$error){
                                if ($field_info['type'] != $value['type']){
                                    $field_primary = "content".$field_info['setmodel_code'].$field_info['table_code']."_id";
                                    if ($value['type'] == "int") {
                                        $sys->set_field_type($field_info['table_fullcode'],$field_info['code'],$field_primary,"int");
                                    } elseif ($value['type'] == "time") {
                                        $sys->set_field_type($field_info['table_fullcode'],$field_info['code'],$field_primary,"int");
                                    } elseif ($value['type'] == "decimal") {
                                        $sys->set_field_type($field_info['table_fullcode'],$field_info['code'],$field_primary,"float");
                                    }
                                }
                            }

                            if(!$error){
                                $sql = "ALTER TABLE ".$field_info['table_fullcode']." CHANGE COLUMN ".$field_info['code']." ".$value['code']." ".$field_info_new['field_sql']."";
                                $result = $db->Execute($sql);
                                if (!$result) {
                                    $error = true;
                                    $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">更改字段失败![".$db->ErrorMsg()."]<!-- CHANGE_COLUMN_error --></span>");
                                    $ajax_response->assign($submit,"value",$submit_value);
                                    $ajax_response->assign($submit,"disabled",false);
                                }
                            }
                        }

                        if(!$error){
                            $sql = "UPDATE ".DB_TABLE_SETMODEL_FIELD." SET
                                        name                = '".addslashes($value['name'])."',
                                        code                = '".addslashes($value['code'])."',
                                        type                = '".addslashes($value['type'])."',
                                        length              = '".addslashes($value['length'])."',
                                        prompt              = '".addslashes($value['prompt'])."',
                                        handle_before       = '".addslashes($value['handle_before'])."',
                                        handle_alfter       = '".addslashes($value['handle_alfter'])."',
                                        value               = '".addslashes($value['value'])."',
                                        html                = '".addslashes($value['html'])."',
                                        if_preload          = '".addslashes((int)$value['if_preload'])."',
                                        if_enable           = '".addslashes((int)$value['if_enable'])."',
                                        rank                = '".addslashes((int)$value['rank'])."'
                                    WHERE id=".$sys->get['field_id']."";
                            $result = $db->Execute($sql);
                            if (!$result) {
                                $ajax_response->alert($db->ErrorMsg());
                                $ajax_response->assign($submit,"value",$submit_value);
                                $ajax_response->assign($submit,"disabled",false);
                            }else{
                                $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel&ope=field_list&table_id=".$field_info['table_id']);
                            }
                        }
                    }
                }
            }

        } else {

            if (!preg_match("/^[1-9][0-9]*$/",$sys->get['table_id'])){
                $ajax_response->alert("数据库表ID错误!");
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $table_info   = $sys->return_table_info($sys->get['table_id']);
                if (!preg_match("/^[1-9][0-9]{0,10}$/", $table_info['id'])) {
                    $ajax_response->alert("此数据库表不存在!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $total_record = func::db_count_record(DB_TABLE_SETMODEL_FIELD, "table_id=".$table_info['id']." AND code='".addslashes($value['code'])."' AND type!='index'");
                    if ($total_record > 0) {
                        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">此标识已经存在,请重新填写不同标识!<!-- code error --></span>");
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    } else {
                        $sql = "INSERT INTO ".DB_TABLE_SETMODEL_FIELD." SET
                                    table_id            = '".addslashes($sys->get['table_id'])."',
                                    name                = '".addslashes($value['name'])."',
                                    code                = '".addslashes($value['code'])."',
                                    type                = '".addslashes($value['type'])."',
                                    team                = '4',
                                    length              = '".addslashes($value['length'])."',
                                    prompt              = '".addslashes($value['prompt'])."',
                                    handle_before       = '".addslashes($value['handle_before'])."',
                                    handle_alfter       = '".addslashes($value['handle_alfter'])."',
                                    value               = '".addslashes($value['value'])."',
                                    html                = '".addslashes($value['html'])."',
                                    if_preload          = '".addslashes((int)$value['if_preload'])."',
                                    if_enable           = '".addslashes((int)$value['if_enable'])."',
                                    rank                = '".addslashes((int)$value['rank'])."'";
                        $result = $db->Execute($sql);
                        $last_record = $db->Insert_ID();
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg().$sql);
                            $ajax_response->assign($submit,"value",$submit_value);
                            $ajax_response->assign($submit,"disabled",false);
                        }else{
                            $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel&ope=field_list&table_id=".$table_info['id']);
                        }
                    }
                }
            }
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "field_form");
//////
// submit_form
function submit_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_cover,$setting_attach,$sys,$setmodel_detail;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

    if ($type == "amend") {
        $submit_value   = "编辑";
    } else {
        $submit_value   = "添加";
    }

    if ( mb_strwidth($value['name'],"UTF-8") < 1 ||
         mb_strwidth($value['name'],"UTF-8") > 60 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "name"; }
        $ajax_response->assign("name_return", "innerHTML", "<span class=\"prompt_failed\">名称必须填写且不能大于60字节<!-- name_return error --></span>");
    } else {
        $ajax_response->assign("name_return", "innerHTML", "");
    }

    if(!preg_match("/^[a-z0-9_]{1,24}$/i",$value['code'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "code"; }
        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">标识必须为英文字母数字或者下划线,少于24位!<!-- code error --></span>");
    } elseif(preg_match("/^_cover|_attach$/i",$value['code'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "code"; }
        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">此标识为系统保留关键字,请重新填写标识!<!-- code error --></span>");
    } else {
        $ajax_response->assign("code_return", "innerHTML", "");
    }

    if ( mb_strwidth($value['brief'],"UTF-8") < 1 ||
         mb_strwidth($value['brief'],"UTF-8") > 255 ) {
        $error = true;
        if(empty($anchor)) { $anchor = "brief"; }
        $ajax_response->assign("brief_return", "innerHTML", "<span class=\"prompt_failed\">简介必须填写且不能大于255字节<!-- brief_return error --></span>");
    } else {
        $ajax_response->assign("brief_return", "innerHTML", "");
    }

    if (!preg_match("/^[a-z0-9_.\/]*$/i",$value['template_channel'])
        || preg_match("/^\//i",$value['template_channel'])
        || preg_match("/\.\./i",$value['template_channel'])){
        $error = true;
        if(empty($anchor)) { $anchor = "template_channel"; }
        $ajax_response->assign("template_channel_return", "innerHTML", "<span class=\"prompt_failed\">频道页模板包含非法字符<!-- template_channel error --></span>");
    } else {
        $ajax_response->assign("template_channel_return", "innerHTML", "");
    }

    if (!preg_match("/^[a-z0-9_.\/]*$/i",$value['template_content'])
        || preg_match("/^\//i",$value['template_content'])
        || preg_match("/\.\./i",$value['template_content'])){
        $error = true;
        if(empty($anchor)) { $anchor = "template_content"; }
        $ajax_response->assign("template_content_return", "innerHTML", "<span class=\"prompt_failed\">详细页模板包含非法字符<!-- template_content error --></span>");
    } else {
        $ajax_response->assign("template_content_return", "innerHTML", "");
    }

    if(!preg_match("/^[12]{1}$/i",$value['if_enable'])){
        $error = true;
        if(empty($anchor)) { $anchor = "if_enable"; }
        $ajax_response->assign("if_enable_return", "innerHTML", "<span class=\"prompt_failed\">必须选择是否开启此模型<!-- if_enable error --></span>");
    } else {
        $ajax_response->assign("if_enable_return", "innerHTML", "");
    }

    if(!preg_match("/^[0-9]+$/",$value['rank'])) {
        $error = true;
        if(empty($anchor)) { $anchor = "rank"; }
        $ajax_response->assign("rank_return", "innerHTML", "<span class=\"prompt_failed\">排序不能为空且必须为数字<!-- rank error --></span>");
    } else {
        $ajax_response->assign("rank_return", "innerHTML", "");
    }

    if($error){
        $ajax_response->assign($submit,"value",$submit_value);
        $ajax_response->assign($submit,"disabled",false);
        $ajax_response->redirect("#".$anchor);
    }else{

        if ($type == "amend") {

            if (!preg_match("/^[1-9][0-9]*$/",$sys->get['setmodel_id'])){
                $ajax_response->alert("模型ID错误!");
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $sys->return_setmodel_info($sys->get['setmodel_id']);
                if (!preg_match("/^[1-9][0-9]*$/",$sys->setmodel_info['id'])){
                    $ajax_response->alert("此模型不存在!");
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                } else {
                    $total_record = func::db_count_record(DB_TABLE_SETMODEL, "code='".addslashes($value['code'])."' AND id!=".$sys->get['setmodel_id']."");
                    if ($total_record > 0) {
                        $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">此标识已经存在,请重新填写不同标识!<!-- code error --></span>");
                        $ajax_response->assign($submit,"value",$submit_value);
                        $ajax_response->assign($submit,"disabled",false);
                    } else {

                        if ($sys->setmodel_info['code'] != $value['code']) {
                            $sys->return_table_list();
                            if (is_array($sys->table_list) && count($sys->table_list) > 0) {

                                foreach ($sys->table_list as $vt) {
                                    $field_new["content".$vt['setmodel_code'].$vt['code']."_id"] = "content".$value['code'].$vt['code']."_id";
                                }

                                foreach ($sys->table_list as $vt) {
                                    $field_list = $sys->return_field_list($vt['id']);
                                    if (is_array($field_list) && count($field_list) > 0) {
                                        foreach ($field_list as $vf) {
                                            if ($vf['if_enable'] == "1" && $vf['team'] == "1"){
                                                $sql = "ALTER TABLE ".$vf['table_fullcode']." CHANGE COLUMN ".$vf['code']." ".$field_new[$vf['code']]." int(11) unsigned NOT NULL auto_increment";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "更改字段名称失败! [".$db->ErrorMsg()."]";
                                                }

                                            } elseif ($vf['if_enable'] == "1" && $vf['team'] == "2"){
                                                $sql = "ALTER TABLE ".$vf['table_fullcode']." CHANGE COLUMN ".$vf['code']." ".$field_new[$vf['code']]." int(11) unsigned NOT NULL default '0'";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "更改字段名称失败! [".$db->ErrorMsg()."]";
                                                }

                                            }
                                            if (preg_match("/^[12]{1}$/", $vf['team'])) {
                                                $sql = "UPDATE ".DB_TABLE_SETMODEL_FIELD." SET code='".$field_new[$vf['code']]."' WHERE table_id=".$vf['table_id']." AND code='".$vf['code']."' AND type!='index'";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "更改字段名称记录失败! [".$db->ErrorMsg()."]";
                                                }

                                            }
                                        }
                                    }
                                    $index_list = $sys->return_index_list($vt['id']);
                                    if (is_array($index_list) && count($index_list) > 0) {
                                        foreach ($index_list as $v) {
                                            if ($v['if_enable'] == "1" && $v['team'] == "2"){
                                                $sql = "ALTER TABLE ".$v['table_fullcode']." ADD INDEX ".$field_new[$v['code']]."(".$field_new[$v['code']]."),DROP INDEX ".$v['code']."";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "更改索引名称失败! [".$db->ErrorMsg()."]";
                                                }

                                            }
                                            if (preg_match("/^[12]{1}$/", $v['team'])) {
                                                $sql = "UPDATE ".DB_TABLE_SETMODEL_FIELD." SET code='".$field_new[$v['code']]."' WHERE table_id=".$v['table_id']." AND code='".$v['code']."' AND type='index'";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "更改索引名称记录失败! [".$db->ErrorMsg()."]";
                                                }

                                            }
                                        }
                                    }
                                    $sql = "RENAME TABLE ".$vt['table_fullcode']." TO ".$SETTING['config_db_prefix']."content".$value['code'].$vt['code'];
                                    $result = $db->Execute($sql);
                                    if (!$result) {
                                        $if_error       = true;
                                        $error_msg[]    = "更改数据库表名称失败! [".$db->ErrorMsg()."]";
                                    }

                                }
                            }
                        }

                        $sql = "UPDATE ".DB_TABLE_SETMODEL." SET
                                    name                = '".addslashes($value['name'])."',
                                    code                = '".addslashes($value['code'])."',
                                    brief               = '".addslashes($value['brief'])."',
                                    template_channel    = '".addslashes($value['template_channel'])."',
                                    template_content     = '".addslashes($value['template_content'])."',
                                    if_enable           = '".addslashes((int)$value['if_enable'])."',
                                    rank                = '".addslashes((int)$value['rank'])."'
                                WHERE id=".$sys->get['setmodel_id']."";
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $ajax_response->alert($db->ErrorMsg());
                            $ajax_response->assign($submit,"value",$submit_value);
                            $ajax_response->assign($submit,"disabled",false);
                        }else{
                            // trans_group
                            foreach ($value['trans_group'] as $k => $v) {
                                if ($v['check'] == "1") {
                                    $v['if_must']   = $v['if_must'] == "1" ? "1" : "2";
                                    $v['rank']      = preg_match("/^[0-9]{1,11}$/",$v['rank']) ? $v['rank'] : "0";
                                    $channel_trans_group    = func::db_count_record(DB_TABLE_SETMODEL_TRANS_GROUP, "setmodel_id=".$sys->get['setmodel_id']." AND trans_group_id=".$k."");
                                    $sql_data_update = array(
                                        "if_must"   => "'".$v['if_must']."'",
                                        "rank"      => "'".$v['rank']."'",
                                    );
                                    $sql_data_insert = array(
                                        "setmodel_id"        => "'".$sys->get['setmodel_id']."'",
                                        "trans_group_id"    => "'".$k."'",
                                        "if_must"           => "'".$v['if_must']."'",
                                        "rank"              => "'".$v['rank']."'",
                                    );
                                    if ($channel_trans_group > 0) {
                                        $result = func::db_update(DB_TABLE_SETMODEL_TRANS_GROUP, $sql_data_update, "setmodel_id=".$sys->get['setmodel_id']." AND trans_group_id=".$k);
                                    } else {
                                        $result = func::db_insert(DB_TABLE_SETMODEL_TRANS_GROUP, $sql_data_insert);
                                    }
                                } else {
                                    $result = func::db_delete(DB_TABLE_SETMODEL_TRANS_GROUP, "setmodel_id=".$sys->get['setmodel_id']." AND trans_group_id=".$k);
                                }
                            }

                            $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel");
                        }
                    }
                }
            }

        } else {

            $total_record = func::db_count_record(DB_TABLE_SETMODEL, "code='".addslashes($value['code'])."'");
            if ($total_record > 0) {
                $ajax_response->assign("code_return", "innerHTML", "<span class=\"prompt_failed\">此标识已经存在,请重新填写不同标识!<!-- code error --></span>");
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            } else {
                $sql = "INSERT INTO ".DB_TABLE_SETMODEL." SET
                            name                = '".addslashes($value['name'])."',
                            code                = '".addslashes($value['code'])."',
                            brief               = '".addslashes($value['brief'])."',
                            template_channel    = '".addslashes($value['template_channel'])."',
                            template_content     = '".addslashes($value['template_content'])."',
                            if_enable           = '".addslashes((int)$value['if_enable'])."',
                            rank                = '".addslashes((int)$value['rank'])."'";
                $result = $db->Execute($sql);
                $last_record = $db->Insert_ID();
                if (!$result) {
                    $ajax_response->alert($db->ErrorMsg());
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                }else{
                    // trans_group
                    foreach ($value['trans_group'] as $k => $v) {
                        if ($v['check'] == "1") {
                            $v['if_must']   = $v['if_must'] == "1" ? "1" : "2";
                            $v['rank']      = preg_match("/^[0-9]{1,11}$/",$v['rank']) ? $v['rank'] : "0";
                            $channel_trans_group = func::db_count_record(DB_TABLE_SETMODEL_TRANS_GROUP, "setmodel_id=".$last_record." AND trans_group_id=".$k."");
                            $sql_data_update = array(
                                "if_must"   => "'".$v['if_must']."'",
                                "rank"      => "'".$v['rank']."'",
                            );
                            $sql_data_insert = array(
                                "setmodel_id"        => "'".$last_record."'",
                                "trans_group_id"    => "'".$k."'",
                                "if_must"           => "'".$v['if_must']."'",
                                "rank"              => "'".$v['rank']."'",
                            );
                            if ($channel_trans_group > 0) {
                                $result = func::db_update(DB_TABLE_SETMODEL_TRANS_GROUP, $sql_data_update, "setmodel_id=".$last_record." AND trans_group_id=".$k);
                            } else {
                                $result = func::db_insert(DB_TABLE_SETMODEL_TRANS_GROUP, $sql_data_insert);
                            }
                        } else {
                            $result = func::db_delete(DB_TABLE_SETMODEL_TRANS_GROUP, "setmodel_id=".$last_record." AND trans_group_id=".$k);
                        }
                    }

                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel");
                }
            }
        }
    }
    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "submit_form");
//////

if($sys->get['ope'] == "add"){

    $trans_group        = $sys->return_trans_group();
    $t->assign(array(
        "trans_group"           => $trans_group,
    ));

}elseif($sys->get['ope'] == "amend"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['setmodel_id'])){
        $sys->prompt("failed","非法操作!<!-- setmodel_id error -->");
    }else{

        $sql = "SELECT setmodel.*
                FROM ".DB_TABLE_SETMODEL." setmodel
                WHERE setmodel.id=".$sys->get['setmodel_id'];
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }else {
            if(!$result->EOF){
                $setmodel_detail = array(
                    "id"                => $result->fields['id'],
                    "name"              => $result->fields['name'],
                    "code"              => $result->fields['code'],
                    "brief"             => $result->fields['brief'],
                    "template_channel"  => $result->fields['template_channel'],
                    "template_content"   => $result->fields['template_content'],
                    "if_enable"         => $result->fields['if_enable'],
                    "rank"              => $result->fields['rank'],
                );
            } else {
                $sys->prompt("failed","此模型不存在!<!-- setmodel_id error -->");
            }
        }

        $trans_group        = $sys->return_trans_group();
        $trans_list         = $sys->return_trans_list($sys->get['setmodel_id']);

        $t->assign(array(
            "setmodel_detail"    => $setmodel_detail,
            "trans_group"           => $trans_group,
            "trans_list"            => $trans_list,
        ));
    }

}elseif($sys->get['ope'] == "if_enable"){

   if (!preg_match("/^[1-9][0-9]*$/",$sys->get['setmodel_id'])) {
       $sys->prompt("failed","非法操作!<!-- setmodel_id error -->");
   } elseif (!preg_match("/^[12]{1}$/",$sys->get['if_enable'])) {
       $sys->prompt("failed","非法操作!<!-- if_enable error -->");
   } else {

        $sys->return_setmodel_info($sys->get['setmodel_id']);
        if (!preg_match("/^[1-9][0-9]*$/",$sys->setmodel_info['id'])) {
            $sys->prompt("failed","非法操作!<!-- setmodel_info error -->");
        } else {

            $sql_data = array(
                "if_enable" => $sys->get['if_enable'],
            );
            $result = func::db_update(DB_TABLE_SETMODEL, $sql_data, "id= '".$sys->get['setmodel_id']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            }
        }
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=setmodel");
   }

}elseif($sys->get['ope'] == "del"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['setmodel_id'])){
        $sys->prompt("failed","非法操作!<!-- setmodel_id error -->");
    }else{

        $sys->return_setmodel_info($sys->get['setmodel_id']);
        $sys->return_table_list();
        if (is_array($sys->table_list) && count($sys->table_list) > 0) {
            foreach ($sys->table_list as $v) {
                $sql = "DROP TABLE ".$v['table_fullcode']."";
                $result = $db->Execute($sql);
                if (!$result) {
                    echo $db->ErrorMsg();
                }
                $sql = "DELETE FROM ".DB_TABLE_SETMODEL_FIELD."
                        WHERE table_id=".$v['id'];
                $result = $db->Execute($sql);
                if (!$result) {
                    echo $db->ErrorMsg();
                }
            }
        }

        $sql = "DELETE FROM ".DB_TABLE_SETMODEL_TABLE."
                WHERE setmodel_id=".$sys->get['setmodel_id'];
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }

        $sql = "DELETE FROM ".DB_TABLE_SETMODEL."
                WHERE id=".$sys->get['setmodel_id'];
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }

        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=setmodel");
    }

}elseif($sys->get['ope'] == "table"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['setmodel_id'])){
        $sys->prompt("failed","非法操作!<!-- setmodel_id error -->");
    }else{

        $sys->return_setmodel_info($sys->get['setmodel_id']);
        if (!preg_match("/^[1-9][0-9]*$/",$sys->setmodel_info['id'])) {
            $sys->prompt("failed","非法操作!<!-- setmodel_info error -->");
        } else {
            function set_value_onfocus($name, $id, $value, $type="text", $maxlength="255", $style="")
            {
                global $SETTING, $LANGUAGE, $MEMBER, $ADMIN, $db, $sys, $select_option;
                $ajax_response = new xajaxResponse();
                if (!empty($style)) { $style = "style=\"".$style."\""; }

                if ($type == "text") {
                    $result = '<input type="text" id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" value="'.$value.'" maxlength="'.$maxlength.'" size="6" class="input" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">';
                    $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                    $ajax_response->script("$('#".$name."_".$id."_input').focus();");
                } elseif($type == "textarea") {
                    $result = '<textarea id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" rows="1" cols="6" class="textarea" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\',  this.value);">'.$value.'</textarea>';
                    $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                    $ajax_response->script("$('#".$name."_".$id."_input').focus();");
                } elseif ($type == "textarea_resize") {
                    $result = '<textarea id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" rows="1" cols="6" class="textarea" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">'.$value.'</textarea>';
                    $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                    $ajax_response->script("$('#".$name."_".$id."_input').resizable({ autohide: true, minWidth: 200, minHeight: 100,  maxWidth: 800, maxHeight: 600 });");
                    $ajax_response->script("$('#".$name."_".$id."_input').focus();");
                } elseif($type == "checkbox") {
                    $checked = $value == "1" ? "checked" : "";
                    $result = '<input type="checkbox" id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" value="1" '.$checked.' class="checkbox" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.checked == true ? 1 : 2);">';
                    $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                    $ajax_response->script("$('#".$name."_".$id."_input').focus();");
                } elseif($type == "rowformat") {
                    $result = '<select id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" class="select" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">';
                    $result .= '<option value=""></option>';
                    if ($value != "2"){
                        $result .= '<option value="1" selected="selected">FIXED</option>';
                        $result .= '<option value="2">DYNAMIC</option>';
                    } else {
                        $result .= '<option value="1">FIXED</option>';
                        $result .= '<option value="2" selected="selected">DYNAMIC</option>';
                    }
                    $result .= '</select>';
                    $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                    $ajax_response->script("$('#".$name."_".$id."_input').focus();");
                } elseif($type == "recordtype") {
                    $result = '<select id="'.$name.'_'.$id.'_input" name="'.$name.'_'.$id.'_input" class="select" '.$style.' onblur="xajax_set_value_onblur(\''.$name.'\', \''.$id.'\', this.value);">';
                    $result .= '<option value=""></option>';
                    if ($value != "2"){
                        $result .= '<option value="1" selected="selected">单</option>';
                        $result .= '<option value="2">多</option>';
                    } else {
                        $result .= '<option value="1">单</option>';
                        $result .= '<option value="2" selected="selected">多</option>';
                    }
                    $result .= '</select>';
                    $ajax_response->assign($name.'_'.$id, "innerHTML", $result);
                    $ajax_response->script("$('#".$name."_".$id."_input').focus();");
                }
                return $ajax_response;
            }
            $bwajax->register(XAJAX_FUNCTION, "set_value_onfocus");

            function set_value_onblur($name, $id, $value="")
            {
                global $SETTING, $LANGUAGE, $ASESSION, $ADMIN, $db, $sys;
                $ajax_response = new xajaxResponse();
                $if_error   = false;
                $error_msg  = array();

                if (!preg_match("/^[1-9][0-9]*$/",$id)){
                    $if_error       = true;
                    $error_msg[]    = "数据库表ID错误!";
                } else {
                    $table_info = $sys->return_table_info($id);
                    if (!preg_match("/^[1-9][0-9]*$/",$table_info['id'])){
                        $if_error       = true;
                        $error_msg[]    = "此数据库表不存在!";
                    }
                }

                // check
                if (!$if_error) {
                    if ($name == "name") {
                        if ( mb_strwidth($value,"UTF-8") < 1 ||
                             mb_strwidth($value,"UTF-8") > 60 ) {
                            $if_error       = true;
                            $error_msg[]    = "名称必须填写且不能大于60字节!";
                        }

                    } elseif ($name == "code") {
                        if(!preg_match("/^[a-z0-9_]{1,24}$/i",$value)) {
                            $if_error       = true;
                            $error_msg[]    = "标识必须为英文字母数字或者下划线,少于24位!";
                        } else {
                            $total_record = func::db_count_record(DB_TABLE_SETMODEL_TABLE, "setmodel_id=".(int)$table_info['setmodel_id']." AND code='".addslashes($value)."' AND id!=".$id."");
                            if ($total_record > 0) {
                                $if_error       = true;
                                $error_msg[]    = "此标识已经存在,请重新填写不同标识!";
                            } else {

                                if ($table_info['code'] != $value) {
                                    $sys->return_setmodel_info($table_info['setmodel_id']);
                                    $sys->return_table_list();
                                    if (is_array($sys->table_list) && count($sys->table_list) > 0) {

                                        $field_new["content".$table_info['setmodel_code'].$table_info['code']."_id"] = "content".$table_info['setmodel_code'].$value."_id";

                                        foreach ($sys->table_list as $vt) {
                                            $field_list = $sys->return_field_list($vt['id']);
                                            if (is_array($field_list) && count($field_list) > 0) {
                                                foreach ($field_list as $vf) {
                                                    if ($vf['if_enable'] == "1" && $vf['team'] == "1" && array_key_exists($vf['code'], $field_new)){
                                                        $sql = "ALTER TABLE ".$vf['table_fullcode']." CHANGE COLUMN ".$vf['code']." ".$field_new[$vf['code']]." int(11) unsigned NOT NULL auto_increment";
                                                        $result = $db->Execute($sql);
                                                        if (!$result) {
                                                            $if_error       = true;
                                                            $error_msg[]    = "更改字段名称失败! [".$db->ErrorMsg()."]";
                                                        }

                                                    } elseif ($vf['if_enable'] == "1" && $vf['team'] == "2" && array_key_exists($vf['code'], $field_new)){
                                                        $sql = "ALTER TABLE ".$vf['table_fullcode']." CHANGE COLUMN ".$vf['code']." ".$field_new[$vf['code']]." int(11) unsigned NOT NULL default '0'";
                                                        $result = $db->Execute($sql);
                                                        if (!$result) {
                                                            $if_error       = true;
                                                            $error_msg[]    = "更改字段名称失败! [".$db->ErrorMsg()."]";
                                                        }

                                                    }
                                                    if (preg_match("/^[12]{1}$/", $vf['team']) && array_key_exists($vf['code'], $field_new)) {
                                                        $sql = "UPDATE ".DB_TABLE_SETMODEL_FIELD." SET code='".$field_new[$vf['code']]."' WHERE table_id=".$vf['table_id']." AND code='".$vf['code']."' AND type!='index'";
                                                        $result = $db->Execute($sql);
                                                        if (!$result) {
                                                            $if_error       = true;
                                                            $error_msg[]    = "更改字段名称记录失败! [".$db->ErrorMsg()."]";
                                                        }

                                                    }
                                                }
                                            }
                                            $index_list = $sys->return_index_list($vt['id']);
                                            if (is_array($index_list) && count($index_list) > 0) {
                                                foreach ($index_list as $v) {
                                                    if ($v['if_enable'] == "1" && $v['team'] == "2" && array_key_exists($v['code'], $field_new)){
                                                        $sql = "ALTER TABLE ".$v['table_fullcode']." ADD INDEX ".$field_new[$v['code']]."(".$field_new[$v['code']]."),DROP INDEX ".$v['code']."";
                                                        $result = $db->Execute($sql);
                                                        if (!$result) {
                                                            $if_error       = true;
                                                            $error_msg[]    = "更改索引名称失败! [".$db->ErrorMsg()."]";
                                                        }

                                                    }
                                                    if (preg_match("/^[12]{1}$/", $v['team']) && array_key_exists($v['code'], $field_new)) {
                                                        $sql = "UPDATE ".DB_TABLE_SETMODEL_FIELD." SET code='".$field_new[$v['code']]."' WHERE table_id=".$v['table_id']." AND code='".$v['code']."' AND type='index'";
                                                        $result = $db->Execute($sql);
                                                        if (!$result) {
                                                            $if_error       = true;
                                                            $error_msg[]    = "更改索引名称记录失败! [".$db->ErrorMsg()."]";
                                                        }

                                                    }
                                                }
                                            }
                                        }
                                    }
                                    $sql = "RENAME TABLE ".$table_info['table_fullcode']." TO ".$SETTING['config_db_prefix']."content".$table_info['setmodel_code'].$value;
                                    $result = $db->Execute($sql);
                                    if (!$result) {
                                        $if_error       = true;
                                        $error_msg[]    = "更改表名称失败! [".$db->ErrorMsg()."]";
                                    }

                                }
                            }
                        }

                    } elseif ($name == "rowformat") {
                        if(!preg_match("/^[12]{1}$/i",$value)) {
                            $if_error       = true;
                            $error_msg[]    = "表类型发生错误!";
                        } else {
                            if ($table_info['rowformat'] != $value) {

                                $field_list = $sys->return_field_list($table_info['id']);
                                if (is_array($field_list) && count($field_list) > 0) {
                                    foreach ($field_list as $vf) {
                                        if ($table_info['rowformat'] == "2" && preg_match("/^html$/i", $vf['type'])){
                                            $if_error       = true;
                                            $error_msg[]    = "类型为DYNAMIC且包含超文本型字段数据库不能转换表类型!";
                                            break;
                                        }
                                    }
                                    if (!$if_error) {
                                        foreach ($field_list as $field_info) {
                                            $field_info_new                 = $sys->build_field_sql($value, $field_info);
                                            preg_match("/^([0-9]+)(\,[0-9]+)?$/i", $field_info_new['length'],$matches);
                                            $field_info_new['length_pull']  = $matches[1];

                                            if(!$if_error){
                                                $sql = "UPDATE ".$field_info['table_fullcode']." SET ".$field_info['code']."=SUBSTRING(".$field_info['code'].",1,".$field_info_new['length_pull'].")";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "字段值缩小失败![".$db->ErrorMsg()."]";
                                                }
                                            }
                                            if(!$if_error){
                                                $sql = "ALTER TABLE ".$field_info['table_fullcode']." CHANGE COLUMN ".$field_info['code']." ".$field_info['code']." ".$field_info_new['field_sql']."";
                                                $result = $db->Execute($sql);
                                                if (!$result) {
                                                    $if_error       = true;
                                                    $error_msg[]    = "更改字段失败![".$db->ErrorMsg()."]";
                                                }
                                            }
                                        }
                                    }
                                }
                                $table_info['rowformat_name'] = $value == "1" ? "FIXED" : "DYNAMIC";
                                $sql = "ALTER TABLE ".$table_info['table_fullcode']." ROW_FORMAT=".$table_info['rowformat_name']."";
                                $result = $db->Execute($sql);
                                if (!$result) {
                                    $if_error       = true;
                                    $error_msg[]    = "更改数据库表类型失败! [".$db->ErrorMsg()."]";
                                }

                            }
                            $value = $value != "2" ? "1" : "2";
                        }
                    } elseif ($name == "recordtype") {
                        $value = $value != "2" ? "1" : "2";
                    } elseif ($name == "if_preload") {
                        $value = $value == "1" ? "1" : "2";
                    }elseif ($name == "rank") {
                        if ( !preg_match("/^[0-9]{1,11}$/",$value) ) {
                            $if_error       = true;
                            $error_msg[]    = "排序必须为数字!";
                        }
                    }
                }

                // update
                if (!$if_error) {
                    $sql = "UPDATE ".DB_TABLE_SETMODEL_TABLE." SET
                                ".$name."   = '".addslashes($value)."'
                            WHERE id=".$id."";
                    $result = $db->Execute($sql);
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = $db->ErrorMsg();
                    }
                }

                // select and set hidden value
                if (!$if_error) {
                    $sql = "SELECT *
                            FROM ".DB_TABLE_SETMODEL_TABLE."
                            WHERE id=".$id."";
                    $result = $db->Execute($sql);
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = $db->ErrorMsg();
                    } else {
                        $ajax_response->assign($name."_".$id."_value", "value", $result->fields[$name]);
                    }
                }

                // show new
                if (!$if_error) {
                    if ($name == "code") {
                        $ajax_response->assign($name."_".$id, "innerHTML", $result->fields[$name]);
                        $ajax_response->assign("table_fullcode_".$id, "innerHTML", $SETTING['config_db_prefix']."content".$sys->setmodel_info['code'].$result->fields[$name]);

                    } elseif ($name == "rowformat") {
                        if ($result->fields[$name] == "1") {
                            $ajax_response->assign($name."_".$id, "innerHTML", "FIXED");
                        } else {
                            $ajax_response->assign($name."_".$id, "innerHTML", "DYNAMIC");
                        }

                    } elseif ($name == "recordtype") {
                        if ($result->fields[$name] == "1") {
                            $ajax_response->assign($name."_".$id, "innerHTML", "单");
                        } else {
                            $ajax_response->assign($name."_".$id, "innerHTML", "多");
                        }

                    } elseif ($name == "if_preload") {
                        if ($result->fields[$name] == "1") {
                            $ajax_response->assign($name."_".$id, "innerHTML", "&radic;");
                        } else {
                            $ajax_response->assign($name."_".$id, "innerHTML", "");
                        }

                    } elseif ($name == "rank") {
                        $ajax_response->assign($name."_".$id, "innerHTML", $result->fields[$name]);
                        $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel&ope=table&setmodel_id=".$sys->get['setmodel_id']);

                    } elseif ($name == "name") {
                        $ajax_response->assign($name."_".$id, "innerHTML", $result->fields[$name]);

                    } else {
                        $ajax_response->assign($name."_".$id, "innerHTML", $result->fields[$name]);
                    }
                }

                // alert error
                if ($if_error) {
                    $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
                }
                return $ajax_response;
            }
            $bwajax->register(XAJAX_FUNCTION, "set_value_onblur");

            function setmodel_table_add($value, $submit)
            {
                global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys;
                $ajax_response = new xajaxResponse();
                $if_error       = false;
                $error_msg      = array();
                $submit_value   = "添加";

                //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

                // check
                if ( mb_strwidth($value['name'],"UTF-8") < 1 ||
                     mb_strwidth($value['name'],"UTF-8") > 60 ) {
                    $if_error       = true;
                    $error_msg[]    = "名称必须填写且不能大于60字节!";
                }
                if(!preg_match("/^[a-z0-9_]{1,24}$/i",$value['code'])) {
                    $if_error       = true;
                    $error_msg[]    = "标识必须为英文字母数字或者下划线,少于24位!";
                }
                if ($name == "rowformat") {
                    $value['rowformat'] = $value['rowformat'] != "2" ? "1" : "2";
                }
                if ($name == "recordtype") {
                    $value['recordtype'] = $value['recordtype'] != "2" ? "1" : "2";
                }
                if ($name == "if_preload") {
                    $value['if_preload'] = $value['if_preload'] == "1" ? "1" : "2";
                }
                if ( !preg_match("/^[0-9]{1,11}$/",$value['rank']) ) {
                    $if_error       = true;
                    $error_msg[]    = "排序必须为数字!";
                }

                if (!$if_error) {
                    $total_record = func::db_count_record(DB_TABLE_SETMODEL_TABLE, "setmodel_id=".(int)$sys->setmodel_info['id']." AND code='".addslashes($value['code'])."'");
                    if ($total_record > 0) {
                        $if_error       = true;
                        $error_msg[]    = "此标识已经存在,请重新填写不同标识!";
                    }
                }

                // show new
                if (!$if_error) {
                    $sql = "INSERT INTO ".DB_TABLE_SETMODEL_TABLE." SET
                                setmodel_id     = '".addslashes((int)$sys->setmodel_info['id'])."',
                                code            = '".addslashes($value['code'])."',
                                name            = '".addslashes($value['name'])."',
                                rowformat      = '".addslashes((int)$value['rowformat'])."',
                                recordtype     = '".addslashes((int)$value['recordtype'])."',
                                if_preload      = '".addslashes((int)$value['if_preload'])."',
                                rank            = '".addslashes((int)$value['rank'])."'";
                    $result = $db->Execute($sql);
                    $last_record = $db->Insert_ID();
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = $db->ErrorMsg();
                    }else{
                        $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel&ope=table&setmodel_id=".$sys->get['setmodel_id']);
                    }
                }

                // alert error
                if ($if_error) {
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                    $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
                }
                return $ajax_response;
            }
            $bwajax->register(XAJAX_FUNCTION, "setmodel_table_add");

            function setmodel_table_del($id)
            {
                global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys;
                $ajax_response = new xajaxResponse();
                $if_error       = false;
                $error_msg      = array();

                if (!$if_error) {
                    if (!preg_match("/^[1-9][0-9]*$/",$id)){
                        $if_error       = true;
                        $error_msg[]    = "数据库表ID错误!";
                    } else {
                        $table_info = $sys->return_table_info($id);
                        if (!preg_match("/^[1-9][0-9]*$/",$table_info['id'])){
                            $if_error       = true;
                            $error_msg[]    = "此数据库表不存在!";
                        }
                        $sys->return_setmodel_info($table_info['setmodel_id']);
                        $sys->return_table_list();
                    }
                }

                //
                if (!$if_error) {
                    $sql = "DROP TABLE ".$table_info['table_fullcode']."";
                    $result = $db->Execute($sql);
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = "删除数据库表失败! [".$db->ErrorMsg()."]";
                    } else {
                        if (is_array($sys->table_list) && count($sys->table_list) > 0) {
                            $field_code = "content".$table_info['setmodel_code'].$table_info['code']."_id";
                            foreach($sys->table_list as $v) {
                                if ($v['table_fullcode'] != $table_info['table_fullcode']) {
                                    $field_info = func::db_select(DB_TABLE_SETMODEL_FIELD, "id, code, if_enable", "table_id=".$v['id']." AND code='".$field_code."' AND type!='index'");
                                    $field_info = $field_info[0];
                                    if ($field_info['if_enable'] == "1") {
                                        $sql = "ALTER TABLE ".$v['table_fullcode']." DROP COLUMN ".$field_code."";
                                        $result = $db->Execute($sql);
                                        if (!$result) {
                                            $if_error       = true;
                                            $error_msg[]    = "清理数据库表[".$v['table_fullcode']."]的连接字段[".$field_code."]失败! [".$db->ErrorMsg()."]";
                                        }
                                    }
                                    $sql = "DELETE FROM ".DB_TABLE_SETMODEL_FIELD."
                                            WHERE table_id=".$v['id']." AND code='".$field_code."' AND type!='index'";
                                    $result = $db->Execute($sql);
                                    if (!$result) {
                                        $if_error       = true;
                                        $error_msg[]    = "删除表字段失败! [".$db->ErrorMsg()."]";
                                    }
                                }
                            }
                        }

                        $sql = "DELETE FROM ".DB_TABLE_SETMODEL_TABLE."
                                WHERE id=".$table_info['id'];
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $if_error       = true;
                            $error_msg[]    = "删除数据库表记录失败! [".$db->ErrorMsg()."]";
                        } else {
                            $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel&ope=table&setmodel_id=".$sys->get['setmodel_id']);
                        }

                        $sql = "DELETE FROM ".DB_TABLE_SETMODEL_FIELD."
                                WHERE table_id=".$table_info['id'];
                        $result = $db->Execute($sql);
                        if (!$result) {
                            $if_error       = true;
                            $error_msg[]    = "删除表字段失败! [".$db->ErrorMsg()."]";
                        }
                    }
                }

                // alert error
                if ($if_error) {
                    $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
                }
                return $ajax_response;
            }
            $bwajax->register(XAJAX_FUNCTION, "setmodel_table_del");

            $sys->return_table_list();

            if (is_array($sys->table_list) && count($sys->table_list) > 0) {
                foreach ($sys->table_list as $v) {
                    $result = $sys->build_table($v);
                }
            }
            $t->assign(array(
                "setmodel_info"     => $sys->setmodel_info,
                "table_list"        => $sys->table_list,
            ));
        }
    }

}elseif($sys->get['ope'] == "field_list"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['table_id'])){
        $sys->prompt("failed","非法操作!<!-- table_id error -->");
    }else{

        $table_info   = $sys->return_table_info($sys->get['table_id']);
        if (!preg_match("/^[1-9][0-9]*$/",$table_info['id'])) {
            $sys->prompt("failed","非法操作!<!-- table_info error -->");
        } else {

            function field_index_add($value, $submit)
            {
                global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$table_info;
                $ajax_response = new xajaxResponse();
                $if_error       = false;
                $error_msg      = array();
                $submit_value   = "添加索引";

                //$ajax_response->alert(print_r($value, true)); $ajax_response->assign($submit,"disabled",false); return $ajax_response;

                // check
                if ( mb_strwidth($value['name'],"UTF-8") < 1 ||
                     mb_strwidth($value['name'],"UTF-8") > 60 ) {
                    $if_error       = true;
                    $error_msg[]    = "名称必须填写且不能大于60字节!";
                }
                if(!preg_match("/^[a-z0-9_,]+$/i",$value['code'])) {
                    $if_error       = true;
                    $error_msg[]    = "标识必须为英文字母数字或者下划线!";
                }
                if ( !preg_match("/^[0-9]{1,11}$/",$value['rank']) ) {
                    $if_error       = true;
                    $error_msg[]    = "排序必须为数字!";
                }

                if (!$if_error) {
                    $total_record = func::db_count_record(DB_TABLE_SETMODEL_FIELD, "table_id=".$table_info['id']." AND code='".addslashes($value['code'])."' AND type='index'");
                    if ($total_record > 0) {
                        $if_error       = true;
                        $error_msg[]    = "此标识已经存在,请重新填写不同标识!";
                    }
                }

                // show new
                if (!$if_error) {
                    $sql = "INSERT INTO ".DB_TABLE_SETMODEL_FIELD." SET
                                table_id            = '".addslashes($table_info['id'])."',
                                name                = '".addslashes($value['name'])."',
                                code                = '".addslashes($value['code'])."',
                                type                = 'index',
                                team                = '4',
                                length              = '0',
                                prompt              = '',
                                handle_before       = '',
                                handle_alfter       = '',
                                value               = '',
                                html                = '',
                                if_preload          = '1',
                                if_enable           = '1',
                                rank                = '".addslashes((int)$value['rank'])."'";
                    $result = $db->Execute($sql);
                    $last_record = $db->Insert_ID();
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = $db->ErrorMsg();
                    }else{
                        $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=setmodel&ope=field_list&table_id=".$sys->get['table_id']);
                    }
                }

                // alert error
                if ($if_error) {
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                    $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
                }
                return $ajax_response;
            }
            $bwajax->register(XAJAX_FUNCTION, "field_index_add");

            function field_index_del($id)
            {
                global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$table_info;
                $ajax_response = new xajaxResponse();
                $if_error       = false;
                $error_msg      = array();

                if (!$if_error) {
                    if (!preg_match("/^[1-9][0-9]*$/",$id)){
                        $if_error       = true;
                        $error_msg[]    = "表索引ID错误!";
                    } else {
                        $field_info = $sys->return_field_info($id);
                        if (!preg_match("/^[1-9][0-9]*$/",$field_info['id'])){
                            $if_error       = true;
                            $error_msg[]    = "此表索引不存在!";
                        }
                    }
                }

                if (!$if_error) {
                    $sql = "ALTER TABLE ".$field_info['table_fullcode']." DROP INDEX ".$field_info['code']."";
                    $result = $db->Execute($sql);
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = "清理数据库表[".$field_info['table_fullcode']."]的索引[".$field_info['code']."]失败! [".$db->ErrorMsg()."]";
                    }
                }

                if (!$if_error) {
                    $sql = "DELETE FROM ".DB_TABLE_SETMODEL_FIELD."
                            WHERE id=".$field_info['id'];
                    $result = $db->Execute($sql);
                    if (!$result) {
                        $if_error       = true;
                        $error_msg[]    = "删除表索引失败! [".$db->ErrorMsg()."]";
                    }
                }

                // alert error
                if ($if_error) {
                    $ajax_response->alert("发生错误,错误信息如下:\n- ".implode("\n- ", $error_msg));
                }
                return $ajax_response;
            }
            $bwajax->register(XAJAX_FUNCTION, "field_index_del");

            $field_type_list    = $sys->return_field_type_list($table_info['rowformat']);

            $result_init_table  = $sys->init_table($table_info['id']);

            $field_list         = $sys->return_field_list($sys->get['table_id']);

            $index_list         = $sys->return_index_list($sys->get['table_id']);

            $result_build_field = $sys->build_field($table_info, $field_list);

            $t->assign(array(
                "table_info"        => $table_info,
                "field_list"        => $field_list,
                "index_list"        => $index_list,
                "field_type_list"   => $field_type_list,
            ));
        }
    }

}elseif($sys->get['ope'] == "field_add"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['table_id'])){
        $sys->prompt("failed","非法操作!<!-- field_id error -->");
    }else{

        $table_info   = $sys->return_table_info($sys->get['table_id']);
        if (!preg_match("/^[1-9][0-9]*$/",$table_info['id'])) {
            $sys->prompt("failed","非法操作!<!-- table_info error -->");
        } else {

            $field_type_list = $sys->return_field_type_list($table_info['rowformat']);

            $t->assign(array(
                "table_info"        => $table_info,
                "field_type_list"   => $field_type_list,
            ));
        }
    }


}elseif($sys->get['ope'] == "field_amend"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['field_id'])){
        $sys->prompt("failed","非法操作!<!-- field_id error -->");
    }else{

        $field_info   = $sys->return_field_info($sys->get['field_id']);
        if (!preg_match("/^[1-9][0-9]*$/",$field_info['id'])) {
            $sys->prompt("failed","非法操作!<!-- field_info error -->");
        } else {
            $table_info   = $sys->return_table_info($field_info['table_id']);
            if (!preg_match("/^[1-9][0-9]*$/",$table_info['id'])) {
                $sys->prompt("failed","非法操作!<!-- table_info error -->");
            } else {

                $field_type_list = $sys->return_field_type_list($table_info['rowformat']);

                $t->assign(array(
                    "field_info"        => $field_info,
                    "field_type_list"   => $field_type_list,
                ));
            }
        }
    }

}elseif($sys->get['ope'] == "field_if_enable"){

   if (!preg_match("/^[1-9][0-9]*$/",$sys->get['field_id'])) {
       $sys->prompt("failed","非法操作!<!-- field_id error -->");
   } elseif (!preg_match("/^[12]{1}$/",$sys->get['if_enable'])) {
       $sys->prompt("failed","非法操作!<!-- if_enable error -->");
   } else {

        $field_info   = func::db_select(DB_TABLE_SETMODEL_FIELD, "id,table_id", "id=".$sys->get['field_id']);
        $field_info   = $field_info[0];
        if (!preg_match("/^[1-9][0-9]*$/",$field_info['id'])) {
            $sys->prompt("failed","非法操作!<!-- field_info error -->");
        } else {

            $sql_data = array(
                "if_enable" => $sys->get['if_enable'],
            );
            $result = func::db_update(DB_TABLE_SETMODEL_FIELD, $sql_data, "id= '".$sys->get['field_id']."'");
            if (!$result) {
                $sys->prompt("failed","非法操作!<!-- db_update failed -->");
            } elseif($sys->get['if_enable'] == "1") {
                $sql_data = array(
                    "if_enable" => "0",
                );
                $result = func::db_update(DB_TABLE_SETMODEL_FIELD, $sql_data, "table_id=".$field_info['table_id']." AND team=2 AND id!= '".$sys->get['field_id']."'");
                if (!$result) {
                    $sys->prompt("failed","非法操作!<!-- db_update failed -->");
                }
            }
        }
        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=setmodel&ope=field_list&table_id=".$field_info['table_id']."");
   }

}elseif($sys->get['ope'] == "field_del"){

    if (!preg_match("/^[1-9][0-9]*$/",$sys->get['field_id'])){
        $sys->prompt("failed","非法操作!<!-- field_id error -->");
    }else{

        $field_info   = $sys->return_field_info($sys->get['field_id']);
        if (!preg_match("/^[1-9][0-9]{0,10}$/", $field_info['id']) || !preg_match("/^[1-9][0-9]{0,10}$/", $field_info['table_id'])) {
            $sys->prompt("failed","非法操作!<!-- field_info error -->");
        } else {

            $sql = "ALTER TABLE ".$field_info['table_fullcode']." DROP COLUMN ".$field_info['code']."";
            $result = $db->Execute($sql);
            if (!$result) {
                echo $db->ErrorMsg();
            }

            $sql = "DELETE FROM ".DB_TABLE_SETMODEL_FIELD."
                    WHERE id=".$sys->get['field_id'];
            $result = $db->Execute($sql);
            if (!$result) {
                echo $db->ErrorMsg();
            }
            $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=setmodel&ope=field_list&table_id=".$field_info['table_id']."");
        }
    }

}else{
    $setmodel_list = $sys->return_setmodel_list();
    $t->assign(array(
        "setmodel_list"     => $setmodel_list,
    ));
}
?>
