<?php
/*
+-----------------------------------------------------------------------------+
| $Id: trans.php 2010-05-24 12:37:44Z Bleakwind $
| Manage trans
| Copyright (c) 2003-2010 Bleakwind (www.weaverdream.com)
| http://www.weaverdream.com/
| Release under the GNU Lesser General Public License Version 3 (LGPLv3):
|   http://www.gnu.org/licenses/lgpl.html
+-----------------------------------------------------------------------------+
*/

if (!defined( 'ENTRY_INDEX')){
    echo "<h1>Forbidden</h1><p>You don't have permission to access on this server.</p>";
    exit;
}

// Sort add and amend ajax
function submit_form($type, $value, $submit)
{
    global $LANGUAGE,$LANGLIST,$SETTING,$CONFIGURE,$MEMBER,$ADMIN,$db,$sys,$c,$setting_attach;
    $ajax_response = new xajaxResponse();
    $error = false;
    //$ajax_response->alert(print_r($value, true)); return $ajax_response;

    $submit_value = $type == "amend" ? "编辑" : "添加";

    if( empty($value['name']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "name"; }
        $ajax_response->assign("name_return", "innerHTML", "<span class=\"prompt_failed\">必须填写名称<!-- name error --></span>");
    } else {
        $ajax_response->assign("name_return", "innerHTML", "");
    }

    if( empty($value['rank']) ) {
        $error = true;
        if(empty($anchor)) { $anchor = "rank"; }
        $ajax_response->assign("rank_return", "innerHTML", "<span class=\"prompt_failed\">必须填写排序<!-- rank error --></span>");
    } else {
        $ajax_response->assign("rank_return", "innerHTML", "");
    }

    if($error){
        $ajax_response->assign($submit,"value",$submit_value);
        $ajax_response->assign($submit,"disabled",false);
        $ajax_response->redirect("#".$anchor);
    }else{

        if ($type == "amend") {

            if (!preg_match("/^[0-9]+$/",$sys->get['trans_id'])){
                $ajax_response->alert("横向分类ID错误!");
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            } else {
                // Sort amend
                $sql = "UPDATE ".DB_TABLE_TRANS." SET
                            name    = '".addslashes(func::str_stripbr($value['name']))."',
                            brief   = '".addslashes($value['brief'])."',
                            rank    = '".addslashes($value['rank'])."'
                        WHERE id=".$sys->get['trans_id']."";
                $result = $db->Execute($sql);
                if (!$result) {
                    $ajax_response->alert($db->ErrorMsg());
                    $ajax_response->assign($submit,"value",$submit_value);
                    $ajax_response->assign($submit,"disabled",false);
                }else{
        
                    $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=trans&pag=".$sys->get['pag']);
                }
            }

        } else {

            $sql = "INSERT INTO ".DB_TABLE_TRANS." SET
                        name    = '".addslashes(func::str_stripbr($value['name']))."',
                        brief   = '".addslashes($value['brief'])."',
                        rank    = '".addslashes($value['rank'])."'";
            $result = &$db->Execute($sql);
            $last_record = $db->Insert_ID();
            //////
            if (!$result) {
                $ajax_response->alert($db->ErrorMsg());
                $ajax_response->assign($submit,"value",$submit_value);
                $ajax_response->assign($submit,"disabled",false);
            }else{

                $ajax_response->redirect($CONFIGURE['common']['control_admin']."?act=trans");
            }
        }
    }

    return $ajax_response;
}
$bwajax->register(XAJAX_FUNCTION, "submit_form");
//////

if($sys->get['ope'] == "add"){

    $t->assign(array(
        "page" => $bwpage->page_current,
    ));

}elseif($sys->get['ope'] == "amend"){

    if (!preg_match("/^[0-9]+$/",$sys->get['trans_id'])){
        $sys->prompt("failed","非法操作!<!-- trans_id error -->");
    }else{

        $sql = "SELECT * FROM ".DB_TABLE_TRANS." WHERE id=".$sys->get['trans_id'];
        $result = &$db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }else {
            if (!$result->EOF) {
                $trans_info = array(
                    'id'        => $result->fields['id'],
                    'name'      => $result->fields['name'],
                    'name_len'  => mb_strwidth($result->fields['name'],"UTF-8"),
                    'brief'     => $result->fields['brief'],
                    'rank'      => $result->fields['rank'],
                );
            }
        }

        if (empty($trans_info)){
            $sys->prompt("failed","无法查询到此横向分类!<!-- no record -->");
        } else {
            $t->assign(array(
                "trans_info"      => $trans_info,
            ));
        }
    }

}elseif($sys->get['ope'] == "del"){
    // check the post
    if (!preg_match("/^[0-9]+$/",$sys->get['trans_id'])){
        $sys->prompt("failed","非法操作!<!-- trans_id error -->");
    }else{

        $sql = "DELETE FROM ".DB_TABLE_TRANS."
                WHERE id=".$sys->get['trans_id'];
        $result = $db->Execute($sql);
        if (!$result) {
            echo $db->ErrorMsg();
        }

        $sys->prompt("jump",$CONFIGURE['common']['control_admin']."?act=trans");
    }

}else{

    $trans_list = array();
    $sql = "SELECT *
            FROM ".DB_TABLE_TRANS."
            ORDER BY rank,id";
    $result = &$db->Execute($sql);
    if (!$result) {
        echo $db->ErrorMsg();
    } else {
        while (!$result->EOF) {
            $trans_list[] = array(
                'id'        => $result->fields['id'],
                'name'      => $result->fields['name'],
                'name_len'  => mb_strwidth($result->fields['name'],"UTF-8"),
                'brief'     => $result->fields['brief'],
                'rank'      => $result->fields['rank'],
            );
            $result->MoveNext();
        }
    }

    $t->assign(array(
        "trans_list"  => $trans_list,
    ));

}
?>
